# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_core.ipynb.

# %% auto 0
__all__ = ['ConsultaFipe']

# %% ../nbs/00_core.ipynb 3
import os
import json
import requests
import pandas as pd

class ConsultaFipe:
    def __init__(self, 
                 mes: str = 'agosto/2022', 
                 tipo_veiculo: str = 'carro',
                 marca: str = 'VW - VolksWagen',
                 modelo: str = 'T-Cross Sense 1.0 TSI Flex 5p Aut.',
                 ano_modelo: str = 2021,
                 combustivel: str = 'Gasolina'):
        self._base_url = "http://veiculos.fipe.org.br/api/veiculos/"

        self.mes = mes
        self.tabela_referencia = self.consulta_tabela_referencia()
        self.codigo_tabela_referencia = int(self.tabela_referencia.query(f"mes == '{self.mes}'").loc[:,'codigo_mes'].values[0])

        self.tipo_veiculo = tipo_veiculo
        self.tipos_veiculos = {'carro': 1, 'moto': 2, 'caminhao': 3}
        self.codigo_tipo_veiculo = self.tipos_veiculos[self.tipo_veiculo]

        self.marca = marca
        self.tabela_marcas = self.consulta_tabela_marcas()
        self.codigo_marca = int(self.tabela_marcas[self.tabela_marcas['marca'].str.contains(self.marca)].loc[:,'codigo_marca'].values[0])

        self.modelo = modelo
        self.tabela_modelos = self.consulta_tabela_modelos()
        self.codigo_modelo = int(self.tabela_modelos.query(f"modelo == '{self.modelo}'").loc[:,'codigo_modelo'].values[0])
        
        self.ano_modelo = ano_modelo
        self.combustivel = combustivel
        self.codigo_tipo_combustivel = 1 if self.combustivel == 'Gasolina' else 2

    def preco(self):
        url = f"{self._base_url}/ConsultarValorComTodosParametros"
        params = {'codigoTabelaReferencia': self.codigo_tabela_referencia,
                  'codigoTipoVeiculo': self.codigo_tipo_veiculo,
                  'codigoMarca': self.codigo_marca,
                  'codigoModelo': self.codigo_modelo,
                  'anoModelo': self.ano_modelo,
                  'codigoTipoCombustivel': self.codigo_tipo_combustivel,
                  'tipoConsulta': 'tradicional'}
        req = requests.post(url, data=params)
        req_text = req.text
        req_json = json.loads(req_text)
        return pd.DataFrame([req_json])

    def consulta_tabela_referencia(self):
        url = f"{self._base_url}/ConsultarTabelaDeReferencia"
        req = requests.post(url)
        req_text = req.text
        req_json = json.loads(req_text)
        df = pd.DataFrame(req_json)
        df.columns = ['codigo_mes', 'mes']
        df['mes'] = df['mes'].str.strip()

        return df

    def consulta_tabela_marcas(self):
        url = f"{self._base_url}/ConsultarMarcas"
        body = {"codigoTabelaReferencia": self.codigo_tabela_referencia, "codigoTipoVeiculo": self.codigo_tipo_veiculo}
        req = requests.post(url, data=body)
        req_text = req.text
        req_json = json.loads(req_text)
        df = pd.DataFrame(req_json).rename(columns={'Label': 'marca', 'Value': 'codigo_marca'})
        df['mes'] = self.mes
        return df

    def consulta_tabela_modelos(self):
        url = f"{self._base_url}/ConsultarModelos"
        body = {"codigoTabelaReferencia": self.codigo_tabela_referencia,
                "codigoTipoVeiculo": self.codigo_tipo_veiculo,
                "codigoMarca": self.codigo_marca}
        req = requests.post(url, data=body)
        req_text = req.text
        req_json = json.loads(req_text)
        df = pd.DataFrame(req_json['Modelos']).rename(columns={'Label': 'modelo', 'Value': 'codigo_modelo'})
        return df

    def update_codigo_tabela_referencia(self):
        self.codigo_tabela_referencia = int(self.tabela_referencia.query(f"mes == '{self.mes}'").loc[:,'codigo_mes'].values[0])
