# Feather API Python Client
This is the Python client for Feather's API. The API provides access to financial data on equities, institutions, and individuals.

To use the API, you'll need an API key. You can get one by emailing [founders@try-feather.com](mailto:founders@try-feather.com)

## Getting Started

If you're using the Python client, you can set your API key as an environment variable `FEATHER_API_KEY`, or pass in the api key as a parameter to the client, as follows:

```
from featherapi import DataClient

API_KEY = 'xxyourfeatherapikeyherexx'

client = DataClient(api_key=API_KEY)
```

If calling the HTTP endpoints yourself, you need to include your api key as an `x-api-key` header. See the HTTP API documentation for more details.

## Equities

To get all available facts for an equity:

```
facts = client.get_equity_facts('AAPL')

print(facts)
```

This will return a dict of pandas dataframes with the following keys:
- `income`: Company income statements
- `balance`: Company balance sheet
- `cashflow`: Company cashflow statements

Additionally, equity facts can be fetched by range:
    
```
# get reports from 2017 to 2022
results = client.get_equity_facts('AAPL', start=2017, end=2022)

# get the available reporting periods for AAPL
available = client.get_available('AAPL')

# available = [2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020, 2021, 2022]

# get the latest 5 years of facts
end = available[-1]
start = available[-5]

results = client.get_equity_facts('AAPL', start=start, end=end)

print(results)
```

To get the institutional ownership for an equity:

```
holders = client.get_institutional_holders('AAPL')

print(holders)
```

To get insider trades for an equity:
```
trades = client.get_insider_trades('AAPL')
```

To get comparable financials/multiples for an equity:
```
comp_financials = client.get_comparable_financials('AAPL')
comp_multiples = client.get_comparable_multiples('AAPL')
```

To get recent stock prices for an equity:
```
# syntax: client.get_stock_price(ticker, interval)
prices = client.get_stock_price('AAPL', '1m')
```
This will return a list of stock price objects (OLHCV) based on one-minute intervals. Valid intervals are `1m`, `5m`, `15m`, `30m`, `1h`, `4h`.

To get daily historical close prices for an equity:
```
prices = client.get_stock_price_historical('AAPL', start='2021-01-01', end='2021-01-31')
```

To get earnings history for an equity, with beats/misses:
```
earnings = client.get_earnings('AAPL')
```

## Institutions
To get an institution's holdings by CIK:

```
# CIK for Berkshire Hathaway is 1652044

holdings = client.get_institution_holdings(1652044)
```

## News
To get the most recent news articles:
```
articles = client.get_articles()
```

To get articles for a keyword (for example, a ticker, company, or industry):

```
articles = client.get_articles('AAPL')
```



