"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TlsCertificate = exports.TlsMode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Enum of supported TLS modes.
 *
 * @experimental
 */
var TlsMode;
(function (TlsMode) {
    TlsMode["STRICT"] = "STRICT";
    TlsMode["PERMISSIVE"] = "PERMISSIVE";
    TlsMode["DISABLED"] = "DISABLED";
})(TlsMode = exports.TlsMode || (exports.TlsMode = {}));
/**
 * (experimental) Represents a TLS certificate.
 *
 * @experimental
 */
class TlsCertificate {
    /**
     * (experimental) Returns an File TLS Certificate.
     *
     * @experimental
     */
    static file(props) {
        return new FileTlsCertificate(props);
    }
    /**
     * (experimental) Returns an ACM TLS Certificate.
     *
     * @experimental
     */
    static acm(props) {
        return new AcmTlsCertificate(props);
    }
}
exports.TlsCertificate = TlsCertificate;
_a = JSII_RTTI_SYMBOL_1;
TlsCertificate[_a] = { fqn: "@aws-cdk/aws-appmesh.TlsCertificate", version: "1.92.0" };
/**
 * Represents a ACM provided TLS certificate
 */
class AcmTlsCertificate extends TlsCertificate {
    constructor(props) {
        super();
        this.tlsMode = props.tlsMode;
        this.acmCertificate = props.certificate;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                acm: {
                    certificateArn: this.acmCertificate.certificateArn,
                },
            },
            tlsMode: this.tlsMode,
        };
    }
}
/**
 * Represents a file provided TLS certificate
 */
class FileTlsCertificate extends TlsCertificate {
    constructor(props) {
        super();
        this.tlsMode = props.tlsMode;
        this.certificateChain = props.certificateChainPath;
        this.privateKey = props.privateKeyPath;
    }
    bind(_scope) {
        return {
            tlsCertificate: {
                file: {
                    certificateChain: this.certificateChain,
                    privateKey: this.privateKey,
                },
            },
            tlsMode: this.tlsMode,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGxzLWNlcnRpZmljYXRlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidGxzLWNlcnRpZmljYXRlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7QUFVQSxJQUFZLE9BZVg7QUFmRCxXQUFZLE9BQU87SUFJakIsNEJBQWlCLENBQUE7SUFLakIsb0NBQXlCLENBQUE7SUFLekIsZ0NBQXFCLENBQUE7QUFDdkIsQ0FBQyxFQWZXLE9BQU8sR0FBUCxlQUFPLEtBQVAsZUFBTyxRQWVsQjs7Ozs7O0FBdURELE1BQXNCLGNBQWM7Ozs7OztJQUkzQixNQUFNLENBQUMsSUFBSSxDQUFDLEtBQTZCO1FBQzlDLE9BQU8sSUFBSSxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUN2QyxDQUFDOzs7Ozs7SUFLTSxNQUFNLENBQUMsR0FBRyxDQUFDLEtBQTRCO1FBQzVDLE9BQU8sSUFBSSxpQkFBaUIsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUN0QyxDQUFDOztBQWJILHdDQW9CQzs7O0FBRUQ7O0dBRUc7QUFDSCxNQUFNLGlCQUFrQixTQUFRLGNBQWM7SUFhNUMsWUFBWSxLQUE0QjtRQUN0QyxLQUFLLEVBQUUsQ0FBQztRQUNSLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7SUFDMUMsQ0FBQztJQUVELElBQUksQ0FBQyxNQUFpQjtRQUNwQixPQUFPO1lBQ0wsY0FBYyxFQUFFO2dCQUNkLEdBQUcsRUFBRTtvQkFDSCxjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWMsQ0FBQyxjQUFjO2lCQUNuRDthQUNGO1lBQ0QsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO1NBQ3RCLENBQUM7SUFDSixDQUFDO0NBQ0Y7QUFFRDs7R0FFRztBQUNILE1BQU0sa0JBQW1CLFNBQVEsY0FBYztJQWtCN0MsWUFBWSxLQUE2QjtRQUN2QyxLQUFLLEVBQUUsQ0FBQztRQUNSLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDLG9CQUFvQixDQUFDO1FBQ25ELElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLGNBQWMsQ0FBQztJQUN6QyxDQUFDO0lBRUQsSUFBSSxDQUFDLE1BQWlCO1FBQ3BCLE9BQU87WUFDTCxjQUFjLEVBQUU7Z0JBQ2QsSUFBSSxFQUFFO29CQUNKLGdCQUFnQixFQUFFLElBQUksQ0FBQyxnQkFBZ0I7b0JBQ3ZDLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVTtpQkFDNUI7YUFDRjtZQUNELE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztTQUN0QixDQUFDO0lBQ0osQ0FBQztDQUNGIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgYWNtIGZyb20gJ0Bhd3MtY2RrL2F3cy1jZXJ0aWZpY2F0ZW1hbmFnZXInO1xuaW1wb3J0IHsgQ2ZuVmlydHVhbE5vZGUgfSBmcm9tICcuL2FwcG1lc2guZ2VuZXJhdGVkJztcblxuLy8ga2VlcCB0aGlzIGltcG9ydCBzZXBhcmF0ZSBmcm9tIG90aGVyIGltcG9ydHMgdG8gcmVkdWNlIGNoYW5jZSBmb3IgbWVyZ2UgY29uZmxpY3RzIHdpdGggdjItbWFpblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLWR1cGxpY2F0ZS1pbXBvcnRzLCBpbXBvcnQvb3JkZXJcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGVudW0gVGxzTW9kZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFNUUklDVCA9ICdTVFJJQ1QnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBQRVJNSVNTSVZFID0gJ1BFUk1JU1NJVkUnLFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIERJU0FCTEVEID0gJ0RJU0FCTEVEJyxcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBUbHNDZXJ0aWZpY2F0ZUNvbmZpZyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHRsc0NlcnRpZmljYXRlOiBDZm5WaXJ0dWFsTm9kZS5MaXN0ZW5lclRsc0NlcnRpZmljYXRlUHJvcGVydHksXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB0bHNNb2RlOiBUbHNNb2RlO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEFjbUNlcnRpZmljYXRlT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdGxzTW9kZTogVGxzTW9kZTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNlcnRpZmljYXRlOiBhY20uSUNlcnRpZmljYXRlO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBGaWxlQ2VydGlmaWNhdGVPcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB0bHNNb2RlOiBUbHNNb2RlO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNlcnRpZmljYXRlQ2hhaW5QYXRoOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcHJpdmF0ZUtleVBhdGg6IHN0cmluZztcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgVGxzQ2VydGlmaWNhdGUge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgZmlsZShwcm9wczogRmlsZUNlcnRpZmljYXRlT3B0aW9ucyk6IFRsc0NlcnRpZmljYXRlIHtcbiAgICByZXR1cm4gbmV3IEZpbGVUbHNDZXJ0aWZpY2F0ZShwcm9wcyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBhY20ocHJvcHM6IEFjbUNlcnRpZmljYXRlT3B0aW9ucyk6IFRsc0NlcnRpZmljYXRlIHtcbiAgICByZXR1cm4gbmV3IEFjbVRsc0NlcnRpZmljYXRlKHByb3BzKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgYWJzdHJhY3QgYmluZChfc2NvcGU6IENvbnN0cnVjdCk6IFRsc0NlcnRpZmljYXRlQ29uZmlnO1xuXG59XG5cbi8qKlxuICogUmVwcmVzZW50cyBhIEFDTSBwcm92aWRlZCBUTFMgY2VydGlmaWNhdGVcbiAqL1xuY2xhc3MgQWNtVGxzQ2VydGlmaWNhdGUgZXh0ZW5kcyBUbHNDZXJ0aWZpY2F0ZSB7XG4gIC8qKlxuICAgKiBUaGUgVExTIG1vZGUuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gVGxzTW9kZS5ESVNBQkxFRFxuICAgKi9cbiAgcmVhZG9ubHkgdGxzTW9kZTogVGxzTW9kZTtcblxuICAvKipcbiAgICogVGhlIEFSTiBvZiB0aGUgQUNNIGNlcnRpZmljYXRlXG4gICAqL1xuICByZWFkb25seSBhY21DZXJ0aWZpY2F0ZTogYWNtLklDZXJ0aWZpY2F0ZTtcblxuICBjb25zdHJ1Y3Rvcihwcm9wczogQWNtQ2VydGlmaWNhdGVPcHRpb25zKSB7XG4gICAgc3VwZXIoKTtcbiAgICB0aGlzLnRsc01vZGUgPSBwcm9wcy50bHNNb2RlO1xuICAgIHRoaXMuYWNtQ2VydGlmaWNhdGUgPSBwcm9wcy5jZXJ0aWZpY2F0ZTtcbiAgfVxuXG4gIGJpbmQoX3Njb3BlOiBDb25zdHJ1Y3QpOiBUbHNDZXJ0aWZpY2F0ZUNvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHRsc0NlcnRpZmljYXRlOiB7XG4gICAgICAgIGFjbToge1xuICAgICAgICAgIGNlcnRpZmljYXRlQXJuOiB0aGlzLmFjbUNlcnRpZmljYXRlLmNlcnRpZmljYXRlQXJuLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICAgIHRsc01vZGU6IHRoaXMudGxzTW9kZSxcbiAgICB9O1xuICB9XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyBhIGZpbGUgcHJvdmlkZWQgVExTIGNlcnRpZmljYXRlXG4gKi9cbmNsYXNzIEZpbGVUbHNDZXJ0aWZpY2F0ZSBleHRlbmRzIFRsc0NlcnRpZmljYXRlIHtcbiAgLyoqXG4gICAqIFRoZSBUTFMgbW9kZS5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBUbHNNb2RlLkRJU0FCTEVEXG4gICAqL1xuICByZWFkb25seSB0bHNNb2RlOiBUbHNNb2RlO1xuXG4gIC8qKlxuICAgKiBUaGUgZmlsZSBwYXRoIG9mIHRoZSBjZXJ0aWZpY2F0ZSBjaGFpbiBmaWxlLlxuICAgKi9cbiAgcmVhZG9ubHkgY2VydGlmaWNhdGVDaGFpbjogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgZmlsZSBwYXRoIG9mIHRoZSBwcml2YXRlIGtleSBmaWxlLlxuICAgKi9cbiAgcmVhZG9ubHkgcHJpdmF0ZUtleTogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHByb3BzOiBGaWxlQ2VydGlmaWNhdGVPcHRpb25zKSB7XG4gICAgc3VwZXIoKTtcbiAgICB0aGlzLnRsc01vZGUgPSBwcm9wcy50bHNNb2RlO1xuICAgIHRoaXMuY2VydGlmaWNhdGVDaGFpbiA9IHByb3BzLmNlcnRpZmljYXRlQ2hhaW5QYXRoO1xuICAgIHRoaXMucHJpdmF0ZUtleSA9IHByb3BzLnByaXZhdGVLZXlQYXRoO1xuICB9XG5cbiAgYmluZChfc2NvcGU6IENvbnN0cnVjdCk6IFRsc0NlcnRpZmljYXRlQ29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgdGxzQ2VydGlmaWNhdGU6IHtcbiAgICAgICAgZmlsZToge1xuICAgICAgICAgIGNlcnRpZmljYXRlQ2hhaW46IHRoaXMuY2VydGlmaWNhdGVDaGFpbixcbiAgICAgICAgICBwcml2YXRlS2V5OiB0aGlzLnByaXZhdGVLZXksXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgICAgdGxzTW9kZTogdGhpcy50bHNNb2RlLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==