# coding: utf-8

"""
    UbiOps

    Client Library to interact with the UbiOps API.  # noqa: E501

    The version of the OpenAPI document: v2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ubiops.api_client import ApiClient
from ubiops.exceptions import (
    ApiTypeError,
    ApiValueError
)


class Monitoring(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def notification_groups_create_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """Create notification groups  # noqa: E501

         ### Description  Create a notification group by defining a name and a list of contacts  ### Required Parameters  - `name`: Name of the notification group. It is unique within a project.  ### Optional Parameters - `contacts`: A list of dictionaries containing the following keys:   - `type`: Type of the contact. It can be `email`.   - `configuration`: A custom dictionary that contains required information for the type. For `email` type, it should contain the key `email_address`.  #### Request Examples ``` {   \"name\": \"notification-group-1\",   \"contacts\": [     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user@ubiops.com\"       }     },     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user.2@ubiops.com\"       }     }   ] } ```  ### Response Structure  Details of the created notification group - `id`: Unique identifier for the notification group (UUID) - `name`: Name of the notification group - `contacts`: A list of contacts in the notification group  #### Response Examples  ``` {   \"id\": \"dc083d2a-74aa-4c49-8806-8adbeadca8a8\",   \"name\": \"notification-group-1\",   \"contacts\": [     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user@ubiops.com\"       }     },     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user.2@ubiops.com\"       }     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_groups_create_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param NotificationGroupCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NotificationGroupList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notification_groups_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `notification_groups_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `notification_groups_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `notification_groups_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.notification_group_create import NotificationGroupCreate

                local_var_params['data'] = NotificationGroupCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/monitoring/notification-groups', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotificationGroupList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def notification_groups_delete_with_http_info(self, project_name, notification_group_name, **kwargs):  # noqa: E501
        """Delete notification group  # noqa: E501

         ### Description  Delete a notification group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_groups_delete_with_http_info(project_name, notification_group_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str notification_group_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'notification_group_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notification_groups_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `notification_groups_delete`")  # noqa: E501
        # verify the required parameter 'notification_group_name' is set
        if self.api_client.client_side_validation and ('notification_group_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['notification_group_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `notification_group_name` when calling `notification_groups_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `notification_groups_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'notification_group_name' in local_var_params
            and local_var_params['notification_group_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['notification_group_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `notification_group_name` must be a string when calling `notification_groups_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'notification_group_name' in local_var_params:
            path_params['notification_group_name'] = local_var_params['notification_group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/monitoring/notification-groups/{notification_group_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def notification_groups_get_with_http_info(self, project_name, notification_group_name, **kwargs):  # noqa: E501
        """Get notification group  # noqa: E501

         ### Description  Retrieve details of a single notification group in a project  ### Response Structure  Details of a notification group - `id`: Unique identifier for the notification group (UUID) - `name`: Name of the notification group - `contacts`: A list of contacts in the notification group  #### Response Examples  ``` {   \"id\": \"dc083d2a-74aa-4c49-8806-8adbeadca8a8\",   \"name\": \"notification-group-1\",   \"contacts\": [     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user@ubiops.com\"       }     },     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user.2@ubiops.com\"       }     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_groups_get_with_http_info(project_name, notification_group_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str notification_group_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NotificationGroupList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'notification_group_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notification_groups_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `notification_groups_get`")  # noqa: E501
        # verify the required parameter 'notification_group_name' is set
        if self.api_client.client_side_validation and ('notification_group_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['notification_group_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `notification_group_name` when calling `notification_groups_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `notification_groups_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'notification_group_name' in local_var_params
            and local_var_params['notification_group_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['notification_group_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `notification_group_name` must be a string when calling `notification_groups_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'notification_group_name' in local_var_params:
            path_params['notification_group_name'] = local_var_params['notification_group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/monitoring/notification-groups/{notification_group_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotificationGroupList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def notification_groups_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List notification groups  # noqa: E501

         ### Description  List the notification groups in a project  ### Response Structure  A list of details of the notification groups in the project - `id`: Unique identifier for the notification group (UUID) - `name`: Name of the notification group - `contacts`: A list of contacts in the notification group  #### Response Examples  ``` [   {     \"id\": \"dc083d2a-74aa-4c49-8806-8adbeadca8a8\",     \"name\": \"notification-group-1\",     \"contacts\": [       {         \"type\": \"email\",         \"configuration\": {           \"email_address\": \"my.example.user@ubiops.com\"         }       },       {         \"type\": \"email\",         \"configuration\": {           \"email_address\": \"my.example.user.2@ubiops.com\"         }       }     ],   },   {     \"id\": \"7193ca09-d28b-4fce-a15a-11e0bc9f7f6f\",     \"name\": \"notification-group-2\",      \"contacts\": [       {         \"type\": \"email\",         \"configuration\": {           \"email_address\": \"my.example.user.3@ubiops.com\"         }       }     ]   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_groups_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[NotificationGroupList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notification_groups_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `notification_groups_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `notification_groups_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/monitoring/notification-groups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[NotificationGroupList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def notification_groups_update_with_http_info(self, project_name, notification_group_name, data, **kwargs):  # noqa: E501
        """Update notification group  # noqa: E501

         ### Description  Update a notification group  ### Optional Parameters  - `name`: New name for the deployment - `contacts`: A list of dictionaries containing the following keys:  - `type`: Type of the contact. It can be `email`.  - `configuration`: A custom dictionary that contains required information for the type. For `email` type, it should contain the key `email_address`.  #### Request Examples ``` {   \"name\": \"new-notification-group-name\" } ```  ### Response Structure  Details of the updated notification group - `id`: Unique identifier for the notification group (UUID) - `name`: Name of the notification group - `contacts`: A list of contacts in the notification group  #### Response Examples ``` {   \"id\": \"dc083d2a-74aa-4c49-8806-8adbeadca8a8\",   \"name\": \"new-notification-group-name\",   \"contacts\": [     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user@ubiops.com\"       }     },     {       \"type\": \"email\",       \"configuration\": {         \"email_address\": \"my.example.user.2@ubiops.com\"       }     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.notification_groups_update_with_http_info(project_name, notification_group_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str notification_group_name: (required)
        :param NotificationGroupUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NotificationGroupList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'notification_group_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method notification_groups_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `notification_groups_update`")  # noqa: E501
        # verify the required parameter 'notification_group_name' is set
        if self.api_client.client_side_validation and ('notification_group_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['notification_group_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `notification_group_name` when calling `notification_groups_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `notification_groups_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `notification_groups_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'notification_group_name' in local_var_params
            and local_var_params['notification_group_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['notification_group_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `notification_group_name` must be a string when calling `notification_groups_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.notification_group_update import NotificationGroupUpdate

                local_var_params['data'] = NotificationGroupUpdate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'notification_group_name' in local_var_params:
            path_params['notification_group_name'] = local_var_params['notification_group_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/monitoring/notification-groups/{notification_group_name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotificationGroupList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
