# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.view
import typing
from abc import ABC
if typing.TYPE_CHECKING:
    from ..awt.x_device import XDevice as XDevice_70ba08fc

class RenderOptions(ABC):
    """
    Service Class

    describes the options for Render jobs.
    
    **since**
    
        OOo 1.1.2

    See Also:
        `API RenderOptions <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1view_1_1RenderOptions.html>`_
    """
    @property
    def IsFirstPage(self) -> bool:
        """
        indicates that the current page is the first page to be exported.
        
        Hyperlinks, notes, and outlines cannot be exported on a per page base. They have to be exported once before the first page is exported. Therefore the IsFirstPage property has been introduced. It is evaluated in the render function and indicates that the current page is the first page to be exported.
        """
        ...
    @property
    def IsLastPage(self) -> bool:
        """
        indicates that the current page is the last page to be exported.
        
        Hyperlinks from the EditEngine have to be exported once after the last page has been processed. Therefore the IsLastPage property has been introduced. It is evaluated in the render function and indicates that the current page is the last page to be exported.
        """
        ...
    @property
    def IsSkipEmptyPages(self) -> bool:
        """
        specifies if empty pages should be skipped.
        
        Tells the PDF export to skip empty pages. This flag also has to be passed to the render function, in order to calculate to correct page numbers during the export of hyperlinks, notes, and outlines.
        """
        ...
    @property
    def PageRange(self) -> str:
        """
        specifies the page ranges to be rendered.
        
        Tells the PDF export to skip empty pages. This flag also has to be passed to the render function, in order to calculate to correct page numbers during the export of hyperlinks, notes, and outlines.
        """
        ...
    @property
    def RenderDevice(self) -> 'XDevice_70ba08fc':
        """
        specifies the device the page should be rendered to
        """
        ...

