# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.ucb
# Libre Office Version: 7.4
from typing_extensions import Literal
from .global_transfer_command_argument import GlobalTransferCommandArgument as GlobalTransferCommandArgument_9ae711da
from .transfer_command_operation import TransferCommandOperation as TransferCommandOperation_486a0ff7
import typing


class GlobalTransferCommandArgument2(GlobalTransferCommandArgument_9ae711da):
    """
    Struct Class

    This struct extends the one for transfers arguments by adding a Mime type and a Document Id property to it.

    See Also:
        `API GlobalTransferCommandArgument2 <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1ucb_1_1GlobalTransferCommandArgument2.html>`_
    """
    typeName: Literal['com.sun.star.ucb.GlobalTransferCommandArgument2']

    def __init__(self, Operation: typing.Optional[TransferCommandOperation_486a0ff7] = ..., SourceURL: typing.Optional[str] = ..., TargetURL: typing.Optional[str] = ..., NewTitle: typing.Optional[str] = ..., NameClash: typing.Optional[int] = ..., MimeType: typing.Optional[str] = ..., DocumentId: typing.Optional[str] = ...) -> None:
        """
        Constructor

        Arguments:
            Operation (TransferCommandOperation, optional): Operation value.
            SourceURL (str, optional): SourceURL value.
            TargetURL (str, optional): TargetURL value.
            NewTitle (str, optional): NewTitle value.
            NameClash (int, optional): NameClash value.
            MimeType (str, optional): MimeType value.
            DocumentId (str, optional): DocumentId value.
        """
        ...


    @property
    def MimeType(self) -> str:
        """
        contains the MIME type of the source object.
        """
        ...


    @property
    def DocumentId(self) -> str:
        """
        contains the DocumentId of the source object.
        """
        ...


