# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.text
# Libre Office Version: 7.4
from typing_extensions import Literal
import typing


class GraphicCrop(object):
    """
    Struct Class

    describes the cropping of graphic objects.
    
    Cropping means to show only parts of the object.
    
    Negative values cut the visible area; positive values extend the visible area by filling it with background color. The absolute sum of top and bottom crop must be smaller than the objects original height. The absolute sum of the left and right crop must be smaller than the object's original width.
    
    If this property is applied to a graphic object, then this object will correct these values if necessary.

    See Also:
        `API GraphicCrop <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1text_1_1GraphicCrop.html>`_
    """
    typeName: Literal['com.sun.star.text.GraphicCrop']

    def __init__(self, Top: typing.Optional[int] = ..., Bottom: typing.Optional[int] = ..., Left: typing.Optional[int] = ..., Right: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            Top (int, optional): Top value.
            Bottom (int, optional): Bottom value.
            Left (int, optional): Left value.
            Right (int, optional): Right value.
        """
        ...


    @property
    def Top(self) -> int:
        """
        contains the top value to cut (if negative) or to extend (if positive)
        """
        ...


    @property
    def Bottom(self) -> int:
        """
        contains the bottom value to cut (if negative) or to extend (if positive)
        """
        ...


    @property
    def Left(self) -> int:
        """
        contains the left value to cut (if negative) or to extend (if positive)
        """
        ...


    @property
    def Right(self) -> int:
        """
        contains the right value to cut (if negative) or to extend (if positive)
        """
        ...


