# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.presentation
import typing
from abc import ABC
if typing.TYPE_CHECKING:
    from .animation_effect import AnimationEffect as AnimationEffect_4f571011
    from .animation_speed import AnimationSpeed as AnimationSpeed_3fb20fb5
    from .click_action import ClickAction as ClickAction_10a30e68
    from ..util.color import Color as Color_68e908c5

class Shape(ABC):
    """
    Service Class

    this service is supported from all shapes inside a PresentationDocument.
    
    This usually enhances objects of type com.sun.star.drawing.Shape with presentation properties.

    See Also:
        `API Shape <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1presentation_1_1Shape.html>`_
    """
    @property
    def Bookmark(self) -> str:
        """
        is a generic URL for the property OnClick.
        """
        ...
    @property
    def DimColor(self) -> 'Color_68e908c5':
        """
        This is the color for dimming this shape.
        
        This color is used if the property com.sun.star.drawing.Shape.DimPrev is TRUE and com.sun.star.drawing.Shape.DimHide is FALSE.
        """
        ...
    @property
    def DimHide(self) -> bool:
        """
        If this property and the property com.sun.star.drawing.Shape.DimPrev are both TRUE, the shape is hidden instead of dimmed to a color.
        """
        ...
    @property
    def DimPrevious(self) -> bool:
        """
        If this property is TRUE, this shape is dimmed to the color of property com.sun.star.drawing.Shape.DimColor after executing its animation effect.
        """
        ...
    @property
    def Effect(self) -> 'AnimationEffect_4f571011':
        """
        selects the animation effect of this shape.
        """
        ...
    @property
    def IsEmptyPresentationObject(self) -> bool:
        """
        If this is a default presentation object and if it is empty, this property is TRUE.
        """
        ...
    @property
    def IsPresentationObject(self) -> bool:
        """
        If this is a presentation object, this property is TRUE.
        
        Presentation objects are objects like TitleTextShape and OutlinerShape.
        """
        ...
    @property
    def OnClick(self) -> 'ClickAction_10a30e68':
        """
        selects an action performed after the user clicks on this shape.
        """
        ...
    @property
    def PlayFull(self) -> bool:
        """
        If this property is TRUE, the sound of this shape is played in full.
        
        The default behavior is to stop the sound after completing the animation effect.
        """
        ...
    @property
    def PresentationOrder(self) -> int:
        """
        This is the position of this shape in the order of the shapes which can be animated on its page.
        
        The animations are executed in this order, starting at the shape with the PresentationOrder \"one.\" You can change the order by changing this number. Setting it to \"one\" makes this shape the first shape in the execution order for the animation effects.
        """
        ...
    @property
    def Sound(self) -> str:
        """
        This is the URL to a sound file that is played while the animation effect of this shape is running.
        """
        ...
    @property
    def SoundOn(self) -> bool:
        """
        If this property is set to TRUE, a sound is played while the animation effect is executed.
        """
        ...
    @property
    def Speed(self) -> 'AnimationSpeed_3fb20fb5':
        """
        This is the speed of the animation effect.
        """
        ...
    @property
    def TextEffect(self) -> 'AnimationEffect_4f571011':
        """
        This is the animation effect for the text inside this shape.
        """
        ...
    @property
    def Verb(self) -> int:
        """
        specifies an \"OLE2\" verb for the ClickAction VERB in the property com.sun.star.drawing.Shape.OnClick.
        """
        ...

