# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.linguistic2
from typing_extensions import Literal
import typing
from ..uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from ..lang.locale import Locale as Locale_70d308fa
    from .proofreading_result import ProofreadingResult as ProofreadingResult_6cc910d4
    from ..text.x_flat_paragraph import XFlatParagraph as XFlatParagraph_c8310c42
    from ..text.x_flat_paragraph_iterator_provider import XFlatParagraphIteratorProvider as XFlatParagraphIteratorProvider_c37e12d7

class XProofreadingIterator(XInterface_8f010a43):
    """
    API for the proofreading iterator that mediates between the document and the proofreader.
    
    **since**
    
        OOo 3.0.1

    See Also:
        `API XProofreadingIterator <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1linguistic2_1_1XProofreadingIterator.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.linguistic2.XProofreadingIterator']

    def checkSentenceAtPosition(self, xDocument: 'XInterface_8f010a43', xFlatParagraph: 'XFlatParagraph_c8310c42', aText: str, aLocale: 'Locale_70d308fa', nStartOfSentencePosition: int, nSuggestedBehindEndOfSentencePosition: int, nErrorPositionInParagraph: int) -> 'ProofreadingResult_6cc910d4':
        """
        start proofreading from a given position

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """
        ...
    def isProofreading(self, xDocument: 'XInterface_8f010a43') -> bool:
        """
        checks if the given document is currently being checked
        """
        ...
    def resetIgnoreRules(self) -> None:
        """
        clears the list of ignored rules for each proofreader
        """
        ...
    def startProofreading(self, xDocument: 'XInterface_8f010a43', xIteratorProvider: 'XFlatParagraphIteratorProvider_c37e12d7') -> None:
        """
        start proofreading and automatically process the whole text

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """
        ...


