# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Service Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.graphic
import typing
from ..beans.x_property_set import XPropertySet as XPropertySet_bc180bfa
if typing.TYPE_CHECKING:
    from ..awt.size import Size as Size_576707ef

class GraphicDescriptor(XPropertySet_bc180bfa):
    """
    Service Class

    This service describes all graphic properties that are available via the com.sun.star.beans.XPropertySet interface.
    
    **since**
    
        LibreOffice 6.1

    See Also:
        `API GraphicDescriptor <https://api.libreoffice.org/docs/idl/ref/servicecom_1_1sun_1_1star_1_1graphic_1_1GraphicDescriptor.html>`_
    """
    @property
    def Alpha(self) -> bool:
        """
        Indicates that it is a pixel graphic with an alpha channel.
        
        The status of this flag is not always clear if the graphic was not loaded at all, e.g. in case of just querying for the GraphicDescriptor
        """
        ...
    @property
    def Animated(self) -> bool:
        """
        Indicates that it is a graphic that consists of several frames that can be played as an animation.
        
        The status of this flag is not always clear if the graphic was not loaded at all, e.g. in case of just querying for the GraphicDescriptor
        """
        ...
    @property
    def BitsPerPixel(self) -> int:
        """
        The number of bits per pixel used for the pixel graphic.
        
        This property is not available for vector graphics and may not be available for some kinds of pixel graphics
        """
        ...
    @property
    def GraphicType(self) -> int:
        """
        The type of the graphic.
        """
        ...
    @property
    def Linked(self) -> bool:
        """
        Indicates that the graphic is an external linked graphic.
        
        **since**
        
            LibreOffice 6.1
        """
        ...
    @property
    def MimeType(self) -> str:
        """
        The MimeType of the loaded graphic.
        
        The mime can be the original mime type of the graphic source the graphic container was constructed from or it can be the internal mime type image/x-vclgraphic, in which case the original mime type is not available anymore
        
        Currently, the following mime types are supported for loaded graphics:
        """
        ...
    @property
    def OriginURL(self) -> str:
        """
        The URL of the location from where the graphic was loaded from.
        
        **since**
        
            LibreOffice 6.1
        """
        ...
    @property
    def Size100thMM(self) -> 'Size_576707ef':
        """
        The Size of the graphic in 100th mm.
        
        This property may not be available in case of pixel graphics or if the logical size can not be determined correctly for some formats without loading the whole graphic
        """
        ...
    @property
    def SizePixel(self) -> 'Size_576707ef':
        """
        The Size of the graphic in pixel.
        
        This property may not be available in case of vector graphics or if the pixel size can not be determined correctly for some formats without loading the whole graphic
        """
        ...
    @property
    def Transparent(self) -> bool:
        """
        Indicates that it is a transparent graphic.
        
        This property is always TRUE for vector graphics. The status of this flag is not always clear if the graphic was not loaded at all, e.g. in case of just querying for the GraphicDescriptor.
        """
        ...

