# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.formula
# Libre Office Version: 7.4
from typing_extensions import Literal
import typing


class SymbolDescriptor(object):
    """
    Struct Class

    
    .. deprecated::
    
        Class is deprecated.

    See Also:
        `API SymbolDescriptor <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1formula_1_1SymbolDescriptor.html>`_
    """
    typeName: Literal['com.sun.star.formula.SymbolDescriptor']

    def __init__(self, sName: typing.Optional[str] = ..., sExportName: typing.Optional[str] = ..., sSymbolSet: typing.Optional[str] = ..., nCharacter: typing.Optional[int] = ..., sFontName: typing.Optional[str] = ..., nCharSet: typing.Optional[int] = ..., nFamily: typing.Optional[int] = ..., nPitch: typing.Optional[int] = ..., nWeight: typing.Optional[int] = ..., nItalic: typing.Optional[int] = ...) -> None:
        """
        Constructor

        Arguments:
            sName (str, optional): sName value.
            sExportName (str, optional): sExportName value.
            sSymbolSet (str, optional): sSymbolSet value.
            nCharacter (int, optional): nCharacter value.
            sFontName (str, optional): sFontName value.
            nCharSet (int, optional): nCharSet value.
            nFamily (int, optional): nFamily value.
            nPitch (int, optional): nPitch value.
            nWeight (int, optional): nWeight value.
            nItalic (int, optional): nItalic value.
        """
        ...


    @property
    def sName(self) -> str:
        """
        The name of the symbol.
        """
        ...


    @property
    def sExportName(self) -> str:
        """
        The export name of the symbol.
        """
        ...


    @property
    def sSymbolSet(self) -> str:
        """
        Specifies the name of the symbol set to which this symbol belongs.
        """
        ...


    @property
    def nCharacter(self) -> int:
        """
        Specifies the Unicode character of the symbol.
        """
        ...


    @property
    def sFontName(self) -> str:
        """
        Specifies the exact name of the font (\"Arial\", \"Courier\", etc.).
        """
        ...


    @property
    def nCharSet(self) -> int:
        """
        Specifies the character set which is supported by the font.
        """
        ...


    @property
    def nFamily(self) -> int:
        """
        Specifies the general style of the font.
        """
        ...


    @property
    def nPitch(self) -> int:
        """
        Specifies the pitch of the font.
        """
        ...


    @property
    def nWeight(self) -> int:
        """
        Specifies the thickness of the line.
        
        The allowed integer values correspond as follows: 0 : com.sun.star.awt.FontWeight.DONTKNOW 1 : com.sun.star.awt.FontWeight.THIN 2 : com.sun.star.awt.FontWeight.ULTRALIGHT 3 : com.sun.star.awt.FontWeight.LIGHT 4 : com.sun.star.awt.FontWeight.SEMILIGHT 5 : com.sun.star.awt.FontWeight.NORMAL 7 : com.sun.star.awt.FontWeight.SEMIBOLD 8 : com.sun.star.awt.FontWeight.BOLD 9 : com.sun.star.awt.FontWeight.ULTRABOLD 10 : com.sun.star.awt.FontWeight.BLACK
        """
        ...


    @property
    def nItalic(self) -> int:
        """
        Specifies if the font is italic.
        
        The values com.sun.star.awt.FontSlant.REVERSE_OBLIQUE and com.sun.star.awt.FontSlant.REVERSE_ITALIC may not be used.
        """
        ...


