# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.datatransfer.dnd
from typing_extensions import Literal
import typing
from ...uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from ..x_transferable import XTransferable as XTransferable_2d800f38
    from .drag_gesture_event import DragGestureEvent as DragGestureEvent_9e7211ca
    from .x_drag_source_listener import XDragSourceListener as XDragSourceListener_d56f12f8

class XDragSource(XInterface_8f010a43):
    """
    This interface is implemented by a view or window that supports drag operations and will be received as part of a DragGestureEvent through a com.sun.star.datatransfer.dnd.XDragGestureListener.dragGestureRecognized() callback.
    
    Differently to Java, the association between view and interface is fixed and can not be changed. Otherwise, the AWT messaging would have to be implemented for any window supporting Drag and Drop operations, which would be a real performance issue.

    See Also:
        `API XDragSource <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1datatransfer_1_1dnd_1_1XDragSource.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.datatransfer.dnd.XDragSource']

    def getDefaultCursor(self, dragAction: int) -> int:
        """
        To get the default cursor for a specified drag action.
        
        The returned value may be used as parameter for the method com.sun.star.datatransfer.dnd.XDragSourceContext.setCursor().

        Raises:
            com.sun.star.lang.IllegalArgumentException: ``IllegalArgumentException``
        """
        ...
    def isDragImageSupported(self) -> bool:
        """
        In order to query if drag image support is available.
        """
        ...
    def startDrag(self, trigger: 'DragGestureEvent_9e7211ca', sourceActions: int, cursor: int, image: int, trans: 'XTransferable_2d800f38', listener: 'XDragSourceListener_d56f12f8') -> None:
        """
        Starts the drag operation.
        
        Note: this call does not block until the drag and drop operation ends. If the Drag and Drop system is unable to initiate a drag operation or if the user attempts to start a drag while an existing drag operation is still executing, the action fails immediately. This is indicated by calling com.sun.star.datatransfer.dnd.XDragSourceListener.dragDropEnd() on the parameter listener with a DragSourceDragEvent showing a failure.
        """
        ...


