# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Interface Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.configuration.backend
from typing_extensions import Literal
import typing
from ...uno.x_interface import XInterface as XInterface_8f010a43
if typing.TYPE_CHECKING:
    from .template_identifier import TemplateIdentifier as TemplateIdentifier_2aaa14b5

class XLayerHandler(XInterface_8f010a43):
    """
    receives a description of a configuration layer as a sequence of events.
    
    **since**
    
        OOo 1.1.2

    See Also:
        `API XLayerHandler <https://api.libreoffice.org/docs/idl/ref/interfacecom_1_1sun_1_1star_1_1configuration_1_1backend_1_1XLayerHandler.html>`_
    """
    __pyunointerface__: Literal['com.sun.star.configuration.backend.XLayerHandler']

    def addOrReplaceNode(self, aName: str, aAttributes: int) -> None:
        """
        receives notification that a new item is started.
        
        The current node must be a set and a preexisting item (if any) must be removable.
        
        The new item will be created from the default template of the set.
        
        Subsequent calls describe the difference from the template of properties and members or items of the node until a matching call to XLayerHandler.endNode() is encountered.
        
        The value is a combination of NodeAttribute flags. Note that NodeAttribute.FUSE has an impact on the semantics of this method.
        
        Not every implementation can detect each condition

        Raises:
            MalformedDataException: ``MalformedDataException``
            com.sun.star.lang.WrappedTargetException: ``WrappedTargetException``
        """
        ...
    def addOrReplaceNodeFromTemplate(self, aName: str, aTemplate: 'TemplateIdentifier_2aaa14b5', aAttributes: int) -> None:
        """
        receives notification that a new item based on a particular template is started.
        
        The current node must be a set and a preexisting item (if any) must be removable.
        
        Subsequent calls describe the difference from the template of properties and members or items of the node until a matching call to XLayerHandler.endNode() is encountered.
        
        The value is a combination of NodeAttribute flags. Note that NodeAttribute.FUSE has an impact on the semantics of this method.
        
        Not every implementation can detect each condition

        Raises:
            MalformedDataException: ``MalformedDataException``
            com.sun.star.lang.WrappedTargetException: ``WrappedTargetException``
        """
        ...
    def addProperty(self, aName: str, aAttributes: int, aType: object) -> None:
        """
        receives notification that a property having a VOID value is added to the current node.
        
        The current node must be extensible.
        
        The value is a combination of NodeAttribute flags and may also contain the SchemaAttribute.REQUIRED flag.
        
        NodeAttribute.MANDATORY need not be set, as dynamically added properties always are mandatory in subsequent layers.
        
        Not every implementation can detect each condition

        Raises:
            MalformedDataException: ``MalformedDataException``
            com.sun.star.lang.WrappedTargetException: ``WrappedTargetException``
        """
        ...
    def addPropertyWithValue(self, aName: str, aAttributes: int, aValue: object) -> None:
        """
        receives notification that a property having a non-VOID value is added to the current node.
        
        The current node must be extensible.
        
        The value is a combination of NodeAttribute flags and may also contain the SchemaAttribute.REQUIRED flag.
        
        NodeAttribute.MANDATORY need not be set, as dynamic properties always are mandatory in subsequent layers.
        
        The value also determines the type. Therefore the value must not be VOID.
        
        Not every implementation can detect each condition

        Raises:
            MalformedDataException: ``MalformedDataException``
            com.sun.star.lang.WrappedTargetException: ``WrappedTargetException``
        """
        ...
    def dropNode(self, aName: str) -> None:
        """
        receives notification that a node is dropped from a set.
        
        The current node must be a set and the item must be removable.
        
        Not every implementation can detect each condition

        Raises:
            MalformedDataException: ``MalformedDataException``
            com.sun.star.lang.WrappedTargetException: ``WrappedTargetException``
        """
        ...
    def endLayer(self) -> None:
        """
        receives notification that a layer description is complete.
        
        Must match a previous call to XLayerHandler.startLayer().
        
        Not every implementation can detect each condition

        Raises:
            MalformedDataException: ``MalformedDataException``
            com.sun.star.lang.WrappedTargetException: ``WrappedTargetException``
        """
        ...
    def endNode(self) -> None:
        """
        receives notification that a node description is complete.
        
        Must match the last open call to XLayerHandler.overrideNode(), XLayerHandler.addOrReplaceNode() or XLayerHandler.addOrReplaceNodeFromTemplate().
        
        Not every implementation can detect each condition

        Raises:
            MalformedDataException: ``MalformedDataException``
            com.sun.star.lang.WrappedTargetException: ``WrappedTargetException``
        """
        ...
    def endProperty(self) -> None:
        """
        receives notification that a property description is complete.
        
        Must match an open call to XLayerHandler.overrideProperty(),
        
        Not every implementation can detect each condition

        Raises:
            MalformedDataException: ``MalformedDataException``
            com.sun.star.lang.WrappedTargetException: ``WrappedTargetException``
        """
        ...
    def overrideNode(self, aName: str, aAttributes: int, bClear: bool) -> None:
        """
        receives notification that a description of a node override is started.
        
        Subsequent calls describe overrides to properties and members or items of the node until a matching call to XLayerHandler.endNode()is encountered.
        
        The value is a combination of NodeAttribute flags.
        
        The attributes are combined cumulatively with those set on lower layers.
        
        Not every implementation can detect each condition

        Raises:
            MalformedDataException: ``MalformedDataException``
            com.sun.star.lang.WrappedTargetException: ``WrappedTargetException``
        """
        ...
    def overrideProperty(self, aName: str, aAttributes: int, aType: object, bClear: bool) -> None:
        """
        receives notification that an existing property is modified.
        
        Subsequent calls describe new value(s) for the property until a matching call to XLayerHandler.endProperty() is encountered.
        
        The value is a combination of NodeAttribute flags.
        
        The attributes are combined cumulatively with those set on lower layers.
        
        This must be the same type as is already defined in the schema or lower layers, unless the previous type was unspecified (as indicated by com.sun.star.uno.TypeClass.ANY.)
        
        A VOID type indicates that the type is unspecified in this layer. In this case any subsequent value may be of a generic type (e.g. string or - for list values - string[].) Such values may be converted to the type defined in the schema by the implementation.
        
        Not every implementation can detect each condition

        Raises:
            MalformedDataException: ``MalformedDataException``
            com.sun.star.lang.WrappedTargetException: ``WrappedTargetException``
        """
        ...
    def setPropertyValue(self, aValue: object) -> None:
        """
        receives notification that the value of the current property is overridden.
        
        The value must match the type of the current property. If the property does not have the SchemaAttribute.REQUIRED flag set, the value can be VOID.
        
        If the current property is localized, this value applies to the default locale.
        
        Not every implementation can detect each condition

        Raises:
            MalformedDataException: ``MalformedDataException``
            com.sun.star.lang.WrappedTargetException: ``WrappedTargetException``
        """
        ...
    def setPropertyValueForLocale(self, aValue: object, aLocale: str) -> None:
        """
        receives notification that the value of the current localized property is overridden for a specific locale .
        
        The value must match the type of the current property. If the property does not have the SchemaAttribute.REQUIRED flag set, the value can be VOID.
        
        Not every implementation can detect each condition

        Raises:
            MalformedDataException: ``MalformedDataException``
            com.sun.star.lang.WrappedTargetException: ``WrappedTargetException``
        """
        ...
    def startLayer(self) -> None:
        """
        receives notification that a layer description is started for a component.
        
        Subsequent calls describe the contents of the layer until a matching call to XLayerHandler.endLayer() is encountered.

        Raises:
            MalformedDataException: ``MalformedDataException``
            com.sun.star.lang.WrappedTargetException: ``WrappedTargetException``
        """
        ...


