# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.4
# Namespace: com.sun.star.awt
from typing_extensions import Literal


class SystemPointer(object):
    """
    Const

    specifies the shape of a mouse pointer.

    See Also:
        `API SystemPointer <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1awt_1_1SystemPointer.html>`_
    """
    ARROW: Literal[0]
    """
    specifies the normal arrow-like mouse pointer.
    """
    INVISIBLE: Literal[1]
    """
    specifies an invisible mouse pointer.
    """
    WAIT: Literal[2]
    """
    specifies a waiting symbol as a mouse pointer (for example hourglass).
    """
    TEXT: Literal[3]
    """
    specifies a mouse pointer for text (cursor-like).
    """
    HELP: Literal[4]
    """
    specifies a mouse pointer for on-line help.
    """
    CROSS: Literal[5]
    """
    specifies a cross as a mouse pointer.
    """
    MOVE: Literal[6]
    """
    specifies a mouse pointer which symbolizes movement.
    """
    NSIZE: Literal[7]
    """
    specifies a mouse pointer which symbolizes resizing for a top border.
    """
    SSIZE: Literal[8]
    """
    specifies a mouse pointer which symbolizes resizing for a bottom border.
    """
    WSIZE: Literal[9]
    """
    specifies a mouse pointer which symbolizes resizing for a left border.
    """
    ESIZE: Literal[10]
    """
    specifies a mouse pointer which symbolizes resizing for a right border.
    """
    NWSIZE: Literal[11]
    """
    specifies a mouse pointer which symbolizes resizing for the top-left corner.
    """
    NESIZE: Literal[12]
    """
    specifies a mouse pointer which symbolizes resizing for the top-right corner.
    """
    SWSIZE: Literal[13]
    """
    specifies a mouse pointer which symbolizes resizing for the bottom-left corner.
    """
    SESIZE: Literal[14]
    """
    specifies a mouse pointer which symbolizes resizing for the bottom-right corner.
    """
    WINDOW_NSIZE: Literal[15]
    """
    specifies a mouse pointer which symbolizes window resizing for a top border.
    """
    WINDOW_SSIZE: Literal[16]
    """
    specifies a mouse pointer which symbolizes window resizing for a bottom border.
    """
    WINDOW_WSIZE: Literal[17]
    """
    specifies a mouse pointer which symbolizes window resizing for a left border.
    """
    WINDOW_ESIZE: Literal[18]
    """
    specifies a mouse pointer which symbolizes window resizing for a right border.
    """
    WINDOW_NWSIZE: Literal[19]
    """
    specifies a mouse pointer which symbolizes window resizing for the top-left corner.
    """
    WINDOW_NESIZE: Literal[20]
    """
    specifies a mouse pointer which symbolizes window resizing for the top-right corner.
    """
    WINDOW_SWSIZE: Literal[21]
    """
    specifies a mouse pointer which symbolizes window resizing for the bottom-left corner.
    """
    WINDOW_SESIZE: Literal[22]
    """
    specifies a mouse pointer which symbolizes window resizing for the bottom-right corner.
    """
    HSPLIT: Literal[23]
    """
    specifies a mouse pointer which symbolizes horizontal splitting.
    """
    VSPLIT: Literal[24]
    """
    specifies a mouse pointer which symbolizes vertical splitting.
    """
    HSIZEBAR: Literal[25]
    """
    specifies a mouse pointer which symbolizes horizontal resizing.
    """
    VSIZEBAR: Literal[26]
    """
    specifies a mouse pointer which symbolizes vertical resizing.
    """
    HAND: Literal[27]
    """
    specifies a hand symbol as mouse pointer.
    """
    REFHAND: Literal[28]
    """
    specifies a pointing hand symbol as mouse pointer.
    """
    PEN: Literal[29]
    """
    specifies a pen symbol as mouse pointer.
    """
    MAGNIFY: Literal[30]
    """
    specifies a magnify symbol as mouse pointer.
    """
    FILL: Literal[31]
    """
    specifies a fill symbol as mouse pointer.
    """
    ROTATE: Literal[32]
    """
    specifies a rotate symbol as mouse pointer.
    """
    HSHEAR: Literal[33]
    """
    specifies a horizontal shear symbol as mouse pointer.
    """
    VSHEAR: Literal[34]
    """
    specifies a vertical shear symbol as mouse pointer.
    """
    MIRROR: Literal[35]
    """
    specifies a mirror symbol as mouse pointer.
    """
    CROOK: Literal[36]
    """
    specifies a crook symbol as mouse pointer.
    """
    CROP: Literal[37]
    """
    specifies a crop symbol as mouse pointer.
    """
    MOVEPOINT: Literal[38]
    """
    specifies a mouse pointer which symbolizes moving a point.
    """
    MOVEBEZIERWEIGHT: Literal[39]
    """
    specifies a mouse pointer which symbolizes moving a Bezier weight.
    """
    MOVEDATA: Literal[40]
    """
    specifies a mouse pointer which symbolizes moving data.
    """
    COPYDATA: Literal[41]
    """
    specifies a mouse pointer which symbolizes copying data.
    """
    LINKDATA: Literal[42]
    """
    specifies a mouse pointer which symbolizes linking data.
    """
    MOVEDATALINK: Literal[43]
    """
    specifies a mouse pointer which symbolizes moving a data link.
    """
    COPYDATALINK: Literal[44]
    """
    specifies a mouse pointer which symbolizes copying a data link.
    """
    MOVEFILE: Literal[45]
    """
    specifies a mouse pointer which symbolizes moving a file.
    """
    COPYFILE: Literal[46]
    """
    specifies a mouse pointer which symbolizes copying a file.
    """
    LINKFILE: Literal[47]
    """
    specifies a mouse pointer which symbolizes linking a file.
    """
    MOVEFILELINK: Literal[48]
    """
    specifies a mouse pointer which symbolizes moving a file link.
    """
    COPYFILELINK: Literal[49]
    """
    specifies a mouse pointer which symbolizes copying a file link.
    """
    MOVEFILES: Literal[50]
    """
    specifies a mouse pointer which symbolizes moving multiple files.
    """
    COPYFILES: Literal[51]
    """
    specifies a mouse pointer which symbolizes copying multiple files.
    """
    NOTALLOWED: Literal[52]
    """
    specifies a mouse pointer which symbolizes \"not allowed\".
    """
    DRAW_LINE: Literal[53]
    """
    specifies a mouse pointer which symbolizes drawing a line.
    """
    DRAW_RECT: Literal[54]
    """
    specifies a mouse pointer which symbolizes drawing a rectangle.
    """
    DRAW_POLYGON: Literal[55]
    """
    specifies a mouse pointer which symbolizes drawing a polygon.
    """
    DRAW_BEZIER: Literal[56]
    """
    specifies a mouse pointer which symbolizes drawing a Bezier.
    """
    DRAW_ARC: Literal[57]
    """
    specifies a mouse pointer which symbolizes drawing an arc.
    """
    DRAW_PIE: Literal[58]
    """
    specifies a mouse pointer which symbolizes drawing a pie.
    """
    DRAW_CIRCLECUT: Literal[59]
    """
    specifies a mouse pointer which symbolizes drawing a circle cut.
    """
    DRAW_ELLIPSE: Literal[60]
    """
    specifies a mouse pointer which symbolizes drawing an ellipse.
    """
    DRAW_FREEHAND: Literal[61]
    """
    specifies a mouse pointer which symbolizes drawing free handed.
    """
    DRAW_CONNECT: Literal[62]
    """
    specifies a mouse pointer which symbolizes drawing a connector.
    """
    DRAW_TEXT: Literal[63]
    """
    specifies a mouse pointer which symbolizes drawing text.
    """
    DRAW_CAPTION: Literal[64]
    """
    specifies a mouse pointer which symbolizes drawing a text caption.
    """
    CHART: Literal[65]
    """
    specifies a mouse pointer which symbolizes a chart.
    """
    DETECTIVE: Literal[66]
    """
    specifies a mouse pointer which symbolizes a detective.
    """
    PIVOT_COL: Literal[67]
    """
    specifies a mouse pointer which symbolizes a pivot column.
    """
    PIVOT_ROW: Literal[68]
    """
    specifies a mouse pointer which symbolizes a pivot row.
    """
    PIVOT_FIELD: Literal[69]
    """
    specifies a mouse pointer which symbolizes a pivot field.
    """
    CHAIN: Literal[70]
    """
    specifies a mouse pointer which symbolizes a chain.
    """
    CHAIN_NOTALLOWED: Literal[71]
    """
    specifies a mouse pointer which symbolizes \"chaining not allowed\".
    """

