/*
 * Decompiled with CFR 0.152.
 */
package org.planit.utils.id;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.id.LocalIdGenerator;

public final class IdGenerator {
    private static final Logger LOGGER = Logger.getLogger(IdGenerator.class.getCanonicalName());
    private static Map<IdGroupingToken, LocalIdGenerator> idGroups = new HashMap<IdGroupingToken, LocalIdGenerator>();

    protected static LocalIdGenerator createIdGeneratorForParent(IdGroupingToken group) {
        LocalIdGenerator idGenerator = new LocalIdGenerator();
        idGroups.put(group, idGenerator);
        LOGGER.fine("created id group for" + group.toString());
        return idGroups.get(group);
    }

    public static int generateId(IdGroupingToken group, Class<? extends Object> theClass) {
        LocalIdGenerator idGeneratorForGroup = null;
        idGeneratorForGroup = !idGroups.containsKey(group) ? IdGenerator.createIdGeneratorForParent(group) : idGroups.get(group);
        return idGeneratorForGroup.generateId(theClass);
    }

    public static void reset() {
        idGroups.clear();
    }

    public static IdGroupingToken createIdGroupingToken(String groupDescription) {
        return new IdGroupingToken(groupDescription);
    }

    public static IdGroupingToken createIdGroupingToken(Object groupOwner, long groupOwnerId) {
        return new IdGroupingToken(groupOwner.getClass().getSimpleName() + "-" + Long.toString(groupOwnerId));
    }
}

