/*
 * Decompiled with CFR 0.152.
 */
package org.planit.trafficassignment.builder;

import org.planit.demands.Demands;
import org.planit.input.InputBuilderListener;
import org.planit.network.physical.PhysicalNetwork;
import org.planit.network.virtual.Zoning;
import org.planit.supply.fundamentaldiagram.FundamentalDiagram;
import org.planit.supply.network.nodemodel.NodeModel;
import org.planit.trafficassignment.CapacityConstrainedAssignment;
import org.planit.trafficassignment.TrafficAssignmentComponentFactory;
import org.planit.trafficassignment.builder.TrafficAssignmentBuilder;
import org.planit.utils.exceptions.PlanItException;

public class CapacityConstrainedTrafficAssignmentBuilder
extends TrafficAssignmentBuilder {
    protected final TrafficAssignmentComponentFactory<FundamentalDiagram> fundamentalDiagramFactory = new TrafficAssignmentComponentFactory<FundamentalDiagram>(FundamentalDiagram.class);
    protected final TrafficAssignmentComponentFactory<NodeModel> nodeModelFactory = new TrafficAssignmentComponentFactory<NodeModel>(NodeModel.class);

    protected CapacityConstrainedTrafficAssignmentBuilder(CapacityConstrainedAssignment capacityConstrainedAssignment, InputBuilderListener trafficComponentCreateListener, Demands demands, Zoning zoning, PhysicalNetwork physicalNetwork) throws PlanItException {
        super(capacityConstrainedAssignment, trafficComponentCreateListener, demands, zoning, physicalNetwork);
        this.fundamentalDiagramFactory.addListener(trafficComponentCreateListener, TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE);
        this.nodeModelFactory.addListener(trafficComponentCreateListener, TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE);
    }

    public FundamentalDiagram createAndRegisterFundamentalDiagram(String fundamentalDiagramType, PhysicalNetwork physicalNetwork) throws PlanItException {
        FundamentalDiagram createdFundamentalDiagram = this.fundamentalDiagramFactory.create(fundamentalDiagramType, new Object[]{this.parentAssignment.getIdGroupingtoken()}, physicalNetwork);
        ((CapacityConstrainedAssignment)this.parentAssignment).setFundamentalDiagram(createdFundamentalDiagram);
        return createdFundamentalDiagram;
    }

    public NodeModel createAndRegisterNodeModel(String nodeModelType) throws PlanItException {
        NodeModel createdNodeModel = this.nodeModelFactory.create(nodeModelType, new Object[]{this.parentAssignment.getIdGroupingtoken()});
        ((CapacityConstrainedAssignment)this.parentAssignment).setNodeModel(createdNodeModel);
        return createdNodeModel;
    }
}

