/*
 * Decompiled with CFR 0.152.
 */
package org.planit.trafficassignment;

import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.djutils.event.Event;
import org.djutils.event.EventInterface;
import org.djutils.event.EventType;
import org.planit.algorithms.shortestpath.DijkstraShortestPathAlgorithm;
import org.planit.algorithms.shortestpath.ShortestPathAlgorithm;
import org.planit.cost.Cost;
import org.planit.cost.physical.initial.InitialLinkSegmentCost;
import org.planit.cost.physical.initial.InitialPhysicalCost;
import org.planit.data.ModeData;
import org.planit.data.SimulationData;
import org.planit.data.TraditionalStaticAssignmentSimulationData;
import org.planit.demands.Demands;
import org.planit.gap.LinkBasedRelativeDualityGapFunction;
import org.planit.input.InputBuilderListener;
import org.planit.interactor.LinkVolumeAccessee;
import org.planit.interactor.LinkVolumeAccessor;
import org.planit.network.physical.PhysicalNetwork;
import org.planit.network.virtual.Zoning;
import org.planit.od.odmatrix.ODMatrixIterator;
import org.planit.od.odmatrix.demand.ODDemandMatrix;
import org.planit.od.odmatrix.skim.ODSkimMatrix;
import org.planit.od.odroute.ODRouteMatrix;
import org.planit.output.adapter.OutputTypeAdapter;
import org.planit.output.adapter.OutputTypeAdapterImpl;
import org.planit.output.adapter.TraditionalStaticAssignmentLinkOutputTypeAdapter;
import org.planit.output.adapter.TraditionalStaticAssignmentODOutputTypeAdapter;
import org.planit.output.adapter.TraditionalStaticRouteOutputTypeAdapter;
import org.planit.output.enums.ODSkimSubOutputType;
import org.planit.output.enums.OutputType;
import org.planit.route.Route;
import org.planit.time.TimePeriod;
import org.planit.trafficassignment.TrafficAssignment;
import org.planit.trafficassignment.builder.TraditionalStaticAssignmentBuilder;
import org.planit.trafficassignment.builder.TrafficAssignmentBuilder;
import org.planit.utils.arrays.ArrayOperations;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.graph.Vertex;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.misc.LoggingUtils;
import org.planit.utils.misc.Pair;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.network.physical.Mode;
import org.planit.utils.network.physical.Node;
import org.planit.utils.network.virtual.Centroid;
import org.planit.utils.network.virtual.ConnectoidSegment;
import org.planit.utils.network.virtual.Zone;

public class TraditionalStaticAssignment
extends TrafficAssignment
implements LinkVolumeAccessee {
    private static final long serialVersionUID = -4610905345414397908L;
    private static final Logger LOGGER = Logger.getLogger(TraditionalStaticAssignment.class.getCanonicalName());
    private static final double DEFAULT_FLOW_EPSILON = 1.0E-6;
    private TraditionalStaticAssignmentSimulationData simulationData = null;

    protected String createLoggingPrefix() {
        return super.createLoggingPrefix(this.simulationData.getIterationIndex());
    }

    private void initialiseTimePeriod(Set<Mode> modes) throws PlanItException {
        this.simulationData = new TraditionalStaticAssignmentSimulationData(this.groupId, this.outputManager);
        this.simulationData.setIterationIndex(0);
        this.simulationData.getModeSpecificData().clear();
        for (Mode mode : modes) {
            this.simulationData.resetModalNetworkSegmentFlows(mode, this.numberOfNetworkSegments);
            this.simulationData.getModeSpecificData().put(mode, new ModeData(new double[this.numberOfNetworkSegments]));
        }
    }

    private void applySmoothing(ModeData modeData) {
        double[] smoothedSegmentFlows = this.smoothing.applySmoothing(modeData.currentNetworkSegmentFlows, modeData.nextNetworkSegmentFlows, this.numberOfNetworkSegments);
        modeData.currentNetworkSegmentFlows = smoothedSegmentFlows;
    }

    private void executeModeTimePeriod(Mode mode, ODDemandMatrix odDemandMatrix, ModeData currentModeData, double[] modalNetworkSegmentCosts, ShortestPathAlgorithm shortestPathAlgorithm) throws PlanItException {
        LinkBasedRelativeDualityGapFunction dualityGapFunction = (LinkBasedRelativeDualityGapFunction)this.getGapFunction();
        ODRouteMatrix odRouteMatrix = this.simulationData.getODPathMatrix(mode);
        Map<ODSkimSubOutputType, ODSkimMatrix> skimMatrixMap = this.simulationData.getSkimMatrixMap(mode);
        long previousOriginZoneId = -1L;
        Pair<Double, EdgeSegment>[] vertexPathAndCosts = null;
        ODMatrixIterator odDemandMatrixIter = odDemandMatrix.iterator();
        while (odDemandMatrixIter.hasNext()) {
            double odDemand = odDemandMatrixIter.next();
            Zone currentOriginZone = odDemandMatrixIter.getCurrentOrigin();
            Zone currentDestinationZone = odDemandMatrixIter.getCurrentDestination();
            if (currentOriginZone.getId() == currentDestinationZone.getId() || !this.outputManager.getOutputConfiguration().isPersistZeroFlow() && !(odDemand - 1.0E-6 > 0.0)) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(LoggingUtils.createRunIdPrefix(this.getId()) + String.format("(O,D)=(%d,%d) --> demand (pcu/h): %f (mode: %d)", currentOriginZone.getExternalId(), currentDestinationZone.getExternalId(), odDemand, mode.getExternalId()));
            }
            if (previousOriginZoneId != currentOriginZone.getId()) {
                Centroid originCentroid = currentOriginZone.getCentroid();
                PlanItException.throwIf(originCentroid.getExitEdgeSegments().isEmpty(), String.format("edge segments have not been assigned to Centroid for Zone %d", currentOriginZone.getExternalId()));
                vertexPathAndCosts = shortestPathAlgorithm.executeOneToAll(originCentroid);
            }
            if (this.outputManager.isOutputTypeActive(OutputType.PATH)) {
                Route route = Route.createRoute(this.groupId, currentDestinationZone.getCentroid(), vertexPathAndCosts);
                odRouteMatrix.setValue(currentOriginZone, currentDestinationZone, route);
            }
            double odShortestPathCost = 0.0;
            if (odDemand - 1.0E-6 > 0.0) {
                try {
                    odShortestPathCost = this.getShortestPathCost(vertexPathAndCosts, currentOriginZone, currentDestinationZone, modalNetworkSegmentCosts, odDemand, currentModeData);
                    dualityGapFunction.increaseConvexityBound(odDemand * odShortestPathCost);
                }
                catch (PlanItException e) {
                    LOGGER.warning(e.getMessage());
                    LOGGER.info(this.createLoggingPrefix() + "impossible path from origin zone " + currentOriginZone.getExternalId() + " to destination zone " + currentDestinationZone.getExternalId() + " (mode " + mode.getExternalId() + ")");
                }
            }
            previousOriginZoneId = currentOriginZone.getId();
            this.updateSkimMatrixMap(skimMatrixMap, currentOriginZone, currentDestinationZone, odDemand, vertexPathAndCosts);
        }
    }

    private double getShortestPathCost(Pair<Double, EdgeSegment>[] vertexPathAndCost, Zone currentOriginZone, Zone currentDestinationZone, double[] modalNetworkSegmentCosts, double odDemand, ModeData currentModeData) throws PlanItException {
        double shortestPathCost = 0.0;
        EdgeSegment currentEdgeSegment = null;
        Vertex currentPathStartVertex = currentDestinationZone.getCentroid();
        while (currentPathStartVertex.getId() != currentOriginZone.getCentroid().getId()) {
            int startVertexId = (int)currentPathStartVertex.getId();
            currentEdgeSegment = vertexPathAndCost[startVertexId].getSecond();
            if (currentEdgeSegment == null) {
                PlanItException.throwIf(currentPathStartVertex instanceof Centroid, "The solution could not find an Edge Segment for the connectoid for zone " + currentPathStartVertex.getParentZone().getExternalId());
                throw new PlanItException("The solution could not find an Edge Segment for node " + ((Node)currentPathStartVertex).getId());
            }
            int edgeSegmentId = (int)currentEdgeSegment.getId();
            shortestPathCost += modalNetworkSegmentCosts[edgeSegmentId];
            int n = edgeSegmentId;
            currentModeData.nextNetworkSegmentFlows[n] = currentModeData.nextNetworkSegmentFlows[n] + odDemand;
            currentPathStartVertex = currentEdgeSegment.getUpstreamVertex();
        }
        return shortestPathCost;
    }

    private void updateSkimMatrixMap(Map<ODSkimSubOutputType, ODSkimMatrix> skimMatrixMap, Zone currentOriginZone, Zone currentDestinationZone, double odDemand, Pair<Double, EdgeSegment>[] vertexPathAndCosts) {
        for (ODSkimSubOutputType odSkimOutputType : this.simulationData.getActiveSkimOutputTypes()) {
            if (!odSkimOutputType.equals(ODSkimSubOutputType.COST)) continue;
            long destinationVertexId = currentDestinationZone.getCentroid().getId();
            Pair<Double, EdgeSegment> vertexPathCost = vertexPathAndCosts[(int)destinationVertexId];
            double odGeneralisedCost = vertexPathCost.getFirst();
            ODSkimMatrix odSkimMatrix = skimMatrixMap.get(odSkimOutputType);
            odSkimMatrix.setValue(currentOriginZone, currentDestinationZone, odGeneralisedCost);
        }
    }

    private void executeTimePeriod(TimePeriod timePeriod) throws PlanItException {
        Calendar startTime;
        Set<Mode> modes = this.demands.getRegisteredModesForTimePeriod(timePeriod);
        this.initialiseTimePeriod(modes);
        LinkBasedRelativeDualityGapFunction dualityGapFunction = (LinkBasedRelativeDualityGapFunction)this.getGapFunction();
        Calendar initialStartTime = startTime = Calendar.getInstance();
        for (Mode mode : modes) {
            double[] modalLinkSegmentCosts = this.initializeModalLinkSegmentCosts(mode, timePeriod);
            this.simulationData.setModalLinkSegmentCosts(mode, modalLinkSegmentCosts);
        }
        boolean converged = false;
        while (!converged) {
            double[] modalLinkSegmentCosts;
            dualityGapFunction.reset();
            this.smoothing.update(this.simulationData.getIterationIndex());
            for (Mode mode : modes) {
                this.simulationData.resetSkimMatrix(mode, this.getTransportNetwork().getZoning().zones);
                this.simulationData.resetPathMatrix(mode, this.getTransportNetwork().getZoning().zones);
                this.simulationData.resetModalNetworkSegmentFlows(mode, this.numberOfNetworkSegments);
                modalLinkSegmentCosts = this.simulationData.getModalLinkSegmentCosts(mode);
                this.executeAndSmoothTimePeriodAndMode(timePeriod, mode, modalLinkSegmentCosts);
            }
            dualityGapFunction.computeGap();
            this.simulationData.incrementIterationIndex();
            LOGGER.info(this.createLoggingPrefix() + String.format("Network travel time: %f", dualityGapFunction.getActualSystemTravelTime()));
            startTime = this.recordTime(startTime, dualityGapFunction.getGap());
            for (Mode mode : modes) {
                modalLinkSegmentCosts = this.recalculateModalLinkSegmentCosts(mode, timePeriod);
                this.simulationData.setModalLinkSegmentCosts(mode, modalLinkSegmentCosts);
            }
            converged = dualityGapFunction.hasConverged(this.simulationData.getIterationIndex());
            this.outputManager.persistOutputData(timePeriod, modes, converged);
        }
        LOGGER.info(LoggingUtils.createRunIdPrefix(this.getId()) + String.format("run time: %d milliseconds", startTime.getTimeInMillis() - initialStartTime.getTimeInMillis()));
    }

    private Calendar recordTime(Calendar startTime, double dualityGap) {
        Calendar currentTime = Calendar.getInstance();
        LOGGER.info(this.createLoggingPrefix() + String.format("duality gap: %.6f (%d ms)", dualityGap, currentTime.getTimeInMillis() - startTime.getTimeInMillis()));
        return currentTime;
    }

    private void executeAndSmoothTimePeriodAndMode(TimePeriod timePeriod, Mode mode, double[] modalNetworkSegmentCosts) throws PlanItException {
        LOGGER.fine(LoggingUtils.createRunIdPrefix(this.getId()) + String.format("[mode %d (id:%d)]", mode.getExternalId(), mode.getId()));
        ModeData currentModeData = this.simulationData.getModeSpecificData().get(mode);
        currentModeData.resetNextNetworkSegmentFlows();
        LinkBasedRelativeDualityGapFunction dualityGapFunction = (LinkBasedRelativeDualityGapFunction)this.getGapFunction();
        DijkstraShortestPathAlgorithm shortestPathAlgorithm = new DijkstraShortestPathAlgorithm(modalNetworkSegmentCosts, this.numberOfNetworkSegments, this.numberOfNetworkVertices);
        ODDemandMatrix odDemandMatrix = this.demands.get(mode, timePeriod);
        this.executeModeTimePeriod(mode, odDemandMatrix, currentModeData, modalNetworkSegmentCosts, shortestPathAlgorithm);
        double totalModeSystemTravelTime = ArrayOperations.dotProduct(currentModeData.currentNetworkSegmentFlows, modalNetworkSegmentCosts, this.numberOfNetworkSegments);
        dualityGapFunction.increaseActualSystemTravelTime(totalModeSystemTravelTime);
        this.applySmoothing(currentModeData);
        ArrayOperations.addTo(this.simulationData.getModalNetworkSegmentFlows(mode), currentModeData.currentNetworkSegmentFlows, this.numberOfNetworkSegments);
        this.simulationData.getModeSpecificData().put(mode, currentModeData);
    }

    private void populateModalConnectoidCosts(Mode mode, double[] currentSegmentCosts) throws PlanItException {
        for (ConnectoidSegment currentSegment : this.transportNetwork.getVirtualNetwork().connectoidSegments) {
            currentSegmentCosts[(int)currentSegment.getId()] = this.virtualCost.getSegmentCost(mode, currentSegment);
        }
    }

    private void calculateModalLinkSegmentCosts(Mode mode, double[] currentSegmentCosts) throws PlanItException {
        this.setModalLinkSegmentCosts(mode, currentSegmentCosts, this.physicalCost);
    }

    private boolean initializeModalLinkSegmentCostsForAllTimePeriods(Mode mode, double[] currentSegmentCosts) throws PlanItException {
        if (!this.initialLinkSegmentCost.isSegmentCostsSetForMode(mode)) {
            return false;
        }
        this.setModalLinkSegmentCosts(mode, currentSegmentCosts, this.initialLinkSegmentCost);
        return true;
    }

    private boolean initializeModalLinkSegmentCostsByTimePeriod(Mode mode, TimePeriod timePeriod, double[] currentSegmentCosts) throws PlanItException {
        InitialLinkSegmentCost initialLinkSegmentCostForTimePeriod = (InitialLinkSegmentCost)this.initialLinkSegmentCostByTimePeriod.get(timePeriod);
        if (!initialLinkSegmentCostForTimePeriod.isSegmentCostsSetForMode(mode)) {
            return false;
        }
        InitialPhysicalCost initialTimePeriodCost = (InitialPhysicalCost)this.initialLinkSegmentCostByTimePeriod.get(timePeriod);
        this.setModalLinkSegmentCosts(mode, currentSegmentCosts, initialTimePeriodCost);
        return true;
    }

    private double[] initializeModalLinkSegmentCosts(Mode mode, TimePeriod timePeriod) throws PlanItException {
        double[] currentSegmentCosts = new double[this.transportNetwork.getTotalNumberOfEdgeSegments()];
        this.populateModalConnectoidCosts(mode, currentSegmentCosts);
        if (this.initialLinkSegmentCostByTimePeriod.containsKey(timePeriod) ? this.initializeModalLinkSegmentCostsByTimePeriod(mode, timePeriod, currentSegmentCosts) : this.initialLinkSegmentCost != null && this.initializeModalLinkSegmentCostsForAllTimePeriods(mode, currentSegmentCosts)) {
            return currentSegmentCosts;
        }
        this.calculateModalLinkSegmentCosts(mode, currentSegmentCosts);
        return currentSegmentCosts;
    }

    private void setModalLinkSegmentCosts(Mode mode, double[] currentSegmentCosts, Cost<LinkSegment> cost) throws PlanItException {
        for (LinkSegment linkSegment : this.transportNetwork.getPhysicalNetwork().linkSegments) {
            double currentSegmentCost = Double.POSITIVE_INFINITY;
            if (linkSegment.isModeAllowedThroughLink(mode) && (currentSegmentCost = cost.getSegmentCost(mode, linkSegment)) < 0.0) {
                throw new PlanItException("Error during calculation of link segment costs");
            }
            currentSegmentCosts[(int)linkSegment.getId()] = currentSegmentCost;
        }
    }

    private double[] recalculateModalLinkSegmentCosts(Mode mode, TimePeriod timePeriod) throws PlanItException {
        double[] currentSegmentCosts = new double[this.transportNetwork.getTotalNumberOfEdgeSegments()];
        this.populateModalConnectoidCosts(mode, currentSegmentCosts);
        this.calculateModalLinkSegmentCosts(mode, currentSegmentCosts);
        return currentSegmentCosts;
    }

    @Override
    protected TrafficAssignmentBuilder createTrafficAssignmentBuilder(InputBuilderListener trafficComponentCreateListener, Demands demands, Zoning zoning, PhysicalNetwork physicalNetwork) throws PlanItException {
        return new TraditionalStaticAssignmentBuilder(this, trafficComponentCreateListener, demands, zoning, physicalNetwork);
    }

    @Override
    protected void addRegisteredEventTypeListeners(EventType eventType) {
        if (eventType.equals(LinkVolumeAccessee.INTERACTOR_PROVIDE_LINKVOLUMEACCESSEE)) {
            this.addListener(this, eventType);
        }
    }

    public TraditionalStaticAssignment(IdGroupingToken groupId) {
        super(groupId);
    }

    @Override
    public void executeEquilibration() throws PlanItException {
        SortedSet<TimePeriod> timePeriods = this.demands.timePeriods.asSortedSetByStartTime();
        LOGGER.info(LoggingUtils.createRunIdPrefix(this.getId()) + "total time periods: " + timePeriods.size());
        for (TimePeriod timePeriod : timePeriods) {
            LOGGER.info(LoggingUtils.createRunIdPrefix(this.getId()) + LoggingUtils.createTimePeriodPrefix(timePeriod.getExternalId(), timePeriod.getId()) + timePeriod.toString());
            this.executeTimePeriod(timePeriod);
        }
    }

    @Override
    public double getTotalNetworkSegmentFlow(LinkSegment linkSegment) {
        return this.simulationData.getTotalNetworkSegmentFlow(linkSegment);
    }

    @Override
    public double[] getModalNetworkSegmentFlows(Mode mode) {
        return this.simulationData.getModalNetworkSegmentFlows(mode);
    }

    @Override
    public int getNumberOfLinkSegments() {
        return this.getTransportNetwork().getTotalNumberOfPhysicalLinkSegments();
    }

    @Override
    public void notify(EventInterface event) throws RemoteException {
        if (event.getType().equals(LinkVolumeAccessor.INTERACTOR_REQUEST_LINKVOLUMEACCESSEE_TYPE) && event.getContent() instanceof LinkVolumeAccessor) {
            LinkVolumeAccessor theLinkVolumeAccessor = (LinkVolumeAccessor)event.getContent();
            this.addListener(theLinkVolumeAccessor, INTERACTOR_PROVIDE_LINKVOLUMEACCESSEE);
            this.fireEvent(new Event(INTERACTOR_PROVIDE_LINKVOLUMEACCESSEE, this, this));
        }
    }

    @Override
    public OutputTypeAdapter createOutputTypeAdapter(OutputType outputType) {
        OutputTypeAdapterImpl outputTypeAdapter = null;
        switch (outputType) {
            case LINK: {
                outputTypeAdapter = new TraditionalStaticAssignmentLinkOutputTypeAdapter(outputType, this);
                break;
            }
            case OD: {
                outputTypeAdapter = new TraditionalStaticAssignmentODOutputTypeAdapter(outputType, this);
                break;
            }
            case PATH: {
                outputTypeAdapter = new TraditionalStaticRouteOutputTypeAdapter(outputType, this);
                break;
            }
            default: {
                LOGGER.warning(LoggingUtils.createRunIdPrefix(this.getId()) + outputType.value() + " has not been defined yet.");
            }
        }
        return outputTypeAdapter;
    }

    @Override
    public SimulationData getSimulationData() {
        return this.simulationData;
    }
}

