/*
 * Decompiled with CFR 0.152.
 */
package org.planit.project;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.planit.cost.physical.initial.InitialLinkSegmentCost;
import org.planit.cost.physical.initial.InitialLinkSegmentCostPeriod;
import org.planit.cost.physical.initial.InitialPhysicalCost;
import org.planit.demands.Demands;
import org.planit.input.InputBuilderListener;
import org.planit.network.physical.PhysicalNetwork;
import org.planit.network.virtual.Zoning;
import org.planit.route.ODRouteSets;
import org.planit.time.TimePeriod;
import org.planit.trafficassignment.TrafficAssignmentComponentFactory;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.misc.LoggingUtils;

public class PlanItProjectInput {
    private static final Logger LOGGER = Logger.getLogger(PlanItProjectInput.class.getCanonicalName());
    private final IdGroupingToken projectGroupId;
    private final long projectId;
    protected final TreeMap<Long, PhysicalNetwork> physicalNetworkMap;
    protected final TreeMap<Long, Demands> demandsMap;
    protected final TreeMap<Long, ODRouteSets> odRouteSetsMap;
    protected final TreeMap<Long, Zoning> zoningsMap;
    protected final Map<PhysicalNetwork, List<InitialLinkSegmentCost>> initialLinkSegmentCosts = new HashMap<PhysicalNetwork, List<InitialLinkSegmentCost>>();
    protected TrafficAssignmentComponentFactory<PhysicalNetwork> physicalNetworkFactory;
    protected TrafficAssignmentComponentFactory<Demands> demandsFactory;
    protected TrafficAssignmentComponentFactory<Zoning> zoningFactory;
    protected TrafficAssignmentComponentFactory<ODRouteSets> odRouteSetsFactory;
    protected TrafficAssignmentComponentFactory<InitialPhysicalCost> initialPhysicalCostFactory;
    public final ProjectNetworks physicalNetworks = new ProjectNetworks();
    public final ProjectDemands demands = new ProjectDemands();
    public final ProjectZonings zonings = new ProjectZonings();
    public final ProjectODRouteSets odRouteSets = new ProjectODRouteSets();

    private void initialiseFactories(InputBuilderListener inputBuilderListener) {
        this.initialPhysicalCostFactory = new TrafficAssignmentComponentFactory<InitialPhysicalCost>(InitialPhysicalCost.class);
        this.physicalNetworkFactory = new TrafficAssignmentComponentFactory<PhysicalNetwork>(PhysicalNetwork.class);
        this.zoningFactory = new TrafficAssignmentComponentFactory<Zoning>(Zoning.class);
        this.demandsFactory = new TrafficAssignmentComponentFactory<Demands>(Demands.class);
        this.physicalNetworkFactory.addListener(inputBuilderListener, TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE);
        this.zoningFactory.addListener(inputBuilderListener, TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE);
        this.demandsFactory.addListener(inputBuilderListener, TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE);
        this.initialPhysicalCostFactory.addListener(inputBuilderListener, TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE);
    }

    public PlanItProjectInput(long projectId, IdGroupingToken projectGroupId, InputBuilderListener inputBuilderListener) {
        this.projectId = projectId;
        this.physicalNetworkMap = new TreeMap();
        this.demandsMap = new TreeMap();
        this.zoningsMap = new TreeMap();
        this.odRouteSetsMap = new TreeMap();
        this.projectGroupId = projectGroupId;
        this.initialiseFactories(inputBuilderListener);
    }

    public PhysicalNetwork createAndRegisterPhysicalNetwork(String physicalNetworkType) throws PlanItException {
        LOGGER.info(LoggingUtils.createProjectPrefix(this.projectId) + "populating network");
        PhysicalNetwork physicalNetwork = this.physicalNetworkFactory.create(physicalNetworkType, new Object[]{this.projectGroupId});
        String prefix = LoggingUtils.createProjectPrefix(this.projectId) + LoggingUtils.createNetworkPrefix(physicalNetwork.getId());
        LOGGER.info(String.format("%s#links: %d", prefix, physicalNetwork.links.getNumberOfLinks()));
        LOGGER.info(String.format("%s#link segments: %d", prefix, physicalNetwork.linkSegments.getNumberOfLinkSegments()));
        LOGGER.info(String.format("%s#nodes: %d", prefix, physicalNetwork.nodes.getNumberOfNodes()));
        LOGGER.info(String.format("%s#modes: %d", prefix, physicalNetwork.modes.getNumberOfModes()));
        this.physicalNetworkMap.put(physicalNetwork.getId(), physicalNetwork);
        return physicalNetwork;
    }

    public Zoning createAndRegisterZoning(PhysicalNetwork physicalNetwork) throws PlanItException {
        PlanItException.throwIf(physicalNetwork == null, "The physical network must be defined before definition of zones can begin");
        LOGGER.info(LoggingUtils.createProjectPrefix(this.projectId) + "populating zoning");
        Zoning zoning = this.zoningFactory.create(Zoning.class.getCanonicalName(), new Object[]{this.projectGroupId, physicalNetwork.getNetworkIdGroupingToken()}, physicalNetwork);
        String prefix = LoggingUtils.createProjectPrefix(this.projectId) + LoggingUtils.createZoningPrefix(zoning.getId());
        LOGGER.info(String.format("%s#zones: %d", prefix, zoning.zones.getNumberOfZones()));
        LOGGER.info(String.format("%s#centroids: %d", prefix, zoning.getVirtualNetwork().centroids.getNumberOfCentroids()));
        LOGGER.info(String.format("%s#connectoids: %d", prefix, zoning.getVirtualNetwork().connectoids.getNumberOfConnectoids()));
        LOGGER.info(String.format("%s#connectoid segments: %d", prefix, zoning.getVirtualNetwork().connectoidSegments.getNumberOfConnectoidSegments()));
        this.zoningsMap.put(zoning.getId(), zoning);
        return zoning;
    }

    public Demands createAndRegisterDemands(Zoning zoning, PhysicalNetwork physicalNetwork) throws PlanItException {
        PlanItException.throwIf(zoning == null, "Zones must be defined before definition of demands can begin");
        PlanItException.throwIf(physicalNetwork == null, "Physical network must be defined before definition of demands can begin");
        LOGGER.info(LoggingUtils.createProjectPrefix(this.projectId) + "populating demands");
        Demands demands = this.demandsFactory.create(Demands.class.getCanonicalName(), new Object[]{this.projectGroupId}, zoning, physicalNetwork);
        String prefix = LoggingUtils.createProjectPrefix(this.projectId) + LoggingUtils.createDemandsPrefix(demands.getId());
        LOGGER.info(String.format("%s#time periods: %d", prefix, demands.timePeriods.getNumberOfTimePeriods()));
        LOGGER.info(String.format("%s#traveler types: %d", prefix, demands.travelerTypes.getNumberOfTravelerTypes()));
        LOGGER.info(String.format("%s#user classes: %d", prefix, demands.userClasses.getNumberOfUserClasses()));
        this.demandsMap.put(demands.getId(), demands);
        return demands;
    }

    public ODRouteSets createAndRegisterODRouteSets(PhysicalNetwork physicalNetwork, Zoning zoning, String odRouteSetInputPath) throws PlanItException {
        PlanItException.throwIf(zoning == null, "Zones must be defined before definition of od route sets can proceed");
        PlanItException.throwIf(physicalNetwork == null, "Physical network must be defined before of od route sets can proceed");
        LOGGER.info(LoggingUtils.createProjectPrefix(this.projectId) + "populating od route sets");
        ODRouteSets odRouteSets = this.odRouteSetsFactory.create(ODRouteSets.class.getCanonicalName(), new Object[]{this.projectGroupId}, odRouteSetInputPath);
        String prefix = LoggingUtils.createProjectPrefix(this.projectId) + LoggingUtils.createOdRouteSetsPrefix(odRouteSets.getId());
        LOGGER.info(String.format("%s#od route sets: %d", prefix, odRouteSets.getNumberOfOdRouteSets()));
        this.odRouteSetsMap.put(odRouteSets.getId(), odRouteSets);
        return odRouteSets;
    }

    public InitialLinkSegmentCost createAndRegisterInitialLinkSegmentCost(PhysicalNetwork network, String fileName) throws PlanItException {
        PlanItException.throwIf(network == null, "Physical network must be read in before initial costs can be read");
        if (!this.initialLinkSegmentCosts.containsKey(network)) {
            this.initialLinkSegmentCosts.put(network, new ArrayList());
        }
        LOGGER.info(LoggingUtils.createProjectPrefix(this.projectId) + "populating initial link segment costs");
        InitialLinkSegmentCost initialLinkSegmentCost = (InitialLinkSegmentCost)this.initialPhysicalCostFactory.create(InitialLinkSegmentCost.class.getCanonicalName(), new Object[]{this.projectGroupId}, network, fileName);
        this.initialLinkSegmentCosts.get(network).add(initialLinkSegmentCost);
        return initialLinkSegmentCost;
    }

    public InitialLinkSegmentCostPeriod createAndRegisterInitialLinkSegmentCost(PhysicalNetwork network, String fileName, TimePeriod timePeriod) throws PlanItException {
        PlanItException.throwIf(network == null, "Physical network must be read in before initial costs can be read");
        if (!this.initialLinkSegmentCosts.containsKey(network)) {
            this.initialLinkSegmentCosts.put(network, new ArrayList());
        }
        LOGGER.info(LoggingUtils.createProjectPrefix(this.projectId) + LoggingUtils.createTimePeriodPrefix(timePeriod.getExternalId(), timePeriod.getId()) + "populating initial link segment costs");
        InitialLinkSegmentCostPeriod initialLinkSegmentCostPeriod = (InitialLinkSegmentCostPeriod)this.initialPhysicalCostFactory.create(InitialLinkSegmentCostPeriod.class.getCanonicalName(), new Object[]{this.projectGroupId}, network, fileName, timePeriod);
        initialLinkSegmentCostPeriod.setTimePeriod(timePeriod);
        this.initialLinkSegmentCosts.get(network).add(initialLinkSegmentCostPeriod);
        return initialLinkSegmentCostPeriod;
    }

    public List<InitialLinkSegmentCostPeriod> createAndRegisterInitialLinkSegmentCost(PhysicalNetwork network, String fileName, Demands demands) throws PlanItException {
        PlanItException.throwIf(network == null, "Physical network must be read in before initial costs can be read");
        ArrayList<InitialLinkSegmentCostPeriod> initialCostsList = new ArrayList<InitialLinkSegmentCostPeriod>();
        for (TimePeriod timePeriod : demands.timePeriods.asSortedSetByStartTime()) {
            InitialLinkSegmentCostPeriod initialLinkSegmentCostPeriod = this.createAndRegisterInitialLinkSegmentCost(network, fileName, timePeriod);
            initialCostsList.add(initialLinkSegmentCostPeriod);
        }
        return initialCostsList;
    }

    public List<InitialLinkSegmentCost> getInitialLinkSegmentCost(PhysicalNetwork network) {
        return this.initialLinkSegmentCosts.get(network);
    }

    public class ProjectODRouteSets {
        public List<ODRouteSets> toList() {
            return new ArrayList<ODRouteSets>(PlanItProjectInput.this.odRouteSetsMap.values());
        }

        public ODRouteSets getODRouteSets(long id) {
            return PlanItProjectInput.this.odRouteSetsMap.get(id);
        }

        public int getNumberOfODRouteSets() {
            return PlanItProjectInput.this.odRouteSetsMap.size();
        }

        public boolean hasRegisteredODRouteSets() {
            return !PlanItProjectInput.this.odRouteSetsMap.isEmpty();
        }

        public ODRouteSets getFirstODRouteSets() {
            return this.hasRegisteredODRouteSets() ? PlanItProjectInput.this.odRouteSetsMap.firstEntry().getValue() : null;
        }
    }

    public class ProjectZonings {
        public List<Zoning> toList() {
            return new ArrayList<Zoning>(PlanItProjectInput.this.zoningsMap.values());
        }

        public Zoning getZoning(long id) {
            return PlanItProjectInput.this.zoningsMap.get(id);
        }

        public int getNumberOfZonings() {
            return PlanItProjectInput.this.zoningsMap.size();
        }

        public boolean hasRegisteredZonings() {
            return !PlanItProjectInput.this.zoningsMap.isEmpty();
        }

        public Zoning getFirstZoning() {
            return this.hasRegisteredZonings() ? PlanItProjectInput.this.zoningsMap.firstEntry().getValue() : null;
        }
    }

    public class ProjectDemands {
        public List<Demands> toList() {
            return new ArrayList<Demands>(PlanItProjectInput.this.demandsMap.values());
        }

        public Demands getDemands(long id) {
            return PlanItProjectInput.this.demandsMap.get(id);
        }

        public int getNumberOfDemands() {
            return PlanItProjectInput.this.demandsMap.size();
        }

        public boolean hasRegisteredDemands() {
            return !PlanItProjectInput.this.demandsMap.isEmpty();
        }

        public Demands getFirstDemands() {
            return this.hasRegisteredDemands() ? PlanItProjectInput.this.demandsMap.firstEntry().getValue() : null;
        }
    }

    public class ProjectNetworks {
        public List<PhysicalNetwork> toList() {
            return new ArrayList<PhysicalNetwork>(PlanItProjectInput.this.physicalNetworkMap.values());
        }

        public PhysicalNetwork getPhysicalNetwork(long id) {
            return PlanItProjectInput.this.physicalNetworkMap.get(id);
        }

        public int getNumberOfPhysicalNetworks() {
            return PlanItProjectInput.this.physicalNetworkMap.size();
        }

        public boolean hasRegisteredNetworks() {
            return !PlanItProjectInput.this.physicalNetworkMap.isEmpty();
        }

        public PhysicalNetwork getFirstNetwork() {
            return this.hasRegisteredNetworks() ? PlanItProjectInput.this.physicalNetworkMap.firstEntry().getValue() : null;
        }
    }
}

