/*
 * Decompiled with CFR 0.152.
 */
package org.planit.output.property;

import java.util.logging.Logger;
import org.planit.output.enums.Type;
import org.planit.output.enums.Units;
import org.planit.output.property.OutputProperty;
import org.planit.output.property.OutputPropertyPriority;
import org.planit.utils.exceptions.PlanItException;

public abstract class BaseOutputProperty
implements Comparable<BaseOutputProperty> {
    private static final Logger LOGGER = Logger.getLogger(BaseOutputProperty.class.getCanonicalName());

    public abstract String getName();

    public abstract Units getUnits();

    public abstract Type getType();

    public abstract OutputProperty getOutputProperty();

    public abstract OutputPropertyPriority getColumnPriority();

    public boolean equals(Object otherProperty) {
        return this.getClass().getCanonicalName().equals(otherProperty.getClass().getCanonicalName());
    }

    public int hashCode() {
        return this.getUnits().hashCode() + this.getType().hashCode() + this.getName().hashCode();
    }

    @Override
    public int compareTo(BaseOutputProperty otherProperty) {
        if (this.getColumnPriority().equals((Object)otherProperty.getColumnPriority())) {
            if (this.getName().equals(otherProperty.getName())) {
                return this.getOutputProperty().compareTo(otherProperty.getOutputProperty());
            }
            return this.getName().compareTo(otherProperty.getName());
        }
        return this.getColumnPriority().value() - otherProperty.getColumnPriority().value();
    }

    public static BaseOutputProperty convertToBaseOutputProperty(String propertyClassName) throws PlanItException {
        try {
            Class<?> entityClass = Class.forName(propertyClassName);
            BaseOutputProperty outputProperty = (BaseOutputProperty)entityClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return outputProperty;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when converting base output property", e);
        }
    }

    public static BaseOutputProperty convertToBaseOutputProperty(OutputProperty outputProperty) throws PlanItException {
        return BaseOutputProperty.convertToBaseOutputProperty(outputProperty.value());
    }
}

