/*
 * Decompiled with CFR 0.152.
 */
package org.planit.output.formatter;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.planit.data.MultiKeyPlanItData;
import org.planit.network.physical.macroscopic.MacroscopicLinkSegmentImpl;
import org.planit.od.odmatrix.ODMatrixIterator;
import org.planit.od.odmatrix.skim.ODSkimMatrix;
import org.planit.od.odroute.ODRouteIterator;
import org.planit.od.odroute.ODRouteMatrix;
import org.planit.output.adapter.LinkOutputTypeAdapter;
import org.planit.output.adapter.ODOutputTypeAdapter;
import org.planit.output.adapter.OutputAdapter;
import org.planit.output.adapter.RouteOutputTypeAdapter;
import org.planit.output.configuration.OutputConfiguration;
import org.planit.output.configuration.OutputTypeConfiguration;
import org.planit.output.configuration.PathOutputTypeConfiguration;
import org.planit.output.enums.ODSkimSubOutputType;
import org.planit.output.enums.OutputType;
import org.planit.output.enums.OutputTypeEnum;
import org.planit.output.enums.RouteIdType;
import org.planit.output.enums.SubOutputTypeEnum;
import org.planit.output.formatter.BaseOutputFormatter;
import org.planit.output.formatter.MemoryOutputIterator;
import org.planit.output.property.OutputProperty;
import org.planit.time.TimePeriod;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.network.physical.Mode;

public class MemoryOutputFormatter
extends BaseOutputFormatter {
    private static final Logger LOGGER = Logger.getLogger(MacroscopicLinkSegmentImpl.class.getCanonicalName());
    private MultiKeyMap<Object, MultiKeyPlanItData> timeModeOutputTypeIterationDataMap;
    public MemoryOutputIterator iterator;

    private Object[] getValues(OutputProperty[] labels, Function<OutputProperty, Object> getValueFromAdapter) throws PlanItException {
        Object[] values = new Object[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            values[i] = getValueFromAdapter.apply(labels[i]);
            if (!(values[i] instanceof PlanItException)) continue;
            throw (PlanItException)values[i];
        }
        return values;
    }

    private void updateOutputAndKeyValues(MultiKeyPlanItData multiKeyPlanItData, OutputProperty[] outputProperties, OutputProperty[] outputKeys, Function<OutputProperty, Object> getValueFromAdapter) throws PlanItException {
        Object[] outputValues = this.getValues(outputProperties, getValueFromAdapter);
        Object[] keyValues = this.getValues(outputKeys, getValueFromAdapter);
        multiKeyPlanItData.putRow(outputValues, keyValues);
    }

    private void updateOutputAndKeyValuesForLink(MultiKeyPlanItData multiKeyPlanItData, OutputProperty[] outputProperties, OutputProperty[] outputKeys, LinkSegment linkSegment, LinkOutputTypeAdapter linkOutputTypeAdapter, Mode mode, TimePeriod timePeriod) throws PlanItException {
        if (linkOutputTypeAdapter.isFlowPositive(linkSegment, mode)) {
            this.updateOutputAndKeyValues(multiKeyPlanItData, outputProperties, outputKeys, label -> linkOutputTypeAdapter.getLinkOutputPropertyValue((OutputProperty)((Object)label), linkSegment, mode, timePeriod, this.outputTimeUnit.getMultiplier()));
        }
    }

    private void updateOutputAndKeyValuesForOD(MultiKeyPlanItData multiKeyPlanItData, OutputProperty[] outputProperties, OutputProperty[] outputKeys, ODMatrixIterator odMatrixIterator, ODOutputTypeAdapter odOutputTypeAdapter, Mode mode, TimePeriod timePeriod) throws PlanItException {
        this.updateOutputAndKeyValues(multiKeyPlanItData, outputProperties, outputKeys, label -> odOutputTypeAdapter.getODOutputPropertyValue((OutputProperty)((Object)label), odMatrixIterator, mode, timePeriod, this.outputTimeUnit.getMultiplier()));
    }

    private void updateOutputAndKeyValuesForPath(MultiKeyPlanItData multiKeyPlanItData, OutputProperty[] outputProperties, OutputProperty[] outputKeys, ODRouteIterator odRouteIterator, RouteOutputTypeAdapter pathOutputTypeAdapter, Mode mode, TimePeriod timePeriod, RouteIdType pathIdType) throws PlanItException {
        this.updateOutputAndKeyValues(multiKeyPlanItData, outputProperties, outputKeys, label -> pathOutputTypeAdapter.getRouteOutputPropertyValue((OutputProperty)((Object)label), odRouteIterator, mode, timePeriod, pathIdType));
    }

    @Override
    protected void writeSimulationResultsForCurrentTimePeriod(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, int iterationIndex) throws PlanItException {
        LOGGER.warning("memory Output for OutputType SIMULATION has not been implemented yet");
    }

    @Override
    protected void writeGeneralResultsForCurrentTimePeriod(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, int iterationIndex) throws PlanItException {
        LOGGER.warning("memory Output for OutputType GENERAL has not been implemented yet");
    }

    @Override
    protected void writeLinkResultsForCurrentTimePeriod(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, int iterationIndex) throws PlanItException {
        PlanItException.throwIf(!(currentOutputType instanceof OutputType) && (OutputType)currentOutputType == OutputType.LINK, "currentOutputTypeEnum is not compatible with outputTypeconfiguration");
        OutputType outputType = (OutputType)currentOutputType;
        OutputProperty[] outputProperties = (OutputProperty[])this.outputValueProperties.get(outputType);
        OutputProperty[] outputKeys = (OutputProperty[])this.outputKeyProperties.get(outputType);
        LinkOutputTypeAdapter linkOutputTypeAdapter = (LinkOutputTypeAdapter)outputAdapter.getOutputTypeAdapter(outputType);
        for (Mode mode : modes) {
            MultiKeyPlanItData multiKeyPlanItData = new MultiKeyPlanItData(outputKeys, outputProperties);
            for (LinkSegment linkSegment : linkOutputTypeAdapter.getPhysicalLinkSegments()) {
                if (!outputConfiguration.isPersistZeroFlow() && !linkOutputTypeAdapter.isFlowPositive(linkSegment, mode)) continue;
                this.updateOutputAndKeyValuesForLink(multiKeyPlanItData, outputProperties, outputKeys, linkSegment, linkOutputTypeAdapter, mode, timePeriod);
            }
            this.timeModeOutputTypeIterationDataMap.put(mode, timePeriod, iterationIndex, outputType, multiKeyPlanItData);
        }
    }

    @Override
    protected void writeOdResultsForCurrentTimePeriod(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, int iterationIndex) throws PlanItException {
        PlanItException.throwIf(!(currentOutputType instanceof SubOutputTypeEnum) || !((SubOutputTypeEnum)currentOutputType instanceof ODSkimSubOutputType), "currentOutputTypeEnum is not compatible with outputTypeconfiguration");
        ODSkimSubOutputType subOutputType = (ODSkimSubOutputType)currentOutputType;
        OutputType outputType = outputTypeConfiguration.getOutputType();
        OutputProperty[] outputProperties = (OutputProperty[])this.outputValueProperties.get(outputType);
        OutputProperty[] outputKeys = (OutputProperty[])this.outputKeyProperties.get(outputType);
        ODOutputTypeAdapter odOutputTypeAdapter = (ODOutputTypeAdapter)outputAdapter.getOutputTypeAdapter(outputType);
        for (Mode mode : modes) {
            MultiKeyPlanItData multiKeyPlanItData = new MultiKeyPlanItData(outputKeys, outputProperties);
            ODSkimMatrix odSkimMatrix = odOutputTypeAdapter.getODSkimMatrix(subOutputType, mode);
            ODMatrixIterator odMatrixIterator = odSkimMatrix.iterator();
            while (odMatrixIterator.hasNext()) {
                odMatrixIterator.next();
                if (!outputConfiguration.isPersistZeroFlow() && !((Double)odOutputTypeAdapter.getODOutputPropertyValue(OutputProperty.OD_COST, odMatrixIterator, mode, timePeriod, this.outputTimeUnit.getMultiplier()) > 0.0)) continue;
                this.updateOutputAndKeyValuesForOD(multiKeyPlanItData, outputProperties, outputKeys, odMatrixIterator, odOutputTypeAdapter, mode, timePeriod);
            }
            this.timeModeOutputTypeIterationDataMap.put(mode, timePeriod, iterationIndex, outputType, multiKeyPlanItData);
        }
    }

    @Override
    protected void writePathResultsForCurrentTimePeriod(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, int iterationIndex) throws PlanItException {
        PlanItException.throwIf(!(currentOutputType instanceof OutputType) && (OutputType)currentOutputType == OutputType.PATH, "currentOutputTypeEnum is not compatible with outputTypeconfiguration");
        OutputType outputType = (OutputType)currentOutputType;
        OutputProperty[] outputProperties = (OutputProperty[])this.outputValueProperties.get(outputType);
        OutputProperty[] outputKeys = (OutputProperty[])this.outputKeyProperties.get(outputType);
        RouteOutputTypeAdapter pathOutputTypeAdapter = (RouteOutputTypeAdapter)outputAdapter.getOutputTypeAdapter(outputType);
        PathOutputTypeConfiguration pathOutputTypeConfiguration = (PathOutputTypeConfiguration)outputTypeConfiguration;
        for (Mode mode : modes) {
            MultiKeyPlanItData multiKeyPlanItData = new MultiKeyPlanItData(outputKeys, outputProperties);
            ODRouteMatrix odPathMatrix = pathOutputTypeAdapter.getODPathMatrix(mode);
            ODRouteIterator odRouteIterator = odPathMatrix.iterator();
            while (odRouteIterator.hasNext()) {
                odRouteIterator.next();
                if (!outputConfiguration.isPersistZeroFlow() && odRouteIterator.getCurrentValue() == null) continue;
                this.updateOutputAndKeyValuesForPath(multiKeyPlanItData, outputProperties, outputKeys, odRouteIterator, pathOutputTypeAdapter, mode, timePeriod, pathOutputTypeConfiguration.getPathIdType());
            }
            this.timeModeOutputTypeIterationDataMap.put(mode, timePeriod, iterationIndex, outputType, multiKeyPlanItData);
        }
    }

    public MemoryOutputFormatter(IdGroupingToken groupId) {
        super(groupId);
    }

    public Object getOutputDataValue(Mode mode, TimePeriod timePeriod, Integer iterationIndex, OutputType outputType, OutputProperty outputProperty, Object[] keyValues) throws PlanItException {
        MultiKeyPlanItData multiKeyPlanItData = this.timeModeOutputTypeIterationDataMap.get(mode, timePeriod, iterationIndex, outputType);
        return multiKeyPlanItData.getRowValue(outputProperty, keyValues);
    }

    @Override
    public void initialiseBeforeSimulation(Map<OutputType, OutputTypeConfiguration> outputTypeConfigurations, long runId) throws PlanItException {
        this.timeModeOutputTypeIterationDataMap = new MultiKeyMap();
    }

    @Override
    public void finaliseAfterSimulation(Map<OutputType, OutputTypeConfiguration> outputTypeConfigurations, OutputAdapter outputAdapter) throws PlanItException {
    }

    public OutputProperty[] getOutputKeyProperties(OutputType outputType) {
        return (OutputProperty[])this.outputKeyProperties.get(outputType);
    }

    public OutputProperty[] getOutputValueProperties(OutputType outputType) {
        return (OutputProperty[])this.outputValueProperties.get(outputType);
    }

    public int getLastIteration() {
        Set keySet = this.timeModeOutputTypeIterationDataMap.keySet();
        int lastIteration = 0;
        for (MultiKey multiKey : keySet) {
            K[] keys = multiKey.getKeys();
            Integer iteration = (Integer)keys[2];
            lastIteration = Math.max(lastIteration, iteration);
        }
        return lastIteration;
    }

    @Override
    public boolean canHandleMultipleIterations() {
        return true;
    }

    public MemoryOutputIterator getIterator(Mode mode, TimePeriod timePeriod, Integer iterationIndex, OutputType outputType) {
        MultiKeyPlanItData multiKeyPlanItData = this.timeModeOutputTypeIterationDataMap.get(mode, timePeriod, iterationIndex, outputType);
        MemoryOutputIterator memoryOutputIterator = new MemoryOutputIterator(multiKeyPlanItData);
        return memoryOutputIterator;
    }

    public int getPositionOfOutputValueProperty(OutputType outputType, OutputProperty outputValueProperty) throws PlanItException {
        Set keySet = this.timeModeOutputTypeIterationDataMap.keySet();
        for (MultiKey multiKey : keySet) {
            K[] keys = multiKey.getKeys();
            Mode mode1 = (Mode)keys[0];
            TimePeriod timePeriod1 = (TimePeriod)keys[1];
            Integer iterationIndex1 = (Integer)keys[2];
            MultiKeyPlanItData multiKeyPlanItData = this.timeModeOutputTypeIterationDataMap.get(mode1, timePeriod1, iterationIndex1, outputType);
            OutputType outputType1 = (OutputType)keys[3];
            if (!outputType1.equals(outputType)) continue;
            return multiKeyPlanItData.getPositionOfOutputValueProperty(outputValueProperty);
        }
        throw new PlanItException("Value property " + outputType.name() + " could not be found in the MemoryOutputFormatter");
    }

    public int getPositionOfOutputKeyProperty(OutputType outputType, OutputProperty outputKeyProperty) throws PlanItException {
        Set keySet = this.timeModeOutputTypeIterationDataMap.keySet();
        for (MultiKey multiKey : keySet) {
            K[] keys = multiKey.getKeys();
            Mode mode1 = (Mode)keys[0];
            TimePeriod timePeriod1 = (TimePeriod)keys[1];
            Integer iterationIndex1 = (Integer)keys[2];
            MultiKeyPlanItData multiKeyPlanItData = this.timeModeOutputTypeIterationDataMap.get(mode1, timePeriod1, iterationIndex1, outputType);
            OutputType outputType1 = (OutputType)keys[3];
            if (!outputType1.equals(outputType)) continue;
            return multiKeyPlanItData.getPositionOfOutputKeyProperty(outputKeyProperty);
        }
        throw new PlanItException("Key property " + outputType.name() + " could not be found in the MemoryOutputFormatter");
    }
}

