/*
 * Decompiled with CFR 0.152.
 */
package org.planit.output.formatter;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.planit.output.adapter.OutputAdapter;
import org.planit.output.configuration.OutputConfiguration;
import org.planit.output.configuration.OutputTypeConfiguration;
import org.planit.output.enums.OutputTimeUnit;
import org.planit.output.enums.OutputType;
import org.planit.output.enums.OutputTypeEnum;
import org.planit.output.enums.SubOutputTypeEnum;
import org.planit.output.formatter.OutputFormatter;
import org.planit.output.property.OutputProperty;
import org.planit.time.TimePeriod;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.network.physical.Mode;

public abstract class BaseOutputFormatter
implements OutputFormatter {
    private static final Logger LOGGER = Logger.getLogger(BaseOutputFormatter.class.getCanonicalName());
    private static final OutputTimeUnit DEFAULT_TIME_UNIT = OutputTimeUnit.HOURS;
    protected Map<OutputType, OutputProperty[]> outputKeyProperties;
    protected Map<OutputType, OutputProperty[]> outputValueProperties;
    protected Map<OutputType, Boolean> outputTypeValuesLocked;
    protected Map<OutputType, Boolean> outputTypeKeysLocked;
    protected long id;
    protected OutputTimeUnit outputTimeUnit;
    protected Set<OutputType> outputTypes;
    protected String initialCostsLocation;

    private void initializeKeyProperties(OutputTypeConfiguration outputTypeConfiguration) throws PlanItException {
        OutputProperty[] outputKeyPropertyArray = outputTypeConfiguration.getOutputKeyProperties();
        OutputType outputType = outputTypeConfiguration.getOutputType();
        OutputProperty[] outputKeyPropertiesArray = outputTypeConfiguration.validateAndFilterKeyProperties(outputKeyPropertyArray);
        PlanItException.throwIf(outputKeyPropertiesArray == null, "Key properties invalid for OutputType " + outputType.value() + " not correctly defined");
        this.outputKeyProperties.put(outputType, outputKeyPropertiesArray);
    }

    protected void lockOutputProperties(OutputType outputType) {
        this.outputTypeValuesLocked.put(outputType, true);
        this.outputTypeKeysLocked.put(outputType, true);
    }

    protected abstract void writeLinkResultsForCurrentTimePeriod(OutputConfiguration var1, OutputTypeConfiguration var2, OutputTypeEnum var3, OutputAdapter var4, Set<Mode> var5, TimePeriod var6, int var7) throws PlanItException;

    protected abstract void writeGeneralResultsForCurrentTimePeriod(OutputConfiguration var1, OutputTypeConfiguration var2, OutputTypeEnum var3, OutputAdapter var4, Set<Mode> var5, TimePeriod var6, int var7) throws PlanItException;

    protected abstract void writeOdResultsForCurrentTimePeriod(OutputConfiguration var1, OutputTypeConfiguration var2, OutputTypeEnum var3, OutputAdapter var4, Set<Mode> var5, TimePeriod var6, int var7) throws PlanItException;

    protected abstract void writeSimulationResultsForCurrentTimePeriod(OutputConfiguration var1, OutputTypeConfiguration var2, OutputTypeEnum var3, OutputAdapter var4, Set<Mode> var5, TimePeriod var6, int var7) throws PlanItException;

    protected abstract void writePathResultsForCurrentTimePeriod(OutputConfiguration var1, OutputTypeConfiguration var2, OutputTypeEnum var3, OutputAdapter var4, Set<Mode> var5, TimePeriod var6, int var7) throws PlanItException;

    public BaseOutputFormatter(IdGroupingToken groupId) {
        this.id = IdGenerator.generateId(groupId, BaseOutputFormatter.class);
        this.outputKeyProperties = new HashMap<OutputType, OutputProperty[]>();
        this.outputValueProperties = new HashMap<OutputType, OutputProperty[]>();
        this.outputTimeUnit = DEFAULT_TIME_UNIT;
        this.outputTypeValuesLocked = new HashMap<OutputType, Boolean>();
        this.outputTypeKeysLocked = new HashMap<OutputType, Boolean>();
        for (OutputType outputType : OutputType.values()) {
            this.outputTypeValuesLocked.put(outputType, false);
            this.outputTypeKeysLocked.put(outputType, false);
        }
    }

    @Override
    public void persist(TimePeriod timePeriod, Set<Mode> modes, OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputAdapter outputAdapter) throws PlanItException {
        int iterationIndex;
        OutputType outputType = outputTypeConfiguration.getOutputType();
        OutputProperty[] outputValuePropertyArray = outputTypeConfiguration.getOutputValueProperties();
        if (!this.outputTypeValuesLocked.get(outputType).booleanValue()) {
            this.outputValueProperties.put(outputType, outputValuePropertyArray);
        } else {
            OutputProperty[] existingOutputValuePropertyArray = this.outputValueProperties.get(outputType);
            PlanItException.throwIf(outputValuePropertyArray.length != existingOutputValuePropertyArray.length, "An attempt was made to change the output value properties after they had been locked");
            for (int i = 0; i < outputValuePropertyArray.length; ++i) {
                PlanItException.throwIf(!existingOutputValuePropertyArray[i].equals((Object)outputValuePropertyArray[i]), "An attempt was made to change the output value properties after they had been locked");
            }
        }
        if (!this.outputTypeKeysLocked.get(outputType).booleanValue()) {
            this.initializeKeyProperties(outputTypeConfiguration);
        }
        HashMap<OutputTypeEnum, Integer> outputTypeIterationInformation = new HashMap<OutputTypeEnum, Integer>();
        if (outputTypeConfiguration.hasActiveSubOutputTypes()) {
            Set<SubOutputTypeEnum> subOutputTypes = outputTypeConfiguration.getActiveSubOutputTypes();
            for (SubOutputTypeEnum subOutputTypeEnum : subOutputTypes) {
                iterationIndex = outputAdapter.getOutputTypeAdapter(outputType).getIterationIndexForSubOutputType(subOutputTypeEnum);
                outputTypeIterationInformation.put(subOutputTypeEnum, iterationIndex);
            }
        } else {
            int iterationIndex2 = outputAdapter.getOutputTypeAdapter(outputType).getIterationIndexForSubOutputType(null);
            outputTypeIterationInformation.put(outputType, iterationIndex2);
        }
        for (Map.Entry entry : outputTypeIterationInformation.entrySet()) {
            OutputTypeEnum currentOutputTypeEnum = (OutputTypeEnum)entry.getKey();
            iterationIndex = (Integer)entry.getValue();
            switch (outputType) {
                case GENERAL: {
                    this.writeGeneralResultsForCurrentTimePeriod(outputConfiguration, outputTypeConfiguration, currentOutputTypeEnum, outputAdapter, modes, timePeriod, iterationIndex);
                    break;
                }
                case LINK: {
                    this.writeLinkResultsForCurrentTimePeriod(outputConfiguration, outputTypeConfiguration, currentOutputTypeEnum, outputAdapter, modes, timePeriod, iterationIndex);
                    break;
                }
                case OD: {
                    this.writeOdResultsForCurrentTimePeriod(outputConfiguration, outputTypeConfiguration, currentOutputTypeEnum, outputAdapter, modes, timePeriod, iterationIndex);
                    break;
                }
                case SIMULATION: {
                    this.writeSimulationResultsForCurrentTimePeriod(outputConfiguration, outputTypeConfiguration, currentOutputTypeEnum, outputAdapter, modes, timePeriod, iterationIndex);
                    break;
                }
                case PATH: {
                    this.writePathResultsForCurrentTimePeriod(outputConfiguration, outputTypeConfiguration, currentOutputTypeEnum, outputAdapter, modes, timePeriod, iterationIndex);
                }
            }
            this.lockOutputProperties(outputType);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    public OutputTimeUnit getOutputTimeUnit() {
        return this.outputTimeUnit;
    }

    public void setOutputTimeUnit(OutputTimeUnit outputTimeUnit) {
        this.outputTimeUnit = outputTimeUnit;
    }

    public String getOutputTimeUnitString() {
        return this.outputTimeUnit.value();
    }
}

