/*
 * Decompiled with CFR 0.152.
 */
package org.planit.output.adapter;

import java.util.logging.Logger;
import org.opengis.geometry.DirectPosition;
import org.planit.graph.VertexImpl;
import org.planit.network.physical.PhysicalNetwork;
import org.planit.output.adapter.LinkOutputTypeAdapter;
import org.planit.output.adapter.OutputTypeAdapterImpl;
import org.planit.output.enums.OutputType;
import org.planit.output.property.OutputProperty;
import org.planit.time.TimePeriod;
import org.planit.trafficassignment.TrafficAssignment;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.network.physical.Mode;
import org.planit.utils.network.physical.Node;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegment;

public abstract class LinkOutputTypeAdapterImpl
extends OutputTypeAdapterImpl
implements LinkOutputTypeAdapter {
    private static final Logger LOGGER = Logger.getLogger(LinkOutputTypeAdapterImpl.class.getCanonicalName());

    protected double getCapacityPerLane(LinkSegment linkSegment) throws PlanItException {
        PlanItException.throwIf(!(linkSegment instanceof MacroscopicLinkSegment), "Tried to calculate capacity per link across an object which is not a MacroscopicLinkSegment");
        MacroscopicLinkSegment macroscopicLinkSegment = (MacroscopicLinkSegment)linkSegment;
        return macroscopicLinkSegment.getLinkSegmentType().getCapacityPerLane();
    }

    protected String getLinkType(LinkSegment linkSegment) throws PlanItException {
        PlanItException.throwIf(!(linkSegment instanceof MacroscopicLinkSegment), "Tried to find the Link Type of an object which is not a MacroscopicLinkSegment");
        MacroscopicLinkSegment macroscopicLinkSegment = (MacroscopicLinkSegment)linkSegment;
        return macroscopicLinkSegment.getLinkSegmentType().getName();
    }

    protected double getMaximumDensity(LinkSegment linkSegment) throws PlanItException {
        PlanItException.throwIf(!(linkSegment instanceof MacroscopicLinkSegment), "Tried to density per lane across an object which is not a MacroscopicLinkSegment");
        MacroscopicLinkSegment macroscopicLinkSegment = (MacroscopicLinkSegment)linkSegment;
        return macroscopicLinkSegment.getLinkSegmentType().getMaximumDensityPerLane();
    }

    protected Object getDownstreamNodeExternalId(LinkSegment linkSegment) throws PlanItException {
        return ((Node)linkSegment.getDownstreamVertex()).getExternalId();
    }

    protected long getDownstreamNodeId(LinkSegment linkSegment) throws PlanItException {
        return ((Node)linkSegment.getDownstreamVertex()).getId();
    }

    protected Object getDownstreamNodeLocation(LinkSegment linkSegment) throws PlanItException {
        PlanItException.throwIf(!(linkSegment.getDownstreamVertex() instanceof VertexImpl), "Downstream node location not available");
        VertexImpl downstreamVertex = (VertexImpl)linkSegment.getDownstreamVertex();
        DirectPosition centrePoint = downstreamVertex.getCentrePointGeometry();
        if (centrePoint == null) {
            return "Not Specified";
        }
        double[] coordinates = centrePoint.getCoordinate();
        return coordinates[0] + "-" + coordinates[1];
    }

    protected double getLength(LinkSegment linkSegment) throws PlanItException {
        return linkSegment.getParentLink().getLength();
    }

    protected Object getLinkSegmentExternalId(LinkSegment linkSegment) throws PlanItException {
        return linkSegment.getExternalId();
    }

    protected long getLinkSegmentId(LinkSegment linkSegment) throws PlanItException {
        return linkSegment.getId();
    }

    protected double getMaximumSpeed(LinkSegment linkSegment, Mode mode) throws PlanItException {
        PlanItException.throwIf(!(linkSegment instanceof MacroscopicLinkSegment), "Tried to read maximum speed of an object which is not a MacroscopicLinkSegment");
        MacroscopicLinkSegment macroscopicLinkSegment = (MacroscopicLinkSegment)linkSegment;
        if (!macroscopicLinkSegment.isModeAllowedThroughLink(mode)) {
            return 0.0;
        }
        return macroscopicLinkSegment.getMaximumSpeed(mode);
    }

    protected int getNumberOfLanes(LinkSegment linkSegment) throws PlanItException {
        return linkSegment.getNumberOfLanes();
    }

    protected Object getUpstreamNodeExternalId(LinkSegment linkSegment) throws PlanItException {
        return ((Node)linkSegment.getUpstreamVertex()).getExternalId();
    }

    protected Object getUpstreamNodeLocation(LinkSegment linkSegment) throws PlanItException {
        PlanItException.throwIf(!(linkSegment.getDownstreamVertex() instanceof VertexImpl), "Upstream node location not available");
        VertexImpl upstreamVertex = (VertexImpl)linkSegment.getUpstreamVertex();
        DirectPosition centrePoint = upstreamVertex.getCentrePointGeometry();
        if (centrePoint == null) {
            return "Not Specified";
        }
        double[] coordinates = centrePoint.getCoordinate();
        return coordinates[0] + "-" + coordinates[1];
    }

    protected long getUpstreamNodeId(LinkSegment linkSegment) throws PlanItException {
        return ((Node)linkSegment.getUpstreamVertex()).getId();
    }

    public LinkOutputTypeAdapterImpl(OutputType outputType, TrafficAssignment trafficAssignment) {
        super(outputType, trafficAssignment);
    }

    @Override
    public PhysicalNetwork.LinkSegments getPhysicalLinkSegments() {
        return this.trafficAssignment.getTransportNetwork().getPhysicalNetwork().linkSegments;
    }

    @Override
    public Object getLinkOutputPropertyValue(OutputProperty outputProperty, LinkSegment linkSegment, Mode mode, TimePeriod timePeriod, double timeUnitMultiplier) {
        try {
            Object obj = this.getCommonPropertyValue(outputProperty, mode, timePeriod);
            if (obj != null) {
                return obj;
            }
            switch (outputProperty) {
                case CAPACITY_PER_LANE: {
                    return this.getCapacityPerLane(linkSegment);
                }
                case DOWNSTREAM_NODE_EXTERNAL_ID: {
                    return this.getDownstreamNodeExternalId(linkSegment);
                }
                case DOWNSTREAM_NODE_ID: {
                    return this.getDownstreamNodeId(linkSegment);
                }
                case DOWNSTREAM_NODE_LOCATION: {
                    return this.getDownstreamNodeLocation(linkSegment);
                }
                case LENGTH: {
                    return this.getLength(linkSegment);
                }
                case LINK_SEGMENT_EXTERNAL_ID: {
                    return this.getLinkSegmentExternalId(linkSegment);
                }
                case LINK_SEGMENT_ID: {
                    return this.getLinkSegmentId(linkSegment);
                }
                case MAXIMUM_DENSITY: {
                    return this.getMaximumDensity(linkSegment);
                }
                case MAXIMUM_SPEED: {
                    return this.getMaximumSpeed(linkSegment, mode);
                }
                case NUMBER_OF_LANES: {
                    return this.getNumberOfLanes(linkSegment);
                }
                case UPSTREAM_NODE_EXTERNAL_ID: {
                    return this.getUpstreamNodeExternalId(linkSegment);
                }
                case UPSTREAM_NODE_ID: {
                    return this.getUpstreamNodeId(linkSegment);
                }
                case UPSTREAM_NODE_LOCATION: {
                    return this.getUpstreamNodeLocation(linkSegment);
                }
                case LINK_TYPE: {
                    return this.getLinkType(linkSegment);
                }
            }
            return null;
        }
        catch (PlanItException e) {
            return e;
        }
    }
}

