/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.transport;

import org.planit.network.physical.PhysicalNetwork;
import org.planit.network.virtual.VirtualNetwork;
import org.planit.network.virtual.Zoning;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.Edge;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.network.physical.Link;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.network.virtual.Connectoid;
import org.planit.utils.network.virtual.ConnectoidSegment;

public class TransportNetwork {
    protected final PhysicalNetwork physicalNetwork;
    protected final Zoning zoning;

    protected void connectVerticesToEdgeSegment(EdgeSegment edgeSegment) throws PlanItException {
        edgeSegment.getUpstreamVertex().getExitEdgeSegments().addEdgeSegment(edgeSegment);
        edgeSegment.getDownstreamVertex().getEntryEdgeSegments().addEdgeSegment(edgeSegment);
    }

    protected void disconnectVerticesFromEdgeSegment(EdgeSegment edgeSegment) throws PlanItException {
        edgeSegment.getUpstreamVertex().getExitEdgeSegments().removeEdgeSegment(edgeSegment);
        edgeSegment.getDownstreamVertex().getEntryEdgeSegments().removeEdgeSegment(edgeSegment);
    }

    protected void connectVerticesToEdge(Edge edge) throws PlanItException {
        edge.getVertexA().getEdges().addEdge(edge);
        edge.getVertexB().getEdges().addEdge(edge);
    }

    protected void disconnectVerticesFromEdge(Edge edge) throws PlanItException {
        edge.getVertexA().getEdges().removeEdge(edge);
        edge.getVertexB().getEdges().removeEdge(edge);
    }

    public TransportNetwork(PhysicalNetwork physicalNetwork, Zoning zoning) {
        this.physicalNetwork = physicalNetwork;
        this.zoning = zoning;
    }

    public int getTotalNumberOfEdgeSegments() {
        return this.getTotalNumberOfPhysicalLinkSegments() + this.getTotalNumberOfConnectoidSegments();
    }

    public int getTotalNumberOfPhysicalLinkSegments() {
        return this.physicalNetwork.linkSegments.getNumberOfLinkSegments();
    }

    public int getTotalNumberOfConnectoidSegments() {
        return this.zoning.getVirtualNetwork().connectoidSegments.getNumberOfConnectoidSegments();
    }

    public int getTotalNumberOfVertices() {
        return this.zoning.getVirtualNetwork().centroids.getNumberOfCentroids() + this.physicalNetwork.nodes.getNumberOfNodes();
    }

    public void integrateConnectoidsAndLinks() throws PlanItException {
        VirtualNetwork virtualNetwork = this.zoning.getVirtualNetwork();
        for (Connectoid connectoid : virtualNetwork.connectoids) {
            virtualNetwork.connectoidSegments.createAndRegisterConnectoidSegment(connectoid, true);
            virtualNetwork.connectoidSegments.createAndRegisterConnectoidSegment(connectoid, false);
            this.connectVerticesToEdge(connectoid);
        }
        for (ConnectoidSegment connectoidSegment : virtualNetwork.connectoidSegments) {
            this.connectVerticesToEdgeSegment(connectoidSegment);
        }
        for (Link link : this.physicalNetwork.links) {
            this.connectVerticesToEdge(link);
        }
        for (LinkSegment linkSegment : this.physicalNetwork.linkSegments) {
            this.connectVerticesToEdgeSegment(linkSegment);
        }
    }

    public void removeVirtualNetworkFromPhysicalNetwork() throws PlanItException {
        for (Connectoid connectoid : this.zoning.getVirtualNetwork().connectoids) {
            this.disconnectVerticesFromEdge(connectoid);
        }
        for (ConnectoidSegment connectoidSegment : this.zoning.getVirtualNetwork().connectoidSegments) {
            this.disconnectVerticesFromEdgeSegment(connectoidSegment);
        }
        for (Link link : this.physicalNetwork.links) {
            this.disconnectVerticesFromEdge(link);
        }
        for (LinkSegment linkSegment : this.physicalNetwork.linkSegments) {
            this.disconnectVerticesFromEdgeSegment(linkSegment);
        }
    }

    public PhysicalNetwork getPhysicalNetwork() {
        return this.physicalNetwork;
    }

    public VirtualNetwork getVirtualNetwork() {
        return this.zoning.getVirtualNetwork();
    }

    public Zoning getZoning() {
        return this.zoning;
    }
}

