/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.xml.util;

import java.io.File;
import java.io.FileReader;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.opengis.gml.PointType;
import org.opengis.geometry.DirectPosition;
import org.planit.geo.PlanitGeoUtils;
import org.planit.utils.exceptions.PlanItException;

public interface XmlUtils {
    public static final String PATH_TO_XSD_FILE = "../../../../../../main/resources/xsd/metadata.xsd";
    public static final Logger LOGGER = Logger.getLogger(XmlUtils.class.getCanonicalName());

    public static DirectPosition getDirectPositionFromPointType(PlanitGeoUtils planitGeoUtils, PointType pointType) throws PlanItException {
        List<Double> value = pointType.getPos().getValue();
        return planitGeoUtils.getDirectPositionFromValues(value.get(0), value.get(1));
    }

    public static void validateXml(String xmlFileLocation, String schemaFileLocation) throws Exception {
        LOGGER.fine("validating " + xmlFileLocation + " against " + schemaFileLocation);
        String schemaLang = "http://www.w3.org/2001/XMLSchema";
        SchemaFactory factory = SchemaFactory.newInstance(schemaLang);
        Schema schema = factory.newSchema(new StreamSource(schemaFileLocation));
        Validator validator = schema.newValidator();
        validator.validate(new StreamSource(xmlFileLocation));
    }

    public static Object generateObjectFromXml(Class<?> clazz, String xmlFileLocation) throws Exception {
        FileReader fileReader = new FileReader(xmlFileLocation);
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(fileReader);
        JAXBContext jaxbContext = JAXBContext.newInstance(clazz);
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        Object obj = unmarshaller.unmarshal(xmlStreamReader);
        xmlStreamReader.close();
        fileReader.close();
        return obj;
    }

    public static void generateXmlFileFromObject(Object object, Class<?> clazz, String xmlFileLocation) throws Exception {
        File file = new File(xmlFileLocation);
        if (!clazz.isInstance(object)) {
            throw new Exception("Trying to convert an object to XML which is not of class " + clazz.getName());
        }
        JAXBContext jaxbContext = JAXBContext.newInstance(clazz);
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.noNamespaceSchemaLocation", PATH_TO_XSD_FILE);
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        marshaller.marshal(object, file);
    }
}

