/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.xml.demands;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.planit.demands.Demands;
import org.planit.input.InputBuilderListener;
import org.planit.network.virtual.Zoning;
import org.planit.od.odmatrix.demand.ODDemandMatrix;
import org.planit.time.TimePeriod;
import org.planit.userclass.UserClass;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.network.physical.Mode;
import org.planit.utils.network.virtual.Zone;
import org.planit.xml.generated.XMLElementOdCellByCellMatrix;
import org.planit.xml.generated.XMLElementOdMatrix;
import org.planit.xml.generated.XMLElementOdRawMatrix;
import org.planit.xml.generated.XMLElementOdRowMatrix;

public class DemandsPopulator {
    private static final List<String> RESERVED_CHARACTERS = Arrays.asList("+", "*", "^");
    private static final Logger LOGGER = Logger.getLogger(DemandsPopulator.class.getCanonicalName());

    private static String escapeSeparator(String separator) {
        if (RESERVED_CHARACTERS.contains(separator)) {
            return "\\" + separator;
        }
        return separator;
    }

    private static Map<Mode, Map<TimePeriod, ODDemandMatrix>> initializeDemandsPerTimePeriodAndMode(Demands demands, Zoning.Zones zones, InputBuilderListener inputBuilderListener) throws PlanItException {
        HashMap<Mode, Map<TimePeriod, ODDemandMatrix>> demandsPerTimePeriodAndMode = new HashMap<Mode, Map<TimePeriod, ODDemandMatrix>>();
        for (Mode mode : inputBuilderListener.getAllModes()) {
            HashMap<TimePeriod, ODDemandMatrix> demandsPerTimePeriod = new HashMap<TimePeriod, ODDemandMatrix>();
            for (TimePeriod timePeriod : demands.timePeriods.asSortedSetByStartTime()) {
                demandsPerTimePeriod.put(timePeriod, new ODDemandMatrix(zones));
            }
            demandsPerTimePeriodAndMode.put(mode, demandsPerTimePeriod);
        }
        return demandsPerTimePeriodAndMode;
    }

    private static void updateDemandMatrixFromOdMatrix(XMLElementOdMatrix odmatrix, double pcu, ODDemandMatrix odDemandMatrix, InputBuilderListener inputBuilderListener) throws Exception {
        if (odmatrix instanceof XMLElementOdCellByCellMatrix) {
            DemandsPopulator.updateDemandMatrixFromCellByCellMatrix((XMLElementOdCellByCellMatrix)odmatrix, pcu, odDemandMatrix, inputBuilderListener);
        } else if (odmatrix instanceof XMLElementOdRowMatrix) {
            DemandsPopulator.updateDemandMatrixFromOdRowMatrix((XMLElementOdRowMatrix)odmatrix, pcu, odDemandMatrix, inputBuilderListener);
        } else if (odmatrix instanceof XMLElementOdRawMatrix) {
            DemandsPopulator.updateDemandMatrixFromOdRawMatrix((XMLElementOdRawMatrix)odmatrix, pcu, odDemandMatrix, inputBuilderListener);
        }
    }

    private static void updateDemandMatrixFromCellByCellMatrix(XMLElementOdCellByCellMatrix odcellbycellmatrix, double pcu, ODDemandMatrix odDemandMatrix, InputBuilderListener inputBuilderListener) {
        List<XMLElementOdCellByCellMatrix.O> o = odcellbycellmatrix.getO();
        for (XMLElementOdCellByCellMatrix.O originZone : o) {
            List<XMLElementOdCellByCellMatrix.O.D> d = originZone.getD();
            for (XMLElementOdCellByCellMatrix.O.D demandZone : d) {
                DemandsPopulator.updateDemandMatrix(odDemandMatrix, originZone.getRef().intValue(), demandZone.getRef().intValue(), pcu, demandZone.getValue(), inputBuilderListener);
            }
        }
    }

    private static void updateDemandMatrixFromOdRowMatrix(XMLElementOdRowMatrix odrowmatrix, double pcu, ODDemandMatrix odDemandMatrix, InputBuilderListener inputBuilderListener) {
        String separator = odrowmatrix.getDs() == null ? "," : odrowmatrix.getDs();
        separator = DemandsPopulator.escapeSeparator(separator);
        List<XMLElementOdRowMatrix.Odrow> odrow = odrowmatrix.getOdrow();
        for (XMLElementOdRowMatrix.Odrow originZone : odrow) {
            String[] rowValuesAsString = originZone.getValue().split(separator);
            for (int i = 0; i < rowValuesAsString.length; ++i) {
                DemandsPopulator.updateDemandMatrix(odDemandMatrix, originZone.getRef().intValue(), i + 1, pcu, Double.parseDouble(rowValuesAsString[i]), inputBuilderListener);
            }
        }
    }

    private static void updateDemandMatrixFromOdRawMatrix(XMLElementOdRawMatrix odrawmatrix, double pcu, ODDemandMatrix odDemandMatrix, InputBuilderListener inputBuilderListener) throws Exception {
        XMLElementOdRawMatrix.Values values = odrawmatrix.getValues();
        String originSeparator = values.getOs() == null ? "," : values.getOs();
        originSeparator = DemandsPopulator.escapeSeparator(originSeparator);
        String destinationSeparator = values.getDs() == null ? "," : values.getDs();
        if (originSeparator.equals(destinationSeparator = DemandsPopulator.escapeSeparator(destinationSeparator))) {
            DemandsPopulator.updateDemandMatrixForEqualSeparators(values, originSeparator, pcu, odDemandMatrix, inputBuilderListener);
        } else {
            DemandsPopulator.updateDemandMatrixForDifferentSeparators(values, originSeparator, destinationSeparator, pcu, odDemandMatrix, inputBuilderListener);
        }
    }

    private static void updateDemandMatrixForDifferentSeparators(XMLElementOdRawMatrix.Values values, String originSeparator, String destinationSeparator, double pcu, ODDemandMatrix odDemandMatrix, InputBuilderListener inputBuilderListener) throws Exception {
        String[] originRows = values.getValue().split(originSeparator);
        int noRows = originRows.length;
        for (int i = 0; i < noRows; ++i) {
            String[] allValuesAsString = originRows[i].split(destinationSeparator);
            int noCols = allValuesAsString.length;
            if (noRows != noCols) {
                throw new Exception("Element <odrawmatrix> does not parse to a square matrix: Row " + (i + 1) + " has " + noCols + " values.");
            }
            for (int col = 0; col < noCols; ++col) {
                DemandsPopulator.updateDemandMatrix(odDemandMatrix, i + 1, col + 1, pcu, Double.parseDouble(allValuesAsString[col]), inputBuilderListener);
            }
        }
    }

    private static void updateDemandMatrixForEqualSeparators(XMLElementOdRawMatrix.Values values, String separator, double pcu, ODDemandMatrix odDemandMatrix, InputBuilderListener inputBuilderListener) throws Exception {
        String[] allValuesAsString = values.getValue().split(separator);
        int size = allValuesAsString.length;
        int noRows = (int)Math.round(Math.sqrt(size));
        if (noRows * noRows != size) {
            throw new Exception("Element <odrawmatrix> contains a string of " + size + " values, which is not an exact square");
        }
        int noCols = noRows;
        for (int i = 0; i < noRows; ++i) {
            int row = i * noRows;
            for (int col = 0; col < noCols; ++col) {
                DemandsPopulator.updateDemandMatrix(odDemandMatrix, i + 1, col + 1, pcu, Double.parseDouble(allValuesAsString[row + col]), inputBuilderListener);
            }
        }
    }

    private static void updateDemandMatrix(ODDemandMatrix odDemandMatrix, int rowRef, int colRef, double pcu, double demandValue, InputBuilderListener inputBuilderListener) {
        Zone originZone = inputBuilderListener.getZoneByExternalId(rowRef);
        Zone destinationZone = inputBuilderListener.getZoneByExternalId(colRef);
        double demand = demandValue * pcu;
        odDemandMatrix.setValue(originZone, destinationZone, demand);
    }

    public static void createAndRegisterDemandMatrix(Demands demands, List<XMLElementOdMatrix> oddemands, Zoning.Zones zones, InputBuilderListener inputBuilderListener) throws Exception {
        Map<Mode, Map<TimePeriod, ODDemandMatrix>> demandsPerTimePeriodAndMode = DemandsPopulator.initializeDemandsPerTimePeriodAndMode(demands, zones, inputBuilderListener);
        for (XMLElementOdMatrix odmatrix : oddemands) {
            long timePeriodId = odmatrix.getTimeperiodref().longValue();
            long userClassExternalId = odmatrix.getUserclassref() == null ? 1L : odmatrix.getUserclassref().longValue();
            UserClass userClass = inputBuilderListener.getUserClassByExternalId(userClassExternalId);
            Mode mode = userClass.getMode();
            TimePeriod timePeriod = inputBuilderListener.getTimePeriodByExternalId(timePeriodId);
            ODDemandMatrix odDemandMatrix = demandsPerTimePeriodAndMode.get(mode).get(timePeriod);
            DemandsPopulator.updateDemandMatrixFromOdMatrix(odmatrix, mode.getPcu(), odDemandMatrix, inputBuilderListener);
            demands.registerODDemand(timePeriod, mode, odDemandMatrix);
        }
    }
}

