/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import org.ojalgo.OjAlgoUtils;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.matrix.store.operation.AggregateAll;
import org.ojalgo.matrix.store.operation.ApplyCholesky;
import org.ojalgo.matrix.store.operation.ApplyLU;
import org.ojalgo.matrix.store.operation.FillMatchingDual;
import org.ojalgo.matrix.store.operation.FillMatchingSingle;
import org.ojalgo.matrix.store.operation.GenerateApplyAndCopyHouseholderColumn;
import org.ojalgo.matrix.store.operation.GenerateApplyAndCopyHouseholderRow;
import org.ojalgo.matrix.store.operation.HermitianRank2Update;
import org.ojalgo.matrix.store.operation.HouseholderLeft;
import org.ojalgo.matrix.store.operation.HouseholderRight;
import org.ojalgo.matrix.store.operation.ModifyAll;
import org.ojalgo.matrix.store.operation.MultiplyBoth;
import org.ojalgo.matrix.store.operation.MultiplyHermitianAndVector;
import org.ojalgo.matrix.store.operation.MultiplyLeft;
import org.ojalgo.matrix.store.operation.MultiplyRight;
import org.ojalgo.matrix.store.operation.RotateLeft;
import org.ojalgo.matrix.store.operation.RotateRight;
import org.ojalgo.matrix.store.operation.SubstituteBackwards;
import org.ojalgo.matrix.store.operation.SubstituteForwards;

public abstract class MatrixOperation {
    public static void setAllOperationThresholds(int value) {
        MatrixOperation.setThresholdsMaxValue(value);
        MatrixOperation.setThresholdsMinValue(value);
    }

    public static void setThresholdsMaxValue(int maxValue) {
        AggregateAll.THRESHOLD = Math.min(maxValue, AggregateAll.THRESHOLD);
        ApplyCholesky.THRESHOLD = Math.min(maxValue, ApplyCholesky.THRESHOLD);
        ApplyLU.THRESHOLD = Math.min(maxValue, ApplyLU.THRESHOLD);
        FillMatchingDual.THRESHOLD = Math.min(maxValue, FillMatchingDual.THRESHOLD);
        FillMatchingSingle.THRESHOLD = Math.min(maxValue, FillMatchingSingle.THRESHOLD);
        GenerateApplyAndCopyHouseholderColumn.THRESHOLD = Math.min(maxValue, GenerateApplyAndCopyHouseholderColumn.THRESHOLD);
        GenerateApplyAndCopyHouseholderRow.THRESHOLD = Math.min(maxValue, GenerateApplyAndCopyHouseholderRow.THRESHOLD);
        HermitianRank2Update.THRESHOLD = Math.min(maxValue, HermitianRank2Update.THRESHOLD);
        HouseholderLeft.THRESHOLD = Math.min(maxValue, HouseholderLeft.THRESHOLD);
        HouseholderRight.THRESHOLD = Math.min(maxValue, HouseholderRight.THRESHOLD);
        AXPY.THRESHOLD = Math.min(maxValue, AXPY.THRESHOLD);
        ModifyAll.THRESHOLD = Math.min(maxValue, ModifyAll.THRESHOLD);
        MultiplyBoth.THRESHOLD = Math.min(maxValue, MultiplyBoth.THRESHOLD);
        MultiplyHermitianAndVector.THRESHOLD = Math.min(maxValue, MultiplyHermitianAndVector.THRESHOLD);
        MultiplyLeft.THRESHOLD = Math.min(maxValue, MultiplyLeft.THRESHOLD);
        MultiplyRight.THRESHOLD = Math.min(maxValue, MultiplyRight.THRESHOLD);
        RotateLeft.THRESHOLD = Math.min(maxValue, RotateLeft.THRESHOLD);
        RotateRight.THRESHOLD = Math.min(maxValue, RotateRight.THRESHOLD);
        SubstituteBackwards.THRESHOLD = Math.min(maxValue, SubstituteBackwards.THRESHOLD);
        SubstituteForwards.THRESHOLD = Math.min(maxValue, SubstituteForwards.THRESHOLD);
    }

    public static void setThresholdsMinValue(int minValue) {
        AggregateAll.THRESHOLD = Math.max(minValue, AggregateAll.THRESHOLD);
        ApplyCholesky.THRESHOLD = Math.max(minValue, ApplyCholesky.THRESHOLD);
        ApplyLU.THRESHOLD = Math.max(minValue, ApplyLU.THRESHOLD);
        FillMatchingDual.THRESHOLD = Math.max(minValue, FillMatchingDual.THRESHOLD);
        FillMatchingSingle.THRESHOLD = Math.max(minValue, FillMatchingSingle.THRESHOLD);
        GenerateApplyAndCopyHouseholderColumn.THRESHOLD = Math.max(minValue, GenerateApplyAndCopyHouseholderColumn.THRESHOLD);
        GenerateApplyAndCopyHouseholderRow.THRESHOLD = Math.max(minValue, GenerateApplyAndCopyHouseholderRow.THRESHOLD);
        HermitianRank2Update.THRESHOLD = Math.max(minValue, HermitianRank2Update.THRESHOLD);
        HouseholderLeft.THRESHOLD = Math.max(minValue, HouseholderLeft.THRESHOLD);
        HouseholderRight.THRESHOLD = Math.max(minValue, HouseholderRight.THRESHOLD);
        AXPY.THRESHOLD = Math.max(minValue, AXPY.THRESHOLD);
        ModifyAll.THRESHOLD = Math.max(minValue, ModifyAll.THRESHOLD);
        MultiplyBoth.THRESHOLD = Math.max(minValue, MultiplyBoth.THRESHOLD);
        MultiplyHermitianAndVector.THRESHOLD = Math.max(minValue, MultiplyHermitianAndVector.THRESHOLD);
        MultiplyLeft.THRESHOLD = Math.max(minValue, MultiplyLeft.THRESHOLD);
        MultiplyRight.THRESHOLD = Math.max(minValue, MultiplyRight.THRESHOLD);
        RotateLeft.THRESHOLD = Math.max(minValue, RotateLeft.THRESHOLD);
        RotateRight.THRESHOLD = Math.max(minValue, RotateRight.THRESHOLD);
        SubstituteBackwards.THRESHOLD = Math.max(minValue, SubstituteBackwards.THRESHOLD);
        SubstituteForwards.THRESHOLD = Math.max(minValue, SubstituteForwards.THRESHOLD);
    }

    protected MatrixOperation() {
    }

    public abstract int threshold();

    public int workers() {
        return OjAlgoUtils.ENVIRONMENT.threads;
    }
}

