/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.ProgrammingError;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.ShadingStore;
import org.ojalgo.scalar.Scalar;

final class UpperHessenbergStore<N extends Number>
extends ShadingStore<N> {
    private UpperHessenbergStore(int aRowDim, int aColDim, MatrixStore<N> base) {
        this(base);
        ProgrammingError.throwForIllegalInvocation();
    }

    UpperHessenbergStore(MatrixStore<N> base) {
        super(base, (int)Math.min(base.countRows(), base.countColumns()), (int)base.countColumns());
    }

    @Override
    public double doubleValue(long row, long col) {
        if (row > col + 1L) {
            return PrimitiveMath.ZERO;
        }
        return this.getBase().doubleValue(row, col);
    }

    @Override
    public int firstInRow(int row) {
        if (row == 0) {
            return 0;
        }
        return row - 1;
    }

    @Override
    public N get(long row, long col) {
        if (row > col + 1L) {
            return this.physical().scalar().zero().get();
        }
        return this.getBase().get(row, col);
    }

    @Override
    public int limitOfColumn(int col) {
        return Math.min(col + 2, this.getRowDim());
    }

    @Override
    public Scalar<N> toScalar(long row, long col) {
        if (row > col + 1L) {
            return this.physical().scalar().zero();
        }
        return this.getBase().toScalar(row, col);
    }
}

