/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import org.ojalgo.matrix.AbstractMatrix;
import org.ojalgo.matrix.MatrixFactory;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.task.DeterminantTask;
import org.ojalgo.matrix.task.InverterTask;
import org.ojalgo.matrix.task.SolverTask;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;

public final class PrimitiveMatrix
extends AbstractMatrix<Double, PrimitiveMatrix> {
    public static final MatrixFactory<Double, PrimitiveMatrix> FACTORY = new MatrixFactory<Double, PrimitiveMatrix>(PrimitiveMatrix.class, PrimitiveDenseStore.FACTORY);

    PrimitiveMatrix(MatrixStore<Double> aStore) {
        super(aStore);
    }

    @Override
    ElementsSupplier<Double> cast(Access1D<?> matrix) {
        if (matrix instanceof PrimitiveMatrix) {
            return ((PrimitiveMatrix)matrix).getStore();
        }
        if (matrix instanceof PrimitiveDenseStore) {
            return (PrimitiveDenseStore)matrix;
        }
        if (matrix instanceof ElementsSupplier && matrix.count() > 0L && matrix.get(0L) instanceof Double) {
            return (ElementsSupplier)((Object)matrix);
        }
        if (matrix instanceof Access2D) {
            Access2D tmpAccess2D = (Access2D)matrix;
            return this.getStore().physical().builder().makeWrapper(tmpAccess2D);
        }
        return (ElementsSupplier)this.getStore().physical().columns(matrix);
    }

    @Override
    Eigenvalue<Double> getDecompositionEigenvalue(Structure2D typical) {
        return Eigenvalue.PRIMITIVE.make(typical, this.isHermitian());
    }

    @Override
    LU<Double> getDecompositionLU(Structure2D typical) {
        return (LU)LU.PRIMITIVE.make(typical);
    }

    @Override
    QR<Double> getDecompositionQR(Structure2D typical) {
        return QR.PRIMITIVE.make(typical);
    }

    @Override
    SingularValue<Double> getDecompositionSingularValue(Structure2D typical) {
        return SingularValue.PRIMITIVE.make(typical);
    }

    @Override
    MatrixFactory<Double, PrimitiveMatrix> getFactory() {
        return FACTORY;
    }

    @Override
    DeterminantTask<Double> getTaskDeterminant(MatrixStore<Double> template) {
        return DeterminantTask.PRIMITIVE.make(template, this.isHermitian(), false);
    }

    @Override
    InverterTask<Double> getTaskInverter(MatrixStore<Double> base) {
        return InverterTask.PRIMITIVE.make(base, this.isHermitian(), false);
    }

    @Override
    SolverTask<Double> getTaskSolver(MatrixStore<Double> templateBody, Access2D<?> templateRHS) {
        return SolverTask.PRIMITIVE.make(templateBody, templateRHS, this.isHermitian(), false);
    }
}

