/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import java.util.List;
import java.util.function.Supplier;
import org.ojalgo.algebra.NormedVectorSpace;
import org.ojalgo.algebra.Operation;
import org.ojalgo.algebra.ScalarOperation;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Mutate2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.context.NumberContext;

@Deprecated
public interface BasicMatrix
extends NormedVectorSpace<BasicMatrix, Number>,
Operation.Subtraction<BasicMatrix>,
Operation.Multiplication<BasicMatrix>,
ScalarOperation.Addition<BasicMatrix, Number>,
ScalarOperation.Division<BasicMatrix, Number>,
ScalarOperation.Subtraction<BasicMatrix, Number>,
Access2D<Number>,
Access2D.Elements,
Access2D.Aggregatable<Number>,
Structure2D.ReducibleTo1D<BasicMatrix>,
NumberContext.Enforceable<BasicMatrix> {
    public static double calculateFrobeniusNorm(BasicMatrix matrix) {
        return matrix.norm();
    }

    public static double calculateInfinityNorm(BasicMatrix matrix) {
        double retVal = PrimitiveMath.ZERO;
        long tmpLimit = matrix.countRows();
        for (long i = 0L; i < tmpLimit; ++i) {
            retVal = PrimitiveFunction.MAX.invoke(retVal, ((Number)matrix.aggregateRow(i, Aggregator.NORM1)).doubleValue());
        }
        return retVal;
    }

    public static double calculateOneNorm(BasicMatrix matrix) {
        double retVal = PrimitiveMath.ZERO;
        long tmpLimit = matrix.countColumns();
        for (long j = 0L; j < tmpLimit; ++j) {
            retVal = PrimitiveFunction.MAX.invoke(retVal, ((Number)matrix.aggregateColumn(j, Aggregator.NORM1)).doubleValue());
        }
        return retVal;
    }

    @Deprecated
    public BasicMatrix add(int var1, int var2, Access2D<?> var3);

    public PhysicalBuilder<? extends Number, ? extends BasicMatrix> copy();

    @Deprecated
    public BasicMatrix divideElements(Access2D<?> var1);

    public boolean equals(Access2D<?> var1, NumberContext var2);

    public void flushCache();

    @Deprecated
    public BasicMatrix getColumnsRange(int var1, int var2);

    public Scalar<?> getCondition();

    public Scalar<?> getDeterminant();

    public List<Eigenvalue.Eigenpair> getEigenpairs();

    public int getRank();

    @Deprecated
    public BasicMatrix getRowsRange(int var1, int var2);

    @Deprecated
    public List<? extends Number> getSingularValues();

    public Scalar<?> getTrace();

    public BasicMatrix invert();

    public boolean isFullRank();

    public boolean isHermitian();

    public boolean isSymmetric();

    public LogicalBuilder<? extends Number, ? extends BasicMatrix> logical();

    @Deprecated
    public BasicMatrix mergeColumns(Access2D<?> var1);

    @Deprecated
    public BasicMatrix mergeRows(Access2D<?> var1);

    @Deprecated
    public BasicMatrix modify(UnaryFunction<? extends Number> var1);

    @Deprecated
    public BasicMatrix multiplyElements(Access2D<?> var1);

    @Deprecated
    default public BasicMatrix selectColumns(int ... someCols) {
        return (BasicMatrix)this.logical().column(someCols).get();
    }

    @Deprecated
    default public BasicMatrix selectRows(int ... someRows) {
        return (BasicMatrix)this.logical().row(someRows).get();
    }

    public BasicMatrix solve(Access2D<?> var1);

    public Scalar<?> toScalar(long var1, long var3);

    public BasicMatrix transpose();

    public static interface PhysicalBuilder<N extends Number, I extends BasicMatrix>
    extends Mutate2D.Receiver<N>,
    Mutate2D.BiModifiable<N>,
    Mutate2D.Exchangeable,
    Supplier<I>,
    Access2D.Collectable<N, PhysicalStore<N>> {
        default public I build() {
            return (I)((BasicMatrix)this.get());
        }
    }

    public static interface LogicalBuilder<N extends Number, I extends BasicMatrix>
    extends Structure2D.Logical<I, LogicalBuilder<N, I>>,
    Access2D.Collectable<N, PhysicalStore<N>> {
        public LogicalBuilder<N, I> above(int var1);

        @Override
        public LogicalBuilder<N, I> above(N ... var1);

        public LogicalBuilder<N, I> below(int var1);

        @Override
        public LogicalBuilder<N, I> below(N ... var1);

        public LogicalBuilder<N, I> bidiagonal(boolean var1, boolean var2);

        default public I build() {
            return (I)((BasicMatrix)this.get());
        }

        public LogicalBuilder<N, I> column(int ... var1);

        public LogicalBuilder<N, I> conjugate();

        public LogicalBuilder<N, I> diagonal();

        public LogicalBuilder<N, I> hermitian(boolean var1);

        public LogicalBuilder<N, I> hessenberg(boolean var1);

        public LogicalBuilder<N, I> left(int var1);

        @Override
        public LogicalBuilder<N, I> left(N ... var1);

        public LogicalBuilder<N, I> limits(int var1, int var2);

        public LogicalBuilder<N, I> offsets(int var1, int var2);

        public LogicalBuilder<N, I> right(int var1);

        @Override
        public LogicalBuilder<N, I> right(N ... var1);

        public LogicalBuilder<N, I> row(int ... var1);

        public LogicalBuilder<N, I> superimpose(BasicMatrix var1);

        public LogicalBuilder<N, I> superimpose(int var1, int var2, BasicMatrix var3);

        public LogicalBuilder<N, I> superimpose(int var1, int var2, Number var3);

        public LogicalBuilder<N, I> transpose();

        public LogicalBuilder<N, I> triangular(boolean var1, boolean var2);

        public LogicalBuilder<N, I> tridiagonal();
    }
}

