/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.constant;

import java.util.Arrays;
import org.ojalgo.constant.BigMath;
import org.ojalgo.function.PrimitiveFunction;

public abstract class PrimitiveMath {
    public static final double ZERO = BigMath.ZERO.doubleValue();
    public static final double ONE = BigMath.ONE.doubleValue();
    public static final double TWO = BigMath.TWO.doubleValue();
    public static final double THREE = BigMath.THREE.doubleValue();
    public static final double FOUR = BigMath.FOUR.doubleValue();
    public static final double FIVE = BigMath.FIVE.doubleValue();
    public static final double SIX = BigMath.SIX.doubleValue();
    public static final double SEVEN = BigMath.SEVEN.doubleValue();
    public static final double EIGHT = BigMath.EIGHT.doubleValue();
    public static final double NINE = BigMath.NINE.doubleValue();
    public static final double TEN = BigMath.TEN.doubleValue();
    public static final double ELEVEN = BigMath.ELEVEN.doubleValue();
    public static final double TWELVE = BigMath.TWELVE.doubleValue();
    public static final double HUNDRED = BigMath.HUNDRED.doubleValue();
    public static final double THOUSAND = BigMath.THOUSAND.doubleValue();
    public static final double NEG = BigMath.NEG.doubleValue();
    public static final double HALF = BigMath.HALF.doubleValue();
    public static final double THIRD = BigMath.THIRD.doubleValue();
    public static final double QUARTER = BigMath.QUARTER.doubleValue();
    public static final double FITH = BigMath.FITH.doubleValue();
    public static final double SIXTH = BigMath.SIXTH.doubleValue();
    public static final double SEVENTH = BigMath.SEVENTH.doubleValue();
    public static final double EIGHTH = BigMath.EIGHTH.doubleValue();
    public static final double NINTH = BigMath.NINTH.doubleValue();
    public static final double TENTH = BigMath.TENTH.doubleValue();
    public static final double ELEVENTH = BigMath.ELEVENTH.doubleValue();
    public static final double TWELFTH = BigMath.TWELFTH.doubleValue();
    public static final double HUNDREDTH = BigMath.HUNDREDTH.doubleValue();
    public static final double THOUSANDTH = BigMath.THOUSANDTH.doubleValue();
    public static final double TWO_THIRDS = BigMath.TWO_THIRDS.doubleValue();
    public static final double THREE_QUARTERS = BigMath.THREE_QUARTERS.doubleValue();
    public static final double E = BigMath.E.doubleValue();
    public static final double PI = BigMath.PI.doubleValue();
    public static final double GOLDEN_RATIO = BigMath.GOLDEN_RATIO.doubleValue();
    public static final double HALF_PI = BigMath.HALF_PI.doubleValue();
    public static final double TWO_PI = BigMath.TWO_PI.doubleValue();
    public static final double SQRT_TWO = BigMath.SQRT_TWO.doubleValue();
    public static final double SQRT_PI = BigMath.SQRT_PI.doubleValue();
    public static final double SQRT_TWO_PI = BigMath.SQRT_TWO_PI.doubleValue();
    public static final double POSITIVE_INFINITY = Double.POSITIVE_INFINITY;
    public static final double NEGATIVE_INFINITY = Double.NEGATIVE_INFINITY;
    public static final double NaN = Double.NaN;
    public static final double MACHINE_LARGEST = Double.MAX_VALUE;
    public static final double MACHINE_SMALLEST = Double.MIN_NORMAL;
    public static final double MACHINE_EPSILON = PrimitiveFunction.POW.invoke(2.0, -52.0);
    @Deprecated
    public static final double TINY = PrimitiveFunction.POW.invoke(2.0, -966.0);
    private static final int[] PRIME = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271};
    public static final long[] POWERS_OF_2 = new long[63];

    public static final int getPrimeNumber(int index) {
        return PRIME[index];
    }

    public static final boolean isPowerOf2(long value) {
        return Arrays.binarySearch(POWERS_OF_2, value) >= 0;
    }

    public static final int powerOf2Larger(long value) {
        int index = Arrays.binarySearch(POWERS_OF_2, value);
        return index >= 0 ? index : Math.min(-(index + 1), 62);
    }

    public static final int powerOf2Smaller(long value) {
        int index = Arrays.binarySearch(POWERS_OF_2, value);
        return index >= 0 ? index : Math.max(-(index + 2), 0);
    }

    private PrimitiveMath() {
    }

    static {
        PrimitiveMath.POWERS_OF_2[0] = 1L;
        for (int p = 1; p < POWERS_OF_2.length; ++p) {
            PrimitiveMath.POWERS_OF_2[p] = POWERS_OF_2[p - 1] * 2L;
        }
    }
}

