/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.lang.reflect.Array;
import java.util.function.DoubleConsumer;

public abstract class Raw1D {
    public static double[] copyOf(double[] original) {
        int tmpLength = original.length;
        double[] retVal = new double[tmpLength];
        System.arraycopy(original, 0, retVal, 0, tmpLength);
        return retVal;
    }

    public static float[] copyOf(float[] original) {
        int tmpLength = original.length;
        float[] retVal = new float[tmpLength];
        System.arraycopy(original, 0, retVal, 0, tmpLength);
        return retVal;
    }

    public static int[] copyOf(int[] original) {
        int tmpLength = original.length;
        int[] retVal = new int[tmpLength];
        System.arraycopy(original, 0, retVal, 0, tmpLength);
        return retVal;
    }

    public static long[] copyOf(long[] original) {
        int tmpLength = original.length;
        long[] retVal = new long[tmpLength];
        System.arraycopy(original, 0, retVal, 0, tmpLength);
        return retVal;
    }

    public static <T> T[] copyOf(T[] original) {
        int tmpLength = original.length;
        Object[] retVal = (Object[])Array.newInstance(original.getClass().getComponentType(), tmpLength);
        System.arraycopy(original, 0, retVal, 0, tmpLength);
        return retVal;
    }

    public static int indexOf(int[] array, int value) {
        int limit = array.length;
        for (int i = 0; i < limit; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long[] array, long value) {
        int limit = array.length;
        for (int i = 0; i < limit; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static void sort(long[] primary, double[] secondary) {
        boolean tmpSwapped;
        int tmpLimit = Math.min(primary.length, secondary.length) - 1;
        do {
            tmpSwapped = false;
            for (int i = 0; i < tmpLimit; ++i) {
                if (primary[i] <= primary[i + 1]) continue;
                long tmpPrimVal = primary[i];
                primary[i] = primary[i + 1];
                primary[i + 1] = tmpPrimVal;
                double tmpSecoVal = secondary[i];
                secondary[i] = secondary[i + 1];
                secondary[i + 1] = tmpSecoVal;
                tmpSwapped = true;
            }
        } while (tmpSwapped);
    }

    public static void sort(long[] primary, Object[] secondary) {
        boolean tmpSwapped;
        int tmpLimit = Math.min(primary.length, secondary.length) - 1;
        do {
            tmpSwapped = false;
            for (int i = 0; i < tmpLimit; ++i) {
                if (primary[i] <= primary[i + 1]) continue;
                long tmpPrimVal = primary[i];
                primary[i] = primary[i + 1];
                primary[i + 1] = tmpPrimVal;
                Object tmpSecoVal = secondary[i];
                secondary[i] = secondary[i + 1];
                secondary[i + 1] = tmpSecoVal;
                tmpSwapped = true;
            }
        } while (tmpSwapped);
    }

    public static void visit(double[] target, DoubleConsumer visitor) {
        Raw1D.visit(target, 0, target.length, visitor);
    }

    public static void visit(double[] target, int first, int limit, DoubleConsumer visitor) {
        int lim = Math.min(limit, target.length);
        for (int i = first; i < lim; ++i) {
            visitor.accept(target[i]);
        }
    }
}

