/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.exceptions;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.List;
import org.djutils.reflection.ClassUtil;

public final class Throw {
    private Throw() {
    }

    public static <T extends Throwable> void when(boolean condition, Class<T> throwableClass, String message) throws T {
        if (condition) {
            Throw.throwMessage(throwableClass, message, new ArrayList<Object>());
        }
    }

    public static <T extends Throwable> void when(boolean condition, Class<T> throwableClass, String message, Object arg) throws T {
        if (condition) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg);
            Throw.throwMessage(throwableClass, message, argList);
        }
    }

    public static <T extends Throwable> void when(boolean condition, Class<T> throwableClass, String message, Object arg1, Object arg2) throws T {
        if (condition) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            Throw.throwMessage(throwableClass, message, argList);
        }
    }

    public static <T extends Throwable> void when(boolean condition, Class<T> throwableClass, String message, Object arg1, Object arg2, Object arg3) throws T {
        if (condition) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            argList.add(arg3);
            Throw.throwMessage(throwableClass, message, argList);
        }
    }

    public static <T extends Throwable> void when(boolean condition, Class<T> throwableClass, String message, Object arg1, Object arg2, Object arg3, Object ... args) throws T {
        if (condition) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            argList.add(arg3);
            argList.addAll(Arrays.asList(args));
            Throw.throwMessage(throwableClass, message, argList);
        }
    }

    private static <T extends Throwable> void throwMessage(Class<T> throwableClass, String message, List<Object> argList) throws T {
        Throwable exception;
        String formattedMessage;
        ArrayList<StackTraceElement> steList = new ArrayList<StackTraceElement>(Arrays.asList(new Throwable().getStackTrace()));
        steList.remove(0);
        steList.remove(0);
        StackTraceElement[] ste = steList.toArray(new StackTraceElement[steList.size()]);
        String where = ste[0].getClassName() + "." + ste[0].getMethodName() + " (" + ste[0].getLineNumber() + "): ";
        Object[] args = argList.toArray();
        try {
            formattedMessage = where + String.format(message, args);
        }
        catch (IllegalFormatException exception2) {
            formattedMessage = where + message + " [FormatException; args=" + argList + "]";
        }
        try {
            Constructor<T> constructor = ClassUtil.resolveConstructor(throwableClass, new Class[]{String.class});
            exception = (Throwable)constructor.newInstance(formattedMessage);
            exception.setStackTrace(ste);
        }
        catch (Throwable t) {
            RuntimeException rte = new RuntimeException(t.getMessage(), new Exception(formattedMessage));
            rte.setStackTrace(ste);
            throw rte;
        }
        throw exception;
    }

    public static <T extends Throwable, O> O when(O object, boolean condition, Class<T> throwableClass, String message) throws T {
        if (condition) {
            Throw.throwMessage(throwableClass, message, new ArrayList<Object>());
        }
        return object;
    }

    public static <T extends Throwable, O> O when(O object, boolean condition, Class<T> throwableClass, String message, Object arg) throws T {
        if (condition) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg);
            Throw.throwMessage(throwableClass, message, argList);
        }
        return object;
    }

    public static <T extends Throwable, O> O when(O object, boolean condition, Class<T> throwableClass, String message, Object arg1, Object arg2) throws T {
        if (condition) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            Throw.throwMessage(throwableClass, message, argList);
        }
        return object;
    }

    public static <T extends Throwable, O> O when(O object, boolean condition, Class<T> throwableClass, String message, Object arg1, Object arg2, Object arg3) throws T {
        if (condition) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            argList.add(arg3);
            Throw.throwMessage(throwableClass, message, argList);
        }
        return object;
    }

    public static <T extends Throwable, O> O when(O object, boolean condition, Class<T> throwableClass, String message, Object arg1, Object arg2, Object arg3, Object ... args) throws T {
        if (condition) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            argList.add(arg3);
            argList.addAll(Arrays.asList(args));
            Throw.throwMessage(throwableClass, message, argList);
        }
        return object;
    }

    public static <O> O whenNull(O object, String message) throws NullPointerException {
        if (object == null) {
            Throw.throwMessage(NullPointerException.class, message, new ArrayList<Object>());
        }
        return object;
    }

    public static <O> O whenNull(O object, String message, Object arg) throws NullPointerException {
        if (object == null) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg);
            Throw.throwMessage(NullPointerException.class, message, argList);
        }
        return object;
    }

    public static <O> O whenNull(O object, String message, Object arg1, Object arg2) throws NullPointerException {
        if (object == null) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            Throw.throwMessage(NullPointerException.class, message, argList);
        }
        return object;
    }

    public static <O> O whenNull(O object, String message, Object arg1, Object arg2, Object arg3) throws NullPointerException {
        if (object == null) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            argList.add(arg3);
            Throw.throwMessage(NullPointerException.class, message, argList);
        }
        return object;
    }

    public static <O> O whenNull(O object, String message, Object arg1, Object arg2, Object arg3, Object ... args) throws NullPointerException {
        if (object == null) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            argList.add(arg3);
            argList.addAll(Arrays.asList(args));
            Throw.throwMessage(NullPointerException.class, message, argList);
        }
        return object;
    }
}

