import unittest as unit

from orcs_class import Orcs

O = Orcs()


class Board:
    def __init__(self):
        self.__filledboard = [
            ["--", "--", "--", "--", "dr", "--", "dr", "--", "dr", "--", "--", "--"],
            ["--", "--", "--", "ma", "ma", "--", "--", "ma", "ma", "--", "--", "--"],
            ["--", "--", "--", "or", "--", "--", "or", "--", "--", "or", "--", "--"],
            ["--", "--", "--", "--", "or", "--", "--", "--", "or", "--", "--", "--"],
            ["--", "--", "--", "--", "--", "--", "--", "--", "--", "--", "--", "--"],
            ["--", "--", "--", "--", "--", "--", "--", "--", "--", "--", "--", "--"],
            ["--", "--", "--", "--", "--", "--", "--", "--", "--", "--", "--", "--"],
            ["--", "--", "--", "--", "--", "--", "--", "--", "--", "--", "--", "--"],
            ["--", "--", "--", "kn", "--", "--", "--", "kn", "--", "--", "--", "--"],
            ["--", "--", "kn", "--", "--", "kn", "--", "--", "kn", "--", "--", "--"],
            ["--", "--", "--", "ar", "ar", "--", "--", "ar", "ar", "--", "--", "--"],
            ["--", "--", "--", "ca", "--", "ca", "--", "ca", "--", "--", "--", "--"]]

        self.__restartGame = [
            ["--", "--", "--", "--", "dr", "--", "dr", "--", "dr", "--", "--", "--"],
            ["--", "--", "--", "ma", "ma", "--", "--", "ma", "ma", "--", "--", "--"],
            ["--", "--", "--", "or", "--", "--", "or", "--", "--", "or", "--", "--"],
            ["--", "--", "--", "--", "or", "--", "--", "--", "or", "--", "--", "--"],
            ["--", "--", "--", "--", "--", "--", "--", "--", "--", "--", "--", "--"],
            ["--", "--", "--", "--", "--", "--", "--", "--", "--", "--", "--", "--"],
            ["--", "--", "--", "--", "--", "--", "--", "--", "--", "--", "--", "--"],
            ["--", "--", "--", "--", "--", "--", "--", "--", "--", "--", "--", "--"],
            ["--", "--", "--", "kn", "--", "--", "--", "kn", "--", "--", "--", "--"],
            ["--", "--", "kn", "--", "--", "kn", "--", "--", "kn", "--", "--", "--"],
            ["--", "--", "--", "ar", "ar", "--", "--", "ar", "ar", "--", "--", "--"],
            ["--", "--", "--", "ca", "--", "ca", "--", "ca", "--", "--", "--", "--"]]

        self.__lcnotation = [
            ["l1", "l2", "l3", "l4", "l5", "l6", "l7", "l8", "l9", "l10", "l11", "l12"],
            ["k1", "k2", "k3", "k4", "k5", "k6", "k7", "k8", "k9", "k10", "k11", "k12"],
            ["j1", "j2", "j3", "j4", "j5", "j6", "j7", "j8", "j9", "j10", "j11", "j12"],
            ["i1", "i2", "i3", "i4", "i5", "i6", "i7", "i8", "i9", "i10", "i11", "i12"],
            ["h1", "h2", "h3", "h4", "h5", "h6", "h7", "h8", "h9", "h10", "h11", "h12"],
            ["g1", "g2", "g3", "g4", "g5", "g6", "g7", "g8", "g9", "g10", "g11", "g12"],
            ["f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "f10", "f11", "f12"],
            ["e1", "e2", "e3", "e4", "e5", "e6", "e7", "e8", "e9", "e10", "e11", "e12"],
            ["d1", "d2", "d3", "d4", "d5", "d6", "d7", "d8", "d9", "d10", "d11", "d12"],
            ["c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9", "c10", "c11", "c12"],
            ["b1", "b2", "b3", "b4", "b5", "b6", "b7", "b8", "b9", "b10", "b11", "b12"],
            ["a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8", "a9", "a10", "a11", "a12"]]

        self.__vert = ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', 'f']
        self.__hor = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l']

    def get_filledboard(self):
        """
        returns a filled board wich is an array of array

        PRE :
        POST : returns the board
        """

        return self.__filledboard

    def get_lcboard(self):
        return self.__lcnotation

    def restartGame(self):
        self.__filledboard = self.__restartGame


class TestBoard(unit.TestCase):
    def test_get_board(self):
        self.assertEqual(type(Board().get_filledboard()), type([]))
        self.assertEqual(type(Board().get_filledboard()), type([]))

    def test_get_hor(self):
        self.assertEqual(type(Board().get_lcboard()), type([]))

