# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['raider']

package_data = \
{'': ['*']}

install_requires = \
['bs4>=0.0.1,<0.0.2',
 'hy>=0.20.0,<0.21.0',
 'importlib-metadata>=4.6.1,<5.0.0',
 'requests>=2.25.1,<3.0.0']

setup_kwargs = {
    'name': 'raider',
    'version': '0.1.1',
    'description': 'Authentication testing tool',
    'long_description': '# What is this\n\nThis is a tool I wrote to help me test authentication for web applications. I was not satisfied with the existing tools when I attempted to find bugs in the authentication part of the application. While web proxies like ZAProxy and Burpsuite allow you to do authenticated tests, they don\'t provide features to test the authentication process itself, i.e. manipulating the relevant input fields to identify broken authentication. Most authentication bugs in the wild have been found by manually testing it or writing custom scripts that replicate the behaviour. Raider aims to make testing easier, by providing the interface to interact with all important elements found in modern authentication systems.\n\n## How does it work\n\nRaider treats the authentication as a finite state machine. Each authentication step is a different state, with its own inputs and outputs. Those can be cookies, headers, CSRF tokens, or other pieces of information.\n\nEach application needs its own configuration file for Raider to work. The configuration is written in [Hylang](https://docs.hylang.org/). The language choice was done for multiple reasons, mainly because it\'s a Lisp dialect embedded in Python. Using Lisp was necessarily since sometimes the authentication can get quite complex, and using a static configuration file would\'ve not been enough to cover all the details. Lisp makes it easy to combine code and data, which is exactly what I needed here.\n\nBy using a real programming language as a configuration file gives Raider a lot of power, and with great power comes great responsibility. Theoretically one can write entire malware inside the application configuration file, which means you should be careful what\'s being executed, and not to use configuration files from sources you don\'t trust. Raider will eval everything inside the .hy files, which means if you\'re not careful you could shoot yourself in the foot and break something on your system.\n\n## Architecture and definitions\n\nRaider treats authentication mechanism like a finite state machine. Each state consists of a single HTTP request with the associated response. This state is called `Flow` in Raider.\n\n### Configuration\n\nConfiguration files are located at `~/.config/raider/`. Project specific files are inside the `apps` subdirectory. Each directory inside `apps` represents another project. All *.hy files inside the project directory will be evaluated in alphabetical order. Take at look at [examples](examples/) directory for inspiration. All objects defined in one file will be available inside the next file, which allows to split the configuration however you want.\n\n### Flows\n\nThe `Flow` object is used to define the HTTP request with all the inputs, the outputs which will be extracted from the response, operations to do after the stage is finished, and other similar information.\n\n### Outputs\n\nAn output is a piece of data we want to extract from the HTTP response. It can be later used as an input to later HTTP requests. For now the following output types are supported:\n\n* Cookie - The cookie from the response will be saved and can later be used as an input.\n\n* Header - Same as Cookie, only the header is saved instead.\n\n* Html - If the piece of information you need is located inside an HTML tag, you can use this object to extract it and pass it down to the next request as input.\n\n* Regex - Same as Html, except it uses regular expressions to extract the information you want.\n\n* Json - Same as Html or Regex, except the information is located inside a JSON body response.\n\n\n### Inputs\n\nAn input is a piece of data that we send with the HTTP request. It can be a cookie, header, or some other information in the HTTP request. They are defined inside the `Request` object. For now Raider supports the following input types:\n\n* Variable - at the moment can be only "username" or "password". Raider will replace the value of the current active user with the correct credential. In the future it will also allow other user relevant data.\n\n* Prompt - Raider will ask for the input value in the command line prompt. This is used for multi-factor authentication code for example.\n\n* Cookie - If a cookie was set up as an output from the previous response it can be passed further as an input to the next request.\n\n* Header - Same as Cookie, except for two header subtypes: ** Basicauth - This header is used for basic authentication.  ** Bearerauth - This is used for bearer authentication with the access token.\n\n* Html - This object will return the value extracted from a previous response. If a HTML tag defined here is found in the request where it\'s set up as an output, the extracted value will be used as an input when used in a `Request` object.\n\n* Regex - Same as Html, except instead of searching for HTML tags, you search for regular expression inside the response.\n\n* Json - Like Html and Regex, only it returns the information from a JSON response.\n\n\n### Operations\n\nThe `Flow` object accepts the operations parameter, which contains a list of operations that will be performed once the response arrives. These are used to define the relationship between authentication steps, i.e. go to "multi_factor" if the HTTP response code is 302, and finish the authentication if the response code is\n200. Once the NextStage operation is encountered, no more operations will be executed, and Raider will move on to the next step of the authentication. For now Raider supports the following operations:\n\n* NextStage - go to the next stage as defined here\n\n* Print - print the value of some extracted output on the command line\n\n* Error - quit Raider with the specified error message\n\n* Grep - this is a conditional operation. The action defined under `:action` will be executed if the regular expression is matched in the HTTP response, and if not, the `:otherwise` operation will be executed.\n\n* Http - this is also a conditional operation. Unlike Grep, it will select which operation to run next based on the HTTP response code.\n\n\n### Special variables\n\nRaider config files must use several special variables prefixed with underscore for internal purposes. All other variables will only be used inside the config file and not transferred to Raider objects.\n\n* _users - this variable will contain a list of dictionaries with the user credentials. For now only usernames and passwords are evaluated, but in future it will be used for other arbitrary user related information.\n\n  Example:\n```\n  (setv _users\n     [{:username "user1"\n\t   :password "s3cr3tP4ssWrd1"}\n      {:username "user2"\n\t   :password "s3cr3tP4ssWrd2"}])\n```\n* _authentication - this variable should contain all of the authentication stages in the `Flow` format. You can define those stages separately as variables like in the tutorial, and include them all at the end in the _authentication variable.\n\n  Example:\n\n```\n(setv _authentication\n      [initialization\n       login\n       multi_factor\n       get_access_token\n       get_unread_messages\n       #_ /])\n```\n\n* _functions - this variable should contain all of the functions in the `Flow` format. Functions look similar to authentication stages, only they are not considered to affect the authentication process.\n\n\n* _base_url (optional) - this variable can be used to create shorter request definitions. If set up, you can create `Request` objects with the ":path" parameter instead of the ":url" one, so you don\'t need the entire URL if it\'s the same base for all requests.\n\n\n# Objects\n\n## Modules\n* Variable - used as a request input. Accepts one single parameter, the name of the variable. For now only "username" and "password" works. In the future it should be used with arbitrary user relevant data.\n\n  Example: `(setv username (Variable "username"))`\n\n* Prompt - used as a request input. Accepts one single parameter, the prompt to be used when asking for user input on command line.\n\n  Example: `(setv mfa_code (Prompt "MFA:"))`\n\n* Regex - used as both input and output. When used as output, the HTTP response will be checked for the regular expression, and the data from the first group, i.e. the string between `(` and `)` will be saved. When used as input, the extracted string will be returned.\n\n  Example:\n  ```\n  (setv access_token\n      (Regex\n        :name "access_token"\n        :regex "\\"accessToken\\":\\"([^\\"]+)\\""))\n  ```\n\n  Here, the string between double quotes following `"accessToken":` will be stored and returned when used as input.\n\n* Html - used as both input and output. When used as output, the HTML will be parsed, the specified tag will be selected, and the necessary attribute will be saved. When used as input, this saved value will be returned.\n\n  Example:\n\n  ```\n  (setv csrf_token\n        (Html\n          :name "csrf_token"\n          :tag "input"\n          :attributes\n          {:name "csrf_token"\n           :value "^[0-9a-f]{40}$"\n           :type "hidden"}\n          :extract "value"))\n\n  ```\n\n  Here the `input` tag will be identified, which has the attribute name as `csrf_token`, the type as `hidden` and its value is a 40 character string made out of lowercase hexadecimal digits. The value attribute will be extracted. When used as input, only the extracted string will be returned.\n\n* Json - used as both input and output. When used as output, the JSON body will be parsed, and the specified attribute will be extracted. The `.` (dot) character is used to go deeper inside the JSON object.\n\n  Example:\n\n  ```\n  (setv access_token\n        (Json\n          :name "access_token"\n          :extract "body.token"))\n  ```\n\n# Running raider\n\nCurrently there\'s no CLI for Raider yet, but this will change. So the\nonly way to run it now is by writing a small python script using the\nRaider library. Once the application is configured, you can\nauthenticate and call the function `get_nickname` with this script:\n\n```\nfrom raider.raider import Raider\n\nraider = Raider("reddit")\nraider.authenticate()\nraider.run_function("get_nickname")\n```\n',
    'author': 'Daniel Neagaru',
    'author_email': 'daniel@digeex.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
