# coding: utf-8

# flake8: noqa
"""
    MAGIC™ API

    --- # The API for accessing Cythereal MAGIC products and services.  ---  ## Authentication  **(Head to our [/auth](../auth/swagger) api to register, login, or generate a token)**  Supported Authentication Schemes:   * HTTP Basic Authentication  * API-KEY in the `X-API-KEY` request header  * JWT token in the `Authorization:\"Bearer {token}\"` request header  ---  ## Content Negotiation    There are two ways to specify the content type of the response. In order of precedence:     * The **Accept** request header can be set with the desired mime type. The most specific version will prevail. i.e. *application/json* > *application/\\**.       *Accept:\"application/json\"*     * The **format** query parameter. (MUST be in lower case)       *?format=json*    Supported Formats:     | query parameter | Accept Header            |         |    |-----------------|--------------------------|---------|    | **json**        | application/json         | Default |    | **xml**         | application/xml          |         |    | **csv**         | text/csv                 |         |    | **txt**         | text/plain               |         |  --- ## Requests  Supported HTTP Methods:   * **GET**  * **POST**  * **PATCH**  * **DELETE**  * **HEAD**  * **OPTIONS**  Every request supports the following query parameters:   * **explain** - (bool) - Returns a detailed explanation of what the endpoint does, as well as potential query parameters that can be used to customize the results    * **download** - (bool) - If set to a truthy value, acts as setting the 'Content-Disposition' header to *\"attachment;\"* and will download the response as a file.   * **filename** - (str) - The filename to use for a downloaded file. Ignored if no file is being downloaded.        * **format** - (str) - Used in a similar manner to the *Accept* Header. Use this to specify which format you want the response returned in. Defaults to *application/json*. Current acceptable values are:      * **json** - (application/json)     * **xml** - (application/xml)     * **csv** - (text/csv)     * **txt** - (text/plain)         * Custom type that returns a description of usage of the endpoint   * **no_links** - (bool) - If set to a truthy value, links will be disabled from the response   * **uri** - (bool) - If set to a truthy value, id lists will be returned as uris instead of id strings.  ---  ## GET Conventions ### Possible query parameters:   **(Check each endpoint description, or use *explain*, for a list of available values for each parameter)**    * **read_mask** - A list of values (keys) to return for the resource or each resource within the list     * Comma separated string of variables     * Leaving this field blank will return the default values.     * Setting this value equal to **`*`** will include **ALL** possible keys.     * Traversal is allowed with the **`.`** operator.     * There are three special keys that can be used with all endponts         * **`*`** - This will return all possible values available         * **`_self`** - This will include the resources uri         * **`_default`** - This will include all default values (Those given with an empty read_mask)           * This would typically be used in conjunction with other 'non-default' fields       * Ex:         * `_default,family,category,_self`    * **dynamic_mask** - A list of dynamically generated values to return about the resource or each resource within the list     * Comma separated string of variables     * Operates the same as read_mask, but each variable will incur a much greater time cost.     * *May* cause timeouts     * Leaving this field blank or empty will return no dynamic variables.    * **expand_mask** - A list of relational variables to *expand* upon and return more than just the ids     * Comma separated string of variables     * Leaving this field blank will cause all relational data to be returned as a list of ids     * Ex:         * The `children` field for a file may return a list of ids normally, but with `children` set in the           `expand_mask`, it can return a list of child File objects with greater details.  ---  ## POST Conventions  This will create a new resource.  The resource data shall be provided in the request body.  The response will be either a 200 or 201, along with a uri to the newly created resource in the `Location` header.  In the case of a long running job, or reprocess, the response will be a 202 along with a **job_id** and it's corresponding **job_uri** that can be used in the */jobs/* endpoint to see the updated status  ---  ## PATCH Conventions   * The update data shall be provided in the request body.  ### Possible query parameters:   **(Check each endpoint description, or use *explain*, for a list of available values for each parameter)**    * **update_mask** - A list of values to update with this request.     * Comma separated string of variables     * This is required to be set for any and all **PATCH** requests to be processed.     * ONLY the specified variables in the update_mask will be updated regardless of the data in the request body.     * An empty or missing *update_mask* **WILL** result in a 400 Bad Request response  ---  ## DELETE Conventions  A successful response will return 204 No Content  ### Possible query parameters:   * **force** - Forces the deletion to go through     * This is required to be set as a truthy value for any and all **DELETE** requests to be processed.     * Not specifying this on a DELETE request (without *explain* set) **WILL** return a 400 Bad Request response   ---  ## *bulk* endpoints  **Bulk** endpoints are the ones that follow the  '*/<resource\\>/bulk/*' convention. They operate in the same fashion as the single resource endpoints ('*/<resource\\>/<resource_id\\>/*') except they can process multiple resources on a single call.  They **MUST** be a **POST** request along with the accompanying request body parameter to work:    * **ids** - A list of ids to operate on (For **GET**, **PATCH**, and **DELETE** bulk requests)   * **resources** - A list of resources to operate on (For **POST** bulk requests)  ### Possible query parameters:   **(Check each endpoint description, or use *explain*, for a list of available actions)**    * **action** - This is a string and can only be one of four values:      * **GET** - Returns a list of the resources, in the same order as provided in the request body.      * **POST** - Acts the same as a post on the pluralized resource endpoint.         * Instead of an **ids** request body parameter being provided in the request body, a **resources** list of new resources must be provided.      * **PATCH** - Acts the same as a patch on a single resource.          * Follows the same **PATCH** conventions from above*      * **DELETE** - Acts the same as a delete on a single resource.          * Follows the same **DELETE** conventions from above*    * **strict** - Causes the bulk endpoint to fail if a single provided id fails     * Boolean     * If set to True, the bulk call will ONLY operate if it is successful on ALL requested resources.     * If even a single resource is non-existent/forbidden, the call will fail and no side effects will take place.  ---  ## Pagination:  Pagination can be done in combination with sorting and filtering on most endpoints that deal with lists (including **PATCH** and **DELETE** calls)  ### Pagination query paramters:        * **page_size** - The number of results to return (default: 50)   * **page_count** - The page used in pagination (default: 1)   * **skip_count** - A specified number of values to skip before collecting values (default: 0)  ---  ## Sorting:  Sorting can be done in combination with filtering and pagination on most endpoints that deal with lists (including **PATCH** and **DELETE** calls)  ### Sorting query parameter:   **(Check each endpoint description, or use *explain*, for a list of available sorters)**    * **order_by** - A list of variables to sort the query on     * Comma separated string of variables     * Regex Pattern - `^(-?[\\w]+,?)*$`     * Variables are sorted in ascending order by default     * Prepend the variable with a `-` to change it to descending order     * Multiple sorters can be specified, with precedence matching the order of the parameter     * Ex:         * `-object_class,create_time`  ---  ## Filtering:  Filtering can be done in combination with pagination and sorting on most endpoints that deal with lists (including **PATCH** and **DELETE** calls)  ### Filters query parameter:   **(Check each endpoint description, or use *explain*, for a list of available filters)**    * **filters** - A string of filters used to narrow down the query results.     * Semi-colon separated string of variables     * Regex patterns:         * Single filter:             * `^\\ *(NOT\\ +)?[\\w]+__[a-z]+\\(.+\\)\\ *`              * `NOT variable__comparator(value)`          * Multiple Filters:             * `^{SINGLE_FILTER_REGEX}(\\ +(AND|OR|;)\\ +{SINGLE_FILTER_REGEX})*$`              * `NOT variable__comparator(value) AND NOT variable__comparator(value); variable__comparator(value)`      * Logical operator order of precedence:         * **AND**         * **OR**         * **;** **(Semi-colon separation denotes conjunction)**         * Example order of precedence:             * **exp1;exp2 AND exp3 OR exp4** is equivalent to **(exp1) AND ((exp2 AND exp3) OR (exp4))**      * Available Comparators:         * **eq** - Equal         * **ne** - Not Equal         * **lt** - Less than         * **lte** - Less than or equal         * **gt** - Greater than         * **gte** - Greater than or equal         * **in** - In (for list values)         * **nin** - Not In (for list values)         * **regex** - Regular Expression Match         * **iregex** - Case Insensitive Regular Expression Match      * The format for **in** and **nin** which operate on arrays is:         * **[]** - The list of values must be enclosed within brackets.         * **,** - The value separtion token is a comma.         * **<variable\\>__<comp\\>([<value1\\>,<value2\\>])**      * Examples:         * `create_time__gte(2022-01-01T13:11:02);object_class__regex(binary.*)`          * `create_time__gte(2022-01-01) AND create_time__lt(2022-02-01) AND NOT match_count__gt(10)`          * `create_time__gte(2022-01-01) AND create_time__lt(2022-02-01)`  ---  ## Responses  All responses **WILL** be of type `APIResponse` and contain the following fields:  * `success` | Boolean value indicating if the operation succeeded.  * `status` | Status code. Corresponds to the HTTP status code.   * `message` | A human readable message providing more details about the operation.  * `links` | A dictionary of `name`: `uri` links providing navigation and state-based actions on resources  * `errors` | Array of error objects. An error object contains the following properties:      * `reason` | Unique identifier for this error. Ex: \"FileNotFoundError\".      * `message`| Human readable error message.      * `parameter`| The parameter (if any) that caused the issue.  Successful operations **MUST** return a `SuccessResponse`, which extends `APIResponse` by adding:  * `success` | **MUST** equal True  * `resource` | Properties containing the response object.     * (In the case of a single entity being returned)  **OR**  * `resources` | A list of response objects.     * (In the case of a list of entities being returned)  Failed Operations **MUST** return an `ErrorResponse`, which extends `APIResponse` by adding:  * `success` | **MUST** equal False.  Common Failed Operations that you may hit on any of the endpoint operations:  * 400 - Bad Request - The request is malformed  * 401 - Unauthorized - All endpoints require authorization  * 403 - Forbidden - The endpoint (with the given parameters) is not available to you  * 404 - Not Found - The endpoint doesn't exist, or the resource being searched for doesn't exist  ---  ## Example Inputs  Here are some example inputs that can be used for testing the service:  * `binary_id`: **ff9790d7902fea4c910b182f6e0b00221a40d616**  * `proc_rva`: **0x1000**  * `search_query`: **ransomware**  ---   # noqa: E501

    OpenAPI spec version: 2.0.0 (v2)
    Contact: support@cythereal.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

# import models into model package
from cythereal_magic.models.all_of_direct_reputation_reputation import AllOfDirectReputationReputation
from cythereal_magic.models.all_of_file_avscan import AllOfFileAvscan
from cythereal_magic.models.all_of_file_campaign import AllOfFileCampaign
from cythereal_magic.models.all_of_file_categories import AllOfFileCategories
from cythereal_magic.models.all_of_file_families import AllOfFileFamilies
from cythereal_magic.models.all_of_file_genomics import AllOfFileGenomics
from cythereal_magic.models.all_of_file_genomics_procedures import AllOfFileGenomicsProcedures
from cythereal_magic.models.all_of_file_labels import AllOfFileLabels
from cythereal_magic.models.all_of_file_match_match_type import AllOfFileMatchMatchType
from cythereal_magic.models.all_of_file_matches import AllOfFileMatches
from cythereal_magic.models.all_of_file_pipeline import AllOfFilePipeline
from cythereal_magic.models.all_of_file_pipeline_dashboard_campaign import AllOfFilePipelineDashboardCampaign
from cythereal_magic.models.all_of_file_pipeline_dashboard_report import AllOfFilePipelineDashboardReport
from cythereal_magic.models.all_of_file_pipeline_ioc_handler import AllOfFilePipelineIocHandler
from cythereal_magic.models.all_of_file_pipeline_proc_hash_signatures import AllOfFilePipelineProcHashSignatures
from cythereal_magic.models.all_of_file_pipeline_similarity_computation import AllOfFilePipelineSimilarityComputation
from cythereal_magic.models.all_of_file_pipeline_srl_juice import AllOfFilePipelineSrlJuice
from cythereal_magic.models.all_of_file_pipeline_srl_scanners import AllOfFilePipelineSrlScanners
from cythereal_magic.models.all_of_file_pipeline_srl_unpacker import AllOfFilePipelineSrlUnpacker
from cythereal_magic.models.all_of_file_pipeline_variant_hash_signatures import AllOfFilePipelineVariantHashSignatures
from cythereal_magic.models.all_of_file_pipeline_web_request_handler import AllOfFilePipelineWebRequestHandler
from cythereal_magic.models.all_of_file_procedures_example_block_eas import AllOfFileProceduresExampleBlockEas
from cythereal_magic.models.all_of_file_reputation import AllOfFileReputation
from cythereal_magic.models.all_of_file_reputation_inferred_reputation import AllOfFileReputationInferredReputation
from cythereal_magic.models.all_of_file_reputation_reputation import AllOfFileReputationReputation
from cythereal_magic.models.all_of_file_similarities import AllOfFileSimilarities
from cythereal_magic.models.all_of_file_unmapped import AllOfFileUnmapped
from cythereal_magic.models.all_of_file_unpacked_genomics import AllOfFileUnpackedGenomics
from cythereal_magic.models.all_of_inferred_reputation_criteria import AllOfInferredReputationCriteria
from cythereal_magic.models.all_of_inferred_reputation_reputation import AllOfInferredReputationReputation
from cythereal_magic.models.all_of_match_subtype_match_subtype import AllOfMatchSubtypeMatchSubtype
from cythereal_magic.models.allowed_parameters import AllowedParameters
from cythereal_magic.models.av_scan_result import AvScanResult
from cythereal_magic.models.bad_request_response import BadRequestResponse
from cythereal_magic.models.block import Block
from cythereal_magic.models.block_ea import BlockEA
from cythereal_magic.models.block_schema import BlockSchema
from cythereal_magic.models.bulk_request import BulkRequest
from cythereal_magic.models.config_enum import ConfigEnum
from cythereal_magic.models.criteria_enum import CriteriaEnum
from cythereal_magic.models.direct_reputation import DirectReputation
from cythereal_magic.models.enveloped_error400 import EnvelopedError400
from cythereal_magic.models.enveloped_error401 import EnvelopedError401
from cythereal_magic.models.enveloped_error404 import EnvelopedError404
from cythereal_magic.models.enveloped_file200 import EnvelopedFile200
from cythereal_magic.models.enveloped_file200_explain_response import EnvelopedFile200ExplainResponse
from cythereal_magic.models.enveloped_file_genomics_response200 import EnvelopedFileGenomicsResponse200
from cythereal_magic.models.enveloped_file_genomics_response200_explain_response import EnvelopedFileGenomicsResponse200ExplainResponse
from cythereal_magic.models.enveloped_file_label_create_response201 import EnvelopedFileLabelCreateResponse201
from cythereal_magic.models.enveloped_file_labels_schema_list200 import EnvelopedFileLabelsSchemaList200
from cythereal_magic.models.enveloped_file_labels_schema_list200_explain_response import EnvelopedFileLabelsSchemaList200ExplainResponse
from cythereal_magic.models.enveloped_file_list200 import EnvelopedFileList200
from cythereal_magic.models.enveloped_file_list200_explain_response import EnvelopedFileList200ExplainResponse
from cythereal_magic.models.enveloped_file_procedure_response_list200 import EnvelopedFileProcedureResponseList200
from cythereal_magic.models.enveloped_file_procedure_response_list200_explain_response import EnvelopedFileProcedureResponseList200ExplainResponse
from cythereal_magic.models.enveloped_file_reputation_response200 import EnvelopedFileReputationResponse200
from cythereal_magic.models.enveloped_file_reputation_response200_explain_response import EnvelopedFileReputationResponse200ExplainResponse
from cythereal_magic.models.enveloped_file_schema200 import EnvelopedFileSchema200
from cythereal_magic.models.enveloped_file_schema200_explain_response import EnvelopedFileSchema200ExplainResponse
from cythereal_magic.models.enveloped_file_schema201 import EnvelopedFileSchema201
from cythereal_magic.models.enveloped_file_schema_list200 import EnvelopedFileSchemaList200
from cythereal_magic.models.enveloped_file_schema_list200_explain_response import EnvelopedFileSchemaList200ExplainResponse
from cythereal_magic.models.enveloped_file_search_response_list200 import EnvelopedFileSearchResponseList200
from cythereal_magic.models.enveloped_file_search_response_list200_explain_response import EnvelopedFileSearchResponseList200ExplainResponse
from cythereal_magic.models.enveloped_file_similarity_response_list200 import EnvelopedFileSimilarityResponseList200
from cythereal_magic.models.enveloped_file_similarity_response_list200_explain_response import EnvelopedFileSimilarityResponseList200ExplainResponse
from cythereal_magic.models.enveloped_file_strings_schema_list200 import EnvelopedFileStringsSchemaList200
from cythereal_magic.models.enveloped_file_strings_schema_list200_explain_response import EnvelopedFileStringsSchemaList200ExplainResponse
from cythereal_magic.models.enveloped_file_update_response206 import EnvelopedFileUpdateResponse206
from cythereal_magic.models.enveloped_file_upload_response_list200 import EnvelopedFileUploadResponseList200
from cythereal_magic.models.enveloped_file_upload_response_list200_explain_response import EnvelopedFileUploadResponseList200ExplainResponse
from cythereal_magic.models.enveloped_file_upload_response_list201 import EnvelopedFileUploadResponseList201
from cythereal_magic.models.enveloped_id_list200 import EnvelopedIdList200
from cythereal_magic.models.enveloped_id_list200_explain_response import EnvelopedIdList200ExplainResponse
from cythereal_magic.models.enveloped_id_list201 import EnvelopedIdList201
from cythereal_magic.models.enveloped_indicator_response_list200 import EnvelopedIndicatorResponseList200
from cythereal_magic.models.enveloped_indicator_response_list200_explain_response import EnvelopedIndicatorResponseList200ExplainResponse
from cythereal_magic.models.enveloped_job_response201 import EnvelopedJobResponse201
from cythereal_magic.models.enveloped_match_list200 import EnvelopedMatchList200
from cythereal_magic.models.enveloped_match_list200_enveloped_id_list200_explain_response import EnvelopedMatchList200EnvelopedIdList200ExplainResponse
from cythereal_magic.models.enveloped_note200 import EnvelopedNote200
from cythereal_magic.models.enveloped_note200_explain_response import EnvelopedNote200ExplainResponse
from cythereal_magic.models.enveloped_note201 import EnvelopedNote201
from cythereal_magic.models.enveloped_note_list200 import EnvelopedNoteList200
from cythereal_magic.models.enveloped_note_list200_enveloped_id_list200_explain_response import EnvelopedNoteList200EnvelopedIdList200ExplainResponse
from cythereal_magic.models.enveloped_note_list200_explain_response import EnvelopedNoteList200ExplainResponse
from cythereal_magic.models.enveloped_payload_create_response201 import EnvelopedPayloadCreateResponse201
from cythereal_magic.models.enveloped_procedure200 import EnvelopedProcedure200
from cythereal_magic.models.enveloped_procedure200_explain_response import EnvelopedProcedure200ExplainResponse
from cythereal_magic.models.enveloped_procedure_group200 import EnvelopedProcedureGroup200
from cythereal_magic.models.enveloped_procedure_group200_explain_response import EnvelopedProcedureGroup200ExplainResponse
from cythereal_magic.models.enveloped_procedure_schema200 import EnvelopedProcedureSchema200
from cythereal_magic.models.enveloped_procedure_schema200_explain_response import EnvelopedProcedureSchema200ExplainResponse
from cythereal_magic.models.enveloped_tag200 import EnvelopedTag200
from cythereal_magic.models.enveloped_tag200_explain_response import EnvelopedTag200ExplainResponse
from cythereal_magic.models.enveloped_tag201 import EnvelopedTag201
from cythereal_magic.models.enveloped_tag_list200 import EnvelopedTagList200
from cythereal_magic.models.enveloped_tag_list200_enveloped_id_list200_explain_response import EnvelopedTagList200EnvelopedIdList200ExplainResponse
from cythereal_magic.models.enveloped_yara_response200 import EnvelopedYaraResponse200
from cythereal_magic.models.enveloped_yara_response200_explain_response import EnvelopedYaraResponse200ExplainResponse
from cythereal_magic.models.error_object import ErrorObject
from cythereal_magic.models.explain_object import ExplainObject
from cythereal_magic.models.explain_response import ExplainResponse
from cythereal_magic.models.file import File
from cythereal_magic.models.file_add_label_request import FileAddLabelRequest
from cythereal_magic.models.file_avscan import FileAvscan
from cythereal_magic.models.file_campaign import FileCampaign
from cythereal_magic.models.file_genomics import FileGenomics
from cythereal_magic.models.file_genomics_response import FileGenomicsResponse
from cythereal_magic.models.file_indicator import FileIndicator
from cythereal_magic.models.file_label_create_response import FileLabelCreateResponse
from cythereal_magic.models.file_labels_schema import FileLabelsSchema
from cythereal_magic.models.file_match import FileMatch
from cythereal_magic.models.file_pipeline import FilePipeline
from cythereal_magic.models.file_procedure_block import FileProcedureBlock
from cythereal_magic.models.file_procedure_response import FileProcedureResponse
from cythereal_magic.models.file_procedures import FileProcedures
from cythereal_magic.models.file_reputation import FileReputation
from cythereal_magic.models.file_reputation_response import FileReputationResponse
from cythereal_magic.models.file_schema import FileSchema
from cythereal_magic.models.file_search_response import FileSearchResponse
from cythereal_magic.models.file_similarity import FileSimilarity
from cythereal_magic.models.file_similarity_response import FileSimilarityResponse
from cythereal_magic.models.file_strings_schema import FileStringsSchema
from cythereal_magic.models.file_update_response import FileUpdateResponse
from cythereal_magic.models.file_upload_request import FileUploadRequest
from cythereal_magic.models.file_upload_response import FileUploadResponse
from cythereal_magic.models.filter import Filter
from cythereal_magic.models.group import Group
from cythereal_magic.models.group_created import GroupCreated
from cythereal_magic.models.group_request import GroupRequest
from cythereal_magic.models.group_response import GroupResponse
from cythereal_magic.models.groups_response import GroupsResponse
from cythereal_magic.models.indicator_request import IndicatorRequest
from cythereal_magic.models.indicator_response import IndicatorResponse
from cythereal_magic.models.inferred_data import InferredData
from cythereal_magic.models.inferred_reputation import InferredReputation
from cythereal_magic.models.inferred_reputation_enum import InferredReputationEnum
from cythereal_magic.models.ioc_file_uploaded_response import IocFileUploadedResponse
from cythereal_magic.models.job_response import JobResponse
from cythereal_magic.models.label_schema import LabelSchema
from cythereal_magic.models.label_type_enum import LabelTypeEnum
from cythereal_magic.models.mapping import Mapping
from cythereal_magic.models.match import Match
from cythereal_magic.models.match_subtype import MatchSubtype
from cythereal_magic.models.match_subtype_enum import MatchSubtypeEnum
from cythereal_magic.models.match_type_enum import MatchTypeEnum
from cythereal_magic.models.method_enum import MethodEnum
from cythereal_magic.models.note import Note
from cythereal_magic.models.note_request import NoteRequest
from cythereal_magic.models.null_enum import NullEnum
from cythereal_magic.models.one_of_indicator_request_type import OneOfIndicatorRequestType
from cythereal_magic.models.one_of_yara_request_config import OneOfYaraRequestConfig
from cythereal_magic.models.parameter_explanation import ParameterExplanation
from cythereal_magic.models.patched_file_update_request import PatchedFileUpdateRequest
from cythereal_magic.models.patched_group_update_request import PatchedGroupUpdateRequest
from cythereal_magic.models.patched_member_update_request import PatchedMemberUpdateRequest
from cythereal_magic.models.patched_tag_color_request import PatchedTagColorRequest
from cythereal_magic.models.patched_tag_request import PatchedTagRequest
from cythereal_magic.models.patched_user_update_request import PatchedUserUpdateRequest
from cythereal_magic.models.payload_create_response import PayloadCreateResponse
from cythereal_magic.models.pipeline_status_enum import PipelineStatusEnum
from cythereal_magic.models.procedure import Procedure
from cythereal_magic.models.procedure_group import ProcedureGroup
from cythereal_magic.models.procedure_schema import ProcedureSchema
from cythereal_magic.models.rep_data import RepData
from cythereal_magic.models.tag import Tag
from cythereal_magic.models.tag_color_request import TagColorRequest
from cythereal_magic.models.tag_created_response import TagCreatedResponse
from cythereal_magic.models.tag_list_response import TagListResponse
from cythereal_magic.models.tag_object_response import TagObjectResponse
from cythereal_magic.models.tag_request import TagRequest
from cythereal_magic.models.type_enum import TypeEnum
from cythereal_magic.models.unauthenticated_response import UnauthenticatedResponse
from cythereal_magic.models.upload_ioc_file_request import UploadIocFileRequest
from cythereal_magic.models.user import User
from cythereal_magic.models.user_id import UserId
from cythereal_magic.models.user_id_request import UserIdRequest
from cythereal_magic.models.user_response import UserResponse
from cythereal_magic.models.users_response import UsersResponse
from cythereal_magic.models.version_enum import VersionEnum
from cythereal_magic.models.yara_request import YaraRequest
from cythereal_magic.models.yara_response import YaraResponse
