"""
    Keycloak Admin REST API

    This is a REST API reference for the Keycloak Admin  # noqa: E501

    The version of the OpenAPI document: 17.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from keycloak_api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from keycloak_api.exceptions import ApiAttributeError


def lazy_import():
    from keycloak_api.model.authentication_flow_representation import AuthenticationFlowRepresentation
    from keycloak_api.model.authenticator_config_representation import AuthenticatorConfigRepresentation
    from keycloak_api.model.client_representation import ClientRepresentation
    from keycloak_api.model.client_scope_representation import ClientScopeRepresentation
    from keycloak_api.model.group_representation import GroupRepresentation
    from keycloak_api.model.identity_provider_mapper_representation import IdentityProviderMapperRepresentation
    from keycloak_api.model.identity_provider_representation import IdentityProviderRepresentation
    from keycloak_api.model.json_node import JsonNode
    from keycloak_api.model.multivalued_hash_map import MultivaluedHashMap
    from keycloak_api.model.protocol_mapper_representation import ProtocolMapperRepresentation
    from keycloak_api.model.required_action_provider_representation import RequiredActionProviderRepresentation
    from keycloak_api.model.role_representation import RoleRepresentation
    from keycloak_api.model.roles_representation import RolesRepresentation
    from keycloak_api.model.scope_mapping_representation import ScopeMappingRepresentation
    from keycloak_api.model.user_federation_mapper_representation import UserFederationMapperRepresentation
    from keycloak_api.model.user_federation_provider_representation import UserFederationProviderRepresentation
    from keycloak_api.model.user_representation import UserRepresentation
    globals()['AuthenticationFlowRepresentation'] = AuthenticationFlowRepresentation
    globals()['AuthenticatorConfigRepresentation'] = AuthenticatorConfigRepresentation
    globals()['ClientRepresentation'] = ClientRepresentation
    globals()['ClientScopeRepresentation'] = ClientScopeRepresentation
    globals()['GroupRepresentation'] = GroupRepresentation
    globals()['IdentityProviderMapperRepresentation'] = IdentityProviderMapperRepresentation
    globals()['IdentityProviderRepresentation'] = IdentityProviderRepresentation
    globals()['JsonNode'] = JsonNode
    globals()['MultivaluedHashMap'] = MultivaluedHashMap
    globals()['ProtocolMapperRepresentation'] = ProtocolMapperRepresentation
    globals()['RequiredActionProviderRepresentation'] = RequiredActionProviderRepresentation
    globals()['RoleRepresentation'] = RoleRepresentation
    globals()['RolesRepresentation'] = RolesRepresentation
    globals()['ScopeMappingRepresentation'] = ScopeMappingRepresentation
    globals()['UserFederationMapperRepresentation'] = UserFederationMapperRepresentation
    globals()['UserFederationProviderRepresentation'] = UserFederationProviderRepresentation
    globals()['UserRepresentation'] = UserRepresentation


class RealmRepresentation(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'access_code_lifespan': (int,),  # noqa: E501
            'access_code_lifespan_login': (int,),  # noqa: E501
            'access_code_lifespan_user_action': (int,),  # noqa: E501
            'access_token_lifespan': (int,),  # noqa: E501
            'access_token_lifespan_for_implicit_flow': (int,),  # noqa: E501
            'account_theme': (str,),  # noqa: E501
            'action_token_generated_by_admin_lifespan': (int,),  # noqa: E501
            'action_token_generated_by_user_lifespan': (int,),  # noqa: E501
            'admin_events_details_enabled': (bool,),  # noqa: E501
            'admin_events_enabled': (bool,),  # noqa: E501
            'admin_theme': (str,),  # noqa: E501
            'attributes': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'authentication_flows': ([AuthenticationFlowRepresentation],),  # noqa: E501
            'authenticator_config': ([AuthenticatorConfigRepresentation],),  # noqa: E501
            'browser_flow': (str,),  # noqa: E501
            'browser_security_headers': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'brute_force_protected': (bool,),  # noqa: E501
            'client_authentication_flow': (str,),  # noqa: E501
            'client_offline_session_idle_timeout': (int,),  # noqa: E501
            'client_offline_session_max_lifespan': (int,),  # noqa: E501
            'client_policies': (JsonNode,),  # noqa: E501
            'client_profiles': (JsonNode,),  # noqa: E501
            'client_scope_mappings': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'client_scopes': ([ClientScopeRepresentation],),  # noqa: E501
            'client_session_idle_timeout': (int,),  # noqa: E501
            'client_session_max_lifespan': (int,),  # noqa: E501
            'clients': ([ClientRepresentation],),  # noqa: E501
            'components': (MultivaluedHashMap,),  # noqa: E501
            'default_default_client_scopes': ([str],),  # noqa: E501
            'default_groups': ([str],),  # noqa: E501
            'default_locale': (str,),  # noqa: E501
            'default_optional_client_scopes': ([str],),  # noqa: E501
            'default_role': (RoleRepresentation,),  # noqa: E501
            'default_signature_algorithm': (str,),  # noqa: E501
            'direct_grant_flow': (str,),  # noqa: E501
            'display_name': (str,),  # noqa: E501
            'display_name_html': (str,),  # noqa: E501
            'docker_authentication_flow': (str,),  # noqa: E501
            'duplicate_emails_allowed': (bool,),  # noqa: E501
            'edit_username_allowed': (bool,),  # noqa: E501
            'email_theme': (str,),  # noqa: E501
            'enabled': (bool,),  # noqa: E501
            'enabled_event_types': ([str],),  # noqa: E501
            'events_enabled': (bool,),  # noqa: E501
            'events_expiration': (int,),  # noqa: E501
            'events_listeners': ([str],),  # noqa: E501
            'failure_factor': (int,),  # noqa: E501
            'federated_users': ([UserRepresentation],),  # noqa: E501
            'groups': ([GroupRepresentation],),  # noqa: E501
            'id': (str,),  # noqa: E501
            'identity_provider_mappers': ([IdentityProviderMapperRepresentation],),  # noqa: E501
            'identity_providers': ([IdentityProviderRepresentation],),  # noqa: E501
            'internationalization_enabled': (bool,),  # noqa: E501
            'keycloak_version': (str,),  # noqa: E501
            'login_theme': (str,),  # noqa: E501
            'login_with_email_allowed': (bool,),  # noqa: E501
            'max_delta_time_seconds': (int,),  # noqa: E501
            'max_failure_wait_seconds': (int,),  # noqa: E501
            'minimum_quick_login_wait_seconds': (int,),  # noqa: E501
            'not_before': (int,),  # noqa: E501
            'o_auth2_device_code_lifespan': (int,),  # noqa: E501
            'o_auth2_device_polling_interval': (int,),  # noqa: E501
            'oauth2_device_code_lifespan': (int,),  # noqa: E501
            'oauth2_device_polling_interval': (int,),  # noqa: E501
            'offline_session_idle_timeout': (int,),  # noqa: E501
            'offline_session_max_lifespan': (int,),  # noqa: E501
            'offline_session_max_lifespan_enabled': (bool,),  # noqa: E501
            'otp_policy_algorithm': (str,),  # noqa: E501
            'otp_policy_digits': (int,),  # noqa: E501
            'otp_policy_initial_counter': (int,),  # noqa: E501
            'otp_policy_look_ahead_window': (int,),  # noqa: E501
            'otp_policy_period': (int,),  # noqa: E501
            'otp_policy_type': (str,),  # noqa: E501
            'otp_supported_applications': ([str],),  # noqa: E501
            'password_policy': (str,),  # noqa: E501
            'permanent_lockout': (bool,),  # noqa: E501
            'protocol_mappers': ([ProtocolMapperRepresentation],),  # noqa: E501
            'quick_login_check_milli_seconds': (int,),  # noqa: E501
            'realm': (str,),  # noqa: E501
            'refresh_token_max_reuse': (int,),  # noqa: E501
            'registration_allowed': (bool,),  # noqa: E501
            'registration_email_as_username': (bool,),  # noqa: E501
            'registration_flow': (str,),  # noqa: E501
            'remember_me': (bool,),  # noqa: E501
            'required_actions': ([RequiredActionProviderRepresentation],),  # noqa: E501
            'reset_credentials_flow': (str,),  # noqa: E501
            'reset_password_allowed': (bool,),  # noqa: E501
            'revoke_refresh_token': (bool,),  # noqa: E501
            'roles': (RolesRepresentation,),  # noqa: E501
            'scope_mappings': ([ScopeMappingRepresentation],),  # noqa: E501
            'smtp_server': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'ssl_required': (str,),  # noqa: E501
            'sso_session_idle_timeout': (int,),  # noqa: E501
            'sso_session_idle_timeout_remember_me': (int,),  # noqa: E501
            'sso_session_max_lifespan': (int,),  # noqa: E501
            'sso_session_max_lifespan_remember_me': (int,),  # noqa: E501
            'supported_locales': ([str],),  # noqa: E501
            'user_federation_mappers': ([UserFederationMapperRepresentation],),  # noqa: E501
            'user_federation_providers': ([UserFederationProviderRepresentation],),  # noqa: E501
            'user_managed_access_allowed': (bool,),  # noqa: E501
            'users': ([UserRepresentation],),  # noqa: E501
            'verify_email': (bool,),  # noqa: E501
            'wait_increment_seconds': (int,),  # noqa: E501
            'web_authn_policy_acceptable_aaguids': ([str],),  # noqa: E501
            'web_authn_policy_attestation_conveyance_preference': (str,),  # noqa: E501
            'web_authn_policy_authenticator_attachment': (str,),  # noqa: E501
            'web_authn_policy_avoid_same_authenticator_register': (bool,),  # noqa: E501
            'web_authn_policy_create_timeout': (int,),  # noqa: E501
            'web_authn_policy_passwordless_acceptable_aaguids': ([str],),  # noqa: E501
            'web_authn_policy_passwordless_attestation_conveyance_preference': (str,),  # noqa: E501
            'web_authn_policy_passwordless_authenticator_attachment': (str,),  # noqa: E501
            'web_authn_policy_passwordless_avoid_same_authenticator_register': (bool,),  # noqa: E501
            'web_authn_policy_passwordless_create_timeout': (int,),  # noqa: E501
            'web_authn_policy_passwordless_require_resident_key': (str,),  # noqa: E501
            'web_authn_policy_passwordless_rp_entity_name': (str,),  # noqa: E501
            'web_authn_policy_passwordless_rp_id': (str,),  # noqa: E501
            'web_authn_policy_passwordless_signature_algorithms': ([str],),  # noqa: E501
            'web_authn_policy_passwordless_user_verification_requirement': (str,),  # noqa: E501
            'web_authn_policy_require_resident_key': (str,),  # noqa: E501
            'web_authn_policy_rp_entity_name': (str,),  # noqa: E501
            'web_authn_policy_rp_id': (str,),  # noqa: E501
            'web_authn_policy_signature_algorithms': ([str],),  # noqa: E501
            'web_authn_policy_user_verification_requirement': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'access_code_lifespan': 'accessCodeLifespan',  # noqa: E501
        'access_code_lifespan_login': 'accessCodeLifespanLogin',  # noqa: E501
        'access_code_lifespan_user_action': 'accessCodeLifespanUserAction',  # noqa: E501
        'access_token_lifespan': 'accessTokenLifespan',  # noqa: E501
        'access_token_lifespan_for_implicit_flow': 'accessTokenLifespanForImplicitFlow',  # noqa: E501
        'account_theme': 'accountTheme',  # noqa: E501
        'action_token_generated_by_admin_lifespan': 'actionTokenGeneratedByAdminLifespan',  # noqa: E501
        'action_token_generated_by_user_lifespan': 'actionTokenGeneratedByUserLifespan',  # noqa: E501
        'admin_events_details_enabled': 'adminEventsDetailsEnabled',  # noqa: E501
        'admin_events_enabled': 'adminEventsEnabled',  # noqa: E501
        'admin_theme': 'adminTheme',  # noqa: E501
        'attributes': 'attributes',  # noqa: E501
        'authentication_flows': 'authenticationFlows',  # noqa: E501
        'authenticator_config': 'authenticatorConfig',  # noqa: E501
        'browser_flow': 'browserFlow',  # noqa: E501
        'browser_security_headers': 'browserSecurityHeaders',  # noqa: E501
        'brute_force_protected': 'bruteForceProtected',  # noqa: E501
        'client_authentication_flow': 'clientAuthenticationFlow',  # noqa: E501
        'client_offline_session_idle_timeout': 'clientOfflineSessionIdleTimeout',  # noqa: E501
        'client_offline_session_max_lifespan': 'clientOfflineSessionMaxLifespan',  # noqa: E501
        'client_policies': 'clientPolicies',  # noqa: E501
        'client_profiles': 'clientProfiles',  # noqa: E501
        'client_scope_mappings': 'clientScopeMappings',  # noqa: E501
        'client_scopes': 'clientScopes',  # noqa: E501
        'client_session_idle_timeout': 'clientSessionIdleTimeout',  # noqa: E501
        'client_session_max_lifespan': 'clientSessionMaxLifespan',  # noqa: E501
        'clients': 'clients',  # noqa: E501
        'components': 'components',  # noqa: E501
        'default_default_client_scopes': 'defaultDefaultClientScopes',  # noqa: E501
        'default_groups': 'defaultGroups',  # noqa: E501
        'default_locale': 'defaultLocale',  # noqa: E501
        'default_optional_client_scopes': 'defaultOptionalClientScopes',  # noqa: E501
        'default_role': 'defaultRole',  # noqa: E501
        'default_signature_algorithm': 'defaultSignatureAlgorithm',  # noqa: E501
        'direct_grant_flow': 'directGrantFlow',  # noqa: E501
        'display_name': 'displayName',  # noqa: E501
        'display_name_html': 'displayNameHtml',  # noqa: E501
        'docker_authentication_flow': 'dockerAuthenticationFlow',  # noqa: E501
        'duplicate_emails_allowed': 'duplicateEmailsAllowed',  # noqa: E501
        'edit_username_allowed': 'editUsernameAllowed',  # noqa: E501
        'email_theme': 'emailTheme',  # noqa: E501
        'enabled': 'enabled',  # noqa: E501
        'enabled_event_types': 'enabledEventTypes',  # noqa: E501
        'events_enabled': 'eventsEnabled',  # noqa: E501
        'events_expiration': 'eventsExpiration',  # noqa: E501
        'events_listeners': 'eventsListeners',  # noqa: E501
        'failure_factor': 'failureFactor',  # noqa: E501
        'federated_users': 'federatedUsers',  # noqa: E501
        'groups': 'groups',  # noqa: E501
        'id': 'id',  # noqa: E501
        'identity_provider_mappers': 'identityProviderMappers',  # noqa: E501
        'identity_providers': 'identityProviders',  # noqa: E501
        'internationalization_enabled': 'internationalizationEnabled',  # noqa: E501
        'keycloak_version': 'keycloakVersion',  # noqa: E501
        'login_theme': 'loginTheme',  # noqa: E501
        'login_with_email_allowed': 'loginWithEmailAllowed',  # noqa: E501
        'max_delta_time_seconds': 'maxDeltaTimeSeconds',  # noqa: E501
        'max_failure_wait_seconds': 'maxFailureWaitSeconds',  # noqa: E501
        'minimum_quick_login_wait_seconds': 'minimumQuickLoginWaitSeconds',  # noqa: E501
        'not_before': 'notBefore',  # noqa: E501
        'o_auth2_device_code_lifespan': 'oAuth2DeviceCodeLifespan',  # noqa: E501
        'o_auth2_device_polling_interval': 'oAuth2DevicePollingInterval',  # noqa: E501
        'oauth2_device_code_lifespan': 'oauth2DeviceCodeLifespan',  # noqa: E501
        'oauth2_device_polling_interval': 'oauth2DevicePollingInterval',  # noqa: E501
        'offline_session_idle_timeout': 'offlineSessionIdleTimeout',  # noqa: E501
        'offline_session_max_lifespan': 'offlineSessionMaxLifespan',  # noqa: E501
        'offline_session_max_lifespan_enabled': 'offlineSessionMaxLifespanEnabled',  # noqa: E501
        'otp_policy_algorithm': 'otpPolicyAlgorithm',  # noqa: E501
        'otp_policy_digits': 'otpPolicyDigits',  # noqa: E501
        'otp_policy_initial_counter': 'otpPolicyInitialCounter',  # noqa: E501
        'otp_policy_look_ahead_window': 'otpPolicyLookAheadWindow',  # noqa: E501
        'otp_policy_period': 'otpPolicyPeriod',  # noqa: E501
        'otp_policy_type': 'otpPolicyType',  # noqa: E501
        'otp_supported_applications': 'otpSupportedApplications',  # noqa: E501
        'password_policy': 'passwordPolicy',  # noqa: E501
        'permanent_lockout': 'permanentLockout',  # noqa: E501
        'protocol_mappers': 'protocolMappers',  # noqa: E501
        'quick_login_check_milli_seconds': 'quickLoginCheckMilliSeconds',  # noqa: E501
        'realm': 'realm',  # noqa: E501
        'refresh_token_max_reuse': 'refreshTokenMaxReuse',  # noqa: E501
        'registration_allowed': 'registrationAllowed',  # noqa: E501
        'registration_email_as_username': 'registrationEmailAsUsername',  # noqa: E501
        'registration_flow': 'registrationFlow',  # noqa: E501
        'remember_me': 'rememberMe',  # noqa: E501
        'required_actions': 'requiredActions',  # noqa: E501
        'reset_credentials_flow': 'resetCredentialsFlow',  # noqa: E501
        'reset_password_allowed': 'resetPasswordAllowed',  # noqa: E501
        'revoke_refresh_token': 'revokeRefreshToken',  # noqa: E501
        'roles': 'roles',  # noqa: E501
        'scope_mappings': 'scopeMappings',  # noqa: E501
        'smtp_server': 'smtpServer',  # noqa: E501
        'ssl_required': 'sslRequired',  # noqa: E501
        'sso_session_idle_timeout': 'ssoSessionIdleTimeout',  # noqa: E501
        'sso_session_idle_timeout_remember_me': 'ssoSessionIdleTimeoutRememberMe',  # noqa: E501
        'sso_session_max_lifespan': 'ssoSessionMaxLifespan',  # noqa: E501
        'sso_session_max_lifespan_remember_me': 'ssoSessionMaxLifespanRememberMe',  # noqa: E501
        'supported_locales': 'supportedLocales',  # noqa: E501
        'user_federation_mappers': 'userFederationMappers',  # noqa: E501
        'user_federation_providers': 'userFederationProviders',  # noqa: E501
        'user_managed_access_allowed': 'userManagedAccessAllowed',  # noqa: E501
        'users': 'users',  # noqa: E501
        'verify_email': 'verifyEmail',  # noqa: E501
        'wait_increment_seconds': 'waitIncrementSeconds',  # noqa: E501
        'web_authn_policy_acceptable_aaguids': 'webAuthnPolicyAcceptableAaguids',  # noqa: E501
        'web_authn_policy_attestation_conveyance_preference': 'webAuthnPolicyAttestationConveyancePreference',  # noqa: E501
        'web_authn_policy_authenticator_attachment': 'webAuthnPolicyAuthenticatorAttachment',  # noqa: E501
        'web_authn_policy_avoid_same_authenticator_register': 'webAuthnPolicyAvoidSameAuthenticatorRegister',  # noqa: E501
        'web_authn_policy_create_timeout': 'webAuthnPolicyCreateTimeout',  # noqa: E501
        'web_authn_policy_passwordless_acceptable_aaguids': 'webAuthnPolicyPasswordlessAcceptableAaguids',  # noqa: E501
        'web_authn_policy_passwordless_attestation_conveyance_preference': 'webAuthnPolicyPasswordlessAttestationConveyancePreference',  # noqa: E501
        'web_authn_policy_passwordless_authenticator_attachment': 'webAuthnPolicyPasswordlessAuthenticatorAttachment',  # noqa: E501
        'web_authn_policy_passwordless_avoid_same_authenticator_register': 'webAuthnPolicyPasswordlessAvoidSameAuthenticatorRegister',  # noqa: E501
        'web_authn_policy_passwordless_create_timeout': 'webAuthnPolicyPasswordlessCreateTimeout',  # noqa: E501
        'web_authn_policy_passwordless_require_resident_key': 'webAuthnPolicyPasswordlessRequireResidentKey',  # noqa: E501
        'web_authn_policy_passwordless_rp_entity_name': 'webAuthnPolicyPasswordlessRpEntityName',  # noqa: E501
        'web_authn_policy_passwordless_rp_id': 'webAuthnPolicyPasswordlessRpId',  # noqa: E501
        'web_authn_policy_passwordless_signature_algorithms': 'webAuthnPolicyPasswordlessSignatureAlgorithms',  # noqa: E501
        'web_authn_policy_passwordless_user_verification_requirement': 'webAuthnPolicyPasswordlessUserVerificationRequirement',  # noqa: E501
        'web_authn_policy_require_resident_key': 'webAuthnPolicyRequireResidentKey',  # noqa: E501
        'web_authn_policy_rp_entity_name': 'webAuthnPolicyRpEntityName',  # noqa: E501
        'web_authn_policy_rp_id': 'webAuthnPolicyRpId',  # noqa: E501
        'web_authn_policy_signature_algorithms': 'webAuthnPolicySignatureAlgorithms',  # noqa: E501
        'web_authn_policy_user_verification_requirement': 'webAuthnPolicyUserVerificationRequirement',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """RealmRepresentation - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            access_code_lifespan (int): [optional]  # noqa: E501
            access_code_lifespan_login (int): [optional]  # noqa: E501
            access_code_lifespan_user_action (int): [optional]  # noqa: E501
            access_token_lifespan (int): [optional]  # noqa: E501
            access_token_lifespan_for_implicit_flow (int): [optional]  # noqa: E501
            account_theme (str): [optional]  # noqa: E501
            action_token_generated_by_admin_lifespan (int): [optional]  # noqa: E501
            action_token_generated_by_user_lifespan (int): [optional]  # noqa: E501
            admin_events_details_enabled (bool): [optional]  # noqa: E501
            admin_events_enabled (bool): [optional]  # noqa: E501
            admin_theme (str): [optional]  # noqa: E501
            attributes ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]  # noqa: E501
            authentication_flows ([AuthenticationFlowRepresentation]): [optional]  # noqa: E501
            authenticator_config ([AuthenticatorConfigRepresentation]): [optional]  # noqa: E501
            browser_flow (str): [optional]  # noqa: E501
            browser_security_headers ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]  # noqa: E501
            brute_force_protected (bool): [optional]  # noqa: E501
            client_authentication_flow (str): [optional]  # noqa: E501
            client_offline_session_idle_timeout (int): [optional]  # noqa: E501
            client_offline_session_max_lifespan (int): [optional]  # noqa: E501
            client_policies (JsonNode): [optional]  # noqa: E501
            client_profiles (JsonNode): [optional]  # noqa: E501
            client_scope_mappings ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]  # noqa: E501
            client_scopes ([ClientScopeRepresentation]): [optional]  # noqa: E501
            client_session_idle_timeout (int): [optional]  # noqa: E501
            client_session_max_lifespan (int): [optional]  # noqa: E501
            clients ([ClientRepresentation]): [optional]  # noqa: E501
            components (MultivaluedHashMap): [optional]  # noqa: E501
            default_default_client_scopes ([str]): [optional]  # noqa: E501
            default_groups ([str]): [optional]  # noqa: E501
            default_locale (str): [optional]  # noqa: E501
            default_optional_client_scopes ([str]): [optional]  # noqa: E501
            default_role (RoleRepresentation): [optional]  # noqa: E501
            default_signature_algorithm (str): [optional]  # noqa: E501
            direct_grant_flow (str): [optional]  # noqa: E501
            display_name (str): [optional]  # noqa: E501
            display_name_html (str): [optional]  # noqa: E501
            docker_authentication_flow (str): [optional]  # noqa: E501
            duplicate_emails_allowed (bool): [optional]  # noqa: E501
            edit_username_allowed (bool): [optional]  # noqa: E501
            email_theme (str): [optional]  # noqa: E501
            enabled (bool): [optional]  # noqa: E501
            enabled_event_types ([str]): [optional]  # noqa: E501
            events_enabled (bool): [optional]  # noqa: E501
            events_expiration (int): [optional]  # noqa: E501
            events_listeners ([str]): [optional]  # noqa: E501
            failure_factor (int): [optional]  # noqa: E501
            federated_users ([UserRepresentation]): [optional]  # noqa: E501
            groups ([GroupRepresentation]): [optional]  # noqa: E501
            id (str): [optional]  # noqa: E501
            identity_provider_mappers ([IdentityProviderMapperRepresentation]): [optional]  # noqa: E501
            identity_providers ([IdentityProviderRepresentation]): [optional]  # noqa: E501
            internationalization_enabled (bool): [optional]  # noqa: E501
            keycloak_version (str): [optional]  # noqa: E501
            login_theme (str): [optional]  # noqa: E501
            login_with_email_allowed (bool): [optional]  # noqa: E501
            max_delta_time_seconds (int): [optional]  # noqa: E501
            max_failure_wait_seconds (int): [optional]  # noqa: E501
            minimum_quick_login_wait_seconds (int): [optional]  # noqa: E501
            not_before (int): [optional]  # noqa: E501
            o_auth2_device_code_lifespan (int): [optional]  # noqa: E501
            o_auth2_device_polling_interval (int): [optional]  # noqa: E501
            oauth2_device_code_lifespan (int): [optional]  # noqa: E501
            oauth2_device_polling_interval (int): [optional]  # noqa: E501
            offline_session_idle_timeout (int): [optional]  # noqa: E501
            offline_session_max_lifespan (int): [optional]  # noqa: E501
            offline_session_max_lifespan_enabled (bool): [optional]  # noqa: E501
            otp_policy_algorithm (str): [optional]  # noqa: E501
            otp_policy_digits (int): [optional]  # noqa: E501
            otp_policy_initial_counter (int): [optional]  # noqa: E501
            otp_policy_look_ahead_window (int): [optional]  # noqa: E501
            otp_policy_period (int): [optional]  # noqa: E501
            otp_policy_type (str): [optional]  # noqa: E501
            otp_supported_applications ([str]): [optional]  # noqa: E501
            password_policy (str): [optional]  # noqa: E501
            permanent_lockout (bool): [optional]  # noqa: E501
            protocol_mappers ([ProtocolMapperRepresentation]): [optional]  # noqa: E501
            quick_login_check_milli_seconds (int): [optional]  # noqa: E501
            realm (str): [optional]  # noqa: E501
            refresh_token_max_reuse (int): [optional]  # noqa: E501
            registration_allowed (bool): [optional]  # noqa: E501
            registration_email_as_username (bool): [optional]  # noqa: E501
            registration_flow (str): [optional]  # noqa: E501
            remember_me (bool): [optional]  # noqa: E501
            required_actions ([RequiredActionProviderRepresentation]): [optional]  # noqa: E501
            reset_credentials_flow (str): [optional]  # noqa: E501
            reset_password_allowed (bool): [optional]  # noqa: E501
            revoke_refresh_token (bool): [optional]  # noqa: E501
            roles (RolesRepresentation): [optional]  # noqa: E501
            scope_mappings ([ScopeMappingRepresentation]): [optional]  # noqa: E501
            smtp_server ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]  # noqa: E501
            ssl_required (str): [optional]  # noqa: E501
            sso_session_idle_timeout (int): [optional]  # noqa: E501
            sso_session_idle_timeout_remember_me (int): [optional]  # noqa: E501
            sso_session_max_lifespan (int): [optional]  # noqa: E501
            sso_session_max_lifespan_remember_me (int): [optional]  # noqa: E501
            supported_locales ([str]): [optional]  # noqa: E501
            user_federation_mappers ([UserFederationMapperRepresentation]): [optional]  # noqa: E501
            user_federation_providers ([UserFederationProviderRepresentation]): [optional]  # noqa: E501
            user_managed_access_allowed (bool): [optional]  # noqa: E501
            users ([UserRepresentation]): [optional]  # noqa: E501
            verify_email (bool): [optional]  # noqa: E501
            wait_increment_seconds (int): [optional]  # noqa: E501
            web_authn_policy_acceptable_aaguids ([str]): [optional]  # noqa: E501
            web_authn_policy_attestation_conveyance_preference (str): [optional]  # noqa: E501
            web_authn_policy_authenticator_attachment (str): [optional]  # noqa: E501
            web_authn_policy_avoid_same_authenticator_register (bool): [optional]  # noqa: E501
            web_authn_policy_create_timeout (int): [optional]  # noqa: E501
            web_authn_policy_passwordless_acceptable_aaguids ([str]): [optional]  # noqa: E501
            web_authn_policy_passwordless_attestation_conveyance_preference (str): [optional]  # noqa: E501
            web_authn_policy_passwordless_authenticator_attachment (str): [optional]  # noqa: E501
            web_authn_policy_passwordless_avoid_same_authenticator_register (bool): [optional]  # noqa: E501
            web_authn_policy_passwordless_create_timeout (int): [optional]  # noqa: E501
            web_authn_policy_passwordless_require_resident_key (str): [optional]  # noqa: E501
            web_authn_policy_passwordless_rp_entity_name (str): [optional]  # noqa: E501
            web_authn_policy_passwordless_rp_id (str): [optional]  # noqa: E501
            web_authn_policy_passwordless_signature_algorithms ([str]): [optional]  # noqa: E501
            web_authn_policy_passwordless_user_verification_requirement (str): [optional]  # noqa: E501
            web_authn_policy_require_resident_key (str): [optional]  # noqa: E501
            web_authn_policy_rp_entity_name (str): [optional]  # noqa: E501
            web_authn_policy_rp_id (str): [optional]  # noqa: E501
            web_authn_policy_signature_algorithms ([str]): [optional]  # noqa: E501
            web_authn_policy_user_verification_requirement (str): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """RealmRepresentation - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            access_code_lifespan (int): [optional]  # noqa: E501
            access_code_lifespan_login (int): [optional]  # noqa: E501
            access_code_lifespan_user_action (int): [optional]  # noqa: E501
            access_token_lifespan (int): [optional]  # noqa: E501
            access_token_lifespan_for_implicit_flow (int): [optional]  # noqa: E501
            account_theme (str): [optional]  # noqa: E501
            action_token_generated_by_admin_lifespan (int): [optional]  # noqa: E501
            action_token_generated_by_user_lifespan (int): [optional]  # noqa: E501
            admin_events_details_enabled (bool): [optional]  # noqa: E501
            admin_events_enabled (bool): [optional]  # noqa: E501
            admin_theme (str): [optional]  # noqa: E501
            attributes ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]  # noqa: E501
            authentication_flows ([AuthenticationFlowRepresentation]): [optional]  # noqa: E501
            authenticator_config ([AuthenticatorConfigRepresentation]): [optional]  # noqa: E501
            browser_flow (str): [optional]  # noqa: E501
            browser_security_headers ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]  # noqa: E501
            brute_force_protected (bool): [optional]  # noqa: E501
            client_authentication_flow (str): [optional]  # noqa: E501
            client_offline_session_idle_timeout (int): [optional]  # noqa: E501
            client_offline_session_max_lifespan (int): [optional]  # noqa: E501
            client_policies (JsonNode): [optional]  # noqa: E501
            client_profiles (JsonNode): [optional]  # noqa: E501
            client_scope_mappings ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]  # noqa: E501
            client_scopes ([ClientScopeRepresentation]): [optional]  # noqa: E501
            client_session_idle_timeout (int): [optional]  # noqa: E501
            client_session_max_lifespan (int): [optional]  # noqa: E501
            clients ([ClientRepresentation]): [optional]  # noqa: E501
            components (MultivaluedHashMap): [optional]  # noqa: E501
            default_default_client_scopes ([str]): [optional]  # noqa: E501
            default_groups ([str]): [optional]  # noqa: E501
            default_locale (str): [optional]  # noqa: E501
            default_optional_client_scopes ([str]): [optional]  # noqa: E501
            default_role (RoleRepresentation): [optional]  # noqa: E501
            default_signature_algorithm (str): [optional]  # noqa: E501
            direct_grant_flow (str): [optional]  # noqa: E501
            display_name (str): [optional]  # noqa: E501
            display_name_html (str): [optional]  # noqa: E501
            docker_authentication_flow (str): [optional]  # noqa: E501
            duplicate_emails_allowed (bool): [optional]  # noqa: E501
            edit_username_allowed (bool): [optional]  # noqa: E501
            email_theme (str): [optional]  # noqa: E501
            enabled (bool): [optional]  # noqa: E501
            enabled_event_types ([str]): [optional]  # noqa: E501
            events_enabled (bool): [optional]  # noqa: E501
            events_expiration (int): [optional]  # noqa: E501
            events_listeners ([str]): [optional]  # noqa: E501
            failure_factor (int): [optional]  # noqa: E501
            federated_users ([UserRepresentation]): [optional]  # noqa: E501
            groups ([GroupRepresentation]): [optional]  # noqa: E501
            id (str): [optional]  # noqa: E501
            identity_provider_mappers ([IdentityProviderMapperRepresentation]): [optional]  # noqa: E501
            identity_providers ([IdentityProviderRepresentation]): [optional]  # noqa: E501
            internationalization_enabled (bool): [optional]  # noqa: E501
            keycloak_version (str): [optional]  # noqa: E501
            login_theme (str): [optional]  # noqa: E501
            login_with_email_allowed (bool): [optional]  # noqa: E501
            max_delta_time_seconds (int): [optional]  # noqa: E501
            max_failure_wait_seconds (int): [optional]  # noqa: E501
            minimum_quick_login_wait_seconds (int): [optional]  # noqa: E501
            not_before (int): [optional]  # noqa: E501
            o_auth2_device_code_lifespan (int): [optional]  # noqa: E501
            o_auth2_device_polling_interval (int): [optional]  # noqa: E501
            oauth2_device_code_lifespan (int): [optional]  # noqa: E501
            oauth2_device_polling_interval (int): [optional]  # noqa: E501
            offline_session_idle_timeout (int): [optional]  # noqa: E501
            offline_session_max_lifespan (int): [optional]  # noqa: E501
            offline_session_max_lifespan_enabled (bool): [optional]  # noqa: E501
            otp_policy_algorithm (str): [optional]  # noqa: E501
            otp_policy_digits (int): [optional]  # noqa: E501
            otp_policy_initial_counter (int): [optional]  # noqa: E501
            otp_policy_look_ahead_window (int): [optional]  # noqa: E501
            otp_policy_period (int): [optional]  # noqa: E501
            otp_policy_type (str): [optional]  # noqa: E501
            otp_supported_applications ([str]): [optional]  # noqa: E501
            password_policy (str): [optional]  # noqa: E501
            permanent_lockout (bool): [optional]  # noqa: E501
            protocol_mappers ([ProtocolMapperRepresentation]): [optional]  # noqa: E501
            quick_login_check_milli_seconds (int): [optional]  # noqa: E501
            realm (str): [optional]  # noqa: E501
            refresh_token_max_reuse (int): [optional]  # noqa: E501
            registration_allowed (bool): [optional]  # noqa: E501
            registration_email_as_username (bool): [optional]  # noqa: E501
            registration_flow (str): [optional]  # noqa: E501
            remember_me (bool): [optional]  # noqa: E501
            required_actions ([RequiredActionProviderRepresentation]): [optional]  # noqa: E501
            reset_credentials_flow (str): [optional]  # noqa: E501
            reset_password_allowed (bool): [optional]  # noqa: E501
            revoke_refresh_token (bool): [optional]  # noqa: E501
            roles (RolesRepresentation): [optional]  # noqa: E501
            scope_mappings ([ScopeMappingRepresentation]): [optional]  # noqa: E501
            smtp_server ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]  # noqa: E501
            ssl_required (str): [optional]  # noqa: E501
            sso_session_idle_timeout (int): [optional]  # noqa: E501
            sso_session_idle_timeout_remember_me (int): [optional]  # noqa: E501
            sso_session_max_lifespan (int): [optional]  # noqa: E501
            sso_session_max_lifespan_remember_me (int): [optional]  # noqa: E501
            supported_locales ([str]): [optional]  # noqa: E501
            user_federation_mappers ([UserFederationMapperRepresentation]): [optional]  # noqa: E501
            user_federation_providers ([UserFederationProviderRepresentation]): [optional]  # noqa: E501
            user_managed_access_allowed (bool): [optional]  # noqa: E501
            users ([UserRepresentation]): [optional]  # noqa: E501
            verify_email (bool): [optional]  # noqa: E501
            wait_increment_seconds (int): [optional]  # noqa: E501
            web_authn_policy_acceptable_aaguids ([str]): [optional]  # noqa: E501
            web_authn_policy_attestation_conveyance_preference (str): [optional]  # noqa: E501
            web_authn_policy_authenticator_attachment (str): [optional]  # noqa: E501
            web_authn_policy_avoid_same_authenticator_register (bool): [optional]  # noqa: E501
            web_authn_policy_create_timeout (int): [optional]  # noqa: E501
            web_authn_policy_passwordless_acceptable_aaguids ([str]): [optional]  # noqa: E501
            web_authn_policy_passwordless_attestation_conveyance_preference (str): [optional]  # noqa: E501
            web_authn_policy_passwordless_authenticator_attachment (str): [optional]  # noqa: E501
            web_authn_policy_passwordless_avoid_same_authenticator_register (bool): [optional]  # noqa: E501
            web_authn_policy_passwordless_create_timeout (int): [optional]  # noqa: E501
            web_authn_policy_passwordless_require_resident_key (str): [optional]  # noqa: E501
            web_authn_policy_passwordless_rp_entity_name (str): [optional]  # noqa: E501
            web_authn_policy_passwordless_rp_id (str): [optional]  # noqa: E501
            web_authn_policy_passwordless_signature_algorithms ([str]): [optional]  # noqa: E501
            web_authn_policy_passwordless_user_verification_requirement (str): [optional]  # noqa: E501
            web_authn_policy_require_resident_key (str): [optional]  # noqa: E501
            web_authn_policy_rp_entity_name (str): [optional]  # noqa: E501
            web_authn_policy_rp_id (str): [optional]  # noqa: E501
            web_authn_policy_signature_algorithms ([str]): [optional]  # noqa: E501
            web_authn_policy_user_verification_requirement (str): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
