# keycloak-api
This is a REST API reference for the Keycloak Admin

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 17.0
- Package version: 17.0-2
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/awalker125/keycloak-api.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/awalker125/keycloak-api.git`)

Then import the package:
```python
import keycloak_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import keycloak_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import keycloak_api
from pprint import pprint
from keycloak_api.api import attack_detection_api
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = keycloak_api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: access_token
configuration = keycloak_api.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with keycloak_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = attack_detection_api.AttackDetectionApi(api_client)
    realm = "realm_example" # str | realm name (not id!)

    try:
        # Clear any user login failures for all users   This can release temporary disabled users
        api_instance.realm_attack_detection_brute_force_users_delete(realm)
    except keycloak_api.ApiException as e:
        print("Exception when calling AttackDetectionApi->realm_attack_detection_brute_force_users_delete: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AttackDetectionApi* | [**realm_attack_detection_brute_force_users_delete**](docs/AttackDetectionApi.md#realm_attack_detection_brute_force_users_delete) | **DELETE** /{realm}/attack-detection/brute-force/users | Clear any user login failures for all users   This can release temporary disabled users
*AttackDetectionApi* | [**realm_attack_detection_brute_force_users_user_id_delete**](docs/AttackDetectionApi.md#realm_attack_detection_brute_force_users_user_id_delete) | **DELETE** /{realm}/attack-detection/brute-force/users/{userId} | Clear any user login failures for the user   This can release temporary disabled user
*AttackDetectionApi* | [**realm_attack_detection_brute_force_users_user_id_get**](docs/AttackDetectionApi.md#realm_attack_detection_brute_force_users_user_id_get) | **GET** /{realm}/attack-detection/brute-force/users/{userId} | Get status of a username in brute force detection
*AuthenticationManagementApi* | [**realm_authentication_authenticator_providers_get**](docs/AuthenticationManagementApi.md#realm_authentication_authenticator_providers_get) | **GET** /{realm}/authentication/authenticator-providers | Get authenticator providers   Returns a stream of authenticator providers.
*AuthenticationManagementApi* | [**realm_authentication_client_authenticator_providers_get**](docs/AuthenticationManagementApi.md#realm_authentication_client_authenticator_providers_get) | **GET** /{realm}/authentication/client-authenticator-providers | Get client authenticator providers   Returns a stream of client authenticator providers.
*AuthenticationManagementApi* | [**realm_authentication_config_description_provider_id_get**](docs/AuthenticationManagementApi.md#realm_authentication_config_description_provider_id_get) | **GET** /{realm}/authentication/config-description/{providerId} | Get authenticator provider’s configuration description
*AuthenticationManagementApi* | [**realm_authentication_config_id_delete**](docs/AuthenticationManagementApi.md#realm_authentication_config_id_delete) | **DELETE** /{realm}/authentication/config/{id} | Delete authenticator configuration
*AuthenticationManagementApi* | [**realm_authentication_config_id_get**](docs/AuthenticationManagementApi.md#realm_authentication_config_id_get) | **GET** /{realm}/authentication/config/{id} | Get authenticator configuration
*AuthenticationManagementApi* | [**realm_authentication_config_id_put**](docs/AuthenticationManagementApi.md#realm_authentication_config_id_put) | **PUT** /{realm}/authentication/config/{id} | Update authenticator configuration
*AuthenticationManagementApi* | [**realm_authentication_executions_execution_id_config_post**](docs/AuthenticationManagementApi.md#realm_authentication_executions_execution_id_config_post) | **POST** /{realm}/authentication/executions/{executionId}/config | Update execution with new configuration
*AuthenticationManagementApi* | [**realm_authentication_executions_execution_id_delete**](docs/AuthenticationManagementApi.md#realm_authentication_executions_execution_id_delete) | **DELETE** /{realm}/authentication/executions/{executionId} | Delete execution
*AuthenticationManagementApi* | [**realm_authentication_executions_execution_id_get**](docs/AuthenticationManagementApi.md#realm_authentication_executions_execution_id_get) | **GET** /{realm}/authentication/executions/{executionId} | Get Single Execution
*AuthenticationManagementApi* | [**realm_authentication_executions_execution_id_lower_priority_post**](docs/AuthenticationManagementApi.md#realm_authentication_executions_execution_id_lower_priority_post) | **POST** /{realm}/authentication/executions/{executionId}/lower-priority | Lower execution’s priority
*AuthenticationManagementApi* | [**realm_authentication_executions_execution_id_raise_priority_post**](docs/AuthenticationManagementApi.md#realm_authentication_executions_execution_id_raise_priority_post) | **POST** /{realm}/authentication/executions/{executionId}/raise-priority | Raise execution’s priority
*AuthenticationManagementApi* | [**realm_authentication_executions_post**](docs/AuthenticationManagementApi.md#realm_authentication_executions_post) | **POST** /{realm}/authentication/executions | Add new authentication execution
*AuthenticationManagementApi* | [**realm_authentication_flows_flow_alias_copy_post**](docs/AuthenticationManagementApi.md#realm_authentication_flows_flow_alias_copy_post) | **POST** /{realm}/authentication/flows/{flowAlias}/copy | Copy existing authentication flow under a new name   The new name is given as &#39;newName&#39; attribute of the passed JSON object
*AuthenticationManagementApi* | [**realm_authentication_flows_flow_alias_executions_execution_post**](docs/AuthenticationManagementApi.md#realm_authentication_flows_flow_alias_executions_execution_post) | **POST** /{realm}/authentication/flows/{flowAlias}/executions/execution | Add new authentication execution to a flow
*AuthenticationManagementApi* | [**realm_authentication_flows_flow_alias_executions_flow_post**](docs/AuthenticationManagementApi.md#realm_authentication_flows_flow_alias_executions_flow_post) | **POST** /{realm}/authentication/flows/{flowAlias}/executions/flow | Add new flow with new execution to existing flow
*AuthenticationManagementApi* | [**realm_authentication_flows_flow_alias_executions_get**](docs/AuthenticationManagementApi.md#realm_authentication_flows_flow_alias_executions_get) | **GET** /{realm}/authentication/flows/{flowAlias}/executions | Get authentication executions for a flow
*AuthenticationManagementApi* | [**realm_authentication_flows_flow_alias_executions_put**](docs/AuthenticationManagementApi.md#realm_authentication_flows_flow_alias_executions_put) | **PUT** /{realm}/authentication/flows/{flowAlias}/executions | Update authentication executions of a Flow
*AuthenticationManagementApi* | [**realm_authentication_flows_get**](docs/AuthenticationManagementApi.md#realm_authentication_flows_get) | **GET** /{realm}/authentication/flows | Get authentication flows   Returns a stream of authentication flows.
*AuthenticationManagementApi* | [**realm_authentication_flows_id_delete**](docs/AuthenticationManagementApi.md#realm_authentication_flows_id_delete) | **DELETE** /{realm}/authentication/flows/{id} | Delete an authentication flow
*AuthenticationManagementApi* | [**realm_authentication_flows_id_get**](docs/AuthenticationManagementApi.md#realm_authentication_flows_id_get) | **GET** /{realm}/authentication/flows/{id} | Get authentication flow for id
*AuthenticationManagementApi* | [**realm_authentication_flows_id_put**](docs/AuthenticationManagementApi.md#realm_authentication_flows_id_put) | **PUT** /{realm}/authentication/flows/{id} | Update an authentication flow
*AuthenticationManagementApi* | [**realm_authentication_flows_post**](docs/AuthenticationManagementApi.md#realm_authentication_flows_post) | **POST** /{realm}/authentication/flows | Create a new authentication flow
*AuthenticationManagementApi* | [**realm_authentication_form_action_providers_get**](docs/AuthenticationManagementApi.md#realm_authentication_form_action_providers_get) | **GET** /{realm}/authentication/form-action-providers | Get form action providers   Returns a stream of form action providers.
*AuthenticationManagementApi* | [**realm_authentication_form_providers_get**](docs/AuthenticationManagementApi.md#realm_authentication_form_providers_get) | **GET** /{realm}/authentication/form-providers | Get form providers   Returns a stream of form providers.
*AuthenticationManagementApi* | [**realm_authentication_per_client_config_description_get**](docs/AuthenticationManagementApi.md#realm_authentication_per_client_config_description_get) | **GET** /{realm}/authentication/per-client-config-description | Get configuration descriptions for all clients
*AuthenticationManagementApi* | [**realm_authentication_register_required_action_post**](docs/AuthenticationManagementApi.md#realm_authentication_register_required_action_post) | **POST** /{realm}/authentication/register-required-action | Register a new required actions
*AuthenticationManagementApi* | [**realm_authentication_required_actions_alias_delete**](docs/AuthenticationManagementApi.md#realm_authentication_required_actions_alias_delete) | **DELETE** /{realm}/authentication/required-actions/{alias} | Delete required action
*AuthenticationManagementApi* | [**realm_authentication_required_actions_alias_get**](docs/AuthenticationManagementApi.md#realm_authentication_required_actions_alias_get) | **GET** /{realm}/authentication/required-actions/{alias} | Get required action for alias
*AuthenticationManagementApi* | [**realm_authentication_required_actions_alias_lower_priority_post**](docs/AuthenticationManagementApi.md#realm_authentication_required_actions_alias_lower_priority_post) | **POST** /{realm}/authentication/required-actions/{alias}/lower-priority | Lower required action’s priority
*AuthenticationManagementApi* | [**realm_authentication_required_actions_alias_put**](docs/AuthenticationManagementApi.md#realm_authentication_required_actions_alias_put) | **PUT** /{realm}/authentication/required-actions/{alias} | Update required action
*AuthenticationManagementApi* | [**realm_authentication_required_actions_alias_raise_priority_post**](docs/AuthenticationManagementApi.md#realm_authentication_required_actions_alias_raise_priority_post) | **POST** /{realm}/authentication/required-actions/{alias}/raise-priority | Raise required action’s priority
*AuthenticationManagementApi* | [**realm_authentication_required_actions_get**](docs/AuthenticationManagementApi.md#realm_authentication_required_actions_get) | **GET** /{realm}/authentication/required-actions | Get required actions   Returns a stream of required actions.
*AuthenticationManagementApi* | [**realm_authentication_unregistered_required_actions_get**](docs/AuthenticationManagementApi.md#realm_authentication_unregistered_required_actions_get) | **GET** /{realm}/authentication/unregistered-required-actions | Get unregistered required actions   Returns a stream of unregistered required actions.
*ClientAttributeCertificateApi* | [**realm_clients_id_certificates_attr_download_post**](docs/ClientAttributeCertificateApi.md#realm_clients_id_certificates_attr_download_post) | **POST** /{realm}/clients/{id}/certificates/{attr}/download | Get a keystore file for the client, containing private key and public certificate
*ClientAttributeCertificateApi* | [**realm_clients_id_certificates_attr_generate_and_download_post**](docs/ClientAttributeCertificateApi.md#realm_clients_id_certificates_attr_generate_and_download_post) | **POST** /{realm}/clients/{id}/certificates/{attr}/generate-and-download | Generate a new keypair and certificate, and get the private key file   Generates a keypair and certificate and serves the private key in a specified keystore format.
*ClientAttributeCertificateApi* | [**realm_clients_id_certificates_attr_generate_post**](docs/ClientAttributeCertificateApi.md#realm_clients_id_certificates_attr_generate_post) | **POST** /{realm}/clients/{id}/certificates/{attr}/generate | Generate a new certificate with new key pair
*ClientAttributeCertificateApi* | [**realm_clients_id_certificates_attr_get**](docs/ClientAttributeCertificateApi.md#realm_clients_id_certificates_attr_get) | **GET** /{realm}/clients/{id}/certificates/{attr} | Get key info
*ClientAttributeCertificateApi* | [**realm_clients_id_certificates_attr_upload_certificate_post**](docs/ClientAttributeCertificateApi.md#realm_clients_id_certificates_attr_upload_certificate_post) | **POST** /{realm}/clients/{id}/certificates/{attr}/upload-certificate | Upload only certificate, not private key
*ClientAttributeCertificateApi* | [**realm_clients_id_certificates_attr_upload_post**](docs/ClientAttributeCertificateApi.md#realm_clients_id_certificates_attr_upload_post) | **POST** /{realm}/clients/{id}/certificates/{attr}/upload | Upload certificate and eventually private key
*ClientInitialAccessApi* | [**realm_clients_initial_access_get**](docs/ClientInitialAccessApi.md#realm_clients_initial_access_get) | **GET** /{realm}/clients-initial-access | 
*ClientInitialAccessApi* | [**realm_clients_initial_access_id_delete**](docs/ClientInitialAccessApi.md#realm_clients_initial_access_id_delete) | **DELETE** /{realm}/clients-initial-access/{id} | 
*ClientInitialAccessApi* | [**realm_clients_initial_access_post**](docs/ClientInitialAccessApi.md#realm_clients_initial_access_post) | **POST** /{realm}/clients-initial-access | Create a new initial access token.
*ClientRegistrationPolicyApi* | [**realm_client_registration_policy_providers_get**](docs/ClientRegistrationPolicyApi.md#realm_client_registration_policy_providers_get) | **GET** /{realm}/client-registration-policy/providers | Base path for retrieve providers with the configProperties properly filled
*ClientRoleMappingsApi* | [**realm_groups_id_role_mappings_clients_client_available_get**](docs/ClientRoleMappingsApi.md#realm_groups_id_role_mappings_clients_client_available_get) | **GET** /{realm}/groups/{id}/role-mappings/clients/{client}/available | Get available client-level roles that can be mapped to the user
*ClientRoleMappingsApi* | [**realm_groups_id_role_mappings_clients_client_composite_get**](docs/ClientRoleMappingsApi.md#realm_groups_id_role_mappings_clients_client_composite_get) | **GET** /{realm}/groups/{id}/role-mappings/clients/{client}/composite | Get effective client-level role mappings   This recurses any composite roles
*ClientRoleMappingsApi* | [**realm_groups_id_role_mappings_clients_client_delete**](docs/ClientRoleMappingsApi.md#realm_groups_id_role_mappings_clients_client_delete) | **DELETE** /{realm}/groups/{id}/role-mappings/clients/{client} | Delete client-level roles from user role mapping
*ClientRoleMappingsApi* | [**realm_groups_id_role_mappings_clients_client_get**](docs/ClientRoleMappingsApi.md#realm_groups_id_role_mappings_clients_client_get) | **GET** /{realm}/groups/{id}/role-mappings/clients/{client} | Get client-level role mappings for the user, and the app
*ClientRoleMappingsApi* | [**realm_groups_id_role_mappings_clients_client_post**](docs/ClientRoleMappingsApi.md#realm_groups_id_role_mappings_clients_client_post) | **POST** /{realm}/groups/{id}/role-mappings/clients/{client} | Add client-level roles to the user role mapping
*ClientRoleMappingsApi* | [**realm_users_id_role_mappings_clients_client_available_get**](docs/ClientRoleMappingsApi.md#realm_users_id_role_mappings_clients_client_available_get) | **GET** /{realm}/users/{id}/role-mappings/clients/{client}/available | Get available client-level roles that can be mapped to the user
*ClientRoleMappingsApi* | [**realm_users_id_role_mappings_clients_client_composite_get**](docs/ClientRoleMappingsApi.md#realm_users_id_role_mappings_clients_client_composite_get) | **GET** /{realm}/users/{id}/role-mappings/clients/{client}/composite | Get effective client-level role mappings   This recurses any composite roles
*ClientRoleMappingsApi* | [**realm_users_id_role_mappings_clients_client_delete**](docs/ClientRoleMappingsApi.md#realm_users_id_role_mappings_clients_client_delete) | **DELETE** /{realm}/users/{id}/role-mappings/clients/{client} | Delete client-level roles from user role mapping
*ClientRoleMappingsApi* | [**realm_users_id_role_mappings_clients_client_get**](docs/ClientRoleMappingsApi.md#realm_users_id_role_mappings_clients_client_get) | **GET** /{realm}/users/{id}/role-mappings/clients/{client} | Get client-level role mappings for the user, and the app
*ClientRoleMappingsApi* | [**realm_users_id_role_mappings_clients_client_post**](docs/ClientRoleMappingsApi.md#realm_users_id_role_mappings_clients_client_post) | **POST** /{realm}/users/{id}/role-mappings/clients/{client} | Add client-level roles to the user role mapping
*ClientScopesApi* | [**realm_client_scopes_get**](docs/ClientScopesApi.md#realm_client_scopes_get) | **GET** /{realm}/client-scopes | Get client scopes belonging to the realm   Returns a list of client scopes belonging to the realm
*ClientScopesApi* | [**realm_client_scopes_id_delete**](docs/ClientScopesApi.md#realm_client_scopes_id_delete) | **DELETE** /{realm}/client-scopes/{id} | Delete the client scope
*ClientScopesApi* | [**realm_client_scopes_id_get**](docs/ClientScopesApi.md#realm_client_scopes_id_get) | **GET** /{realm}/client-scopes/{id} | Get representation of the client scope
*ClientScopesApi* | [**realm_client_scopes_id_put**](docs/ClientScopesApi.md#realm_client_scopes_id_put) | **PUT** /{realm}/client-scopes/{id} | Update the client scope
*ClientScopesApi* | [**realm_client_scopes_post**](docs/ClientScopesApi.md#realm_client_scopes_post) | **POST** /{realm}/client-scopes | Create a new client scope   Client Scope’s name must be unique!
*ClientsApi* | [**realm_clients_get**](docs/ClientsApi.md#realm_clients_get) | **GET** /{realm}/clients | Get clients belonging to the realm.
*ClientsApi* | [**realm_clients_id_client_secret_get**](docs/ClientsApi.md#realm_clients_id_client_secret_get) | **GET** /{realm}/clients/{id}/client-secret | Get the client secret
*ClientsApi* | [**realm_clients_id_client_secret_post**](docs/ClientsApi.md#realm_clients_id_client_secret_post) | **POST** /{realm}/clients/{id}/client-secret | Generate a new secret for the client
*ClientsApi* | [**realm_clients_id_default_client_scopes_client_scope_id_delete**](docs/ClientsApi.md#realm_clients_id_default_client_scopes_client_scope_id_delete) | **DELETE** /{realm}/clients/{id}/default-client-scopes/{clientScopeId} | 
*ClientsApi* | [**realm_clients_id_default_client_scopes_client_scope_id_put**](docs/ClientsApi.md#realm_clients_id_default_client_scopes_client_scope_id_put) | **PUT** /{realm}/clients/{id}/default-client-scopes/{clientScopeId} | 
*ClientsApi* | [**realm_clients_id_default_client_scopes_get**](docs/ClientsApi.md#realm_clients_id_default_client_scopes_get) | **GET** /{realm}/clients/{id}/default-client-scopes | Get default client scopes.
*ClientsApi* | [**realm_clients_id_delete**](docs/ClientsApi.md#realm_clients_id_delete) | **DELETE** /{realm}/clients/{id} | Delete the client
*ClientsApi* | [**realm_clients_id_evaluate_scopes_generate_example_access_token_get**](docs/ClientsApi.md#realm_clients_id_evaluate_scopes_generate_example_access_token_get) | **GET** /{realm}/clients/{id}/evaluate-scopes/generate-example-access-token | Create JSON with payload of example access token
*ClientsApi* | [**realm_clients_id_evaluate_scopes_generate_example_id_token_get**](docs/ClientsApi.md#realm_clients_id_evaluate_scopes_generate_example_id_token_get) | **GET** /{realm}/clients/{id}/evaluate-scopes/generate-example-id-token | Create JSON with payload of example id token
*ClientsApi* | [**realm_clients_id_evaluate_scopes_generate_example_userinfo_get**](docs/ClientsApi.md#realm_clients_id_evaluate_scopes_generate_example_userinfo_get) | **GET** /{realm}/clients/{id}/evaluate-scopes/generate-example-userinfo | Create JSON with payload of example user info
*ClientsApi* | [**realm_clients_id_evaluate_scopes_protocol_mappers_get**](docs/ClientsApi.md#realm_clients_id_evaluate_scopes_protocol_mappers_get) | **GET** /{realm}/clients/{id}/evaluate-scopes/protocol-mappers | Return list of all protocol mappers, which will be used when generating tokens issued for particular client.
*ClientsApi* | [**realm_clients_id_evaluate_scopes_scope_mappings_role_container_id_granted_get**](docs/ClientsApi.md#realm_clients_id_evaluate_scopes_scope_mappings_role_container_id_granted_get) | **GET** /{realm}/clients/{id}/evaluate-scopes/scope-mappings/{roleContainerId}/granted | Get effective scope mapping of all roles of particular role container, which this client is defacto allowed to have in the accessToken issued for him.
*ClientsApi* | [**realm_clients_id_evaluate_scopes_scope_mappings_role_container_id_not_granted_get**](docs/ClientsApi.md#realm_clients_id_evaluate_scopes_scope_mappings_role_container_id_not_granted_get) | **GET** /{realm}/clients/{id}/evaluate-scopes/scope-mappings/{roleContainerId}/not-granted | Get roles, which this client doesn’t have scope for and can’t have them in the accessToken issued for him.
*ClientsApi* | [**realm_clients_id_get**](docs/ClientsApi.md#realm_clients_id_get) | **GET** /{realm}/clients/{id} | Get representation of the client
*ClientsApi* | [**realm_clients_id_installation_providers_provider_id_get**](docs/ClientsApi.md#realm_clients_id_installation_providers_provider_id_get) | **GET** /{realm}/clients/{id}/installation/providers/{providerId} | 
*ClientsApi* | [**realm_clients_id_management_permissions_get**](docs/ClientsApi.md#realm_clients_id_management_permissions_get) | **GET** /{realm}/clients/{id}/management/permissions | Return object stating whether client Authorization permissions have been initialized or not and a reference
*ClientsApi* | [**realm_clients_id_management_permissions_put**](docs/ClientsApi.md#realm_clients_id_management_permissions_put) | **PUT** /{realm}/clients/{id}/management/permissions | Return object stating whether client Authorization permissions have been initialized or not and a reference
*ClientsApi* | [**realm_clients_id_nodes_node_delete**](docs/ClientsApi.md#realm_clients_id_nodes_node_delete) | **DELETE** /{realm}/clients/{id}/nodes/{node} | Unregister a cluster node from the client
*ClientsApi* | [**realm_clients_id_nodes_post**](docs/ClientsApi.md#realm_clients_id_nodes_post) | **POST** /{realm}/clients/{id}/nodes | Register a cluster node with the client   Manually register cluster node to this client - usually it’s not needed to call this directly as adapter should handle  by sending registration request to Keycloak
*ClientsApi* | [**realm_clients_id_offline_session_count_get**](docs/ClientsApi.md#realm_clients_id_offline_session_count_get) | **GET** /{realm}/clients/{id}/offline-session-count | Get application offline session count   Returns a number of offline user sessions associated with this client   {      \&quot;count\&quot;: number  }
*ClientsApi* | [**realm_clients_id_offline_sessions_get**](docs/ClientsApi.md#realm_clients_id_offline_sessions_get) | **GET** /{realm}/clients/{id}/offline-sessions | Get offline sessions for client   Returns a list of offline user sessions associated with this client
*ClientsApi* | [**realm_clients_id_optional_client_scopes_client_scope_id_delete**](docs/ClientsApi.md#realm_clients_id_optional_client_scopes_client_scope_id_delete) | **DELETE** /{realm}/clients/{id}/optional-client-scopes/{clientScopeId} | 
*ClientsApi* | [**realm_clients_id_optional_client_scopes_client_scope_id_put**](docs/ClientsApi.md#realm_clients_id_optional_client_scopes_client_scope_id_put) | **PUT** /{realm}/clients/{id}/optional-client-scopes/{clientScopeId} | 
*ClientsApi* | [**realm_clients_id_optional_client_scopes_get**](docs/ClientsApi.md#realm_clients_id_optional_client_scopes_get) | **GET** /{realm}/clients/{id}/optional-client-scopes | Get optional client scopes.
*ClientsApi* | [**realm_clients_id_push_revocation_post**](docs/ClientsApi.md#realm_clients_id_push_revocation_post) | **POST** /{realm}/clients/{id}/push-revocation | Push the client’s revocation policy to its admin URL   If the client has an admin URL, push revocation policy to it.
*ClientsApi* | [**realm_clients_id_put**](docs/ClientsApi.md#realm_clients_id_put) | **PUT** /{realm}/clients/{id} | Update the client
*ClientsApi* | [**realm_clients_id_registration_access_token_post**](docs/ClientsApi.md#realm_clients_id_registration_access_token_post) | **POST** /{realm}/clients/{id}/registration-access-token | Generate a new registration access token for the client
*ClientsApi* | [**realm_clients_id_service_account_user_get**](docs/ClientsApi.md#realm_clients_id_service_account_user_get) | **GET** /{realm}/clients/{id}/service-account-user | Get a user dedicated to the service account
*ClientsApi* | [**realm_clients_id_session_count_get**](docs/ClientsApi.md#realm_clients_id_session_count_get) | **GET** /{realm}/clients/{id}/session-count | Get application session count   Returns a number of user sessions associated with this client   {      \&quot;count\&quot;: number  }
*ClientsApi* | [**realm_clients_id_test_nodes_available_get**](docs/ClientsApi.md#realm_clients_id_test_nodes_available_get) | **GET** /{realm}/clients/{id}/test-nodes-available | Test if registered cluster nodes are available   Tests availability by sending &#39;ping&#39; request to all cluster nodes.
*ClientsApi* | [**realm_clients_id_user_sessions_get**](docs/ClientsApi.md#realm_clients_id_user_sessions_get) | **GET** /{realm}/clients/{id}/user-sessions | Get user sessions for client   Returns a list of user sessions associated with this client
*ClientsApi* | [**realm_clients_post**](docs/ClientsApi.md#realm_clients_post) | **POST** /{realm}/clients | Create a new client   Client’s client_id must be unique!
*ComponentApi* | [**realm_components_get**](docs/ComponentApi.md#realm_components_get) | **GET** /{realm}/components | 
*ComponentApi* | [**realm_components_id_delete**](docs/ComponentApi.md#realm_components_id_delete) | **DELETE** /{realm}/components/{id} | 
*ComponentApi* | [**realm_components_id_get**](docs/ComponentApi.md#realm_components_id_get) | **GET** /{realm}/components/{id} | 
*ComponentApi* | [**realm_components_id_put**](docs/ComponentApi.md#realm_components_id_put) | **PUT** /{realm}/components/{id} | 
*ComponentApi* | [**realm_components_id_sub_component_types_get**](docs/ComponentApi.md#realm_components_id_sub_component_types_get) | **GET** /{realm}/components/{id}/sub-component-types | List of subcomponent types that are available to configure for a particular parent component.
*ComponentApi* | [**realm_components_post**](docs/ComponentApi.md#realm_components_post) | **POST** /{realm}/components | 
*GroupsApi* | [**realm_groups_count_get**](docs/GroupsApi.md#realm_groups_count_get) | **GET** /{realm}/groups/count | Returns the groups counts.
*GroupsApi* | [**realm_groups_get**](docs/GroupsApi.md#realm_groups_get) | **GET** /{realm}/groups | Get group hierarchy.
*GroupsApi* | [**realm_groups_id_children_post**](docs/GroupsApi.md#realm_groups_id_children_post) | **POST** /{realm}/groups/{id}/children | Set or create child.
*GroupsApi* | [**realm_groups_id_delete**](docs/GroupsApi.md#realm_groups_id_delete) | **DELETE** /{realm}/groups/{id} | 
*GroupsApi* | [**realm_groups_id_get**](docs/GroupsApi.md#realm_groups_id_get) | **GET** /{realm}/groups/{id} | 
*GroupsApi* | [**realm_groups_id_management_permissions_get**](docs/GroupsApi.md#realm_groups_id_management_permissions_get) | **GET** /{realm}/groups/{id}/management/permissions | Return object stating whether client Authorization permissions have been initialized or not and a reference
*GroupsApi* | [**realm_groups_id_management_permissions_put**](docs/GroupsApi.md#realm_groups_id_management_permissions_put) | **PUT** /{realm}/groups/{id}/management/permissions | Return object stating whether client Authorization permissions have been initialized or not and a reference
*GroupsApi* | [**realm_groups_id_members_get**](docs/GroupsApi.md#realm_groups_id_members_get) | **GET** /{realm}/groups/{id}/members | Get users   Returns a stream of users, filtered according to query parameters
*GroupsApi* | [**realm_groups_id_put**](docs/GroupsApi.md#realm_groups_id_put) | **PUT** /{realm}/groups/{id} | Update group, ignores subgroups.
*GroupsApi* | [**realm_groups_post**](docs/GroupsApi.md#realm_groups_post) | **POST** /{realm}/groups | create or add a top level realm groupSet or create child.
*IdentityProvidersApi* | [**realm_identity_provider_import_config_post**](docs/IdentityProvidersApi.md#realm_identity_provider_import_config_post) | **POST** /{realm}/identity-provider/import-config | Import identity provider from uploaded JSON file
*IdentityProvidersApi* | [**realm_identity_provider_instances_alias_delete**](docs/IdentityProvidersApi.md#realm_identity_provider_instances_alias_delete) | **DELETE** /{realm}/identity-provider/instances/{alias} | Delete the identity provider
*IdentityProvidersApi* | [**realm_identity_provider_instances_alias_export_get**](docs/IdentityProvidersApi.md#realm_identity_provider_instances_alias_export_get) | **GET** /{realm}/identity-provider/instances/{alias}/export | Export public broker configuration for identity provider
*IdentityProvidersApi* | [**realm_identity_provider_instances_alias_get**](docs/IdentityProvidersApi.md#realm_identity_provider_instances_alias_get) | **GET** /{realm}/identity-provider/instances/{alias} | Get the identity provider
*IdentityProvidersApi* | [**realm_identity_provider_instances_alias_management_permissions_get**](docs/IdentityProvidersApi.md#realm_identity_provider_instances_alias_management_permissions_get) | **GET** /{realm}/identity-provider/instances/{alias}/management/permissions | Return object stating whether client Authorization permissions have been initialized or not and a reference
*IdentityProvidersApi* | [**realm_identity_provider_instances_alias_management_permissions_put**](docs/IdentityProvidersApi.md#realm_identity_provider_instances_alias_management_permissions_put) | **PUT** /{realm}/identity-provider/instances/{alias}/management/permissions | Return object stating whether client Authorization permissions have been initialized or not and a reference
*IdentityProvidersApi* | [**realm_identity_provider_instances_alias_mapper_types_get**](docs/IdentityProvidersApi.md#realm_identity_provider_instances_alias_mapper_types_get) | **GET** /{realm}/identity-provider/instances/{alias}/mapper-types | Get mapper types for identity provider
*IdentityProvidersApi* | [**realm_identity_provider_instances_alias_mappers_get**](docs/IdentityProvidersApi.md#realm_identity_provider_instances_alias_mappers_get) | **GET** /{realm}/identity-provider/instances/{alias}/mappers | Get mappers for identity provider
*IdentityProvidersApi* | [**realm_identity_provider_instances_alias_mappers_id_delete**](docs/IdentityProvidersApi.md#realm_identity_provider_instances_alias_mappers_id_delete) | **DELETE** /{realm}/identity-provider/instances/{alias}/mappers/{id} | Delete a mapper for the identity provider
*IdentityProvidersApi* | [**realm_identity_provider_instances_alias_mappers_id_get**](docs/IdentityProvidersApi.md#realm_identity_provider_instances_alias_mappers_id_get) | **GET** /{realm}/identity-provider/instances/{alias}/mappers/{id} | Get mapper by id for the identity provider
*IdentityProvidersApi* | [**realm_identity_provider_instances_alias_mappers_id_put**](docs/IdentityProvidersApi.md#realm_identity_provider_instances_alias_mappers_id_put) | **PUT** /{realm}/identity-provider/instances/{alias}/mappers/{id} | Update a mapper for the identity provider
*IdentityProvidersApi* | [**realm_identity_provider_instances_alias_mappers_post**](docs/IdentityProvidersApi.md#realm_identity_provider_instances_alias_mappers_post) | **POST** /{realm}/identity-provider/instances/{alias}/mappers | Add a mapper to identity provider
*IdentityProvidersApi* | [**realm_identity_provider_instances_alias_put**](docs/IdentityProvidersApi.md#realm_identity_provider_instances_alias_put) | **PUT** /{realm}/identity-provider/instances/{alias} | Update the identity provider
*IdentityProvidersApi* | [**realm_identity_provider_instances_get**](docs/IdentityProvidersApi.md#realm_identity_provider_instances_get) | **GET** /{realm}/identity-provider/instances | Get identity providers
*IdentityProvidersApi* | [**realm_identity_provider_instances_post**](docs/IdentityProvidersApi.md#realm_identity_provider_instances_post) | **POST** /{realm}/identity-provider/instances | Create a new identity provider
*IdentityProvidersApi* | [**realm_identity_provider_providers_provider_id_get**](docs/IdentityProvidersApi.md#realm_identity_provider_providers_provider_id_get) | **GET** /{realm}/identity-provider/providers/{provider_id} | Get identity providers
*KeyApi* | [**realm_keys_get**](docs/KeyApi.md#realm_keys_get) | **GET** /{realm}/keys | 
*ProtocolMappersApi* | [**realm_client_scopes_id1_protocol_mappers_models_id2_delete**](docs/ProtocolMappersApi.md#realm_client_scopes_id1_protocol_mappers_models_id2_delete) | **DELETE** /{realm}/client-scopes/{id1}/protocol-mappers/models/{id2} | Delete the mapper
*ProtocolMappersApi* | [**realm_client_scopes_id1_protocol_mappers_models_id2_get**](docs/ProtocolMappersApi.md#realm_client_scopes_id1_protocol_mappers_models_id2_get) | **GET** /{realm}/client-scopes/{id1}/protocol-mappers/models/{id2} | Get mapper by id
*ProtocolMappersApi* | [**realm_client_scopes_id1_protocol_mappers_models_id2_put**](docs/ProtocolMappersApi.md#realm_client_scopes_id1_protocol_mappers_models_id2_put) | **PUT** /{realm}/client-scopes/{id1}/protocol-mappers/models/{id2} | Update the mapper
*ProtocolMappersApi* | [**realm_client_scopes_id_protocol_mappers_add_models_post**](docs/ProtocolMappersApi.md#realm_client_scopes_id_protocol_mappers_add_models_post) | **POST** /{realm}/client-scopes/{id}/protocol-mappers/add-models | Create multiple mappers
*ProtocolMappersApi* | [**realm_client_scopes_id_protocol_mappers_models_get**](docs/ProtocolMappersApi.md#realm_client_scopes_id_protocol_mappers_models_get) | **GET** /{realm}/client-scopes/{id}/protocol-mappers/models | Get mappers
*ProtocolMappersApi* | [**realm_client_scopes_id_protocol_mappers_models_post**](docs/ProtocolMappersApi.md#realm_client_scopes_id_protocol_mappers_models_post) | **POST** /{realm}/client-scopes/{id}/protocol-mappers/models | Create a mapper
*ProtocolMappersApi* | [**realm_client_scopes_id_protocol_mappers_protocol_protocol_get**](docs/ProtocolMappersApi.md#realm_client_scopes_id_protocol_mappers_protocol_protocol_get) | **GET** /{realm}/client-scopes/{id}/protocol-mappers/protocol/{protocol} | Get mappers by name for a specific protocol
*ProtocolMappersApi* | [**realm_clients_id1_protocol_mappers_models_id2_delete**](docs/ProtocolMappersApi.md#realm_clients_id1_protocol_mappers_models_id2_delete) | **DELETE** /{realm}/clients/{id1}/protocol-mappers/models/{id2} | Delete the mapper
*ProtocolMappersApi* | [**realm_clients_id1_protocol_mappers_models_id2_get**](docs/ProtocolMappersApi.md#realm_clients_id1_protocol_mappers_models_id2_get) | **GET** /{realm}/clients/{id1}/protocol-mappers/models/{id2} | Get mapper by id
*ProtocolMappersApi* | [**realm_clients_id1_protocol_mappers_models_id2_put**](docs/ProtocolMappersApi.md#realm_clients_id1_protocol_mappers_models_id2_put) | **PUT** /{realm}/clients/{id1}/protocol-mappers/models/{id2} | Update the mapper
*ProtocolMappersApi* | [**realm_clients_id_protocol_mappers_add_models_post**](docs/ProtocolMappersApi.md#realm_clients_id_protocol_mappers_add_models_post) | **POST** /{realm}/clients/{id}/protocol-mappers/add-models | Create multiple mappers
*ProtocolMappersApi* | [**realm_clients_id_protocol_mappers_models_get**](docs/ProtocolMappersApi.md#realm_clients_id_protocol_mappers_models_get) | **GET** /{realm}/clients/{id}/protocol-mappers/models | Get mappers
*ProtocolMappersApi* | [**realm_clients_id_protocol_mappers_models_post**](docs/ProtocolMappersApi.md#realm_clients_id_protocol_mappers_models_post) | **POST** /{realm}/clients/{id}/protocol-mappers/models | Create a mapper
*ProtocolMappersApi* | [**realm_clients_id_protocol_mappers_protocol_protocol_get**](docs/ProtocolMappersApi.md#realm_clients_id_protocol_mappers_protocol_protocol_get) | **GET** /{realm}/clients/{id}/protocol-mappers/protocol/{protocol} | Get mappers by name for a specific protocol
*RealmsAdminApi* | [**admin_realms_post**](docs/RealmsAdminApi.md#admin_realms_post) | **POST** /admin/realms | Import a realm   Imports a realm from a full representation of that realm.
*RealmsAdminApi* | [**realm_admin_events_delete**](docs/RealmsAdminApi.md#realm_admin_events_delete) | **DELETE** /{realm}/admin-events | Delete all admin events
*RealmsAdminApi* | [**realm_admin_events_get**](docs/RealmsAdminApi.md#realm_admin_events_get) | **GET** /{realm}/admin-events | Get admin events   Returns all admin events, or filters events based on URL query parameters listed here
*RealmsAdminApi* | [**realm_clear_keys_cache_post**](docs/RealmsAdminApi.md#realm_clear_keys_cache_post) | **POST** /{realm}/clear-keys-cache | Clear cache of external public keys (Public keys of clients or Identity providers)
*RealmsAdminApi* | [**realm_clear_realm_cache_post**](docs/RealmsAdminApi.md#realm_clear_realm_cache_post) | **POST** /{realm}/clear-realm-cache | Clear realm cache
*RealmsAdminApi* | [**realm_clear_user_cache_post**](docs/RealmsAdminApi.md#realm_clear_user_cache_post) | **POST** /{realm}/clear-user-cache | Clear user cache
*RealmsAdminApi* | [**realm_client_description_converter_post**](docs/RealmsAdminApi.md#realm_client_description_converter_post) | **POST** /{realm}/client-description-converter | Base path for importing clients under this realm.
*RealmsAdminApi* | [**realm_client_policies_policies_get**](docs/RealmsAdminApi.md#realm_client_policies_policies_get) | **GET** /{realm}/client-policies/policies | 
*RealmsAdminApi* | [**realm_client_policies_policies_put**](docs/RealmsAdminApi.md#realm_client_policies_policies_put) | **PUT** /{realm}/client-policies/policies | 
*RealmsAdminApi* | [**realm_client_policies_profiles_get**](docs/RealmsAdminApi.md#realm_client_policies_profiles_get) | **GET** /{realm}/client-policies/profiles | 
*RealmsAdminApi* | [**realm_client_policies_profiles_put**](docs/RealmsAdminApi.md#realm_client_policies_profiles_put) | **PUT** /{realm}/client-policies/profiles | 
*RealmsAdminApi* | [**realm_client_session_stats_get**](docs/RealmsAdminApi.md#realm_client_session_stats_get) | **GET** /{realm}/client-session-stats | Get client session stats   Returns a JSON map.
*RealmsAdminApi* | [**realm_credential_registrators_get**](docs/RealmsAdminApi.md#realm_credential_registrators_get) | **GET** /{realm}/credential-registrators | 
*RealmsAdminApi* | [**realm_default_default_client_scopes_client_scope_id_delete**](docs/RealmsAdminApi.md#realm_default_default_client_scopes_client_scope_id_delete) | **DELETE** /{realm}/default-default-client-scopes/{clientScopeId} | 
*RealmsAdminApi* | [**realm_default_default_client_scopes_client_scope_id_put**](docs/RealmsAdminApi.md#realm_default_default_client_scopes_client_scope_id_put) | **PUT** /{realm}/default-default-client-scopes/{clientScopeId} | 
*RealmsAdminApi* | [**realm_default_default_client_scopes_get**](docs/RealmsAdminApi.md#realm_default_default_client_scopes_get) | **GET** /{realm}/default-default-client-scopes | Get realm default client scopes.
*RealmsAdminApi* | [**realm_default_groups_get**](docs/RealmsAdminApi.md#realm_default_groups_get) | **GET** /{realm}/default-groups | Get group hierarchy.
*RealmsAdminApi* | [**realm_default_groups_group_id_delete**](docs/RealmsAdminApi.md#realm_default_groups_group_id_delete) | **DELETE** /{realm}/default-groups/{groupId} | 
*RealmsAdminApi* | [**realm_default_groups_group_id_put**](docs/RealmsAdminApi.md#realm_default_groups_group_id_put) | **PUT** /{realm}/default-groups/{groupId} | 
*RealmsAdminApi* | [**realm_default_optional_client_scopes_client_scope_id_delete**](docs/RealmsAdminApi.md#realm_default_optional_client_scopes_client_scope_id_delete) | **DELETE** /{realm}/default-optional-client-scopes/{clientScopeId} | 
*RealmsAdminApi* | [**realm_default_optional_client_scopes_client_scope_id_put**](docs/RealmsAdminApi.md#realm_default_optional_client_scopes_client_scope_id_put) | **PUT** /{realm}/default-optional-client-scopes/{clientScopeId} | 
*RealmsAdminApi* | [**realm_default_optional_client_scopes_get**](docs/RealmsAdminApi.md#realm_default_optional_client_scopes_get) | **GET** /{realm}/default-optional-client-scopes | Get realm optional client scopes.
*RealmsAdminApi* | [**realm_delete**](docs/RealmsAdminApi.md#realm_delete) | **DELETE** /{realm} | Delete the realm
*RealmsAdminApi* | [**realm_events_config_get**](docs/RealmsAdminApi.md#realm_events_config_get) | **GET** /{realm}/events/config | Get the events provider configuration   Returns JSON object with events provider configuration
*RealmsAdminApi* | [**realm_events_config_put**](docs/RealmsAdminApi.md#realm_events_config_put) | **PUT** /{realm}/events/config | Update the events provider   Change the events provider and/or its configuration
*RealmsAdminApi* | [**realm_events_delete**](docs/RealmsAdminApi.md#realm_events_delete) | **DELETE** /{realm}/events | Delete all events
*RealmsAdminApi* | [**realm_events_get**](docs/RealmsAdminApi.md#realm_events_get) | **GET** /{realm}/events | Get events   Returns all events, or filters them based on URL query parameters listed here
*RealmsAdminApi* | [**realm_get**](docs/RealmsAdminApi.md#realm_get) | **GET** /{realm} | Get the top-level representation of the realm   It will not include nested information like User and Client representations.
*RealmsAdminApi* | [**realm_group_by_path_path_get**](docs/RealmsAdminApi.md#realm_group_by_path_path_get) | **GET** /{realm}/group-by-path/{path} | 
*RealmsAdminApi* | [**realm_ldap_server_capabilities_post**](docs/RealmsAdminApi.md#realm_ldap_server_capabilities_post) | **POST** /{realm}/ldap-server-capabilities | Get LDAP supported extensions.
*RealmsAdminApi* | [**realm_localization_get**](docs/RealmsAdminApi.md#realm_localization_get) | **GET** /{realm}/localization | 
*RealmsAdminApi* | [**realm_localization_locale_delete**](docs/RealmsAdminApi.md#realm_localization_locale_delete) | **DELETE** /{realm}/localization/{locale} | 
*RealmsAdminApi* | [**realm_localization_locale_get**](docs/RealmsAdminApi.md#realm_localization_locale_get) | **GET** /{realm}/localization/{locale} | 
*RealmsAdminApi* | [**realm_localization_locale_key_delete**](docs/RealmsAdminApi.md#realm_localization_locale_key_delete) | **DELETE** /{realm}/localization/{locale}/{key} | 
*RealmsAdminApi* | [**realm_localization_locale_key_get**](docs/RealmsAdminApi.md#realm_localization_locale_key_get) | **GET** /{realm}/localization/{locale}/{key} | 
*RealmsAdminApi* | [**realm_localization_locale_key_put**](docs/RealmsAdminApi.md#realm_localization_locale_key_put) | **PUT** /{realm}/localization/{locale}/{key} | 
*RealmsAdminApi* | [**realm_localization_locale_post**](docs/RealmsAdminApi.md#realm_localization_locale_post) | **POST** /{realm}/localization/{locale} | 
*RealmsAdminApi* | [**realm_logout_all_post**](docs/RealmsAdminApi.md#realm_logout_all_post) | **POST** /{realm}/logout-all | Removes all user sessions.
*RealmsAdminApi* | [**realm_partial_export_post**](docs/RealmsAdminApi.md#realm_partial_export_post) | **POST** /{realm}/partial-export | Partial export of existing realm into a JSON file.
*RealmsAdminApi* | [**realm_partial_import_post**](docs/RealmsAdminApi.md#realm_partial_import_post) | **POST** /{realm}/partialImport | Partial import from a JSON file to an existing realm.
*RealmsAdminApi* | [**realm_push_revocation_post**](docs/RealmsAdminApi.md#realm_push_revocation_post) | **POST** /{realm}/push-revocation | Push the realm’s revocation policy to any client that has an admin url associated with it.
*RealmsAdminApi* | [**realm_put**](docs/RealmsAdminApi.md#realm_put) | **PUT** /{realm} | Update the top-level information of the realm   Any user, roles or client information in the representation  will be ignored.
*RealmsAdminApi* | [**realm_sessions_session_delete**](docs/RealmsAdminApi.md#realm_sessions_session_delete) | **DELETE** /{realm}/sessions/{session} | Remove a specific user session.
*RealmsAdminApi* | [**realm_test_ldap_connection_post**](docs/RealmsAdminApi.md#realm_test_ldap_connection_post) | **POST** /{realm}/testLDAPConnection | Test LDAP connection
*RealmsAdminApi* | [**realm_test_smtp_connection_post**](docs/RealmsAdminApi.md#realm_test_smtp_connection_post) | **POST** /{realm}/testSMTPConnection | 
*RealmsAdminApi* | [**realm_users_management_permissions_get**](docs/RealmsAdminApi.md#realm_users_management_permissions_get) | **GET** /{realm}/users-management-permissions | 
*RealmsAdminApi* | [**realm_users_management_permissions_put**](docs/RealmsAdminApi.md#realm_users_management_permissions_put) | **PUT** /{realm}/users-management-permissions | 
*RoleMapperApi* | [**realm_groups_id_role_mappings_get**](docs/RoleMapperApi.md#realm_groups_id_role_mappings_get) | **GET** /{realm}/groups/{id}/role-mappings | Get role mappings
*RoleMapperApi* | [**realm_groups_id_role_mappings_realm_available_get**](docs/RoleMapperApi.md#realm_groups_id_role_mappings_realm_available_get) | **GET** /{realm}/groups/{id}/role-mappings/realm/available | Get realm-level roles that can be mapped
*RoleMapperApi* | [**realm_groups_id_role_mappings_realm_composite_get**](docs/RoleMapperApi.md#realm_groups_id_role_mappings_realm_composite_get) | **GET** /{realm}/groups/{id}/role-mappings/realm/composite | Get effective realm-level role mappings   This will recurse all composite roles to get the result.
*RoleMapperApi* | [**realm_groups_id_role_mappings_realm_delete**](docs/RoleMapperApi.md#realm_groups_id_role_mappings_realm_delete) | **DELETE** /{realm}/groups/{id}/role-mappings/realm | Delete realm-level role mappings
*RoleMapperApi* | [**realm_groups_id_role_mappings_realm_get**](docs/RoleMapperApi.md#realm_groups_id_role_mappings_realm_get) | **GET** /{realm}/groups/{id}/role-mappings/realm | Get realm-level role mappings
*RoleMapperApi* | [**realm_groups_id_role_mappings_realm_post**](docs/RoleMapperApi.md#realm_groups_id_role_mappings_realm_post) | **POST** /{realm}/groups/{id}/role-mappings/realm | Add realm-level role mappings to the user
*RoleMapperApi* | [**realm_users_id_role_mappings_get**](docs/RoleMapperApi.md#realm_users_id_role_mappings_get) | **GET** /{realm}/users/{id}/role-mappings | Get role mappings
*RoleMapperApi* | [**realm_users_id_role_mappings_realm_available_get**](docs/RoleMapperApi.md#realm_users_id_role_mappings_realm_available_get) | **GET** /{realm}/users/{id}/role-mappings/realm/available | Get realm-level roles that can be mapped
*RoleMapperApi* | [**realm_users_id_role_mappings_realm_composite_get**](docs/RoleMapperApi.md#realm_users_id_role_mappings_realm_composite_get) | **GET** /{realm}/users/{id}/role-mappings/realm/composite | Get effective realm-level role mappings   This will recurse all composite roles to get the result.
*RoleMapperApi* | [**realm_users_id_role_mappings_realm_delete**](docs/RoleMapperApi.md#realm_users_id_role_mappings_realm_delete) | **DELETE** /{realm}/users/{id}/role-mappings/realm | Delete realm-level role mappings
*RoleMapperApi* | [**realm_users_id_role_mappings_realm_get**](docs/RoleMapperApi.md#realm_users_id_role_mappings_realm_get) | **GET** /{realm}/users/{id}/role-mappings/realm | Get realm-level role mappings
*RoleMapperApi* | [**realm_users_id_role_mappings_realm_post**](docs/RoleMapperApi.md#realm_users_id_role_mappings_realm_post) | **POST** /{realm}/users/{id}/role-mappings/realm | Add realm-level role mappings to the user
*RolesApi* | [**realm_clients_id_roles_get**](docs/RolesApi.md#realm_clients_id_roles_get) | **GET** /{realm}/clients/{id}/roles | Get all roles for the realm or client
*RolesApi* | [**realm_clients_id_roles_post**](docs/RolesApi.md#realm_clients_id_roles_post) | **POST** /{realm}/clients/{id}/roles | Create a new role for the realm or client
*RolesApi* | [**realm_clients_id_roles_role_name_composites_clients_client_uuid_get**](docs/RolesApi.md#realm_clients_id_roles_role_name_composites_clients_client_uuid_get) | **GET** /{realm}/clients/{id}/roles/{role-name}/composites/clients/{clientUuid} | Get client-level roles for the client that are in the role’s composite
*RolesApi* | [**realm_clients_id_roles_role_name_composites_delete**](docs/RolesApi.md#realm_clients_id_roles_role_name_composites_delete) | **DELETE** /{realm}/clients/{id}/roles/{role-name}/composites | Remove roles from the role’s composite
*RolesApi* | [**realm_clients_id_roles_role_name_composites_get**](docs/RolesApi.md#realm_clients_id_roles_role_name_composites_get) | **GET** /{realm}/clients/{id}/roles/{role-name}/composites | Get composites of the role
*RolesApi* | [**realm_clients_id_roles_role_name_composites_post**](docs/RolesApi.md#realm_clients_id_roles_role_name_composites_post) | **POST** /{realm}/clients/{id}/roles/{role-name}/composites | Add a composite to the role
*RolesApi* | [**realm_clients_id_roles_role_name_composites_realm_get**](docs/RolesApi.md#realm_clients_id_roles_role_name_composites_realm_get) | **GET** /{realm}/clients/{id}/roles/{role-name}/composites/realm | Get realm-level roles of the role’s composite
*RolesApi* | [**realm_clients_id_roles_role_name_delete**](docs/RolesApi.md#realm_clients_id_roles_role_name_delete) | **DELETE** /{realm}/clients/{id}/roles/{role-name} | Delete a role by name
*RolesApi* | [**realm_clients_id_roles_role_name_get**](docs/RolesApi.md#realm_clients_id_roles_role_name_get) | **GET** /{realm}/clients/{id}/roles/{role-name} | Get a role by name
*RolesApi* | [**realm_clients_id_roles_role_name_groups_get**](docs/RolesApi.md#realm_clients_id_roles_role_name_groups_get) | **GET** /{realm}/clients/{id}/roles/{role-name}/groups | Returns a stream of groups that have the specified role name
*RolesApi* | [**realm_clients_id_roles_role_name_management_permissions_get**](docs/RolesApi.md#realm_clients_id_roles_role_name_management_permissions_get) | **GET** /{realm}/clients/{id}/roles/{role-name}/management/permissions | Return object stating whether role Authorization permissions have been initialized or not and a reference
*RolesApi* | [**realm_clients_id_roles_role_name_management_permissions_put**](docs/RolesApi.md#realm_clients_id_roles_role_name_management_permissions_put) | **PUT** /{realm}/clients/{id}/roles/{role-name}/management/permissions | Return object stating whether role Authorization permissions have been initialized or not and a reference
*RolesApi* | [**realm_clients_id_roles_role_name_put**](docs/RolesApi.md#realm_clients_id_roles_role_name_put) | **PUT** /{realm}/clients/{id}/roles/{role-name} | Update a role by name
*RolesApi* | [**realm_clients_id_roles_role_name_users_get**](docs/RolesApi.md#realm_clients_id_roles_role_name_users_get) | **GET** /{realm}/clients/{id}/roles/{role-name}/users | Returns a stream of users that have the specified role name.
*RolesApi* | [**realm_roles_get**](docs/RolesApi.md#realm_roles_get) | **GET** /{realm}/roles | Get all roles for the realm or client
*RolesApi* | [**realm_roles_post**](docs/RolesApi.md#realm_roles_post) | **POST** /{realm}/roles | Create a new role for the realm or client
*RolesApi* | [**realm_roles_role_name_composites_clients_client_uuid_get**](docs/RolesApi.md#realm_roles_role_name_composites_clients_client_uuid_get) | **GET** /{realm}/roles/{role-name}/composites/clients/{clientUuid} | Get client-level roles for the client that are in the role’s composite
*RolesApi* | [**realm_roles_role_name_composites_delete**](docs/RolesApi.md#realm_roles_role_name_composites_delete) | **DELETE** /{realm}/roles/{role-name}/composites | Remove roles from the role’s composite
*RolesApi* | [**realm_roles_role_name_composites_get**](docs/RolesApi.md#realm_roles_role_name_composites_get) | **GET** /{realm}/roles/{role-name}/composites | Get composites of the role
*RolesApi* | [**realm_roles_role_name_composites_post**](docs/RolesApi.md#realm_roles_role_name_composites_post) | **POST** /{realm}/roles/{role-name}/composites | Add a composite to the role
*RolesApi* | [**realm_roles_role_name_composites_realm_get**](docs/RolesApi.md#realm_roles_role_name_composites_realm_get) | **GET** /{realm}/roles/{role-name}/composites/realm | Get realm-level roles of the role’s composite
*RolesApi* | [**realm_roles_role_name_delete**](docs/RolesApi.md#realm_roles_role_name_delete) | **DELETE** /{realm}/roles/{role-name} | Delete a role by name
*RolesApi* | [**realm_roles_role_name_get**](docs/RolesApi.md#realm_roles_role_name_get) | **GET** /{realm}/roles/{role-name} | Get a role by name
*RolesApi* | [**realm_roles_role_name_groups_get**](docs/RolesApi.md#realm_roles_role_name_groups_get) | **GET** /{realm}/roles/{role-name}/groups | Returns a stream of groups that have the specified role name
*RolesApi* | [**realm_roles_role_name_management_permissions_get**](docs/RolesApi.md#realm_roles_role_name_management_permissions_get) | **GET** /{realm}/roles/{role-name}/management/permissions | Return object stating whether role Authorization permissions have been initialized or not and a reference
*RolesApi* | [**realm_roles_role_name_management_permissions_put**](docs/RolesApi.md#realm_roles_role_name_management_permissions_put) | **PUT** /{realm}/roles/{role-name}/management/permissions | Return object stating whether role Authorization permissions have been initialized or not and a reference
*RolesApi* | [**realm_roles_role_name_put**](docs/RolesApi.md#realm_roles_role_name_put) | **PUT** /{realm}/roles/{role-name} | Update a role by name
*RolesApi* | [**realm_roles_role_name_users_get**](docs/RolesApi.md#realm_roles_role_name_users_get) | **GET** /{realm}/roles/{role-name}/users | Returns a stream of users that have the specified role name.
*RolesByIDApi* | [**realm_roles_by_id_role_id_composites_clients_client_uuid_get**](docs/RolesByIDApi.md#realm_roles_by_id_role_id_composites_clients_client_uuid_get) | **GET** /{realm}/roles-by-id/{role-id}/composites/clients/{clientUuid} | Get client-level roles for the client that are in the role’s composite
*RolesByIDApi* | [**realm_roles_by_id_role_id_composites_delete**](docs/RolesByIDApi.md#realm_roles_by_id_role_id_composites_delete) | **DELETE** /{realm}/roles-by-id/{role-id}/composites | Remove a set of roles from the role’s composite
*RolesByIDApi* | [**realm_roles_by_id_role_id_composites_get**](docs/RolesByIDApi.md#realm_roles_by_id_role_id_composites_get) | **GET** /{realm}/roles-by-id/{role-id}/composites | Get role’s children   Returns a set of role’s children provided the role is a composite.
*RolesByIDApi* | [**realm_roles_by_id_role_id_composites_post**](docs/RolesByIDApi.md#realm_roles_by_id_role_id_composites_post) | **POST** /{realm}/roles-by-id/{role-id}/composites | Make the role a composite role by associating some child roles
*RolesByIDApi* | [**realm_roles_by_id_role_id_composites_realm_get**](docs/RolesByIDApi.md#realm_roles_by_id_role_id_composites_realm_get) | **GET** /{realm}/roles-by-id/{role-id}/composites/realm | Get realm-level roles that are in the role’s composite
*RolesByIDApi* | [**realm_roles_by_id_role_id_delete**](docs/RolesByIDApi.md#realm_roles_by_id_role_id_delete) | **DELETE** /{realm}/roles-by-id/{role-id} | Delete the role
*RolesByIDApi* | [**realm_roles_by_id_role_id_get**](docs/RolesByIDApi.md#realm_roles_by_id_role_id_get) | **GET** /{realm}/roles-by-id/{role-id} | Get a specific role’s representation
*RolesByIDApi* | [**realm_roles_by_id_role_id_management_permissions_get**](docs/RolesByIDApi.md#realm_roles_by_id_role_id_management_permissions_get) | **GET** /{realm}/roles-by-id/{role-id}/management/permissions | Return object stating whether role Authoirzation permissions have been initialized or not and a reference
*RolesByIDApi* | [**realm_roles_by_id_role_id_management_permissions_put**](docs/RolesByIDApi.md#realm_roles_by_id_role_id_management_permissions_put) | **PUT** /{realm}/roles-by-id/{role-id}/management/permissions | Return object stating whether role Authoirzation permissions have been initialized or not and a reference
*RolesByIDApi* | [**realm_roles_by_id_role_id_put**](docs/RolesByIDApi.md#realm_roles_by_id_role_id_put) | **PUT** /{realm}/roles-by-id/{role-id} | Update the role
*RootApi* | [**admin_realms_get**](docs/RootApi.md#admin_realms_get) | **GET** /admin/realms | Get themes, social providers, auth providers, and event listeners available on this server
*ScopeMappingsApi* | [**realm_client_scopes_id_scope_mappings_clients_client_available_get**](docs/ScopeMappingsApi.md#realm_client_scopes_id_scope_mappings_clients_client_available_get) | **GET** /{realm}/client-scopes/{id}/scope-mappings/clients/{client}/available | The available client-level roles   Returns the roles for the client that can be associated with the client’s scope
*ScopeMappingsApi* | [**realm_client_scopes_id_scope_mappings_clients_client_composite_get**](docs/ScopeMappingsApi.md#realm_client_scopes_id_scope_mappings_clients_client_composite_get) | **GET** /{realm}/client-scopes/{id}/scope-mappings/clients/{client}/composite | Get effective client roles   Returns the roles for the client that are associated with the client’s scope.
*ScopeMappingsApi* | [**realm_client_scopes_id_scope_mappings_clients_client_delete**](docs/ScopeMappingsApi.md#realm_client_scopes_id_scope_mappings_clients_client_delete) | **DELETE** /{realm}/client-scopes/{id}/scope-mappings/clients/{client} | Remove client-level roles from the client’s scope.
*ScopeMappingsApi* | [**realm_client_scopes_id_scope_mappings_clients_client_get**](docs/ScopeMappingsApi.md#realm_client_scopes_id_scope_mappings_clients_client_get) | **GET** /{realm}/client-scopes/{id}/scope-mappings/clients/{client} | Get the roles associated with a client’s scope   Returns roles for the client.
*ScopeMappingsApi* | [**realm_client_scopes_id_scope_mappings_clients_client_post**](docs/ScopeMappingsApi.md#realm_client_scopes_id_scope_mappings_clients_client_post) | **POST** /{realm}/client-scopes/{id}/scope-mappings/clients/{client} | Add client-level roles to the client’s scope
*ScopeMappingsApi* | [**realm_client_scopes_id_scope_mappings_realm_available_get**](docs/ScopeMappingsApi.md#realm_client_scopes_id_scope_mappings_realm_available_get) | **GET** /{realm}/client-scopes/{id}/scope-mappings/realm/available | Get realm-level roles that are available to attach to this client’s scope
*ScopeMappingsApi* | [**realm_client_scopes_id_scope_mappings_realm_composite_get**](docs/ScopeMappingsApi.md#realm_client_scopes_id_scope_mappings_realm_composite_get) | **GET** /{realm}/client-scopes/{id}/scope-mappings/realm/composite | Get effective realm-level roles associated with the client’s scope   What this does is recurse  any composite roles associated with the client’s scope and adds the roles to this lists.
*ScopeMappingsApi* | [**realm_client_scopes_id_scope_mappings_realm_delete**](docs/ScopeMappingsApi.md#realm_client_scopes_id_scope_mappings_realm_delete) | **DELETE** /{realm}/client-scopes/{id}/scope-mappings/realm | Remove a set of realm-level roles from the client’s scope
*ScopeMappingsApi* | [**realm_client_scopes_id_scope_mappings_realm_get**](docs/ScopeMappingsApi.md#realm_client_scopes_id_scope_mappings_realm_get) | **GET** /{realm}/client-scopes/{id}/scope-mappings/realm | Get realm-level roles associated with the client’s scope
*ScopeMappingsApi* | [**realm_client_scopes_id_scope_mappings_realm_post**](docs/ScopeMappingsApi.md#realm_client_scopes_id_scope_mappings_realm_post) | **POST** /{realm}/client-scopes/{id}/scope-mappings/realm | Add a set of realm-level roles to the client’s scope
*ScopeMappingsApi* | [**realm_clients_id_scope_mappings_clients_client_available_get**](docs/ScopeMappingsApi.md#realm_clients_id_scope_mappings_clients_client_available_get) | **GET** /{realm}/clients/{id}/scope-mappings/clients/{client}/available | The available client-level roles   Returns the roles for the client that can be associated with the client’s scope
*ScopeMappingsApi* | [**realm_clients_id_scope_mappings_clients_client_composite_get**](docs/ScopeMappingsApi.md#realm_clients_id_scope_mappings_clients_client_composite_get) | **GET** /{realm}/clients/{id}/scope-mappings/clients/{client}/composite | Get effective client roles   Returns the roles for the client that are associated with the client’s scope.
*ScopeMappingsApi* | [**realm_clients_id_scope_mappings_clients_client_delete**](docs/ScopeMappingsApi.md#realm_clients_id_scope_mappings_clients_client_delete) | **DELETE** /{realm}/clients/{id}/scope-mappings/clients/{client} | Remove client-level roles from the client’s scope.
*ScopeMappingsApi* | [**realm_clients_id_scope_mappings_clients_client_get**](docs/ScopeMappingsApi.md#realm_clients_id_scope_mappings_clients_client_get) | **GET** /{realm}/clients/{id}/scope-mappings/clients/{client} | Get the roles associated with a client’s scope   Returns roles for the client.
*ScopeMappingsApi* | [**realm_clients_id_scope_mappings_clients_client_post**](docs/ScopeMappingsApi.md#realm_clients_id_scope_mappings_clients_client_post) | **POST** /{realm}/clients/{id}/scope-mappings/clients/{client} | Add client-level roles to the client’s scope
*ScopeMappingsApi* | [**realm_clients_id_scope_mappings_realm_available_get**](docs/ScopeMappingsApi.md#realm_clients_id_scope_mappings_realm_available_get) | **GET** /{realm}/clients/{id}/scope-mappings/realm/available | Get realm-level roles that are available to attach to this client’s scope
*ScopeMappingsApi* | [**realm_clients_id_scope_mappings_realm_composite_get**](docs/ScopeMappingsApi.md#realm_clients_id_scope_mappings_realm_composite_get) | **GET** /{realm}/clients/{id}/scope-mappings/realm/composite | Get effective realm-level roles associated with the client’s scope   What this does is recurse  any composite roles associated with the client’s scope and adds the roles to this lists.
*ScopeMappingsApi* | [**realm_clients_id_scope_mappings_realm_delete**](docs/ScopeMappingsApi.md#realm_clients_id_scope_mappings_realm_delete) | **DELETE** /{realm}/clients/{id}/scope-mappings/realm | Remove a set of realm-level roles from the client’s scope
*ScopeMappingsApi* | [**realm_clients_id_scope_mappings_realm_get**](docs/ScopeMappingsApi.md#realm_clients_id_scope_mappings_realm_get) | **GET** /{realm}/clients/{id}/scope-mappings/realm | Get realm-level roles associated with the client’s scope
*ScopeMappingsApi* | [**realm_clients_id_scope_mappings_realm_post**](docs/ScopeMappingsApi.md#realm_clients_id_scope_mappings_realm_post) | **POST** /{realm}/clients/{id}/scope-mappings/realm | Add a set of realm-level roles to the client’s scope
*UserStorageProviderApi* | [**id_name_get**](docs/UserStorageProviderApi.md#id_name_get) | **GET** /{id}/name | Need this for admin console to display simple name of provider when displaying client detail   KEYCLOAK-4328
*UserStorageProviderApi* | [**realm_user_storage_id_name_get**](docs/UserStorageProviderApi.md#realm_user_storage_id_name_get) | **GET** /{realm}/user-storage/{id}/name | Need this for admin console to display simple name of provider when displaying user detail   KEYCLOAK-4328
*UserStorageProviderApi* | [**realm_user_storage_id_remove_imported_users_post**](docs/UserStorageProviderApi.md#realm_user_storage_id_remove_imported_users_post) | **POST** /{realm}/user-storage/{id}/remove-imported-users | Remove imported users
*UserStorageProviderApi* | [**realm_user_storage_id_sync_post**](docs/UserStorageProviderApi.md#realm_user_storage_id_sync_post) | **POST** /{realm}/user-storage/{id}/sync | Trigger sync of users   Action can be \&quot;triggerFullSync\&quot; or \&quot;triggerChangedUsersSync\&quot;
*UserStorageProviderApi* | [**realm_user_storage_id_unlink_users_post**](docs/UserStorageProviderApi.md#realm_user_storage_id_unlink_users_post) | **POST** /{realm}/user-storage/{id}/unlink-users | Unlink imported users from a storage provider
*UserStorageProviderApi* | [**realm_user_storage_parent_id_mappers_id_sync_post**](docs/UserStorageProviderApi.md#realm_user_storage_parent_id_mappers_id_sync_post) | **POST** /{realm}/user-storage/{parentId}/mappers/{id}/sync | Trigger sync of mapper data related to ldap mapper (roles, groups, …​)   direction is \&quot;fedToKeycloak\&quot; or \&quot;keycloakToFed\&quot;
*UsersApi* | [**realm_users_count_get**](docs/UsersApi.md#realm_users_count_get) | **GET** /{realm}/users/count | Returns the number of users that match the given criteria.
*UsersApi* | [**realm_users_get**](docs/UsersApi.md#realm_users_get) | **GET** /{realm}/users | Get users   Returns a stream of users, filtered according to query parameters.
*UsersApi* | [**realm_users_id_configured_user_storage_credential_types_get**](docs/UsersApi.md#realm_users_id_configured_user_storage_credential_types_get) | **GET** /{realm}/users/{id}/configured-user-storage-credential-types | Return credential types, which are provided by the user storage where user is stored.
*UsersApi* | [**realm_users_id_consents_client_delete**](docs/UsersApi.md#realm_users_id_consents_client_delete) | **DELETE** /{realm}/users/{id}/consents/{client} | Revoke consent and offline tokens for particular client from user
*UsersApi* | [**realm_users_id_consents_get**](docs/UsersApi.md#realm_users_id_consents_get) | **GET** /{realm}/users/{id}/consents | Get consents granted by the user
*UsersApi* | [**realm_users_id_credentials_credential_id_delete**](docs/UsersApi.md#realm_users_id_credentials_credential_id_delete) | **DELETE** /{realm}/users/{id}/credentials/{credentialId} | Remove a credential for a user
*UsersApi* | [**realm_users_id_credentials_credential_id_move_after_new_previous_credential_id_post**](docs/UsersApi.md#realm_users_id_credentials_credential_id_move_after_new_previous_credential_id_post) | **POST** /{realm}/users/{id}/credentials/{credentialId}/moveAfter/{newPreviousCredentialId} | Move a credential to a position behind another credential
*UsersApi* | [**realm_users_id_credentials_credential_id_move_to_first_post**](docs/UsersApi.md#realm_users_id_credentials_credential_id_move_to_first_post) | **POST** /{realm}/users/{id}/credentials/{credentialId}/moveToFirst | Move a credential to a first position in the credentials list of the user
*UsersApi* | [**realm_users_id_credentials_credential_id_user_label_put**](docs/UsersApi.md#realm_users_id_credentials_credential_id_user_label_put) | **PUT** /{realm}/users/{id}/credentials/{credentialId}/userLabel | Update a credential label for a user
*UsersApi* | [**realm_users_id_credentials_get**](docs/UsersApi.md#realm_users_id_credentials_get) | **GET** /{realm}/users/{id}/credentials | 
*UsersApi* | [**realm_users_id_delete**](docs/UsersApi.md#realm_users_id_delete) | **DELETE** /{realm}/users/{id} | Delete the user
*UsersApi* | [**realm_users_id_disable_credential_types_put**](docs/UsersApi.md#realm_users_id_disable_credential_types_put) | **PUT** /{realm}/users/{id}/disable-credential-types | Disable all credentials for a user of a specific type
*UsersApi* | [**realm_users_id_execute_actions_email_put**](docs/UsersApi.md#realm_users_id_execute_actions_email_put) | **PUT** /{realm}/users/{id}/execute-actions-email | Send a update account email to the user   An email contains a link the user can click to perform a set of required actions.
*UsersApi* | [**realm_users_id_federated_identity_get**](docs/UsersApi.md#realm_users_id_federated_identity_get) | **GET** /{realm}/users/{id}/federated-identity | Get social logins associated with the user
*UsersApi* | [**realm_users_id_federated_identity_provider_delete**](docs/UsersApi.md#realm_users_id_federated_identity_provider_delete) | **DELETE** /{realm}/users/{id}/federated-identity/{provider} | Remove a social login provider from user
*UsersApi* | [**realm_users_id_federated_identity_provider_post**](docs/UsersApi.md#realm_users_id_federated_identity_provider_post) | **POST** /{realm}/users/{id}/federated-identity/{provider} | Add a social login provider to the user
*UsersApi* | [**realm_users_id_get**](docs/UsersApi.md#realm_users_id_get) | **GET** /{realm}/users/{id} | Get representation of the user
*UsersApi* | [**realm_users_id_groups_count_get**](docs/UsersApi.md#realm_users_id_groups_count_get) | **GET** /{realm}/users/{id}/groups/count | 
*UsersApi* | [**realm_users_id_groups_get**](docs/UsersApi.md#realm_users_id_groups_get) | **GET** /{realm}/users/{id}/groups | 
*UsersApi* | [**realm_users_id_groups_group_id_delete**](docs/UsersApi.md#realm_users_id_groups_group_id_delete) | **DELETE** /{realm}/users/{id}/groups/{groupId} | 
*UsersApi* | [**realm_users_id_groups_group_id_put**](docs/UsersApi.md#realm_users_id_groups_group_id_put) | **PUT** /{realm}/users/{id}/groups/{groupId} | 
*UsersApi* | [**realm_users_id_impersonation_post**](docs/UsersApi.md#realm_users_id_impersonation_post) | **POST** /{realm}/users/{id}/impersonation | Impersonate the user
*UsersApi* | [**realm_users_id_logout_post**](docs/UsersApi.md#realm_users_id_logout_post) | **POST** /{realm}/users/{id}/logout | Remove all user sessions associated with the user   Also send notification to all clients that have an admin URL to invalidate the sessions for the particular user.
*UsersApi* | [**realm_users_id_offline_sessions_client_uuid_get**](docs/UsersApi.md#realm_users_id_offline_sessions_client_uuid_get) | **GET** /{realm}/users/{id}/offline-sessions/{clientUuid} | Get offline sessions associated with the user and client
*UsersApi* | [**realm_users_id_put**](docs/UsersApi.md#realm_users_id_put) | **PUT** /{realm}/users/{id} | Update the user
*UsersApi* | [**realm_users_id_reset_password_put**](docs/UsersApi.md#realm_users_id_reset_password_put) | **PUT** /{realm}/users/{id}/reset-password | Set up a new password for the user.
*UsersApi* | [**realm_users_id_send_verify_email_put**](docs/UsersApi.md#realm_users_id_send_verify_email_put) | **PUT** /{realm}/users/{id}/send-verify-email | Send an email-verification email to the user   An email contains a link the user can click to verify their email address.
*UsersApi* | [**realm_users_id_sessions_get**](docs/UsersApi.md#realm_users_id_sessions_get) | **GET** /{realm}/users/{id}/sessions | Get sessions associated with the user
*UsersApi* | [**realm_users_post**](docs/UsersApi.md#realm_users_post) | **POST** /{realm}/users | Create a new user   Username must be unique.
*UsersApi* | [**realm_users_profile_get**](docs/UsersApi.md#realm_users_profile_get) | **GET** /{realm}/users/profile | 
*UsersApi* | [**realm_users_profile_put**](docs/UsersApi.md#realm_users_profile_put) | **PUT** /{realm}/users/profile | 


## Documentation For Models

 - [AccessToken](docs/AccessToken.md)
 - [AccessTokenAccess](docs/AccessTokenAccess.md)
 - [AccessTokenAuthorization](docs/AccessTokenAuthorization.md)
 - [AccessTokenCertConf](docs/AccessTokenCertConf.md)
 - [AddressClaimSet](docs/AddressClaimSet.md)
 - [AuthenticationExecutionExportRepresentation](docs/AuthenticationExecutionExportRepresentation.md)
 - [AuthenticationExecutionInfoRepresentation](docs/AuthenticationExecutionInfoRepresentation.md)
 - [AuthenticationExecutionRepresentation](docs/AuthenticationExecutionRepresentation.md)
 - [AuthenticationFlowRepresentation](docs/AuthenticationFlowRepresentation.md)
 - [AuthenticatorConfigInfoRepresentation](docs/AuthenticatorConfigInfoRepresentation.md)
 - [AuthenticatorConfigRepresentation](docs/AuthenticatorConfigRepresentation.md)
 - [CertificateRepresentation](docs/CertificateRepresentation.md)
 - [ClientInitialAccessCreatePresentation](docs/ClientInitialAccessCreatePresentation.md)
 - [ClientInitialAccessPresentation](docs/ClientInitialAccessPresentation.md)
 - [ClientMappingsRepresentation](docs/ClientMappingsRepresentation.md)
 - [ClientPoliciesRepresentation](docs/ClientPoliciesRepresentation.md)
 - [ClientPolicyConditionRepresentation](docs/ClientPolicyConditionRepresentation.md)
 - [ClientPolicyExecutorRepresentation](docs/ClientPolicyExecutorRepresentation.md)
 - [ClientPolicyRepresentation](docs/ClientPolicyRepresentation.md)
 - [ClientProfileRepresentation](docs/ClientProfileRepresentation.md)
 - [ClientProfilesRepresentation](docs/ClientProfilesRepresentation.md)
 - [ClientRepresentation](docs/ClientRepresentation.md)
 - [ClientScopeEvaluateResourceProtocolMapperEvaluationRepresentation](docs/ClientScopeEvaluateResourceProtocolMapperEvaluationRepresentation.md)
 - [ClientScopeRepresentation](docs/ClientScopeRepresentation.md)
 - [ComponentExportRepresentation](docs/ComponentExportRepresentation.md)
 - [ComponentRepresentation](docs/ComponentRepresentation.md)
 - [ConfigPropertyRepresentation](docs/ConfigPropertyRepresentation.md)
 - [CredentialRepresentation](docs/CredentialRepresentation.md)
 - [FederatedIdentityRepresentation](docs/FederatedIdentityRepresentation.md)
 - [GlobalRequestResult](docs/GlobalRequestResult.md)
 - [GroupRepresentation](docs/GroupRepresentation.md)
 - [IDToken](docs/IDToken.md)
 - [IdentityProviderMapperRepresentation](docs/IdentityProviderMapperRepresentation.md)
 - [IdentityProviderRepresentation](docs/IdentityProviderRepresentation.md)
 - [JsonNode](docs/JsonNode.md)
 - [KeyStoreConfig](docs/KeyStoreConfig.md)
 - [KeysMetadataRepresentation](docs/KeysMetadataRepresentation.md)
 - [KeysMetadataRepresentationKeyMetadataRepresentation](docs/KeysMetadataRepresentationKeyMetadataRepresentation.md)
 - [ManagementPermissionReference](docs/ManagementPermissionReference.md)
 - [MappingsRepresentation](docs/MappingsRepresentation.md)
 - [MemoryInfoRepresentation](docs/MemoryInfoRepresentation.md)
 - [MultivaluedHashMap](docs/MultivaluedHashMap.md)
 - [PartialImportRepresentation](docs/PartialImportRepresentation.md)
 - [PasswordPolicyTypeRepresentation](docs/PasswordPolicyTypeRepresentation.md)
 - [Permission](docs/Permission.md)
 - [PolicyRepresentation](docs/PolicyRepresentation.md)
 - [ProfileInfoRepresentation](docs/ProfileInfoRepresentation.md)
 - [ProtocolMapperRepresentation](docs/ProtocolMapperRepresentation.md)
 - [ProviderRepresentation](docs/ProviderRepresentation.md)
 - [RealmEventsConfigRepresentation](docs/RealmEventsConfigRepresentation.md)
 - [RealmRepresentation](docs/RealmRepresentation.md)
 - [RequiredActionProviderRepresentation](docs/RequiredActionProviderRepresentation.md)
 - [ResourceRepresentation](docs/ResourceRepresentation.md)
 - [ResourceServerRepresentation](docs/ResourceServerRepresentation.md)
 - [RoleRepresentation](docs/RoleRepresentation.md)
 - [RoleRepresentationComposites](docs/RoleRepresentationComposites.md)
 - [RolesRepresentation](docs/RolesRepresentation.md)
 - [ScopeMappingRepresentation](docs/ScopeMappingRepresentation.md)
 - [ScopeRepresentation](docs/ScopeRepresentation.md)
 - [ServerInfoRepresentation](docs/ServerInfoRepresentation.md)
 - [SpiInfoRepresentation](docs/SpiInfoRepresentation.md)
 - [SynchronizationResult](docs/SynchronizationResult.md)
 - [SystemInfoRepresentation](docs/SystemInfoRepresentation.md)
 - [TestLdapConnectionRepresentation](docs/TestLdapConnectionRepresentation.md)
 - [UserConsentRepresentation](docs/UserConsentRepresentation.md)
 - [UserFederationMapperRepresentation](docs/UserFederationMapperRepresentation.md)
 - [UserFederationProviderRepresentation](docs/UserFederationProviderRepresentation.md)
 - [UserRepresentation](docs/UserRepresentation.md)


## Documentation For Authorization


## access_token

- **Type**: Bearer authentication


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in keycloak_api.apis and keycloak_api.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from keycloak_api.api.default_api import DefaultApi`
- `from keycloak_api.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import keycloak_api
from keycloak_api.apis import *
from keycloak_api.models import *
```

