# delphix-dct-api
Delphix DCT API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.0.0
- Package version: 2.0.0.0rc1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://support.delphix.com](https://support.delphix.com)

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import delphix.api.gateway
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import delphix.api.gateway
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import delphix.api.gateway
from pprint import pprint
from delphix.api.gateway.api import api_clients_api
from delphix.api.gateway.model.api_client_create_parameter import ApiClientCreateParameter
from delphix.api.gateway.model.api_client_create_response import ApiClientCreateResponse
from delphix.api.gateway.model.list_api_clients_response import ListApiClientsResponse
from delphix.api.gateway.model.model_api_client import ModelApiClient
# Defining the host is optional and defaults to http://localhost/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = delphix.api.gateway.Configuration(
    host = "http://localhost/v2"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with delphix.api.gateway.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = api_clients_api.ApiClientsApi(api_client)
    api_client_create_parameter = ApiClientCreateParameter(
        name="name_example",
        generate_api_key=True,
        api_client_id="api_client_id_example",
    ) # ApiClientCreateParameter | 

    try:
        # Create a new API Client. 
        api_response = api_instance.create_api_client(api_client_create_parameter)
        pprint(api_response)
    except delphix.api.gateway.ApiException as e:
        print("Exception when calling ApiClientsApi->create_api_client: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApiClientsApi* | [**create_api_client**](docs/ApiClientsApi.md#create_api_client) | **POST** /management/api-clients | Create a new API Client. 
*ApiClientsApi* | [**delete_api_client**](docs/ApiClientsApi.md#delete_api_client) | **DELETE** /management/api-clients/{id} | Delete an API client
*ApiClientsApi* | [**get_api_client**](docs/ApiClientsApi.md#get_api_client) | **GET** /management/api-clients/{id} | Get an API client by id
*ApiClientsApi* | [**get_api_clients**](docs/ApiClientsApi.md#get_api_clients) | **GET** /management/api-clients | Returns a list of API clients.
*ApiClientsApi* | [**update_api_client**](docs/ApiClientsApi.md#update_api_client) | **PUT** /management/api-clients/{id} | Update an Api client. 
*BookmarksApi* | [**create_bookmark**](docs/BookmarksApi.md#create_bookmark) | **POST** /bookmarks | Create a bookmark at the current time.
*BookmarksApi* | [**delete_bookmark**](docs/BookmarksApi.md#delete_bookmark) | **DELETE** /bookmarks/{bookmarkId} | Delete a bookmark.
*BookmarksApi* | [**get_bookmark_by_id**](docs/BookmarksApi.md#get_bookmark_by_id) | **GET** /bookmarks/{bookmarkId} | Get a bookmark by ID.
*BookmarksApi* | [**get_bookmarks**](docs/BookmarksApi.md#get_bookmarks) | **GET** /bookmarks | List all bookmarks.
*BookmarksApi* | [**get_vdb_groups_by_bookmark**](docs/BookmarksApi.md#get_vdb_groups_by_bookmark) | **GET** /bookmarks/{bookmarkId}/vdb-groups | List VDB Groups compatible with this bookmark.
*BookmarksApi* | [**search_bookmarks**](docs/BookmarksApi.md#search_bookmarks) | **POST** /bookmarks/search | Search for bookmarks.
*ConnectivityApi* | [**connectivity_check**](docs/ConnectivityApi.md#connectivity_check) | **POST** /connectivity/check | Checks connectivity between an engine and a remote host machine on a given port.
*DSourcesApi* | [**create_tags_dsource**](docs/DSourcesApi.md#create_tags_dsource) | **POST** /dsources/{dsourceId}/tags | Create tags for a dSource.
*DSourcesApi* | [**delete_tags_dsource**](docs/DSourcesApi.md#delete_tags_dsource) | **POST** /dsources/{dsourceId}/tags/delete | Delete tags for a dSource.
*DSourcesApi* | [**get_dsource_by_id**](docs/DSourcesApi.md#get_dsource_by_id) | **GET** /dsources/{dsourceId} | Get a dSource by ID.
*DSourcesApi* | [**get_dsource_snapshots**](docs/DSourcesApi.md#get_dsource_snapshots) | **GET** /dsources/{dsourceId}/snapshots | List Snapshots for a dSource.
*DSourcesApi* | [**get_dsources**](docs/DSourcesApi.md#get_dsources) | **GET** /dsources | List all dSources.
*DSourcesApi* | [**get_tags_dsource**](docs/DSourcesApi.md#get_tags_dsource) | **GET** /dsources/{dsourceId}/tags | Get tags for a dSource.
*DSourcesApi* | [**search_dsources**](docs/DSourcesApi.md#search_dsources) | **POST** /dsources/search | Search for DSources.
*DSourcesApi* | [**snapshot_dsource**](docs/DSourcesApi.md#snapshot_dsource) | **POST** /dsources/{dsourceId}/snapshots | Snapshot a DSource.
*EnvironmentsApi* | [**create_environment**](docs/EnvironmentsApi.md#create_environment) | **POST** /environments | Create an environment.
*EnvironmentsApi* | [**create_environment_tags**](docs/EnvironmentsApi.md#create_environment_tags) | **POST** /environments/{environmentId}/tags | Create tags for an Environment.
*EnvironmentsApi* | [**create_environment_user**](docs/EnvironmentsApi.md#create_environment_user) | **POST** /environments/{environmentId}/users | Create environment user.
*EnvironmentsApi* | [**delete_environment**](docs/EnvironmentsApi.md#delete_environment) | **DELETE** /environments/{environmentId} | Delete an environment by ID.
*EnvironmentsApi* | [**delete_environment_tags**](docs/EnvironmentsApi.md#delete_environment_tags) | **POST** /environments/{environmentId}/tags/delete | Delete tags for an Environment.
*EnvironmentsApi* | [**delete_environment_user**](docs/EnvironmentsApi.md#delete_environment_user) | **DELETE** /environments/{environmentId}/users/{userRef} | Delete environment user.
*EnvironmentsApi* | [**disable_environment**](docs/EnvironmentsApi.md#disable_environment) | **POST** /environments/{environmentId}/disable | Disable environment.
*EnvironmentsApi* | [**enable_environment**](docs/EnvironmentsApi.md#enable_environment) | **POST** /environments/{environmentId}/enable | Enable a disabled environment.
*EnvironmentsApi* | [**get_environment_by_id**](docs/EnvironmentsApi.md#get_environment_by_id) | **GET** /environments/{environmentId} | Returns an environment by ID.
*EnvironmentsApi* | [**get_environments**](docs/EnvironmentsApi.md#get_environments) | **GET** /environments | List all environments.
*EnvironmentsApi* | [**get_tags_environment**](docs/EnvironmentsApi.md#get_tags_environment) | **GET** /environments/{environmentId}/tags | Get tags for an Environment.
*EnvironmentsApi* | [**list_environment_users**](docs/EnvironmentsApi.md#list_environment_users) | **GET** /environments/{environmentId}/users | List environment users.
*EnvironmentsApi* | [**primary_environment_user**](docs/EnvironmentsApi.md#primary_environment_user) | **POST** /environments/{environmentId}/users/{userRef}/primary | Set primary environment user.
*EnvironmentsApi* | [**refresh_environment**](docs/EnvironmentsApi.md#refresh_environment) | **POST** /environments/{environmentId}/refresh | Refresh environment.
*EnvironmentsApi* | [**search_environments**](docs/EnvironmentsApi.md#search_environments) | **POST** /environments/search | Search for environments.
*EnvironmentsApi* | [**update_environment**](docs/EnvironmentsApi.md#update_environment) | **PUT** /environments/{environmentId} | Update an environment by ID.
*EnvironmentsApi* | [**update_environment_user**](docs/EnvironmentsApi.md#update_environment_user) | **PUT** /environments/{environmentId}/users/{userRef} | Update environment user.
*JobsApi* | [**abandon_job**](docs/JobsApi.md#abandon_job) | **POST** /jobs/{jobId}/abandon | Abandons a job.
*JobsApi* | [**get_job_by_id**](docs/JobsApi.md#get_job_by_id) | **GET** /jobs/{jobId} | Returns a job by ID.
*ManagementApi* | [**create_engine_tags**](docs/ManagementApi.md#create_engine_tags) | **POST** /management/engines/{engineId}/tags | Create tags for a engine.
*ManagementApi* | [**create_hashicorp_vault**](docs/ManagementApi.md#create_hashicorp_vault) | **POST** /management/vaults/hashicorp | Configure a new Hashicorp Vault
*ManagementApi* | [**delete_engine_tags**](docs/ManagementApi.md#delete_engine_tags) | **POST** /management/engines/{engineId}/tags/delete | Delete tags for an Engine.
*ManagementApi* | [**delete_hashicorp_vault**](docs/ManagementApi.md#delete_hashicorp_vault) | **DELETE** /management/vaults/hashicorp/{vaultId} | Delete a Hashicorp vault by id
*ManagementApi* | [**get_engine_tags**](docs/ManagementApi.md#get_engine_tags) | **GET** /management/engines/{engineId}/tags | Get tags for a Engine.
*ManagementApi* | [**get_hashicorp_vault**](docs/ManagementApi.md#get_hashicorp_vault) | **GET** /management/vaults/hashicorp/{vaultId} | Get a Hashicorp vault by id
*ManagementApi* | [**get_hashicorp_vaults**](docs/ManagementApi.md#get_hashicorp_vaults) | **GET** /management/vaults/hashicorp | Returns a list of configured Hashicorp vaults.
*ManagementApi* | [**get_registered_engine**](docs/ManagementApi.md#get_registered_engine) | **GET** /management/engines/{engineId} | Returns a registered engine by ID.
*ManagementApi* | [**get_registered_engines**](docs/ManagementApi.md#get_registered_engines) | **GET** /management/engines | Returns a list of registered engines.
*ManagementApi* | [**get_smtp_config**](docs/ManagementApi.md#get_smtp_config) | **GET** /management/smtp | Returns the SMTP configuration
*ManagementApi* | [**register_engine**](docs/ManagementApi.md#register_engine) | **POST** /management/engines | Register an engine.
*ManagementApi* | [**search_engines**](docs/ManagementApi.md#search_engines) | **POST** /management/engines/search | Search for engines.
*ManagementApi* | [**unregister_engine**](docs/ManagementApi.md#unregister_engine) | **DELETE** /management/engines/{engineId} | Unregister an engine.
*ManagementApi* | [**update_registered_engine**](docs/ManagementApi.md#update_registered_engine) | **PUT** /management/engines/{engineId} | Update a registered engine.
*ManagementApi* | [**update_smtp_config**](docs/ManagementApi.md#update_smtp_config) | **PUT** /management/smtp | Update SMTP Config.
*ManagementApi* | [**validate_smtp_config**](docs/ManagementApi.md#validate_smtp_config) | **POST** /management/smtp/validate | Validate SMTP Config.
*ReportingApi* | [**create_reporting_schedule**](docs/ReportingApi.md#create_reporting_schedule) | **POST** /reporting/schedule | Create a new report schedule.
*ReportingApi* | [**delete_reporting_schedule**](docs/ReportingApi.md#delete_reporting_schedule) | **DELETE** /reporting/schedule/{reportId} | Delete report schedule by ID.
*ReportingApi* | [**get_api_usage_report**](docs/ReportingApi.md#get_api_usage_report) | **GET** /reporting/api-usage-report | Gets the report of API usage metrics over a given time period.
*ReportingApi* | [**get_dsource_usage_report**](docs/ReportingApi.md#get_dsource_usage_report) | **GET** /reporting/dsource-usage-report | Gets the usage report for virtualization engine dSources.
*ReportingApi* | [**get_product_info**](docs/ReportingApi.md#get_product_info) | **GET** /reporting/product_info | Returns the DCT Product Information.
*ReportingApi* | [**get_reporting_schedule_by_id**](docs/ReportingApi.md#get_reporting_schedule_by_id) | **GET** /reporting/schedule/{reportId} | Returns a report schedule by ID.
*ReportingApi* | [**get_reporting_schedules**](docs/ReportingApi.md#get_reporting_schedules) | **GET** /reporting/schedule | List all report schedules.
*ReportingApi* | [**get_vdb_inventory_report**](docs/ReportingApi.md#get_vdb_inventory_report) | **GET** /reporting/vdb-inventory-report | Gets the inventory report for virtualization engine VDBs.
*ReportingApi* | [**get_virtualization_storage_summary_report**](docs/ReportingApi.md#get_virtualization_storage_summary_report) | **GET** /reporting/virtualization-storage-summary-report | Gets the storage summary report for virtualization engines.
*ReportingApi* | [**update_reporting_schedule**](docs/ReportingApi.md#update_reporting_schedule) | **PUT** /reporting/schedule/{reportId} | Update a reporting schedule by ID.
*SnapshotsApi* | [**get_snapshot_by_id**](docs/SnapshotsApi.md#get_snapshot_by_id) | **GET** /snapshots/{snapshotId} | Get a Snapshot by ID.
*SourcesApi* | [**get_source_by_id**](docs/SourcesApi.md#get_source_by_id) | **GET** /sources/{sourceId} | Get a source by ID.
*SourcesApi* | [**get_sources**](docs/SourcesApi.md#get_sources) | **GET** /sources | List all sources.
*SourcesApi* | [**search_sources**](docs/SourcesApi.md#search_sources) | **POST** /sources/search | Search for Sources.
*VDBGroupsApi* | [**create_vdb_group**](docs/VDBGroupsApi.md#create_vdb_group) | **POST** /vdb-groups | Create a new VDBGroup.
*VDBGroupsApi* | [**delete_vdb_group**](docs/VDBGroupsApi.md#delete_vdb_group) | **DELETE** /vdb-groups/{vdbGroupId} | Delete a VDBGoup.
*VDBGroupsApi* | [**get_bookmarks_by_vdb_group**](docs/VDBGroupsApi.md#get_bookmarks_by_vdb_group) | **GET** /vdb-groups/{vdbGroupId}/bookmarks | List bookmarks compatible with this VDB Group.
*VDBGroupsApi* | [**get_vdb_group**](docs/VDBGroupsApi.md#get_vdb_group) | **GET** /vdb-groups/{vdbGroupId} | Get a VDBGroup by name.
*VDBGroupsApi* | [**get_vdb_groups**](docs/VDBGroupsApi.md#get_vdb_groups) | **GET** /vdb-groups | List all VDBGroups.
*VDBGroupsApi* | [**provision_vdb_group_from_bookmark**](docs/VDBGroupsApi.md#provision_vdb_group_from_bookmark) | **POST** /vdb-groups/provision_from_bookmark | Provision a new VDB Group from a Bookmark.
*VDBGroupsApi* | [**refresh_vdb_group**](docs/VDBGroupsApi.md#refresh_vdb_group) | **POST** /vdb-groups/{vdbGroupId}/refresh | Refresh a VDBGroup.
*VDBGroupsApi* | [**rollback_vdb_group**](docs/VDBGroupsApi.md#rollback_vdb_group) | **POST** /vdb-groups/{vdbGroupId}/rollback | Rollback a VDBGroup.
*VDBGroupsApi* | [**search_vdb_groups**](docs/VDBGroupsApi.md#search_vdb_groups) | **POST** /vdb-groups/search | Search for VDB Groups.
*VDBGroupsApi* | [**update_vdb_group_by_id**](docs/VDBGroupsApi.md#update_vdb_group_by_id) | **PATCH** /vdb-groups/{vdbGroupId} | Update values of a VDB group.
*VDBsApi* | [**create_vdb_tags**](docs/VDBsApi.md#create_vdb_tags) | **POST** /vdbs/{vdbId}/tags | Create tags for a VDB.
*VDBsApi* | [**delete_vdb**](docs/VDBsApi.md#delete_vdb) | **POST** /vdbs/{vdbId}/delete | Delete a VDB.
*VDBsApi* | [**delete_vdb_tags**](docs/VDBsApi.md#delete_vdb_tags) | **POST** /vdbs/{vdbId}/tags/delete | Delete tags for a VDB.
*VDBsApi* | [**disable_vdb**](docs/VDBsApi.md#disable_vdb) | **POST** /vdbs/{vdbId}/disable | Disable a VDB.
*VDBsApi* | [**enable_vdb**](docs/VDBsApi.md#enable_vdb) | **POST** /vdbs/{vdbId}/enable | Enable a VDB.
*VDBsApi* | [**get_tags_vdb**](docs/VDBsApi.md#get_tags_vdb) | **GET** /vdbs/{vdbId}/tags | Get tags for a VDB.
*VDBsApi* | [**get_vdb_by_id**](docs/VDBsApi.md#get_vdb_by_id) | **GET** /vdbs/{vdbId} | Get a VDB by ID.
*VDBsApi* | [**get_vdb_snapshots**](docs/VDBsApi.md#get_vdb_snapshots) | **GET** /vdbs/{vdbId}/snapshots | List Snapshots for a VDB.
*VDBsApi* | [**get_vdbs**](docs/VDBsApi.md#get_vdbs) | **GET** /vdbs | List all vdbs.
*VDBsApi* | [**provision_vdb_by_snapshot**](docs/VDBsApi.md#provision_vdb_by_snapshot) | **POST** /vdbs/provision_by_snapshot | Provision a new VDB by snapshot.
*VDBsApi* | [**provision_vdb_by_timestamp**](docs/VDBsApi.md#provision_vdb_by_timestamp) | **POST** /vdbs/provision_by_timestamp | Provision a new VDB by timestamp.
*VDBsApi* | [**provision_vdb_from_bookmark**](docs/VDBsApi.md#provision_vdb_from_bookmark) | **POST** /vdbs/provision_from_bookmark | Provision a new VDB from a bookmark with a single VDB.
*VDBsApi* | [**refresh_vdb_by_snapshot**](docs/VDBsApi.md#refresh_vdb_by_snapshot) | **POST** /vdbs/{vdbId}/refresh_by_snapshot | Refresh a VDB by snapshot.
*VDBsApi* | [**refresh_vdb_by_timestamp**](docs/VDBsApi.md#refresh_vdb_by_timestamp) | **POST** /vdbs/{vdbId}/refresh_by_timestamp | Refresh a VDB by timestamp.
*VDBsApi* | [**refresh_vdb_from_bookmark**](docs/VDBsApi.md#refresh_vdb_from_bookmark) | **POST** /vdbs/{vdbId}/refresh_from_bookmark | Refresh a VDB from bookmark with a single VDB.
*VDBsApi* | [**rollback_vdb_by_snapshot**](docs/VDBsApi.md#rollback_vdb_by_snapshot) | **POST** /vdbs/{vdbId}/rollback_by_snapshot | Rollback a VDB by snapshot.
*VDBsApi* | [**rollback_vdb_by_timestamp**](docs/VDBsApi.md#rollback_vdb_by_timestamp) | **POST** /vdbs/{vdbId}/rollback_by_timestamp | Rollback a VDB by timestamp.
*VDBsApi* | [**rollback_vdb_from_bookmark**](docs/VDBsApi.md#rollback_vdb_from_bookmark) | **POST** /vdbs/{vdbId}/rollback_from_bookmark | Rollback a VDB from a bookmark with only the same VDB.
*VDBsApi* | [**search_vdbs**](docs/VDBsApi.md#search_vdbs) | **POST** /vdbs/search | Search for VDBs.
*VDBsApi* | [**snapshot_vdb**](docs/VDBsApi.md#snapshot_vdb) | **POST** /vdbs/{vdbId}/snapshots | Snapshot a VDB.
*VDBsApi* | [**start_vdb**](docs/VDBsApi.md#start_vdb) | **POST** /vdbs/{vdbId}/start | Start a VDB.
*VDBsApi* | [**stop_vdb**](docs/VDBsApi.md#stop_vdb) | **POST** /vdbs/{vdbId}/stop | Stop a VDB.
*VDBsApi* | [**update_vdb_by_id**](docs/VDBsApi.md#update_vdb_by_id) | **PATCH** /vdbs/{vdbId} | Update values of a VDB


## Documentation For Models

 - [ApiClientCreateParameter](docs/ApiClientCreateParameter.md)
 - [ApiClientCreateResponse](docs/ApiClientCreateResponse.md)
 - [ApiUsageData](docs/ApiUsageData.md)
 - [ApiUsageReportResponse](docs/ApiUsageReportResponse.md)
 - [BaseProvisionVDBParameters](docs/BaseProvisionVDBParameters.md)
 - [BaseProvisionVDBParametersAllOf](docs/BaseProvisionVDBParametersAllOf.md)
 - [Bookmark](docs/Bookmark.md)
 - [ConnectivityCheckParameters](docs/ConnectivityCheckParameters.md)
 - [ConnectivityCheckResponse](docs/ConnectivityCheckResponse.md)
 - [CreateBookmarkResponse](docs/CreateBookmarkResponse.md)
 - [CreateEnvironmentResponse](docs/CreateEnvironmentResponse.md)
 - [CreateEnvironmentUserResponse](docs/CreateEnvironmentUserResponse.md)
 - [CreateVDBGroupRequest](docs/CreateVDBGroupRequest.md)
 - [CreateVDBGroupResponse](docs/CreateVDBGroupResponse.md)
 - [DSource](docs/DSource.md)
 - [DSourceSnapshotParameters](docs/DSourceSnapshotParameters.md)
 - [DSourceUsageData](docs/DSourceUsageData.md)
 - [DSourceUsageReportResponse](docs/DSourceUsageReportResponse.md)
 - [DataPointBySnapshotParameters](docs/DataPointBySnapshotParameters.md)
 - [DataPointByTimestampParameters](docs/DataPointByTimestampParameters.md)
 - [DataPointFromBookmarkParameters](docs/DataPointFromBookmarkParameters.md)
 - [DeleteEngineResponse](docs/DeleteEngineResponse.md)
 - [DeleteEnvironmentResponse](docs/DeleteEnvironmentResponse.md)
 - [DeleteEnvironmentUserResponse](docs/DeleteEnvironmentUserResponse.md)
 - [DeleteTag](docs/DeleteTag.md)
 - [DeleteVDBParameters](docs/DeleteVDBParameters.md)
 - [DeleteVDBResponse](docs/DeleteVDBResponse.md)
 - [DisableEnvironmentResponse](docs/DisableEnvironmentResponse.md)
 - [DisableVDBParameters](docs/DisableVDBParameters.md)
 - [DisableVDBResponse](docs/DisableVDBResponse.md)
 - [EnableEnvironmentResponse](docs/EnableEnvironmentResponse.md)
 - [EnableVDBParameters](docs/EnableVDBParameters.md)
 - [EnableVDBResponse](docs/EnableVDBResponse.md)
 - [Engine](docs/Engine.md)
 - [EngineRegistrationParameter](docs/EngineRegistrationParameter.md)
 - [Environment](docs/Environment.md)
 - [EnvironmentCreateParameters](docs/EnvironmentCreateParameters.md)
 - [EnvironmentUpdateParameters](docs/EnvironmentUpdateParameters.md)
 - [EnvironmentUser](docs/EnvironmentUser.md)
 - [EnvironmentUserParams](docs/EnvironmentUserParams.md)
 - [Error](docs/Error.md)
 - [Errors](docs/Errors.md)
 - [HashicorpVault](docs/HashicorpVault.md)
 - [Hook](docs/Hook.md)
 - [Host](docs/Host.md)
 - [Job](docs/Job.md)
 - [ListApiClientsResponse](docs/ListApiClientsResponse.md)
 - [ListBookmarksByVDBGroupsResponse](docs/ListBookmarksByVDBGroupsResponse.md)
 - [ListBookmarksResponse](docs/ListBookmarksResponse.md)
 - [ListDSourcesResponse](docs/ListDSourcesResponse.md)
 - [ListEnvironmentUsers](docs/ListEnvironmentUsers.md)
 - [ListEnvironmentsResponse](docs/ListEnvironmentsResponse.md)
 - [ListHashicorpVaultsResponse](docs/ListHashicorpVaultsResponse.md)
 - [ListRegisteredEnginesResponse](docs/ListRegisteredEnginesResponse.md)
 - [ListReportingScheduleResponse](docs/ListReportingScheduleResponse.md)
 - [ListSnapshotsResponse](docs/ListSnapshotsResponse.md)
 - [ListSourcesResponse](docs/ListSourcesResponse.md)
 - [ListVDBGroupsByBookmarkResponse](docs/ListVDBGroupsByBookmarkResponse.md)
 - [ListVDBGroupsResponse](docs/ListVDBGroupsResponse.md)
 - [ListVDBsResponse](docs/ListVDBsResponse.md)
 - [ModelApiClient](docs/ModelApiClient.md)
 - [PaginatedResponseMetadata](docs/PaginatedResponseMetadata.md)
 - [PrimaryEnvironmentUserResponse](docs/PrimaryEnvironmentUserResponse.md)
 - [ProductHistory](docs/ProductHistory.md)
 - [ProductInfo](docs/ProductInfo.md)
 - [ProvisionVDBBySnapshotParameters](docs/ProvisionVDBBySnapshotParameters.md)
 - [ProvisionVDBBySnapshotParametersAllOf](docs/ProvisionVDBBySnapshotParametersAllOf.md)
 - [ProvisionVDBByTimestampParameters](docs/ProvisionVDBByTimestampParameters.md)
 - [ProvisionVDBByTimestampParametersAllOf](docs/ProvisionVDBByTimestampParametersAllOf.md)
 - [ProvisionVDBFromBookmarkParameters](docs/ProvisionVDBFromBookmarkParameters.md)
 - [ProvisionVDBGroupFromBookmarkParameters](docs/ProvisionVDBGroupFromBookmarkParameters.md)
 - [ProvisionVDBGroupFromBookmarkResponse](docs/ProvisionVDBGroupFromBookmarkResponse.md)
 - [ProvisionVDBResponse](docs/ProvisionVDBResponse.md)
 - [RefreshEnvironmentResponse](docs/RefreshEnvironmentResponse.md)
 - [RefreshVDBBySnapshotParameters](docs/RefreshVDBBySnapshotParameters.md)
 - [RefreshVDBBySnapshotResponse](docs/RefreshVDBBySnapshotResponse.md)
 - [RefreshVDBByTimestampParameters](docs/RefreshVDBByTimestampParameters.md)
 - [RefreshVDBByTimestampParametersAllOf](docs/RefreshVDBByTimestampParametersAllOf.md)
 - [RefreshVDBByTimestampResponse](docs/RefreshVDBByTimestampResponse.md)
 - [RefreshVDBFromBookmarkParameters](docs/RefreshVDBFromBookmarkParameters.md)
 - [RefreshVDBFromBookmarkResponse](docs/RefreshVDBFromBookmarkResponse.md)
 - [RefreshVDBGroupParameters](docs/RefreshVDBGroupParameters.md)
 - [RefreshVDBGroupResponse](docs/RefreshVDBGroupResponse.md)
 - [RegisteredEngine](docs/RegisteredEngine.md)
 - [ReportingSchedule](docs/ReportingSchedule.md)
 - [Repository](docs/Repository.md)
 - [RollbackVDBBySnapshotParameters](docs/RollbackVDBBySnapshotParameters.md)
 - [RollbackVDBBySnapshotResponse](docs/RollbackVDBBySnapshotResponse.md)
 - [RollbackVDBByTimestampParameters](docs/RollbackVDBByTimestampParameters.md)
 - [RollbackVDBByTimestampResponse](docs/RollbackVDBByTimestampResponse.md)
 - [RollbackVDBFromBookmarkParameters](docs/RollbackVDBFromBookmarkParameters.md)
 - [RollbackVDBFromBookmarkResponse](docs/RollbackVDBFromBookmarkResponse.md)
 - [RollbackVDBGroupParameters](docs/RollbackVDBGroupParameters.md)
 - [RollbackVDBGroupResponse](docs/RollbackVDBGroupResponse.md)
 - [SMTPConfigParams](docs/SMTPConfigParams.md)
 - [SMTPConfigValidate](docs/SMTPConfigValidate.md)
 - [SearchBody](docs/SearchBody.md)
 - [SearchBookmarksResponse](docs/SearchBookmarksResponse.md)
 - [SearchDSourcesResponse](docs/SearchDSourcesResponse.md)
 - [SearchEnginesResponse](docs/SearchEnginesResponse.md)
 - [SearchEnvironmentsResponse](docs/SearchEnvironmentsResponse.md)
 - [SearchSourcesResponse](docs/SearchSourcesResponse.md)
 - [SearchVDBGroupResponse](docs/SearchVDBGroupResponse.md)
 - [SearchVDBsResponse](docs/SearchVDBsResponse.md)
 - [Snapshot](docs/Snapshot.md)
 - [SnapshotDSourceResponse](docs/SnapshotDSourceResponse.md)
 - [SnapshotVDBResponse](docs/SnapshotVDBResponse.md)
 - [Source](docs/Source.md)
 - [StartVDBResponse](docs/StartVDBResponse.md)
 - [StopVDBResponse](docs/StopVDBResponse.md)
 - [Tag](docs/Tag.md)
 - [TagsRequest](docs/TagsRequest.md)
 - [TagsResponse](docs/TagsResponse.md)
 - [UpdateEnvironmentResponse](docs/UpdateEnvironmentResponse.md)
 - [UpdateEnvironmentUserResponse](docs/UpdateEnvironmentUserResponse.md)
 - [UpdateVDBGroupParameters](docs/UpdateVDBGroupParameters.md)
 - [UpdateVDBParameters](docs/UpdateVDBParameters.md)
 - [UpdateVDBResponse](docs/UpdateVDBResponse.md)
 - [VDB](docs/VDB.md)
 - [VDBGroup](docs/VDBGroup.md)
 - [VDBInventoryData](docs/VDBInventoryData.md)
 - [VDBInventoryReportResponse](docs/VDBInventoryReportResponse.md)
 - [VirtualDatasetHooks](docs/VirtualDatasetHooks.md)
 - [VirtualizationStorageSummaryData](docs/VirtualizationStorageSummaryData.md)
 - [VirtualizationStorageSummaryReportResponse](docs/VirtualizationStorageSummaryReportResponse.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

support@delphix.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in delphix.api.gateway.apis and delphix.api.gateway.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from delphix.api.gateway.api.default_api import DefaultApi`
- `from delphix.api.gateway.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import delphix.api.gateway
from delphix.api.gateway.apis import *
from delphix.api.gateway.models import *
```

