from functools import partial

import matplotlib.pyplot as plt
from PySpice.Spice.Netlist import Circuit
from PySpice.Unit import u_ns, u_ps, u_V

from sky130.config import PATH


def import_spice(name: str) -> Circuit:
    """Returns a Spice circuit model from a component name.
    based on
    https://github.com/chipsalliance/silicon-notebooks/blob/main/analog-inverter-magic.ipynb

    FIXME!
    """
    fields = name.split("_")
    library_name = "_".join(fields[0:4])
    library_path = PATH.spice / f"{library_name}.spice"
    circuit = Circuit(name)
    circuit.lib(library_path, name)
    # circuit.include('mosfet.spice')
    return circuit


sky130_fd_sc_hd__a2111o_1 = partial(import_spice, "sky130_fd_sc_hd__a2111o_1")
sky130_fd_sc_hd__a2111o_2 = partial(import_spice, "sky130_fd_sc_hd__a2111o_2")
sky130_fd_sc_hd__a2111o_4 = partial(import_spice, "sky130_fd_sc_hd__a2111o_4")
sky130_fd_sc_hd__a2111oi_0 = partial(import_spice, "sky130_fd_sc_hd__a2111oi_0")
sky130_fd_sc_hd__a2111oi_1 = partial(import_spice, "sky130_fd_sc_hd__a2111oi_1")
sky130_fd_sc_hd__a2111oi_2 = partial(import_spice, "sky130_fd_sc_hd__a2111oi_2")
sky130_fd_sc_hd__a2111oi_4 = partial(import_spice, "sky130_fd_sc_hd__a2111oi_4")
sky130_fd_sc_hd__a211o_1 = partial(import_spice, "sky130_fd_sc_hd__a211o_1")
sky130_fd_sc_hd__a211o_2 = partial(import_spice, "sky130_fd_sc_hd__a211o_2")
sky130_fd_sc_hd__a211o_4 = partial(import_spice, "sky130_fd_sc_hd__a211o_4")
sky130_fd_sc_hd__a211oi_1 = partial(import_spice, "sky130_fd_sc_hd__a211oi_1")
sky130_fd_sc_hd__a211oi_2 = partial(import_spice, "sky130_fd_sc_hd__a211oi_2")
sky130_fd_sc_hd__a211oi_4 = partial(import_spice, "sky130_fd_sc_hd__a211oi_4")
sky130_fd_sc_hd__a21bo_1 = partial(import_spice, "sky130_fd_sc_hd__a21bo_1")
sky130_fd_sc_hd__a21bo_2 = partial(import_spice, "sky130_fd_sc_hd__a21bo_2")
sky130_fd_sc_hd__a21bo_4 = partial(import_spice, "sky130_fd_sc_hd__a21bo_4")
sky130_fd_sc_hd__a21boi_0 = partial(import_spice, "sky130_fd_sc_hd__a21boi_0")
sky130_fd_sc_hd__a21boi_1 = partial(import_spice, "sky130_fd_sc_hd__a21boi_1")
sky130_fd_sc_hd__a21boi_2 = partial(import_spice, "sky130_fd_sc_hd__a21boi_2")
sky130_fd_sc_hd__a21boi_4 = partial(import_spice, "sky130_fd_sc_hd__a21boi_4")
sky130_fd_sc_hd__a21o_1 = partial(import_spice, "sky130_fd_sc_hd__a21o_1")
sky130_fd_sc_hd__a21o_2 = partial(import_spice, "sky130_fd_sc_hd__a21o_2")
sky130_fd_sc_hd__a21o_4 = partial(import_spice, "sky130_fd_sc_hd__a21o_4")
sky130_fd_sc_hd__a21oi_1 = partial(import_spice, "sky130_fd_sc_hd__a21oi_1")
sky130_fd_sc_hd__a21oi_2 = partial(import_spice, "sky130_fd_sc_hd__a21oi_2")
sky130_fd_sc_hd__a21oi_4 = partial(import_spice, "sky130_fd_sc_hd__a21oi_4")
sky130_fd_sc_hd__a221o_1 = partial(import_spice, "sky130_fd_sc_hd__a221o_1")
sky130_fd_sc_hd__a221o_2 = partial(import_spice, "sky130_fd_sc_hd__a221o_2")
sky130_fd_sc_hd__a221o_4 = partial(import_spice, "sky130_fd_sc_hd__a221o_4")
sky130_fd_sc_hd__a221oi_1 = partial(import_spice, "sky130_fd_sc_hd__a221oi_1")
sky130_fd_sc_hd__a221oi_2 = partial(import_spice, "sky130_fd_sc_hd__a221oi_2")
sky130_fd_sc_hd__a221oi_4 = partial(import_spice, "sky130_fd_sc_hd__a221oi_4")
sky130_fd_sc_hd__a222oi_1 = partial(import_spice, "sky130_fd_sc_hd__a222oi_1")
sky130_fd_sc_hd__a22o_1 = partial(import_spice, "sky130_fd_sc_hd__a22o_1")
sky130_fd_sc_hd__a22o_2 = partial(import_spice, "sky130_fd_sc_hd__a22o_2")
sky130_fd_sc_hd__a22o_4 = partial(import_spice, "sky130_fd_sc_hd__a22o_4")
sky130_fd_sc_hd__a22oi_1 = partial(import_spice, "sky130_fd_sc_hd__a22oi_1")
sky130_fd_sc_hd__a22oi_2 = partial(import_spice, "sky130_fd_sc_hd__a22oi_2")
sky130_fd_sc_hd__a22oi_4 = partial(import_spice, "sky130_fd_sc_hd__a22oi_4")
sky130_fd_sc_hd__a2bb2o_1 = partial(import_spice, "sky130_fd_sc_hd__a2bb2o_1")
sky130_fd_sc_hd__a2bb2o_2 = partial(import_spice, "sky130_fd_sc_hd__a2bb2o_2")
sky130_fd_sc_hd__a2bb2o_4 = partial(import_spice, "sky130_fd_sc_hd__a2bb2o_4")
sky130_fd_sc_hd__a2bb2oi_1 = partial(import_spice, "sky130_fd_sc_hd__a2bb2oi_1")
sky130_fd_sc_hd__a2bb2oi_2 = partial(import_spice, "sky130_fd_sc_hd__a2bb2oi_2")
sky130_fd_sc_hd__a2bb2oi_4 = partial(import_spice, "sky130_fd_sc_hd__a2bb2oi_4")
sky130_fd_sc_hd__a311o_1 = partial(import_spice, "sky130_fd_sc_hd__a311o_1")
sky130_fd_sc_hd__a311o_2 = partial(import_spice, "sky130_fd_sc_hd__a311o_2")
sky130_fd_sc_hd__a311o_4 = partial(import_spice, "sky130_fd_sc_hd__a311o_4")
sky130_fd_sc_hd__a311oi_1 = partial(import_spice, "sky130_fd_sc_hd__a311oi_1")
sky130_fd_sc_hd__a311oi_2 = partial(import_spice, "sky130_fd_sc_hd__a311oi_2")
sky130_fd_sc_hd__a311oi_4 = partial(import_spice, "sky130_fd_sc_hd__a311oi_4")
sky130_fd_sc_hd__a31o_1 = partial(import_spice, "sky130_fd_sc_hd__a31o_1")
sky130_fd_sc_hd__a31o_2 = partial(import_spice, "sky130_fd_sc_hd__a31o_2")
sky130_fd_sc_hd__a31o_4 = partial(import_spice, "sky130_fd_sc_hd__a31o_4")
sky130_fd_sc_hd__a31oi_1 = partial(import_spice, "sky130_fd_sc_hd__a31oi_1")
sky130_fd_sc_hd__a31oi_2 = partial(import_spice, "sky130_fd_sc_hd__a31oi_2")
sky130_fd_sc_hd__a31oi_4 = partial(import_spice, "sky130_fd_sc_hd__a31oi_4")
sky130_fd_sc_hd__a32o_1 = partial(import_spice, "sky130_fd_sc_hd__a32o_1")
sky130_fd_sc_hd__a32o_2 = partial(import_spice, "sky130_fd_sc_hd__a32o_2")
sky130_fd_sc_hd__a32o_4 = partial(import_spice, "sky130_fd_sc_hd__a32o_4")
sky130_fd_sc_hd__a32oi_1 = partial(import_spice, "sky130_fd_sc_hd__a32oi_1")
sky130_fd_sc_hd__a32oi_2 = partial(import_spice, "sky130_fd_sc_hd__a32oi_2")
sky130_fd_sc_hd__a32oi_4 = partial(import_spice, "sky130_fd_sc_hd__a32oi_4")
sky130_fd_sc_hd__a41o_1 = partial(import_spice, "sky130_fd_sc_hd__a41o_1")
sky130_fd_sc_hd__a41o_2 = partial(import_spice, "sky130_fd_sc_hd__a41o_2")
sky130_fd_sc_hd__a41o_4 = partial(import_spice, "sky130_fd_sc_hd__a41o_4")
sky130_fd_sc_hd__a41oi_1 = partial(import_spice, "sky130_fd_sc_hd__a41oi_1")
sky130_fd_sc_hd__a41oi_2 = partial(import_spice, "sky130_fd_sc_hd__a41oi_2")
sky130_fd_sc_hd__a41oi_4 = partial(import_spice, "sky130_fd_sc_hd__a41oi_4")
sky130_fd_sc_hd__and2_0 = partial(import_spice, "sky130_fd_sc_hd__and2_0")
sky130_fd_sc_hd__and2_1 = partial(import_spice, "sky130_fd_sc_hd__and2_1")
sky130_fd_sc_hd__and2_2 = partial(import_spice, "sky130_fd_sc_hd__and2_2")
sky130_fd_sc_hd__and2_4 = partial(import_spice, "sky130_fd_sc_hd__and2_4")
sky130_fd_sc_hd__and2b_1 = partial(import_spice, "sky130_fd_sc_hd__and2b_1")
sky130_fd_sc_hd__and2b_2 = partial(import_spice, "sky130_fd_sc_hd__and2b_2")
sky130_fd_sc_hd__and2b_4 = partial(import_spice, "sky130_fd_sc_hd__and2b_4")
sky130_fd_sc_hd__and3_1 = partial(import_spice, "sky130_fd_sc_hd__and3_1")
sky130_fd_sc_hd__and3_2 = partial(import_spice, "sky130_fd_sc_hd__and3_2")
sky130_fd_sc_hd__and3_4 = partial(import_spice, "sky130_fd_sc_hd__and3_4")
sky130_fd_sc_hd__and3b_1 = partial(import_spice, "sky130_fd_sc_hd__and3b_1")
sky130_fd_sc_hd__and3b_2 = partial(import_spice, "sky130_fd_sc_hd__and3b_2")
sky130_fd_sc_hd__and3b_4 = partial(import_spice, "sky130_fd_sc_hd__and3b_4")
sky130_fd_sc_hd__and4_1 = partial(import_spice, "sky130_fd_sc_hd__and4_1")
sky130_fd_sc_hd__and4_2 = partial(import_spice, "sky130_fd_sc_hd__and4_2")
sky130_fd_sc_hd__and4_4 = partial(import_spice, "sky130_fd_sc_hd__and4_4")
sky130_fd_sc_hd__and4b_1 = partial(import_spice, "sky130_fd_sc_hd__and4b_1")
sky130_fd_sc_hd__and4b_2 = partial(import_spice, "sky130_fd_sc_hd__and4b_2")
sky130_fd_sc_hd__and4b_4 = partial(import_spice, "sky130_fd_sc_hd__and4b_4")
sky130_fd_sc_hd__and4bb_1 = partial(import_spice, "sky130_fd_sc_hd__and4bb_1")
sky130_fd_sc_hd__and4bb_2 = partial(import_spice, "sky130_fd_sc_hd__and4bb_2")
sky130_fd_sc_hd__and4bb_4 = partial(import_spice, "sky130_fd_sc_hd__and4bb_4")
sky130_fd_sc_hd__buf_1 = partial(import_spice, "sky130_fd_sc_hd__buf_1")
sky130_fd_sc_hd__buf_12 = partial(import_spice, "sky130_fd_sc_hd__buf_12")
sky130_fd_sc_hd__buf_16 = partial(import_spice, "sky130_fd_sc_hd__buf_16")
sky130_fd_sc_hd__buf_2 = partial(import_spice, "sky130_fd_sc_hd__buf_2")
sky130_fd_sc_hd__buf_4 = partial(import_spice, "sky130_fd_sc_hd__buf_4")
sky130_fd_sc_hd__buf_6 = partial(import_spice, "sky130_fd_sc_hd__buf_6")
sky130_fd_sc_hd__buf_8 = partial(import_spice, "sky130_fd_sc_hd__buf_8")
sky130_fd_sc_hd__bufbuf_16 = partial(import_spice, "sky130_fd_sc_hd__bufbuf_16")
sky130_fd_sc_hd__bufbuf_8 = partial(import_spice, "sky130_fd_sc_hd__bufbuf_8")
sky130_fd_sc_hd__bufinv_16 = partial(import_spice, "sky130_fd_sc_hd__bufinv_16")
sky130_fd_sc_hd__bufinv_8 = partial(import_spice, "sky130_fd_sc_hd__bufinv_8")
sky130_fd_sc_hd__clkbuf_1 = partial(import_spice, "sky130_fd_sc_hd__clkbuf_1")
sky130_fd_sc_hd__clkbuf_16 = partial(import_spice, "sky130_fd_sc_hd__clkbuf_16")
sky130_fd_sc_hd__clkbuf_2 = partial(import_spice, "sky130_fd_sc_hd__clkbuf_2")
sky130_fd_sc_hd__clkbuf_4 = partial(import_spice, "sky130_fd_sc_hd__clkbuf_4")
sky130_fd_sc_hd__clkbuf_8 = partial(import_spice, "sky130_fd_sc_hd__clkbuf_8")
sky130_fd_sc_hd__clkdlybuf4s15_1 = partial(
    import_spice, "sky130_fd_sc_hd__clkdlybuf4s15_1"
)
sky130_fd_sc_hd__clkdlybuf4s15_2 = partial(
    import_spice, "sky130_fd_sc_hd__clkdlybuf4s15_2"
)
sky130_fd_sc_hd__clkdlybuf4s18_1 = partial(
    import_spice, "sky130_fd_sc_hd__clkdlybuf4s18_1"
)
sky130_fd_sc_hd__clkdlybuf4s18_2 = partial(
    import_spice, "sky130_fd_sc_hd__clkdlybuf4s18_2"
)
sky130_fd_sc_hd__clkdlybuf4s25_1 = partial(
    import_spice, "sky130_fd_sc_hd__clkdlybuf4s25_1"
)
sky130_fd_sc_hd__clkdlybuf4s25_2 = partial(
    import_spice, "sky130_fd_sc_hd__clkdlybuf4s25_2"
)
sky130_fd_sc_hd__clkdlybuf4s50_1 = partial(
    import_spice, "sky130_fd_sc_hd__clkdlybuf4s50_1"
)
sky130_fd_sc_hd__clkdlybuf4s50_2 = partial(
    import_spice, "sky130_fd_sc_hd__clkdlybuf4s50_2"
)
sky130_fd_sc_hd__clkinv_1 = partial(import_spice, "sky130_fd_sc_hd__clkinv_1")
sky130_fd_sc_hd__clkinv_16 = partial(import_spice, "sky130_fd_sc_hd__clkinv_16")
sky130_fd_sc_hd__clkinv_2 = partial(import_spice, "sky130_fd_sc_hd__clkinv_2")
sky130_fd_sc_hd__clkinv_4 = partial(import_spice, "sky130_fd_sc_hd__clkinv_4")
sky130_fd_sc_hd__clkinv_8 = partial(import_spice, "sky130_fd_sc_hd__clkinv_8")
sky130_fd_sc_hd__clkinvlp_2 = partial(import_spice, "sky130_fd_sc_hd__clkinvlp_2")
sky130_fd_sc_hd__clkinvlp_4 = partial(import_spice, "sky130_fd_sc_hd__clkinvlp_4")
sky130_fd_sc_hd__conb_1 = partial(import_spice, "sky130_fd_sc_hd__conb_1")
sky130_fd_sc_hd__decap_12 = partial(import_spice, "sky130_fd_sc_hd__decap_12")
sky130_fd_sc_hd__decap_3 = partial(import_spice, "sky130_fd_sc_hd__decap_3")
sky130_fd_sc_hd__decap_4 = partial(import_spice, "sky130_fd_sc_hd__decap_4")
sky130_fd_sc_hd__decap_6 = partial(import_spice, "sky130_fd_sc_hd__decap_6")
sky130_fd_sc_hd__decap_8 = partial(import_spice, "sky130_fd_sc_hd__decap_8")
sky130_fd_sc_hd__dfbbn_1 = partial(import_spice, "sky130_fd_sc_hd__dfbbn_1")
sky130_fd_sc_hd__dfbbn_2 = partial(import_spice, "sky130_fd_sc_hd__dfbbn_2")
sky130_fd_sc_hd__dfbbp_1 = partial(import_spice, "sky130_fd_sc_hd__dfbbp_1")
sky130_fd_sc_hd__dfrbp_1 = partial(import_spice, "sky130_fd_sc_hd__dfrbp_1")
sky130_fd_sc_hd__dfrbp_2 = partial(import_spice, "sky130_fd_sc_hd__dfrbp_2")
sky130_fd_sc_hd__dfrtn_1 = partial(import_spice, "sky130_fd_sc_hd__dfrtn_1")
sky130_fd_sc_hd__dfrtp_1 = partial(import_spice, "sky130_fd_sc_hd__dfrtp_1")
sky130_fd_sc_hd__dfrtp_2 = partial(import_spice, "sky130_fd_sc_hd__dfrtp_2")
sky130_fd_sc_hd__dfrtp_4 = partial(import_spice, "sky130_fd_sc_hd__dfrtp_4")
sky130_fd_sc_hd__dfsbp_1 = partial(import_spice, "sky130_fd_sc_hd__dfsbp_1")
sky130_fd_sc_hd__dfsbp_2 = partial(import_spice, "sky130_fd_sc_hd__dfsbp_2")
sky130_fd_sc_hd__dfstp_1 = partial(import_spice, "sky130_fd_sc_hd__dfstp_1")
sky130_fd_sc_hd__dfstp_2 = partial(import_spice, "sky130_fd_sc_hd__dfstp_2")
sky130_fd_sc_hd__dfstp_4 = partial(import_spice, "sky130_fd_sc_hd__dfstp_4")
sky130_fd_sc_hd__dfxbp_1 = partial(import_spice, "sky130_fd_sc_hd__dfxbp_1")
sky130_fd_sc_hd__dfxbp_2 = partial(import_spice, "sky130_fd_sc_hd__dfxbp_2")
sky130_fd_sc_hd__dfxtp_1 = partial(import_spice, "sky130_fd_sc_hd__dfxtp_1")
sky130_fd_sc_hd__dfxtp_2 = partial(import_spice, "sky130_fd_sc_hd__dfxtp_2")
sky130_fd_sc_hd__dfxtp_4 = partial(import_spice, "sky130_fd_sc_hd__dfxtp_4")
sky130_fd_sc_hd__diode_2 = partial(import_spice, "sky130_fd_sc_hd__diode_2")
sky130_fd_sc_hd__dlclkp_1 = partial(import_spice, "sky130_fd_sc_hd__dlclkp_1")
sky130_fd_sc_hd__dlclkp_2 = partial(import_spice, "sky130_fd_sc_hd__dlclkp_2")
sky130_fd_sc_hd__dlclkp_4 = partial(import_spice, "sky130_fd_sc_hd__dlclkp_4")
sky130_fd_sc_hd__dlrbn_1 = partial(import_spice, "sky130_fd_sc_hd__dlrbn_1")
sky130_fd_sc_hd__dlrbn_2 = partial(import_spice, "sky130_fd_sc_hd__dlrbn_2")
sky130_fd_sc_hd__dlrbp_1 = partial(import_spice, "sky130_fd_sc_hd__dlrbp_1")
sky130_fd_sc_hd__dlrbp_2 = partial(import_spice, "sky130_fd_sc_hd__dlrbp_2")
sky130_fd_sc_hd__dlrtn_1 = partial(import_spice, "sky130_fd_sc_hd__dlrtn_1")
sky130_fd_sc_hd__dlrtn_2 = partial(import_spice, "sky130_fd_sc_hd__dlrtn_2")
sky130_fd_sc_hd__dlrtn_4 = partial(import_spice, "sky130_fd_sc_hd__dlrtn_4")
sky130_fd_sc_hd__dlrtp_1 = partial(import_spice, "sky130_fd_sc_hd__dlrtp_1")
sky130_fd_sc_hd__dlrtp_2 = partial(import_spice, "sky130_fd_sc_hd__dlrtp_2")
sky130_fd_sc_hd__dlrtp_4 = partial(import_spice, "sky130_fd_sc_hd__dlrtp_4")
sky130_fd_sc_hd__dlxbn_1 = partial(import_spice, "sky130_fd_sc_hd__dlxbn_1")
sky130_fd_sc_hd__dlxbn_2 = partial(import_spice, "sky130_fd_sc_hd__dlxbn_2")
sky130_fd_sc_hd__dlxbp_1 = partial(import_spice, "sky130_fd_sc_hd__dlxbp_1")
sky130_fd_sc_hd__dlxtn_1 = partial(import_spice, "sky130_fd_sc_hd__dlxtn_1")
sky130_fd_sc_hd__dlxtn_2 = partial(import_spice, "sky130_fd_sc_hd__dlxtn_2")
sky130_fd_sc_hd__dlxtn_4 = partial(import_spice, "sky130_fd_sc_hd__dlxtn_4")
sky130_fd_sc_hd__dlxtp_1 = partial(import_spice, "sky130_fd_sc_hd__dlxtp_1")
sky130_fd_sc_hd__dlygate4sd1_1 = partial(import_spice, "sky130_fd_sc_hd__dlygate4sd1_1")
sky130_fd_sc_hd__dlygate4sd2_1 = partial(import_spice, "sky130_fd_sc_hd__dlygate4sd2_1")
sky130_fd_sc_hd__dlygate4sd3_1 = partial(import_spice, "sky130_fd_sc_hd__dlygate4sd3_1")
sky130_fd_sc_hd__dlymetal6s2s_1 = partial(
    import_spice, "sky130_fd_sc_hd__dlymetal6s2s_1"
)
sky130_fd_sc_hd__dlymetal6s4s_1 = partial(
    import_spice, "sky130_fd_sc_hd__dlymetal6s4s_1"
)
sky130_fd_sc_hd__dlymetal6s6s_1 = partial(
    import_spice, "sky130_fd_sc_hd__dlymetal6s6s_1"
)
sky130_fd_sc_hd__ebufn_1 = partial(import_spice, "sky130_fd_sc_hd__ebufn_1")
sky130_fd_sc_hd__ebufn_2 = partial(import_spice, "sky130_fd_sc_hd__ebufn_2")
sky130_fd_sc_hd__ebufn_4 = partial(import_spice, "sky130_fd_sc_hd__ebufn_4")
sky130_fd_sc_hd__ebufn_8 = partial(import_spice, "sky130_fd_sc_hd__ebufn_8")
sky130_fd_sc_hd__edfxbp_1 = partial(import_spice, "sky130_fd_sc_hd__edfxbp_1")
sky130_fd_sc_hd__edfxtp_1 = partial(import_spice, "sky130_fd_sc_hd__edfxtp_1")
sky130_fd_sc_hd__einvn_0 = partial(import_spice, "sky130_fd_sc_hd__einvn_0")
sky130_fd_sc_hd__einvn_1 = partial(import_spice, "sky130_fd_sc_hd__einvn_1")
sky130_fd_sc_hd__einvn_2 = partial(import_spice, "sky130_fd_sc_hd__einvn_2")
sky130_fd_sc_hd__einvn_4 = partial(import_spice, "sky130_fd_sc_hd__einvn_4")
sky130_fd_sc_hd__einvn_8 = partial(import_spice, "sky130_fd_sc_hd__einvn_8")
sky130_fd_sc_hd__einvp_1 = partial(import_spice, "sky130_fd_sc_hd__einvp_1")
sky130_fd_sc_hd__einvp_2 = partial(import_spice, "sky130_fd_sc_hd__einvp_2")
sky130_fd_sc_hd__einvp_4 = partial(import_spice, "sky130_fd_sc_hd__einvp_4")
sky130_fd_sc_hd__einvp_8 = partial(import_spice, "sky130_fd_sc_hd__einvp_8")
sky130_fd_sc_hd__fa_1 = partial(import_spice, "sky130_fd_sc_hd__fa_1")
sky130_fd_sc_hd__fa_2 = partial(import_spice, "sky130_fd_sc_hd__fa_2")
sky130_fd_sc_hd__fa_4 = partial(import_spice, "sky130_fd_sc_hd__fa_4")
sky130_fd_sc_hd__fah_1 = partial(import_spice, "sky130_fd_sc_hd__fah_1")
sky130_fd_sc_hd__fahcin_1 = partial(import_spice, "sky130_fd_sc_hd__fahcin_1")
sky130_fd_sc_hd__fahcon_1 = partial(import_spice, "sky130_fd_sc_hd__fahcon_1")
sky130_fd_sc_hd__fill_1 = partial(import_spice, "sky130_fd_sc_hd__fill_1")
sky130_fd_sc_hd__fill_2 = partial(import_spice, "sky130_fd_sc_hd__fill_2")
sky130_fd_sc_hd__fill_4 = partial(import_spice, "sky130_fd_sc_hd__fill_4")
sky130_fd_sc_hd__fill_8 = partial(import_spice, "sky130_fd_sc_hd__fill_8")
sky130_fd_sc_hd__ha_1 = partial(import_spice, "sky130_fd_sc_hd__ha_1")
sky130_fd_sc_hd__ha_2 = partial(import_spice, "sky130_fd_sc_hd__ha_2")
sky130_fd_sc_hd__ha_4 = partial(import_spice, "sky130_fd_sc_hd__ha_4")
sky130_fd_sc_hd__inv_1 = partial(import_spice, "sky130_fd_sc_hd__inv_1")
sky130_fd_sc_hd__inv_12 = partial(import_spice, "sky130_fd_sc_hd__inv_12")
sky130_fd_sc_hd__inv_16 = partial(import_spice, "sky130_fd_sc_hd__inv_16")
sky130_fd_sc_hd__inv_2 = partial(import_spice, "sky130_fd_sc_hd__inv_2")
sky130_fd_sc_hd__inv_4 = partial(import_spice, "sky130_fd_sc_hd__inv_4")
sky130_fd_sc_hd__inv_6 = partial(import_spice, "sky130_fd_sc_hd__inv_6")
sky130_fd_sc_hd__inv_8 = partial(import_spice, "sky130_fd_sc_hd__inv_8")
sky130_fd_sc_hd__lpflow_bleeder_1 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_bleeder_1"
)
sky130_fd_sc_hd__lpflow_clkbufkapwr_1 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_clkbufkapwr_1"
)
sky130_fd_sc_hd__lpflow_clkbufkapwr_16 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_clkbufkapwr_16"
)
sky130_fd_sc_hd__lpflow_clkbufkapwr_2 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_clkbufkapwr_2"
)
sky130_fd_sc_hd__lpflow_clkbufkapwr_4 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_clkbufkapwr_4"
)
sky130_fd_sc_hd__lpflow_clkbufkapwr_8 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_clkbufkapwr_8"
)
sky130_fd_sc_hd__lpflow_clkinvkapwr_1 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_clkinvkapwr_1"
)
sky130_fd_sc_hd__lpflow_clkinvkapwr_16 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_clkinvkapwr_16"
)
sky130_fd_sc_hd__lpflow_clkinvkapwr_2 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_clkinvkapwr_2"
)
sky130_fd_sc_hd__lpflow_clkinvkapwr_4 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_clkinvkapwr_4"
)
sky130_fd_sc_hd__lpflow_clkinvkapwr_8 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_clkinvkapwr_8"
)
sky130_fd_sc_hd__lpflow_decapkapwr_12 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_decapkapwr_12"
)
sky130_fd_sc_hd__lpflow_decapkapwr_3 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_decapkapwr_3"
)
sky130_fd_sc_hd__lpflow_decapkapwr_4 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_decapkapwr_4"
)
sky130_fd_sc_hd__lpflow_decapkapwr_6 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_decapkapwr_6"
)
sky130_fd_sc_hd__lpflow_decapkapwr_8 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_decapkapwr_8"
)
sky130_fd_sc_hd__lpflow_inputiso0n_1 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_inputiso0n_1"
)
sky130_fd_sc_hd__lpflow_inputiso0p_1 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_inputiso0p_1"
)
sky130_fd_sc_hd__lpflow_inputiso1n_1 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_inputiso1n_1"
)
sky130_fd_sc_hd__lpflow_inputiso1p_1 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_inputiso1p_1"
)
sky130_fd_sc_hd__lpflow_inputisolatch_1 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_inputisolatch_1"
)
sky130_fd_sc_hd__lpflow_isobufsrc_1 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_isobufsrc_1"
)
sky130_fd_sc_hd__lpflow_isobufsrc_16 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_isobufsrc_16"
)
sky130_fd_sc_hd__lpflow_isobufsrc_2 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_isobufsrc_2"
)
sky130_fd_sc_hd__lpflow_isobufsrc_4 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_isobufsrc_4"
)
sky130_fd_sc_hd__lpflow_isobufsrc_8 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_isobufsrc_8"
)
sky130_fd_sc_hd__lpflow_isobufsrckapwr_16 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_isobufsrckapwr_16"
)
sky130_fd_sc_hd__lpflow_lsbuf_lh_hl_isowell_tap_1 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_lsbuf_lh_hl_isowell_tap_1"
)
sky130_fd_sc_hd__lpflow_lsbuf_lh_hl_isowell_tap_2 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_lsbuf_lh_hl_isowell_tap_2"
)
sky130_fd_sc_hd__lpflow_lsbuf_lh_hl_isowell_tap_4 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_lsbuf_lh_hl_isowell_tap_4"
)
sky130_fd_sc_hd__lpflow_lsbuf_lh_isowell_4 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_lsbuf_lh_isowell_4"
)
sky130_fd_sc_hd__lpflow_lsbuf_lh_isowell_tap_1 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_lsbuf_lh_isowell_tap_1"
)
sky130_fd_sc_hd__lpflow_lsbuf_lh_isowell_tap_2 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_lsbuf_lh_isowell_tap_2"
)
sky130_fd_sc_hd__lpflow_lsbuf_lh_isowell_tap_4 = partial(
    import_spice, "sky130_fd_sc_hd__lpflow_lsbuf_lh_isowell_tap_4"
)
sky130_fd_sc_hd__macro_sparecell = partial(
    import_spice, "sky130_fd_sc_hd__macro_sparecell"
)
sky130_fd_sc_hd__maj3_1 = partial(import_spice, "sky130_fd_sc_hd__maj3_1")
sky130_fd_sc_hd__maj3_2 = partial(import_spice, "sky130_fd_sc_hd__maj3_2")
sky130_fd_sc_hd__maj3_4 = partial(import_spice, "sky130_fd_sc_hd__maj3_4")
sky130_fd_sc_hd__mux2_1 = partial(import_spice, "sky130_fd_sc_hd__mux2_1")
sky130_fd_sc_hd__mux2_2 = partial(import_spice, "sky130_fd_sc_hd__mux2_2")
sky130_fd_sc_hd__mux2_4 = partial(import_spice, "sky130_fd_sc_hd__mux2_4")
sky130_fd_sc_hd__mux2_8 = partial(import_spice, "sky130_fd_sc_hd__mux2_8")
sky130_fd_sc_hd__mux2i_1 = partial(import_spice, "sky130_fd_sc_hd__mux2i_1")
sky130_fd_sc_hd__mux2i_2 = partial(import_spice, "sky130_fd_sc_hd__mux2i_2")
sky130_fd_sc_hd__mux2i_4 = partial(import_spice, "sky130_fd_sc_hd__mux2i_4")
sky130_fd_sc_hd__mux4_1 = partial(import_spice, "sky130_fd_sc_hd__mux4_1")
sky130_fd_sc_hd__mux4_2 = partial(import_spice, "sky130_fd_sc_hd__mux4_2")
sky130_fd_sc_hd__mux4_4 = partial(import_spice, "sky130_fd_sc_hd__mux4_4")
sky130_fd_sc_hd__nand2_1 = partial(import_spice, "sky130_fd_sc_hd__nand2_1")
sky130_fd_sc_hd__nand2_2 = partial(import_spice, "sky130_fd_sc_hd__nand2_2")
sky130_fd_sc_hd__nand2_4 = partial(import_spice, "sky130_fd_sc_hd__nand2_4")
sky130_fd_sc_hd__nand2_8 = partial(import_spice, "sky130_fd_sc_hd__nand2_8")
sky130_fd_sc_hd__nand2b_1 = partial(import_spice, "sky130_fd_sc_hd__nand2b_1")
sky130_fd_sc_hd__nand2b_2 = partial(import_spice, "sky130_fd_sc_hd__nand2b_2")
sky130_fd_sc_hd__nand2b_4 = partial(import_spice, "sky130_fd_sc_hd__nand2b_4")
sky130_fd_sc_hd__nand3_1 = partial(import_spice, "sky130_fd_sc_hd__nand3_1")
sky130_fd_sc_hd__nand3_2 = partial(import_spice, "sky130_fd_sc_hd__nand3_2")
sky130_fd_sc_hd__nand3_4 = partial(import_spice, "sky130_fd_sc_hd__nand3_4")
sky130_fd_sc_hd__nand3b_1 = partial(import_spice, "sky130_fd_sc_hd__nand3b_1")
sky130_fd_sc_hd__nand3b_2 = partial(import_spice, "sky130_fd_sc_hd__nand3b_2")
sky130_fd_sc_hd__nand3b_4 = partial(import_spice, "sky130_fd_sc_hd__nand3b_4")
sky130_fd_sc_hd__nand4_1 = partial(import_spice, "sky130_fd_sc_hd__nand4_1")
sky130_fd_sc_hd__nand4_2 = partial(import_spice, "sky130_fd_sc_hd__nand4_2")
sky130_fd_sc_hd__nand4_4 = partial(import_spice, "sky130_fd_sc_hd__nand4_4")
sky130_fd_sc_hd__nand4b_1 = partial(import_spice, "sky130_fd_sc_hd__nand4b_1")
sky130_fd_sc_hd__nand4b_2 = partial(import_spice, "sky130_fd_sc_hd__nand4b_2")
sky130_fd_sc_hd__nand4b_4 = partial(import_spice, "sky130_fd_sc_hd__nand4b_4")
sky130_fd_sc_hd__nand4bb_1 = partial(import_spice, "sky130_fd_sc_hd__nand4bb_1")
sky130_fd_sc_hd__nand4bb_2 = partial(import_spice, "sky130_fd_sc_hd__nand4bb_2")
sky130_fd_sc_hd__nand4bb_4 = partial(import_spice, "sky130_fd_sc_hd__nand4bb_4")
sky130_fd_sc_hd__nor2_1 = partial(import_spice, "sky130_fd_sc_hd__nor2_1")
sky130_fd_sc_hd__nor2_2 = partial(import_spice, "sky130_fd_sc_hd__nor2_2")
sky130_fd_sc_hd__nor2_4 = partial(import_spice, "sky130_fd_sc_hd__nor2_4")
sky130_fd_sc_hd__nor2_8 = partial(import_spice, "sky130_fd_sc_hd__nor2_8")
sky130_fd_sc_hd__nor2b_1 = partial(import_spice, "sky130_fd_sc_hd__nor2b_1")
sky130_fd_sc_hd__nor2b_2 = partial(import_spice, "sky130_fd_sc_hd__nor2b_2")
sky130_fd_sc_hd__nor2b_4 = partial(import_spice, "sky130_fd_sc_hd__nor2b_4")
sky130_fd_sc_hd__nor3_1 = partial(import_spice, "sky130_fd_sc_hd__nor3_1")
sky130_fd_sc_hd__nor3_2 = partial(import_spice, "sky130_fd_sc_hd__nor3_2")
sky130_fd_sc_hd__nor3_4 = partial(import_spice, "sky130_fd_sc_hd__nor3_4")
sky130_fd_sc_hd__nor3b_1 = partial(import_spice, "sky130_fd_sc_hd__nor3b_1")
sky130_fd_sc_hd__nor3b_2 = partial(import_spice, "sky130_fd_sc_hd__nor3b_2")
sky130_fd_sc_hd__nor3b_4 = partial(import_spice, "sky130_fd_sc_hd__nor3b_4")
sky130_fd_sc_hd__nor4_1 = partial(import_spice, "sky130_fd_sc_hd__nor4_1")
sky130_fd_sc_hd__nor4_2 = partial(import_spice, "sky130_fd_sc_hd__nor4_2")
sky130_fd_sc_hd__nor4_4 = partial(import_spice, "sky130_fd_sc_hd__nor4_4")
sky130_fd_sc_hd__nor4b_1 = partial(import_spice, "sky130_fd_sc_hd__nor4b_1")
sky130_fd_sc_hd__nor4b_2 = partial(import_spice, "sky130_fd_sc_hd__nor4b_2")
sky130_fd_sc_hd__nor4b_4 = partial(import_spice, "sky130_fd_sc_hd__nor4b_4")
sky130_fd_sc_hd__nor4bb_1 = partial(import_spice, "sky130_fd_sc_hd__nor4bb_1")
sky130_fd_sc_hd__nor4bb_2 = partial(import_spice, "sky130_fd_sc_hd__nor4bb_2")
sky130_fd_sc_hd__nor4bb_4 = partial(import_spice, "sky130_fd_sc_hd__nor4bb_4")
sky130_fd_sc_hd__o2111a_1 = partial(import_spice, "sky130_fd_sc_hd__o2111a_1")
sky130_fd_sc_hd__o2111a_2 = partial(import_spice, "sky130_fd_sc_hd__o2111a_2")
sky130_fd_sc_hd__o2111a_4 = partial(import_spice, "sky130_fd_sc_hd__o2111a_4")
sky130_fd_sc_hd__o2111ai_1 = partial(import_spice, "sky130_fd_sc_hd__o2111ai_1")
sky130_fd_sc_hd__o2111ai_2 = partial(import_spice, "sky130_fd_sc_hd__o2111ai_2")
sky130_fd_sc_hd__o2111ai_4 = partial(import_spice, "sky130_fd_sc_hd__o2111ai_4")
sky130_fd_sc_hd__o211a_1 = partial(import_spice, "sky130_fd_sc_hd__o211a_1")
sky130_fd_sc_hd__o211a_2 = partial(import_spice, "sky130_fd_sc_hd__o211a_2")
sky130_fd_sc_hd__o211a_4 = partial(import_spice, "sky130_fd_sc_hd__o211a_4")
sky130_fd_sc_hd__o211ai_1 = partial(import_spice, "sky130_fd_sc_hd__o211ai_1")
sky130_fd_sc_hd__o211ai_2 = partial(import_spice, "sky130_fd_sc_hd__o211ai_2")
sky130_fd_sc_hd__o211ai_4 = partial(import_spice, "sky130_fd_sc_hd__o211ai_4")
sky130_fd_sc_hd__o21a_1 = partial(import_spice, "sky130_fd_sc_hd__o21a_1")
sky130_fd_sc_hd__o21a_2 = partial(import_spice, "sky130_fd_sc_hd__o21a_2")
sky130_fd_sc_hd__o21a_4 = partial(import_spice, "sky130_fd_sc_hd__o21a_4")
sky130_fd_sc_hd__o21ai_0 = partial(import_spice, "sky130_fd_sc_hd__o21ai_0")
sky130_fd_sc_hd__o21ai_1 = partial(import_spice, "sky130_fd_sc_hd__o21ai_1")
sky130_fd_sc_hd__o21ai_2 = partial(import_spice, "sky130_fd_sc_hd__o21ai_2")
sky130_fd_sc_hd__o21ai_4 = partial(import_spice, "sky130_fd_sc_hd__o21ai_4")
sky130_fd_sc_hd__o21ba_1 = partial(import_spice, "sky130_fd_sc_hd__o21ba_1")
sky130_fd_sc_hd__o21ba_2 = partial(import_spice, "sky130_fd_sc_hd__o21ba_2")
sky130_fd_sc_hd__o21ba_4 = partial(import_spice, "sky130_fd_sc_hd__o21ba_4")
sky130_fd_sc_hd__o21bai_1 = partial(import_spice, "sky130_fd_sc_hd__o21bai_1")
sky130_fd_sc_hd__o21bai_2 = partial(import_spice, "sky130_fd_sc_hd__o21bai_2")
sky130_fd_sc_hd__o21bai_4 = partial(import_spice, "sky130_fd_sc_hd__o21bai_4")
sky130_fd_sc_hd__o221a_1 = partial(import_spice, "sky130_fd_sc_hd__o221a_1")
sky130_fd_sc_hd__o221a_2 = partial(import_spice, "sky130_fd_sc_hd__o221a_2")
sky130_fd_sc_hd__o221a_4 = partial(import_spice, "sky130_fd_sc_hd__o221a_4")
sky130_fd_sc_hd__o221ai_1 = partial(import_spice, "sky130_fd_sc_hd__o221ai_1")
sky130_fd_sc_hd__o221ai_2 = partial(import_spice, "sky130_fd_sc_hd__o221ai_2")
sky130_fd_sc_hd__o221ai_4 = partial(import_spice, "sky130_fd_sc_hd__o221ai_4")
sky130_fd_sc_hd__o22a_1 = partial(import_spice, "sky130_fd_sc_hd__o22a_1")
sky130_fd_sc_hd__o22a_2 = partial(import_spice, "sky130_fd_sc_hd__o22a_2")
sky130_fd_sc_hd__o22a_4 = partial(import_spice, "sky130_fd_sc_hd__o22a_4")
sky130_fd_sc_hd__o22ai_1 = partial(import_spice, "sky130_fd_sc_hd__o22ai_1")
sky130_fd_sc_hd__o22ai_2 = partial(import_spice, "sky130_fd_sc_hd__o22ai_2")
sky130_fd_sc_hd__o22ai_4 = partial(import_spice, "sky130_fd_sc_hd__o22ai_4")
sky130_fd_sc_hd__o2bb2a_1 = partial(import_spice, "sky130_fd_sc_hd__o2bb2a_1")
sky130_fd_sc_hd__o2bb2a_2 = partial(import_spice, "sky130_fd_sc_hd__o2bb2a_2")
sky130_fd_sc_hd__o2bb2a_4 = partial(import_spice, "sky130_fd_sc_hd__o2bb2a_4")
sky130_fd_sc_hd__o2bb2ai_1 = partial(import_spice, "sky130_fd_sc_hd__o2bb2ai_1")
sky130_fd_sc_hd__o2bb2ai_2 = partial(import_spice, "sky130_fd_sc_hd__o2bb2ai_2")
sky130_fd_sc_hd__o2bb2ai_4 = partial(import_spice, "sky130_fd_sc_hd__o2bb2ai_4")
sky130_fd_sc_hd__o311a_1 = partial(import_spice, "sky130_fd_sc_hd__o311a_1")
sky130_fd_sc_hd__o311a_2 = partial(import_spice, "sky130_fd_sc_hd__o311a_2")
sky130_fd_sc_hd__o311a_4 = partial(import_spice, "sky130_fd_sc_hd__o311a_4")
sky130_fd_sc_hd__o311ai_0 = partial(import_spice, "sky130_fd_sc_hd__o311ai_0")
sky130_fd_sc_hd__o311ai_1 = partial(import_spice, "sky130_fd_sc_hd__o311ai_1")
sky130_fd_sc_hd__o311ai_2 = partial(import_spice, "sky130_fd_sc_hd__o311ai_2")
sky130_fd_sc_hd__o311ai_4 = partial(import_spice, "sky130_fd_sc_hd__o311ai_4")
sky130_fd_sc_hd__o31a_1 = partial(import_spice, "sky130_fd_sc_hd__o31a_1")
sky130_fd_sc_hd__o31a_2 = partial(import_spice, "sky130_fd_sc_hd__o31a_2")
sky130_fd_sc_hd__o31a_4 = partial(import_spice, "sky130_fd_sc_hd__o31a_4")
sky130_fd_sc_hd__o31ai_1 = partial(import_spice, "sky130_fd_sc_hd__o31ai_1")
sky130_fd_sc_hd__o31ai_2 = partial(import_spice, "sky130_fd_sc_hd__o31ai_2")
sky130_fd_sc_hd__o31ai_4 = partial(import_spice, "sky130_fd_sc_hd__o31ai_4")
sky130_fd_sc_hd__o32a_1 = partial(import_spice, "sky130_fd_sc_hd__o32a_1")
sky130_fd_sc_hd__o32a_2 = partial(import_spice, "sky130_fd_sc_hd__o32a_2")
sky130_fd_sc_hd__o32a_4 = partial(import_spice, "sky130_fd_sc_hd__o32a_4")
sky130_fd_sc_hd__o32ai_1 = partial(import_spice, "sky130_fd_sc_hd__o32ai_1")
sky130_fd_sc_hd__o32ai_2 = partial(import_spice, "sky130_fd_sc_hd__o32ai_2")
sky130_fd_sc_hd__o32ai_4 = partial(import_spice, "sky130_fd_sc_hd__o32ai_4")
sky130_fd_sc_hd__o41a_1 = partial(import_spice, "sky130_fd_sc_hd__o41a_1")
sky130_fd_sc_hd__o41a_2 = partial(import_spice, "sky130_fd_sc_hd__o41a_2")
sky130_fd_sc_hd__o41a_4 = partial(import_spice, "sky130_fd_sc_hd__o41a_4")
sky130_fd_sc_hd__o41ai_1 = partial(import_spice, "sky130_fd_sc_hd__o41ai_1")
sky130_fd_sc_hd__o41ai_2 = partial(import_spice, "sky130_fd_sc_hd__o41ai_2")
sky130_fd_sc_hd__o41ai_4 = partial(import_spice, "sky130_fd_sc_hd__o41ai_4")
sky130_fd_sc_hd__or2_0 = partial(import_spice, "sky130_fd_sc_hd__or2_0")
sky130_fd_sc_hd__or2_1 = partial(import_spice, "sky130_fd_sc_hd__or2_1")
sky130_fd_sc_hd__or2_2 = partial(import_spice, "sky130_fd_sc_hd__or2_2")
sky130_fd_sc_hd__or2_4 = partial(import_spice, "sky130_fd_sc_hd__or2_4")
sky130_fd_sc_hd__or2b_1 = partial(import_spice, "sky130_fd_sc_hd__or2b_1")
sky130_fd_sc_hd__or2b_2 = partial(import_spice, "sky130_fd_sc_hd__or2b_2")
sky130_fd_sc_hd__or2b_4 = partial(import_spice, "sky130_fd_sc_hd__or2b_4")
sky130_fd_sc_hd__or3_1 = partial(import_spice, "sky130_fd_sc_hd__or3_1")
sky130_fd_sc_hd__or3_2 = partial(import_spice, "sky130_fd_sc_hd__or3_2")
sky130_fd_sc_hd__or3_4 = partial(import_spice, "sky130_fd_sc_hd__or3_4")
sky130_fd_sc_hd__or3b_1 = partial(import_spice, "sky130_fd_sc_hd__or3b_1")
sky130_fd_sc_hd__or3b_2 = partial(import_spice, "sky130_fd_sc_hd__or3b_2")
sky130_fd_sc_hd__or3b_4 = partial(import_spice, "sky130_fd_sc_hd__or3b_4")
sky130_fd_sc_hd__or4_1 = partial(import_spice, "sky130_fd_sc_hd__or4_1")
sky130_fd_sc_hd__or4_2 = partial(import_spice, "sky130_fd_sc_hd__or4_2")
sky130_fd_sc_hd__or4_4 = partial(import_spice, "sky130_fd_sc_hd__or4_4")
sky130_fd_sc_hd__or4b_1 = partial(import_spice, "sky130_fd_sc_hd__or4b_1")
sky130_fd_sc_hd__or4b_2 = partial(import_spice, "sky130_fd_sc_hd__or4b_2")
sky130_fd_sc_hd__or4b_4 = partial(import_spice, "sky130_fd_sc_hd__or4b_4")
sky130_fd_sc_hd__or4bb_1 = partial(import_spice, "sky130_fd_sc_hd__or4bb_1")
sky130_fd_sc_hd__or4bb_2 = partial(import_spice, "sky130_fd_sc_hd__or4bb_2")
sky130_fd_sc_hd__or4bb_4 = partial(import_spice, "sky130_fd_sc_hd__or4bb_4")
sky130_fd_sc_hd__probe_p_8 = partial(import_spice, "sky130_fd_sc_hd__probe_p_8")
sky130_fd_sc_hd__probec_p_8 = partial(import_spice, "sky130_fd_sc_hd__probec_p_8")
sky130_fd_sc_hd__sdfbbn_1 = partial(import_spice, "sky130_fd_sc_hd__sdfbbn_1")
sky130_fd_sc_hd__sdfbbn_2 = partial(import_spice, "sky130_fd_sc_hd__sdfbbn_2")
sky130_fd_sc_hd__sdfbbp_1 = partial(import_spice, "sky130_fd_sc_hd__sdfbbp_1")
sky130_fd_sc_hd__sdfrbp_1 = partial(import_spice, "sky130_fd_sc_hd__sdfrbp_1")
sky130_fd_sc_hd__sdfrbp_2 = partial(import_spice, "sky130_fd_sc_hd__sdfrbp_2")
sky130_fd_sc_hd__sdfrtn_1 = partial(import_spice, "sky130_fd_sc_hd__sdfrtn_1")
sky130_fd_sc_hd__sdfrtp_1 = partial(import_spice, "sky130_fd_sc_hd__sdfrtp_1")
sky130_fd_sc_hd__sdfrtp_2 = partial(import_spice, "sky130_fd_sc_hd__sdfrtp_2")
sky130_fd_sc_hd__sdfrtp_4 = partial(import_spice, "sky130_fd_sc_hd__sdfrtp_4")
sky130_fd_sc_hd__sdfsbp_1 = partial(import_spice, "sky130_fd_sc_hd__sdfsbp_1")
sky130_fd_sc_hd__sdfsbp_2 = partial(import_spice, "sky130_fd_sc_hd__sdfsbp_2")
sky130_fd_sc_hd__sdfstp_1 = partial(import_spice, "sky130_fd_sc_hd__sdfstp_1")
sky130_fd_sc_hd__sdfstp_2 = partial(import_spice, "sky130_fd_sc_hd__sdfstp_2")
sky130_fd_sc_hd__sdfstp_4 = partial(import_spice, "sky130_fd_sc_hd__sdfstp_4")
sky130_fd_sc_hd__sdfxbp_1 = partial(import_spice, "sky130_fd_sc_hd__sdfxbp_1")
sky130_fd_sc_hd__sdfxbp_2 = partial(import_spice, "sky130_fd_sc_hd__sdfxbp_2")
sky130_fd_sc_hd__sdfxtp_1 = partial(import_spice, "sky130_fd_sc_hd__sdfxtp_1")
sky130_fd_sc_hd__sdfxtp_2 = partial(import_spice, "sky130_fd_sc_hd__sdfxtp_2")
sky130_fd_sc_hd__sdfxtp_4 = partial(import_spice, "sky130_fd_sc_hd__sdfxtp_4")
sky130_fd_sc_hd__sdlclkp_1 = partial(import_spice, "sky130_fd_sc_hd__sdlclkp_1")
sky130_fd_sc_hd__sdlclkp_2 = partial(import_spice, "sky130_fd_sc_hd__sdlclkp_2")
sky130_fd_sc_hd__sdlclkp_4 = partial(import_spice, "sky130_fd_sc_hd__sdlclkp_4")
sky130_fd_sc_hd__sedfxbp_1 = partial(import_spice, "sky130_fd_sc_hd__sedfxbp_1")
sky130_fd_sc_hd__sedfxbp_2 = partial(import_spice, "sky130_fd_sc_hd__sedfxbp_2")
sky130_fd_sc_hd__sedfxtp_1 = partial(import_spice, "sky130_fd_sc_hd__sedfxtp_1")
sky130_fd_sc_hd__sedfxtp_2 = partial(import_spice, "sky130_fd_sc_hd__sedfxtp_2")
sky130_fd_sc_hd__sedfxtp_4 = partial(import_spice, "sky130_fd_sc_hd__sedfxtp_4")
sky130_fd_sc_hd__tap_1 = partial(import_spice, "sky130_fd_sc_hd__tap_1")
sky130_fd_sc_hd__tap_2 = partial(import_spice, "sky130_fd_sc_hd__tap_2")
sky130_fd_sc_hd__tapvgnd2_1 = partial(import_spice, "sky130_fd_sc_hd__tapvgnd2_1")
sky130_fd_sc_hd__tapvgnd_1 = partial(import_spice, "sky130_fd_sc_hd__tapvgnd_1")
sky130_fd_sc_hd__tapvpwrvgnd_1 = partial(import_spice, "sky130_fd_sc_hd__tapvpwrvgnd_1")
sky130_fd_sc_hd__xnor2_1 = partial(import_spice, "sky130_fd_sc_hd__xnor2_1")
sky130_fd_sc_hd__xnor2_2 = partial(import_spice, "sky130_fd_sc_hd__xnor2_2")
sky130_fd_sc_hd__xnor2_4 = partial(import_spice, "sky130_fd_sc_hd__xnor2_4")
sky130_fd_sc_hd__xnor3_1 = partial(import_spice, "sky130_fd_sc_hd__xnor3_1")
sky130_fd_sc_hd__xnor3_2 = partial(import_spice, "sky130_fd_sc_hd__xnor3_2")
sky130_fd_sc_hd__xnor3_4 = partial(import_spice, "sky130_fd_sc_hd__xnor3_4")
sky130_fd_sc_hd__xor2_1 = partial(import_spice, "sky130_fd_sc_hd__xor2_1")
sky130_fd_sc_hd__xor2_2 = partial(import_spice, "sky130_fd_sc_hd__xor2_2")
sky130_fd_sc_hd__xor2_4 = partial(import_spice, "sky130_fd_sc_hd__xor2_4")
sky130_fd_sc_hd__xor3_1 = partial(import_spice, "sky130_fd_sc_hd__xor3_1")
sky130_fd_sc_hd__xor3_2 = partial(import_spice, "sky130_fd_sc_hd__xor3_2")
sky130_fd_sc_hd__xor3_4 = partial(import_spice, "sky130_fd_sc_hd__xor3_4")
sky130_fd_sc_hs__a2111o_1 = partial(import_spice, "sky130_fd_sc_hs__a2111o_1")
sky130_fd_sc_hs__a2111o_2 = partial(import_spice, "sky130_fd_sc_hs__a2111o_2")
sky130_fd_sc_hs__a2111o_4 = partial(import_spice, "sky130_fd_sc_hs__a2111o_4")
sky130_fd_sc_hs__a2111oi_1 = partial(import_spice, "sky130_fd_sc_hs__a2111oi_1")
sky130_fd_sc_hs__a2111oi_2 = partial(import_spice, "sky130_fd_sc_hs__a2111oi_2")
sky130_fd_sc_hs__a2111oi_4 = partial(import_spice, "sky130_fd_sc_hs__a2111oi_4")
sky130_fd_sc_hs__a211o_1 = partial(import_spice, "sky130_fd_sc_hs__a211o_1")
sky130_fd_sc_hs__a211o_2 = partial(import_spice, "sky130_fd_sc_hs__a211o_2")
sky130_fd_sc_hs__a211o_4 = partial(import_spice, "sky130_fd_sc_hs__a211o_4")
sky130_fd_sc_hs__a211oi_1 = partial(import_spice, "sky130_fd_sc_hs__a211oi_1")
sky130_fd_sc_hs__a211oi_2 = partial(import_spice, "sky130_fd_sc_hs__a211oi_2")
sky130_fd_sc_hs__a211oi_4 = partial(import_spice, "sky130_fd_sc_hs__a211oi_4")
sky130_fd_sc_hs__a21bo_1 = partial(import_spice, "sky130_fd_sc_hs__a21bo_1")
sky130_fd_sc_hs__a21bo_2 = partial(import_spice, "sky130_fd_sc_hs__a21bo_2")
sky130_fd_sc_hs__a21bo_4 = partial(import_spice, "sky130_fd_sc_hs__a21bo_4")
sky130_fd_sc_hs__a21boi_1 = partial(import_spice, "sky130_fd_sc_hs__a21boi_1")
sky130_fd_sc_hs__a21boi_2 = partial(import_spice, "sky130_fd_sc_hs__a21boi_2")
sky130_fd_sc_hs__a21boi_4 = partial(import_spice, "sky130_fd_sc_hs__a21boi_4")
sky130_fd_sc_hs__a21o_1 = partial(import_spice, "sky130_fd_sc_hs__a21o_1")
sky130_fd_sc_hs__a21o_2 = partial(import_spice, "sky130_fd_sc_hs__a21o_2")
sky130_fd_sc_hs__a21o_4 = partial(import_spice, "sky130_fd_sc_hs__a21o_4")
sky130_fd_sc_hs__a21oi_1 = partial(import_spice, "sky130_fd_sc_hs__a21oi_1")
sky130_fd_sc_hs__a21oi_2 = partial(import_spice, "sky130_fd_sc_hs__a21oi_2")
sky130_fd_sc_hs__a21oi_4 = partial(import_spice, "sky130_fd_sc_hs__a21oi_4")
sky130_fd_sc_hs__a221o_1 = partial(import_spice, "sky130_fd_sc_hs__a221o_1")
sky130_fd_sc_hs__a221o_2 = partial(import_spice, "sky130_fd_sc_hs__a221o_2")
sky130_fd_sc_hs__a221o_4 = partial(import_spice, "sky130_fd_sc_hs__a221o_4")
sky130_fd_sc_hs__a221oi_1 = partial(import_spice, "sky130_fd_sc_hs__a221oi_1")
sky130_fd_sc_hs__a221oi_2 = partial(import_spice, "sky130_fd_sc_hs__a221oi_2")
sky130_fd_sc_hs__a221oi_4 = partial(import_spice, "sky130_fd_sc_hs__a221oi_4")
sky130_fd_sc_hs__a222o_1 = partial(import_spice, "sky130_fd_sc_hs__a222o_1")
sky130_fd_sc_hs__a222o_2 = partial(import_spice, "sky130_fd_sc_hs__a222o_2")
sky130_fd_sc_hs__a222oi_1 = partial(import_spice, "sky130_fd_sc_hs__a222oi_1")
sky130_fd_sc_hs__a222oi_2 = partial(import_spice, "sky130_fd_sc_hs__a222oi_2")
sky130_fd_sc_hs__a22o_1 = partial(import_spice, "sky130_fd_sc_hs__a22o_1")
sky130_fd_sc_hs__a22o_2 = partial(import_spice, "sky130_fd_sc_hs__a22o_2")
sky130_fd_sc_hs__a22o_4 = partial(import_spice, "sky130_fd_sc_hs__a22o_4")
sky130_fd_sc_hs__a22oi_1 = partial(import_spice, "sky130_fd_sc_hs__a22oi_1")
sky130_fd_sc_hs__a22oi_2 = partial(import_spice, "sky130_fd_sc_hs__a22oi_2")
sky130_fd_sc_hs__a22oi_4 = partial(import_spice, "sky130_fd_sc_hs__a22oi_4")
sky130_fd_sc_hs__a2bb2o_1 = partial(import_spice, "sky130_fd_sc_hs__a2bb2o_1")
sky130_fd_sc_hs__a2bb2o_2 = partial(import_spice, "sky130_fd_sc_hs__a2bb2o_2")
sky130_fd_sc_hs__a2bb2o_4 = partial(import_spice, "sky130_fd_sc_hs__a2bb2o_4")
sky130_fd_sc_hs__a2bb2oi_1 = partial(import_spice, "sky130_fd_sc_hs__a2bb2oi_1")
sky130_fd_sc_hs__a2bb2oi_2 = partial(import_spice, "sky130_fd_sc_hs__a2bb2oi_2")
sky130_fd_sc_hs__a2bb2oi_4 = partial(import_spice, "sky130_fd_sc_hs__a2bb2oi_4")
sky130_fd_sc_hs__a311o_1 = partial(import_spice, "sky130_fd_sc_hs__a311o_1")
sky130_fd_sc_hs__a311o_2 = partial(import_spice, "sky130_fd_sc_hs__a311o_2")
sky130_fd_sc_hs__a311o_4 = partial(import_spice, "sky130_fd_sc_hs__a311o_4")
sky130_fd_sc_hs__a311oi_1 = partial(import_spice, "sky130_fd_sc_hs__a311oi_1")
sky130_fd_sc_hs__a311oi_2 = partial(import_spice, "sky130_fd_sc_hs__a311oi_2")
sky130_fd_sc_hs__a311oi_4 = partial(import_spice, "sky130_fd_sc_hs__a311oi_4")
sky130_fd_sc_hs__a31o_1 = partial(import_spice, "sky130_fd_sc_hs__a31o_1")
sky130_fd_sc_hs__a31o_2 = partial(import_spice, "sky130_fd_sc_hs__a31o_2")
sky130_fd_sc_hs__a31o_4 = partial(import_spice, "sky130_fd_sc_hs__a31o_4")
sky130_fd_sc_hs__a31oi_1 = partial(import_spice, "sky130_fd_sc_hs__a31oi_1")
sky130_fd_sc_hs__a31oi_2 = partial(import_spice, "sky130_fd_sc_hs__a31oi_2")
sky130_fd_sc_hs__a31oi_4 = partial(import_spice, "sky130_fd_sc_hs__a31oi_4")
sky130_fd_sc_hs__a32o_1 = partial(import_spice, "sky130_fd_sc_hs__a32o_1")
sky130_fd_sc_hs__a32o_2 = partial(import_spice, "sky130_fd_sc_hs__a32o_2")
sky130_fd_sc_hs__a32o_4 = partial(import_spice, "sky130_fd_sc_hs__a32o_4")
sky130_fd_sc_hs__a32oi_1 = partial(import_spice, "sky130_fd_sc_hs__a32oi_1")
sky130_fd_sc_hs__a32oi_2 = partial(import_spice, "sky130_fd_sc_hs__a32oi_2")
sky130_fd_sc_hs__a32oi_4 = partial(import_spice, "sky130_fd_sc_hs__a32oi_4")
sky130_fd_sc_hs__a41o_1 = partial(import_spice, "sky130_fd_sc_hs__a41o_1")
sky130_fd_sc_hs__a41o_2 = partial(import_spice, "sky130_fd_sc_hs__a41o_2")
sky130_fd_sc_hs__a41o_4 = partial(import_spice, "sky130_fd_sc_hs__a41o_4")
sky130_fd_sc_hs__a41oi_1 = partial(import_spice, "sky130_fd_sc_hs__a41oi_1")
sky130_fd_sc_hs__a41oi_2 = partial(import_spice, "sky130_fd_sc_hs__a41oi_2")
sky130_fd_sc_hs__a41oi_4 = partial(import_spice, "sky130_fd_sc_hs__a41oi_4")
sky130_fd_sc_hs__and2_1 = partial(import_spice, "sky130_fd_sc_hs__and2_1")
sky130_fd_sc_hs__and2_2 = partial(import_spice, "sky130_fd_sc_hs__and2_2")
sky130_fd_sc_hs__and2_4 = partial(import_spice, "sky130_fd_sc_hs__and2_4")
sky130_fd_sc_hs__and2b_1 = partial(import_spice, "sky130_fd_sc_hs__and2b_1")
sky130_fd_sc_hs__and2b_2 = partial(import_spice, "sky130_fd_sc_hs__and2b_2")
sky130_fd_sc_hs__and2b_4 = partial(import_spice, "sky130_fd_sc_hs__and2b_4")
sky130_fd_sc_hs__and3_1 = partial(import_spice, "sky130_fd_sc_hs__and3_1")
sky130_fd_sc_hs__and3_2 = partial(import_spice, "sky130_fd_sc_hs__and3_2")
sky130_fd_sc_hs__and3_4 = partial(import_spice, "sky130_fd_sc_hs__and3_4")
sky130_fd_sc_hs__and3b_1 = partial(import_spice, "sky130_fd_sc_hs__and3b_1")
sky130_fd_sc_hs__and3b_2 = partial(import_spice, "sky130_fd_sc_hs__and3b_2")
sky130_fd_sc_hs__and3b_4 = partial(import_spice, "sky130_fd_sc_hs__and3b_4")
sky130_fd_sc_hs__and4_1 = partial(import_spice, "sky130_fd_sc_hs__and4_1")
sky130_fd_sc_hs__and4_2 = partial(import_spice, "sky130_fd_sc_hs__and4_2")
sky130_fd_sc_hs__and4_4 = partial(import_spice, "sky130_fd_sc_hs__and4_4")
sky130_fd_sc_hs__and4b_1 = partial(import_spice, "sky130_fd_sc_hs__and4b_1")
sky130_fd_sc_hs__and4b_2 = partial(import_spice, "sky130_fd_sc_hs__and4b_2")
sky130_fd_sc_hs__and4b_4 = partial(import_spice, "sky130_fd_sc_hs__and4b_4")
sky130_fd_sc_hs__and4bb_1 = partial(import_spice, "sky130_fd_sc_hs__and4bb_1")
sky130_fd_sc_hs__and4bb_2 = partial(import_spice, "sky130_fd_sc_hs__and4bb_2")
sky130_fd_sc_hs__and4bb_4 = partial(import_spice, "sky130_fd_sc_hs__and4bb_4")
sky130_fd_sc_hs__buf_1 = partial(import_spice, "sky130_fd_sc_hs__buf_1")
sky130_fd_sc_hs__buf_16 = partial(import_spice, "sky130_fd_sc_hs__buf_16")
sky130_fd_sc_hs__buf_2 = partial(import_spice, "sky130_fd_sc_hs__buf_2")
sky130_fd_sc_hs__buf_4 = partial(import_spice, "sky130_fd_sc_hs__buf_4")
sky130_fd_sc_hs__buf_8 = partial(import_spice, "sky130_fd_sc_hs__buf_8")
sky130_fd_sc_hs__bufbuf_16 = partial(import_spice, "sky130_fd_sc_hs__bufbuf_16")
sky130_fd_sc_hs__bufbuf_8 = partial(import_spice, "sky130_fd_sc_hs__bufbuf_8")
sky130_fd_sc_hs__bufinv_16 = partial(import_spice, "sky130_fd_sc_hs__bufinv_16")
sky130_fd_sc_hs__bufinv_8 = partial(import_spice, "sky130_fd_sc_hs__bufinv_8")
sky130_fd_sc_hs__clkbuf_1 = partial(import_spice, "sky130_fd_sc_hs__clkbuf_1")
sky130_fd_sc_hs__clkbuf_16 = partial(import_spice, "sky130_fd_sc_hs__clkbuf_16")
sky130_fd_sc_hs__clkbuf_2 = partial(import_spice, "sky130_fd_sc_hs__clkbuf_2")
sky130_fd_sc_hs__clkbuf_4 = partial(import_spice, "sky130_fd_sc_hs__clkbuf_4")
sky130_fd_sc_hs__clkbuf_8 = partial(import_spice, "sky130_fd_sc_hs__clkbuf_8")
sky130_fd_sc_hs__clkdlyinv3sd1_1 = partial(
    import_spice, "sky130_fd_sc_hs__clkdlyinv3sd1_1"
)
sky130_fd_sc_hs__clkdlyinv3sd2_1 = partial(
    import_spice, "sky130_fd_sc_hs__clkdlyinv3sd2_1"
)
sky130_fd_sc_hs__clkdlyinv3sd3_1 = partial(
    import_spice, "sky130_fd_sc_hs__clkdlyinv3sd3_1"
)
sky130_fd_sc_hs__clkdlyinv5sd1_1 = partial(
    import_spice, "sky130_fd_sc_hs__clkdlyinv5sd1_1"
)
sky130_fd_sc_hs__clkdlyinv5sd2_1 = partial(
    import_spice, "sky130_fd_sc_hs__clkdlyinv5sd2_1"
)
sky130_fd_sc_hs__clkdlyinv5sd3_1 = partial(
    import_spice, "sky130_fd_sc_hs__clkdlyinv5sd3_1"
)
sky130_fd_sc_hs__clkinv_1 = partial(import_spice, "sky130_fd_sc_hs__clkinv_1")
sky130_fd_sc_hs__clkinv_16 = partial(import_spice, "sky130_fd_sc_hs__clkinv_16")
sky130_fd_sc_hs__clkinv_2 = partial(import_spice, "sky130_fd_sc_hs__clkinv_2")
sky130_fd_sc_hs__clkinv_4 = partial(import_spice, "sky130_fd_sc_hs__clkinv_4")
sky130_fd_sc_hs__clkinv_8 = partial(import_spice, "sky130_fd_sc_hs__clkinv_8")
sky130_fd_sc_hs__conb_1 = partial(import_spice, "sky130_fd_sc_hs__conb_1")
sky130_fd_sc_hs__decap_4 = partial(import_spice, "sky130_fd_sc_hs__decap_4")
sky130_fd_sc_hs__decap_8 = partial(import_spice, "sky130_fd_sc_hs__decap_8")
sky130_fd_sc_hs__dfbbn_1 = partial(import_spice, "sky130_fd_sc_hs__dfbbn_1")
sky130_fd_sc_hs__dfbbn_2 = partial(import_spice, "sky130_fd_sc_hs__dfbbn_2")
sky130_fd_sc_hs__dfbbp_1 = partial(import_spice, "sky130_fd_sc_hs__dfbbp_1")
sky130_fd_sc_hs__dfrbp_1 = partial(import_spice, "sky130_fd_sc_hs__dfrbp_1")
sky130_fd_sc_hs__dfrbp_2 = partial(import_spice, "sky130_fd_sc_hs__dfrbp_2")
sky130_fd_sc_hs__dfrtn_1 = partial(import_spice, "sky130_fd_sc_hs__dfrtn_1")
sky130_fd_sc_hs__dfrtp_1 = partial(import_spice, "sky130_fd_sc_hs__dfrtp_1")
sky130_fd_sc_hs__dfrtp_2 = partial(import_spice, "sky130_fd_sc_hs__dfrtp_2")
sky130_fd_sc_hs__dfrtp_4 = partial(import_spice, "sky130_fd_sc_hs__dfrtp_4")
sky130_fd_sc_hs__dfsbp_1 = partial(import_spice, "sky130_fd_sc_hs__dfsbp_1")
sky130_fd_sc_hs__dfsbp_2 = partial(import_spice, "sky130_fd_sc_hs__dfsbp_2")
sky130_fd_sc_hs__dfstp_1 = partial(import_spice, "sky130_fd_sc_hs__dfstp_1")
sky130_fd_sc_hs__dfstp_2 = partial(import_spice, "sky130_fd_sc_hs__dfstp_2")
sky130_fd_sc_hs__dfstp_4 = partial(import_spice, "sky130_fd_sc_hs__dfstp_4")
sky130_fd_sc_hs__dfxbp_1 = partial(import_spice, "sky130_fd_sc_hs__dfxbp_1")
sky130_fd_sc_hs__dfxbp_2 = partial(import_spice, "sky130_fd_sc_hs__dfxbp_2")
sky130_fd_sc_hs__dfxtp_1 = partial(import_spice, "sky130_fd_sc_hs__dfxtp_1")
sky130_fd_sc_hs__dfxtp_2 = partial(import_spice, "sky130_fd_sc_hs__dfxtp_2")
sky130_fd_sc_hs__dfxtp_4 = partial(import_spice, "sky130_fd_sc_hs__dfxtp_4")
sky130_fd_sc_hs__diode_2 = partial(import_spice, "sky130_fd_sc_hs__diode_2")
sky130_fd_sc_hs__dlclkp_1 = partial(import_spice, "sky130_fd_sc_hs__dlclkp_1")
sky130_fd_sc_hs__dlclkp_2 = partial(import_spice, "sky130_fd_sc_hs__dlclkp_2")
sky130_fd_sc_hs__dlclkp_4 = partial(import_spice, "sky130_fd_sc_hs__dlclkp_4")
sky130_fd_sc_hs__dlrbn_1 = partial(import_spice, "sky130_fd_sc_hs__dlrbn_1")
sky130_fd_sc_hs__dlrbn_2 = partial(import_spice, "sky130_fd_sc_hs__dlrbn_2")
sky130_fd_sc_hs__dlrbp_1 = partial(import_spice, "sky130_fd_sc_hs__dlrbp_1")
sky130_fd_sc_hs__dlrbp_2 = partial(import_spice, "sky130_fd_sc_hs__dlrbp_2")
sky130_fd_sc_hs__dlrtn_1 = partial(import_spice, "sky130_fd_sc_hs__dlrtn_1")
sky130_fd_sc_hs__dlrtn_2 = partial(import_spice, "sky130_fd_sc_hs__dlrtn_2")
sky130_fd_sc_hs__dlrtn_4 = partial(import_spice, "sky130_fd_sc_hs__dlrtn_4")
sky130_fd_sc_hs__dlrtp_1 = partial(import_spice, "sky130_fd_sc_hs__dlrtp_1")
sky130_fd_sc_hs__dlrtp_2 = partial(import_spice, "sky130_fd_sc_hs__dlrtp_2")
sky130_fd_sc_hs__dlrtp_4 = partial(import_spice, "sky130_fd_sc_hs__dlrtp_4")
sky130_fd_sc_hs__dlxbn_1 = partial(import_spice, "sky130_fd_sc_hs__dlxbn_1")
sky130_fd_sc_hs__dlxbn_2 = partial(import_spice, "sky130_fd_sc_hs__dlxbn_2")
sky130_fd_sc_hs__dlxbp_1 = partial(import_spice, "sky130_fd_sc_hs__dlxbp_1")
sky130_fd_sc_hs__dlxtn_1 = partial(import_spice, "sky130_fd_sc_hs__dlxtn_1")
sky130_fd_sc_hs__dlxtn_2 = partial(import_spice, "sky130_fd_sc_hs__dlxtn_2")
sky130_fd_sc_hs__dlxtn_4 = partial(import_spice, "sky130_fd_sc_hs__dlxtn_4")
sky130_fd_sc_hs__dlxtp_1 = partial(import_spice, "sky130_fd_sc_hs__dlxtp_1")
sky130_fd_sc_hs__dlygate4sd1_1 = partial(import_spice, "sky130_fd_sc_hs__dlygate4sd1_1")
sky130_fd_sc_hs__dlygate4sd2_1 = partial(import_spice, "sky130_fd_sc_hs__dlygate4sd2_1")
sky130_fd_sc_hs__dlygate4sd3_1 = partial(import_spice, "sky130_fd_sc_hs__dlygate4sd3_1")
sky130_fd_sc_hs__dlymetal6s2s_1 = partial(
    import_spice, "sky130_fd_sc_hs__dlymetal6s2s_1"
)
sky130_fd_sc_hs__dlymetal6s4s_1 = partial(
    import_spice, "sky130_fd_sc_hs__dlymetal6s4s_1"
)
sky130_fd_sc_hs__dlymetal6s6s_1 = partial(
    import_spice, "sky130_fd_sc_hs__dlymetal6s6s_1"
)
sky130_fd_sc_hs__ebufn_1 = partial(import_spice, "sky130_fd_sc_hs__ebufn_1")
sky130_fd_sc_hs__ebufn_2 = partial(import_spice, "sky130_fd_sc_hs__ebufn_2")
sky130_fd_sc_hs__ebufn_4 = partial(import_spice, "sky130_fd_sc_hs__ebufn_4")
sky130_fd_sc_hs__ebufn_8 = partial(import_spice, "sky130_fd_sc_hs__ebufn_8")
sky130_fd_sc_hs__edfxbp_1 = partial(import_spice, "sky130_fd_sc_hs__edfxbp_1")
sky130_fd_sc_hs__edfxtp_1 = partial(import_spice, "sky130_fd_sc_hs__edfxtp_1")
sky130_fd_sc_hs__einvn_1 = partial(import_spice, "sky130_fd_sc_hs__einvn_1")
sky130_fd_sc_hs__einvn_2 = partial(import_spice, "sky130_fd_sc_hs__einvn_2")
sky130_fd_sc_hs__einvn_4 = partial(import_spice, "sky130_fd_sc_hs__einvn_4")
sky130_fd_sc_hs__einvn_8 = partial(import_spice, "sky130_fd_sc_hs__einvn_8")
sky130_fd_sc_hs__einvp_1 = partial(import_spice, "sky130_fd_sc_hs__einvp_1")
sky130_fd_sc_hs__einvp_2 = partial(import_spice, "sky130_fd_sc_hs__einvp_2")
sky130_fd_sc_hs__einvp_4 = partial(import_spice, "sky130_fd_sc_hs__einvp_4")
sky130_fd_sc_hs__einvp_8 = partial(import_spice, "sky130_fd_sc_hs__einvp_8")
sky130_fd_sc_hs__fa_1 = partial(import_spice, "sky130_fd_sc_hs__fa_1")
sky130_fd_sc_hs__fa_2 = partial(import_spice, "sky130_fd_sc_hs__fa_2")
sky130_fd_sc_hs__fa_4 = partial(import_spice, "sky130_fd_sc_hs__fa_4")
sky130_fd_sc_hs__fah_1 = partial(import_spice, "sky130_fd_sc_hs__fah_1")
sky130_fd_sc_hs__fah_2 = partial(import_spice, "sky130_fd_sc_hs__fah_2")
sky130_fd_sc_hs__fah_4 = partial(import_spice, "sky130_fd_sc_hs__fah_4")
sky130_fd_sc_hs__fahcin_1 = partial(import_spice, "sky130_fd_sc_hs__fahcin_1")
sky130_fd_sc_hs__fahcon_1 = partial(import_spice, "sky130_fd_sc_hs__fahcon_1")
sky130_fd_sc_hs__fill_1 = partial(import_spice, "sky130_fd_sc_hs__fill_1")
sky130_fd_sc_hs__fill_2 = partial(import_spice, "sky130_fd_sc_hs__fill_2")
sky130_fd_sc_hs__fill_4 = partial(import_spice, "sky130_fd_sc_hs__fill_4")
sky130_fd_sc_hs__fill_8 = partial(import_spice, "sky130_fd_sc_hs__fill_8")
sky130_fd_sc_hs__fill_diode_2 = partial(import_spice, "sky130_fd_sc_hs__fill_diode_2")
sky130_fd_sc_hs__fill_diode_4 = partial(import_spice, "sky130_fd_sc_hs__fill_diode_4")
sky130_fd_sc_hs__fill_diode_8 = partial(import_spice, "sky130_fd_sc_hs__fill_diode_8")
sky130_fd_sc_hs__ha_1 = partial(import_spice, "sky130_fd_sc_hs__ha_1")
sky130_fd_sc_hs__ha_2 = partial(import_spice, "sky130_fd_sc_hs__ha_2")
sky130_fd_sc_hs__ha_4 = partial(import_spice, "sky130_fd_sc_hs__ha_4")
sky130_fd_sc_hs__inv_1 = partial(import_spice, "sky130_fd_sc_hs__inv_1")
sky130_fd_sc_hs__inv_16 = partial(import_spice, "sky130_fd_sc_hs__inv_16")
sky130_fd_sc_hs__inv_2 = partial(import_spice, "sky130_fd_sc_hs__inv_2")
sky130_fd_sc_hs__inv_4 = partial(import_spice, "sky130_fd_sc_hs__inv_4")
sky130_fd_sc_hs__inv_8 = partial(import_spice, "sky130_fd_sc_hs__inv_8")
sky130_fd_sc_hs__maj3_1 = partial(import_spice, "sky130_fd_sc_hs__maj3_1")
sky130_fd_sc_hs__maj3_2 = partial(import_spice, "sky130_fd_sc_hs__maj3_2")
sky130_fd_sc_hs__maj3_4 = partial(import_spice, "sky130_fd_sc_hs__maj3_4")
sky130_fd_sc_hs__mux2_1 = partial(import_spice, "sky130_fd_sc_hs__mux2_1")
sky130_fd_sc_hs__mux2_2 = partial(import_spice, "sky130_fd_sc_hs__mux2_2")
sky130_fd_sc_hs__mux2_4 = partial(import_spice, "sky130_fd_sc_hs__mux2_4")
sky130_fd_sc_hs__mux2i_1 = partial(import_spice, "sky130_fd_sc_hs__mux2i_1")
sky130_fd_sc_hs__mux2i_2 = partial(import_spice, "sky130_fd_sc_hs__mux2i_2")
sky130_fd_sc_hs__mux2i_4 = partial(import_spice, "sky130_fd_sc_hs__mux2i_4")
sky130_fd_sc_hs__mux4_1 = partial(import_spice, "sky130_fd_sc_hs__mux4_1")
sky130_fd_sc_hs__mux4_2 = partial(import_spice, "sky130_fd_sc_hs__mux4_2")
sky130_fd_sc_hs__mux4_4 = partial(import_spice, "sky130_fd_sc_hs__mux4_4")
sky130_fd_sc_hs__nand2_1 = partial(import_spice, "sky130_fd_sc_hs__nand2_1")
sky130_fd_sc_hs__nand2_2 = partial(import_spice, "sky130_fd_sc_hs__nand2_2")
sky130_fd_sc_hs__nand2_4 = partial(import_spice, "sky130_fd_sc_hs__nand2_4")
sky130_fd_sc_hs__nand2_8 = partial(import_spice, "sky130_fd_sc_hs__nand2_8")
sky130_fd_sc_hs__nand2b_1 = partial(import_spice, "sky130_fd_sc_hs__nand2b_1")
sky130_fd_sc_hs__nand2b_2 = partial(import_spice, "sky130_fd_sc_hs__nand2b_2")
sky130_fd_sc_hs__nand2b_4 = partial(import_spice, "sky130_fd_sc_hs__nand2b_4")
sky130_fd_sc_hs__nand3_1 = partial(import_spice, "sky130_fd_sc_hs__nand3_1")
sky130_fd_sc_hs__nand3_2 = partial(import_spice, "sky130_fd_sc_hs__nand3_2")
sky130_fd_sc_hs__nand3_4 = partial(import_spice, "sky130_fd_sc_hs__nand3_4")
sky130_fd_sc_hs__nand3b_1 = partial(import_spice, "sky130_fd_sc_hs__nand3b_1")
sky130_fd_sc_hs__nand3b_2 = partial(import_spice, "sky130_fd_sc_hs__nand3b_2")
sky130_fd_sc_hs__nand3b_4 = partial(import_spice, "sky130_fd_sc_hs__nand3b_4")
sky130_fd_sc_hs__nand4_1 = partial(import_spice, "sky130_fd_sc_hs__nand4_1")
sky130_fd_sc_hs__nand4_2 = partial(import_spice, "sky130_fd_sc_hs__nand4_2")
sky130_fd_sc_hs__nand4_4 = partial(import_spice, "sky130_fd_sc_hs__nand4_4")
sky130_fd_sc_hs__nand4b_1 = partial(import_spice, "sky130_fd_sc_hs__nand4b_1")
sky130_fd_sc_hs__nand4b_2 = partial(import_spice, "sky130_fd_sc_hs__nand4b_2")
sky130_fd_sc_hs__nand4b_4 = partial(import_spice, "sky130_fd_sc_hs__nand4b_4")
sky130_fd_sc_hs__nand4bb_1 = partial(import_spice, "sky130_fd_sc_hs__nand4bb_1")
sky130_fd_sc_hs__nand4bb_2 = partial(import_spice, "sky130_fd_sc_hs__nand4bb_2")
sky130_fd_sc_hs__nand4bb_4 = partial(import_spice, "sky130_fd_sc_hs__nand4bb_4")
sky130_fd_sc_hs__nor2_1 = partial(import_spice, "sky130_fd_sc_hs__nor2_1")
sky130_fd_sc_hs__nor2_2 = partial(import_spice, "sky130_fd_sc_hs__nor2_2")
sky130_fd_sc_hs__nor2_4 = partial(import_spice, "sky130_fd_sc_hs__nor2_4")
sky130_fd_sc_hs__nor2_8 = partial(import_spice, "sky130_fd_sc_hs__nor2_8")
sky130_fd_sc_hs__nor2b_1 = partial(import_spice, "sky130_fd_sc_hs__nor2b_1")
sky130_fd_sc_hs__nor2b_2 = partial(import_spice, "sky130_fd_sc_hs__nor2b_2")
sky130_fd_sc_hs__nor2b_4 = partial(import_spice, "sky130_fd_sc_hs__nor2b_4")
sky130_fd_sc_hs__nor3_1 = partial(import_spice, "sky130_fd_sc_hs__nor3_1")
sky130_fd_sc_hs__nor3_2 = partial(import_spice, "sky130_fd_sc_hs__nor3_2")
sky130_fd_sc_hs__nor3_4 = partial(import_spice, "sky130_fd_sc_hs__nor3_4")
sky130_fd_sc_hs__nor3b_1 = partial(import_spice, "sky130_fd_sc_hs__nor3b_1")
sky130_fd_sc_hs__nor3b_2 = partial(import_spice, "sky130_fd_sc_hs__nor3b_2")
sky130_fd_sc_hs__nor3b_4 = partial(import_spice, "sky130_fd_sc_hs__nor3b_4")
sky130_fd_sc_hs__nor4_1 = partial(import_spice, "sky130_fd_sc_hs__nor4_1")
sky130_fd_sc_hs__nor4_2 = partial(import_spice, "sky130_fd_sc_hs__nor4_2")
sky130_fd_sc_hs__nor4_4 = partial(import_spice, "sky130_fd_sc_hs__nor4_4")
sky130_fd_sc_hs__nor4b_1 = partial(import_spice, "sky130_fd_sc_hs__nor4b_1")
sky130_fd_sc_hs__nor4b_2 = partial(import_spice, "sky130_fd_sc_hs__nor4b_2")
sky130_fd_sc_hs__nor4b_4 = partial(import_spice, "sky130_fd_sc_hs__nor4b_4")
sky130_fd_sc_hs__nor4bb_1 = partial(import_spice, "sky130_fd_sc_hs__nor4bb_1")
sky130_fd_sc_hs__nor4bb_2 = partial(import_spice, "sky130_fd_sc_hs__nor4bb_2")
sky130_fd_sc_hs__nor4bb_4 = partial(import_spice, "sky130_fd_sc_hs__nor4bb_4")
sky130_fd_sc_hs__o2111a_1 = partial(import_spice, "sky130_fd_sc_hs__o2111a_1")
sky130_fd_sc_hs__o2111a_2 = partial(import_spice, "sky130_fd_sc_hs__o2111a_2")
sky130_fd_sc_hs__o2111a_4 = partial(import_spice, "sky130_fd_sc_hs__o2111a_4")
sky130_fd_sc_hs__o2111ai_1 = partial(import_spice, "sky130_fd_sc_hs__o2111ai_1")
sky130_fd_sc_hs__o2111ai_2 = partial(import_spice, "sky130_fd_sc_hs__o2111ai_2")
sky130_fd_sc_hs__o2111ai_4 = partial(import_spice, "sky130_fd_sc_hs__o2111ai_4")
sky130_fd_sc_hs__o211a_1 = partial(import_spice, "sky130_fd_sc_hs__o211a_1")
sky130_fd_sc_hs__o211a_2 = partial(import_spice, "sky130_fd_sc_hs__o211a_2")
sky130_fd_sc_hs__o211a_4 = partial(import_spice, "sky130_fd_sc_hs__o211a_4")
sky130_fd_sc_hs__o211ai_1 = partial(import_spice, "sky130_fd_sc_hs__o211ai_1")
sky130_fd_sc_hs__o211ai_2 = partial(import_spice, "sky130_fd_sc_hs__o211ai_2")
sky130_fd_sc_hs__o211ai_4 = partial(import_spice, "sky130_fd_sc_hs__o211ai_4")
sky130_fd_sc_hs__o21a_1 = partial(import_spice, "sky130_fd_sc_hs__o21a_1")
sky130_fd_sc_hs__o21a_2 = partial(import_spice, "sky130_fd_sc_hs__o21a_2")
sky130_fd_sc_hs__o21a_4 = partial(import_spice, "sky130_fd_sc_hs__o21a_4")
sky130_fd_sc_hs__o21ai_1 = partial(import_spice, "sky130_fd_sc_hs__o21ai_1")
sky130_fd_sc_hs__o21ai_2 = partial(import_spice, "sky130_fd_sc_hs__o21ai_2")
sky130_fd_sc_hs__o21ai_4 = partial(import_spice, "sky130_fd_sc_hs__o21ai_4")
sky130_fd_sc_hs__o21ba_1 = partial(import_spice, "sky130_fd_sc_hs__o21ba_1")
sky130_fd_sc_hs__o21ba_2 = partial(import_spice, "sky130_fd_sc_hs__o21ba_2")
sky130_fd_sc_hs__o21ba_4 = partial(import_spice, "sky130_fd_sc_hs__o21ba_4")
sky130_fd_sc_hs__o21bai_1 = partial(import_spice, "sky130_fd_sc_hs__o21bai_1")
sky130_fd_sc_hs__o21bai_2 = partial(import_spice, "sky130_fd_sc_hs__o21bai_2")
sky130_fd_sc_hs__o21bai_4 = partial(import_spice, "sky130_fd_sc_hs__o21bai_4")
sky130_fd_sc_hs__o221a_1 = partial(import_spice, "sky130_fd_sc_hs__o221a_1")
sky130_fd_sc_hs__o221a_2 = partial(import_spice, "sky130_fd_sc_hs__o221a_2")
sky130_fd_sc_hs__o221a_4 = partial(import_spice, "sky130_fd_sc_hs__o221a_4")
sky130_fd_sc_hs__o221ai_1 = partial(import_spice, "sky130_fd_sc_hs__o221ai_1")
sky130_fd_sc_hs__o221ai_2 = partial(import_spice, "sky130_fd_sc_hs__o221ai_2")
sky130_fd_sc_hs__o221ai_4 = partial(import_spice, "sky130_fd_sc_hs__o221ai_4")
sky130_fd_sc_hs__o22a_1 = partial(import_spice, "sky130_fd_sc_hs__o22a_1")
sky130_fd_sc_hs__o22a_2 = partial(import_spice, "sky130_fd_sc_hs__o22a_2")
sky130_fd_sc_hs__o22a_4 = partial(import_spice, "sky130_fd_sc_hs__o22a_4")
sky130_fd_sc_hs__o22ai_1 = partial(import_spice, "sky130_fd_sc_hs__o22ai_1")
sky130_fd_sc_hs__o22ai_2 = partial(import_spice, "sky130_fd_sc_hs__o22ai_2")
sky130_fd_sc_hs__o22ai_4 = partial(import_spice, "sky130_fd_sc_hs__o22ai_4")
sky130_fd_sc_hs__o2bb2a_1 = partial(import_spice, "sky130_fd_sc_hs__o2bb2a_1")
sky130_fd_sc_hs__o2bb2a_2 = partial(import_spice, "sky130_fd_sc_hs__o2bb2a_2")
sky130_fd_sc_hs__o2bb2a_4 = partial(import_spice, "sky130_fd_sc_hs__o2bb2a_4")
sky130_fd_sc_hs__o2bb2ai_1 = partial(import_spice, "sky130_fd_sc_hs__o2bb2ai_1")
sky130_fd_sc_hs__o2bb2ai_2 = partial(import_spice, "sky130_fd_sc_hs__o2bb2ai_2")
sky130_fd_sc_hs__o2bb2ai_4 = partial(import_spice, "sky130_fd_sc_hs__o2bb2ai_4")
sky130_fd_sc_hs__o311a_1 = partial(import_spice, "sky130_fd_sc_hs__o311a_1")
sky130_fd_sc_hs__o311a_2 = partial(import_spice, "sky130_fd_sc_hs__o311a_2")
sky130_fd_sc_hs__o311a_4 = partial(import_spice, "sky130_fd_sc_hs__o311a_4")
sky130_fd_sc_hs__o311ai_1 = partial(import_spice, "sky130_fd_sc_hs__o311ai_1")
sky130_fd_sc_hs__o311ai_2 = partial(import_spice, "sky130_fd_sc_hs__o311ai_2")
sky130_fd_sc_hs__o311ai_4 = partial(import_spice, "sky130_fd_sc_hs__o311ai_4")
sky130_fd_sc_hs__o31a_1 = partial(import_spice, "sky130_fd_sc_hs__o31a_1")
sky130_fd_sc_hs__o31a_2 = partial(import_spice, "sky130_fd_sc_hs__o31a_2")
sky130_fd_sc_hs__o31a_4 = partial(import_spice, "sky130_fd_sc_hs__o31a_4")
sky130_fd_sc_hs__o31ai_1 = partial(import_spice, "sky130_fd_sc_hs__o31ai_1")
sky130_fd_sc_hs__o31ai_2 = partial(import_spice, "sky130_fd_sc_hs__o31ai_2")
sky130_fd_sc_hs__o31ai_4 = partial(import_spice, "sky130_fd_sc_hs__o31ai_4")
sky130_fd_sc_hs__o32a_1 = partial(import_spice, "sky130_fd_sc_hs__o32a_1")
sky130_fd_sc_hs__o32a_2 = partial(import_spice, "sky130_fd_sc_hs__o32a_2")
sky130_fd_sc_hs__o32a_4 = partial(import_spice, "sky130_fd_sc_hs__o32a_4")
sky130_fd_sc_hs__o32ai_1 = partial(import_spice, "sky130_fd_sc_hs__o32ai_1")
sky130_fd_sc_hs__o32ai_2 = partial(import_spice, "sky130_fd_sc_hs__o32ai_2")
sky130_fd_sc_hs__o32ai_4 = partial(import_spice, "sky130_fd_sc_hs__o32ai_4")
sky130_fd_sc_hs__o41a_1 = partial(import_spice, "sky130_fd_sc_hs__o41a_1")
sky130_fd_sc_hs__o41a_2 = partial(import_spice, "sky130_fd_sc_hs__o41a_2")
sky130_fd_sc_hs__o41a_4 = partial(import_spice, "sky130_fd_sc_hs__o41a_4")
sky130_fd_sc_hs__o41ai_1 = partial(import_spice, "sky130_fd_sc_hs__o41ai_1")
sky130_fd_sc_hs__o41ai_2 = partial(import_spice, "sky130_fd_sc_hs__o41ai_2")
sky130_fd_sc_hs__o41ai_4 = partial(import_spice, "sky130_fd_sc_hs__o41ai_4")
sky130_fd_sc_hs__or2_1 = partial(import_spice, "sky130_fd_sc_hs__or2_1")
sky130_fd_sc_hs__or2_2 = partial(import_spice, "sky130_fd_sc_hs__or2_2")
sky130_fd_sc_hs__or2_4 = partial(import_spice, "sky130_fd_sc_hs__or2_4")
sky130_fd_sc_hs__or2b_1 = partial(import_spice, "sky130_fd_sc_hs__or2b_1")
sky130_fd_sc_hs__or2b_2 = partial(import_spice, "sky130_fd_sc_hs__or2b_2")
sky130_fd_sc_hs__or2b_4 = partial(import_spice, "sky130_fd_sc_hs__or2b_4")
sky130_fd_sc_hs__or3_1 = partial(import_spice, "sky130_fd_sc_hs__or3_1")
sky130_fd_sc_hs__or3_2 = partial(import_spice, "sky130_fd_sc_hs__or3_2")
sky130_fd_sc_hs__or3_4 = partial(import_spice, "sky130_fd_sc_hs__or3_4")
sky130_fd_sc_hs__or3b_1 = partial(import_spice, "sky130_fd_sc_hs__or3b_1")
sky130_fd_sc_hs__or3b_2 = partial(import_spice, "sky130_fd_sc_hs__or3b_2")
sky130_fd_sc_hs__or3b_4 = partial(import_spice, "sky130_fd_sc_hs__or3b_4")
sky130_fd_sc_hs__or4_1 = partial(import_spice, "sky130_fd_sc_hs__or4_1")
sky130_fd_sc_hs__or4_2 = partial(import_spice, "sky130_fd_sc_hs__or4_2")
sky130_fd_sc_hs__or4_4 = partial(import_spice, "sky130_fd_sc_hs__or4_4")
sky130_fd_sc_hs__or4b_1 = partial(import_spice, "sky130_fd_sc_hs__or4b_1")
sky130_fd_sc_hs__or4b_2 = partial(import_spice, "sky130_fd_sc_hs__or4b_2")
sky130_fd_sc_hs__or4b_4 = partial(import_spice, "sky130_fd_sc_hs__or4b_4")
sky130_fd_sc_hs__or4bb_1 = partial(import_spice, "sky130_fd_sc_hs__or4bb_1")
sky130_fd_sc_hs__or4bb_2 = partial(import_spice, "sky130_fd_sc_hs__or4bb_2")
sky130_fd_sc_hs__or4bb_4 = partial(import_spice, "sky130_fd_sc_hs__or4bb_4")
sky130_fd_sc_hs__sdfbbn_1 = partial(import_spice, "sky130_fd_sc_hs__sdfbbn_1")
sky130_fd_sc_hs__sdfbbn_2 = partial(import_spice, "sky130_fd_sc_hs__sdfbbn_2")
sky130_fd_sc_hs__sdfbbp_1 = partial(import_spice, "sky130_fd_sc_hs__sdfbbp_1")
sky130_fd_sc_hs__sdfrbp_1 = partial(import_spice, "sky130_fd_sc_hs__sdfrbp_1")
sky130_fd_sc_hs__sdfrbp_2 = partial(import_spice, "sky130_fd_sc_hs__sdfrbp_2")
sky130_fd_sc_hs__sdfrtn_1 = partial(import_spice, "sky130_fd_sc_hs__sdfrtn_1")
sky130_fd_sc_hs__sdfrtp_1 = partial(import_spice, "sky130_fd_sc_hs__sdfrtp_1")
sky130_fd_sc_hs__sdfrtp_2 = partial(import_spice, "sky130_fd_sc_hs__sdfrtp_2")
sky130_fd_sc_hs__sdfrtp_4 = partial(import_spice, "sky130_fd_sc_hs__sdfrtp_4")
sky130_fd_sc_hs__sdfsbp_1 = partial(import_spice, "sky130_fd_sc_hs__sdfsbp_1")
sky130_fd_sc_hs__sdfsbp_2 = partial(import_spice, "sky130_fd_sc_hs__sdfsbp_2")
sky130_fd_sc_hs__sdfstp_1 = partial(import_spice, "sky130_fd_sc_hs__sdfstp_1")
sky130_fd_sc_hs__sdfstp_2 = partial(import_spice, "sky130_fd_sc_hs__sdfstp_2")
sky130_fd_sc_hs__sdfstp_4 = partial(import_spice, "sky130_fd_sc_hs__sdfstp_4")
sky130_fd_sc_hs__sdfxbp_1 = partial(import_spice, "sky130_fd_sc_hs__sdfxbp_1")
sky130_fd_sc_hs__sdfxbp_2 = partial(import_spice, "sky130_fd_sc_hs__sdfxbp_2")
sky130_fd_sc_hs__sdfxtp_1 = partial(import_spice, "sky130_fd_sc_hs__sdfxtp_1")
sky130_fd_sc_hs__sdfxtp_2 = partial(import_spice, "sky130_fd_sc_hs__sdfxtp_2")
sky130_fd_sc_hs__sdfxtp_4 = partial(import_spice, "sky130_fd_sc_hs__sdfxtp_4")
sky130_fd_sc_hs__sdlclkp_1 = partial(import_spice, "sky130_fd_sc_hs__sdlclkp_1")
sky130_fd_sc_hs__sdlclkp_2 = partial(import_spice, "sky130_fd_sc_hs__sdlclkp_2")
sky130_fd_sc_hs__sdlclkp_4 = partial(import_spice, "sky130_fd_sc_hs__sdlclkp_4")
sky130_fd_sc_hs__sedfxbp_1 = partial(import_spice, "sky130_fd_sc_hs__sedfxbp_1")
sky130_fd_sc_hs__sedfxbp_2 = partial(import_spice, "sky130_fd_sc_hs__sedfxbp_2")
sky130_fd_sc_hs__sedfxtp_1 = partial(import_spice, "sky130_fd_sc_hs__sedfxtp_1")
sky130_fd_sc_hs__sedfxtp_2 = partial(import_spice, "sky130_fd_sc_hs__sedfxtp_2")
sky130_fd_sc_hs__sedfxtp_4 = partial(import_spice, "sky130_fd_sc_hs__sedfxtp_4")
sky130_fd_sc_hs__tap_1 = partial(import_spice, "sky130_fd_sc_hs__tap_1")
sky130_fd_sc_hs__tap_2 = partial(import_spice, "sky130_fd_sc_hs__tap_2")
sky130_fd_sc_hs__tapmet1_2 = partial(import_spice, "sky130_fd_sc_hs__tapmet1_2")
sky130_fd_sc_hs__tapvgnd2_1 = partial(import_spice, "sky130_fd_sc_hs__tapvgnd2_1")
sky130_fd_sc_hs__tapvgnd_1 = partial(import_spice, "sky130_fd_sc_hs__tapvgnd_1")
sky130_fd_sc_hs__tapvpwrvgnd_1 = partial(import_spice, "sky130_fd_sc_hs__tapvpwrvgnd_1")
sky130_fd_sc_hs__xnor2_1 = partial(import_spice, "sky130_fd_sc_hs__xnor2_1")
sky130_fd_sc_hs__xnor2_2 = partial(import_spice, "sky130_fd_sc_hs__xnor2_2")
sky130_fd_sc_hs__xnor2_4 = partial(import_spice, "sky130_fd_sc_hs__xnor2_4")
sky130_fd_sc_hs__xnor3_1 = partial(import_spice, "sky130_fd_sc_hs__xnor3_1")
sky130_fd_sc_hs__xnor3_2 = partial(import_spice, "sky130_fd_sc_hs__xnor3_2")
sky130_fd_sc_hs__xnor3_4 = partial(import_spice, "sky130_fd_sc_hs__xnor3_4")
sky130_fd_sc_hs__xor2_1 = partial(import_spice, "sky130_fd_sc_hs__xor2_1")
sky130_fd_sc_hs__xor2_2 = partial(import_spice, "sky130_fd_sc_hs__xor2_2")
sky130_fd_sc_hs__xor2_4 = partial(import_spice, "sky130_fd_sc_hs__xor2_4")
sky130_fd_sc_hs__xor3_1 = partial(import_spice, "sky130_fd_sc_hs__xor3_1")
sky130_fd_sc_hs__xor3_2 = partial(import_spice, "sky130_fd_sc_hs__xor3_2")
sky130_fd_sc_hs__xor3_4 = partial(import_spice, "sky130_fd_sc_hs__xor3_4")
sky130_fd_sc_hvl__a21o_1 = partial(import_spice, "sky130_fd_sc_hvl__a21o_1")
sky130_fd_sc_hvl__a21oi_1 = partial(import_spice, "sky130_fd_sc_hvl__a21oi_1")
sky130_fd_sc_hvl__a22o_1 = partial(import_spice, "sky130_fd_sc_hvl__a22o_1")
sky130_fd_sc_hvl__a22oi_1 = partial(import_spice, "sky130_fd_sc_hvl__a22oi_1")
sky130_fd_sc_hvl__and2_1 = partial(import_spice, "sky130_fd_sc_hvl__and2_1")
sky130_fd_sc_hvl__and3_1 = partial(import_spice, "sky130_fd_sc_hvl__and3_1")
sky130_fd_sc_hvl__buf_1 = partial(import_spice, "sky130_fd_sc_hvl__buf_1")
sky130_fd_sc_hvl__buf_16 = partial(import_spice, "sky130_fd_sc_hvl__buf_16")
sky130_fd_sc_hvl__buf_2 = partial(import_spice, "sky130_fd_sc_hvl__buf_2")
sky130_fd_sc_hvl__buf_32 = partial(import_spice, "sky130_fd_sc_hvl__buf_32")
sky130_fd_sc_hvl__buf_4 = partial(import_spice, "sky130_fd_sc_hvl__buf_4")
sky130_fd_sc_hvl__buf_8 = partial(import_spice, "sky130_fd_sc_hvl__buf_8")
sky130_fd_sc_hvl__conb_1 = partial(import_spice, "sky130_fd_sc_hvl__conb_1")
sky130_fd_sc_hvl__decap_4 = partial(import_spice, "sky130_fd_sc_hvl__decap_4")
sky130_fd_sc_hvl__decap_8 = partial(import_spice, "sky130_fd_sc_hvl__decap_8")
sky130_fd_sc_hvl__dfrbp_1 = partial(import_spice, "sky130_fd_sc_hvl__dfrbp_1")
sky130_fd_sc_hvl__dfrtp_1 = partial(import_spice, "sky130_fd_sc_hvl__dfrtp_1")
sky130_fd_sc_hvl__dfsbp_1 = partial(import_spice, "sky130_fd_sc_hvl__dfsbp_1")
sky130_fd_sc_hvl__dfstp_1 = partial(import_spice, "sky130_fd_sc_hvl__dfstp_1")
sky130_fd_sc_hvl__dfxbp_1 = partial(import_spice, "sky130_fd_sc_hvl__dfxbp_1")
sky130_fd_sc_hvl__dfxtp_1 = partial(import_spice, "sky130_fd_sc_hvl__dfxtp_1")
sky130_fd_sc_hvl__diode_2 = partial(import_spice, "sky130_fd_sc_hvl__diode_2")
sky130_fd_sc_hvl__dlclkp_1 = partial(import_spice, "sky130_fd_sc_hvl__dlclkp_1")
sky130_fd_sc_hvl__dlrtp_1 = partial(import_spice, "sky130_fd_sc_hvl__dlrtp_1")
sky130_fd_sc_hvl__dlxtp_1 = partial(import_spice, "sky130_fd_sc_hvl__dlxtp_1")
sky130_fd_sc_hvl__einvn_1 = partial(import_spice, "sky130_fd_sc_hvl__einvn_1")
sky130_fd_sc_hvl__einvp_1 = partial(import_spice, "sky130_fd_sc_hvl__einvp_1")
sky130_fd_sc_hvl__fill_1 = partial(import_spice, "sky130_fd_sc_hvl__fill_1")
sky130_fd_sc_hvl__fill_2 = partial(import_spice, "sky130_fd_sc_hvl__fill_2")
sky130_fd_sc_hvl__fill_4 = partial(import_spice, "sky130_fd_sc_hvl__fill_4")
sky130_fd_sc_hvl__fill_8 = partial(import_spice, "sky130_fd_sc_hvl__fill_8")
sky130_fd_sc_hvl__inv_1 = partial(import_spice, "sky130_fd_sc_hvl__inv_1")
sky130_fd_sc_hvl__inv_16 = partial(import_spice, "sky130_fd_sc_hvl__inv_16")
sky130_fd_sc_hvl__inv_2 = partial(import_spice, "sky130_fd_sc_hvl__inv_2")
sky130_fd_sc_hvl__inv_4 = partial(import_spice, "sky130_fd_sc_hvl__inv_4")
sky130_fd_sc_hvl__inv_8 = partial(import_spice, "sky130_fd_sc_hvl__inv_8")
sky130_fd_sc_hvl__lsbufhv2hv_hl_1 = partial(
    import_spice, "sky130_fd_sc_hvl__lsbufhv2hv_hl_1"
)
sky130_fd_sc_hvl__lsbufhv2hv_lh_1 = partial(
    import_spice, "sky130_fd_sc_hvl__lsbufhv2hv_lh_1"
)
sky130_fd_sc_hvl__lsbufhv2lv_1 = partial(import_spice, "sky130_fd_sc_hvl__lsbufhv2lv_1")
sky130_fd_sc_hvl__lsbufhv2lv_simple_1 = partial(
    import_spice, "sky130_fd_sc_hvl__lsbufhv2lv_simple_1"
)
sky130_fd_sc_hvl__lsbuflv2hv_1 = partial(import_spice, "sky130_fd_sc_hvl__lsbuflv2hv_1")
sky130_fd_sc_hvl__lsbuflv2hv_clkiso_hlkg_3 = partial(
    import_spice, "sky130_fd_sc_hvl__lsbuflv2hv_clkiso_hlkg_3"
)
sky130_fd_sc_hvl__lsbuflv2hv_isosrchvaon_1 = partial(
    import_spice, "sky130_fd_sc_hvl__lsbuflv2hv_isosrchvaon_1"
)
sky130_fd_sc_hvl__lsbuflv2hv_symmetric_1 = partial(
    import_spice, "sky130_fd_sc_hvl__lsbuflv2hv_symmetric_1"
)
sky130_fd_sc_hvl__mux2_1 = partial(import_spice, "sky130_fd_sc_hvl__mux2_1")
sky130_fd_sc_hvl__mux4_1 = partial(import_spice, "sky130_fd_sc_hvl__mux4_1")
sky130_fd_sc_hvl__nand2_1 = partial(import_spice, "sky130_fd_sc_hvl__nand2_1")
sky130_fd_sc_hvl__nand3_1 = partial(import_spice, "sky130_fd_sc_hvl__nand3_1")
sky130_fd_sc_hvl__nor2_1 = partial(import_spice, "sky130_fd_sc_hvl__nor2_1")
sky130_fd_sc_hvl__nor3_1 = partial(import_spice, "sky130_fd_sc_hvl__nor3_1")
sky130_fd_sc_hvl__o21a_1 = partial(import_spice, "sky130_fd_sc_hvl__o21a_1")
sky130_fd_sc_hvl__o21ai_1 = partial(import_spice, "sky130_fd_sc_hvl__o21ai_1")
sky130_fd_sc_hvl__o22a_1 = partial(import_spice, "sky130_fd_sc_hvl__o22a_1")
sky130_fd_sc_hvl__o22ai_1 = partial(import_spice, "sky130_fd_sc_hvl__o22ai_1")
sky130_fd_sc_hvl__or2_1 = partial(import_spice, "sky130_fd_sc_hvl__or2_1")
sky130_fd_sc_hvl__or3_1 = partial(import_spice, "sky130_fd_sc_hvl__or3_1")
sky130_fd_sc_hvl__probe_p_8 = partial(import_spice, "sky130_fd_sc_hvl__probe_p_8")
sky130_fd_sc_hvl__probec_p_8 = partial(import_spice, "sky130_fd_sc_hvl__probec_p_8")
sky130_fd_sc_hvl__schmittbuf_1 = partial(import_spice, "sky130_fd_sc_hvl__schmittbuf_1")
sky130_fd_sc_hvl__sdfrbp_1 = partial(import_spice, "sky130_fd_sc_hvl__sdfrbp_1")
sky130_fd_sc_hvl__sdfrtp_1 = partial(import_spice, "sky130_fd_sc_hvl__sdfrtp_1")
sky130_fd_sc_hvl__sdfsbp_1 = partial(import_spice, "sky130_fd_sc_hvl__sdfsbp_1")
sky130_fd_sc_hvl__sdfstp_1 = partial(import_spice, "sky130_fd_sc_hvl__sdfstp_1")
sky130_fd_sc_hvl__sdfxbp_1 = partial(import_spice, "sky130_fd_sc_hvl__sdfxbp_1")
sky130_fd_sc_hvl__sdfxtp_1 = partial(import_spice, "sky130_fd_sc_hvl__sdfxtp_1")
sky130_fd_sc_hvl__sdlclkp_1 = partial(import_spice, "sky130_fd_sc_hvl__sdlclkp_1")
sky130_fd_sc_hvl__sdlxtp_1 = partial(import_spice, "sky130_fd_sc_hvl__sdlxtp_1")
sky130_fd_sc_hvl__xnor2_1 = partial(import_spice, "sky130_fd_sc_hvl__xnor2_1")
sky130_fd_sc_hvl__xor2_1 = partial(import_spice, "sky130_fd_sc_hvl__xor2_1")


if __name__ == "__main__":
    circuit = sky130_fd_sc_hd__a2111o_1()

    # circuit = Circuit('mosfet0')
    # circuit.lib(, 'tt')
    # circuit.include('mosfet.spice')
    # circuit.X('mosfet0', 'mosfet', 'DRAIN', 'GATE', 'VGND')
    circuit.V("gnd", "VGND", 0, 0)
    circuit.V("dd", "VPWR", "VGND", 1.8)
    circuit.R("", "VPWR", "DRAIN", "10k")
    circuit.PulseVoltageSource(
        "Vin",
        "GATE",
        "VGND",
        initial_value=0 @ u_V,
        pulsed_value=1.8 @ u_V,
        rise_time=10 @ u_ps,
        fall_time=10 @ u_ps,
        pulse_width=1 @ u_ns,
        period=2 @ u_ns,
        delay_time=1 @ u_ns,
    )
    print(str(circuit))
    simulator = circuit.simulator()
    analysis = simulator.transient(step_time=10 @ u_ps, end_time=2 @ u_ns)
    print("done")
    fig, ax = plt.subplots(figsize=(20, 10))
    ax.set_title("mosfet")
    ax.set_xlabel("time in 1e-14s")
    ax.set_ylabel("voltage in V")
    ax.plot(analysis.GATE)
    ax.plot(analysis.DRAIN)
    ax.legend(("GATE", "DRAIN"))
    plt.tight_layout()
    plt.show()
