from gf2lib import gf2matrix
from gf2lib.gf2matrix import GF2Matrix

# ==========================================
# ================ 矩阵创建 ==================
# ==========================================

m = gf2matrix.identity(4)  # 创建n维单位阵(n=4)
#  m = [[1, 0, 0, 0],
#       [0, 1, 0, 0],
#       [0, 0, 1, 0],
#       [0, 0, 0, 1]]

m = gf2matrix.from_int(0b101)  # 从整数中读取
#  m = [[1], [0], [1]]

m = gf2matrix.from_int(0b101, 8)  # 限定列向量长度
# m = [[0], [0], [0], [0], [0], [1], [0], [1]]

# ==========================================
# ================ 矩阵操作 ==================
# ==========================================

m1 = [[0], [0], [0], [0], [0], [1], [0], [1]]
m2 = [[0], [0], [0], [0], [0], [1], [0], [1]]
cmp = gf2matrix.equal(m1, m2)  # 矩阵判等(true)

m = [[0, 1]]
m = gf2matrix.h_stack(m, m)  # 水平拼接
# m = [[0, 1, 0, 1]]

m = [[0, 1, 0, 1]]
m = gf2matrix.h_slice(m, 0, None, 2)  # 水平切片, start=0,stop=None,step=2
# m = [[0, 0]]

m = [[0], [1]]
m = gf2matrix.v_stack(m, m)  # 垂直拼接
# m = [[0], [1], [0], [1]]

m = [[0], [1], [0], [1]]
m = gf2matrix.v_slice(m, 0, None, 2)  # 垂直切片, start=0,stop=None,step=2
# m = [[0], [0]]

# ==========================================
# ================ 矩阵操作 ==================
# ==========================================

m = [[0], [0], [0], [0], [0], [1], [0], [1]]
m = gf2matrix.transpose(m)  # 矩阵转置
# m = [[0, 0, 0, 0, 0, 1, 0, 1]]

m1 = [[0], [0], [0], [0], [0], [1], [0], [1]]
m2 = [[0], [0], [0], [0], [0], [1], [0], [1]]
m = gf2matrix.add(m1, m2)  # 矩阵加法
# m = [[0], [0], [0], [0], [0], [0], [0], [0]]

m1 = [[0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1], [1, 0, 0, 0]]
m2 = [[0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1], [1, 0, 0, 0]]
m = gf2matrix.mul(m1, m2)  # 矩阵乘法
# m = [[0, 0, 1, 0], [0, 0, 0, 1], [1, 0, 0, 0], [0, 1, 0, 0]]

m = [[0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1], [1, 0, 0, 0]]
m_inv = gf2matrix.inverse(m)  # 矩阵求逆, 若没有逆矩阵则返回None
# m_inv = [[0, 0, 0, 1], [1, 0, 0, 0], [0, 1, 0, 0], [0, 0, 1, 0]]

# ==================================================================
# ================ GF2Matrix 对象 ===================================
# ==================================================================

# 矩阵创建
M = GF2Matrix.identity(4)
M = GF2Matrix.from_int(0b101)
M = GF2Matrix.from_int(0b101, 8)
M = GF2Matrix([[0], [0], [0], [0], [0], [1], [0], [1]])

item = M[0, 0]  # 获取第0行0列元素
item = M.matrix[0][0]  # 与M[0, 0]等价

M[0, 0] = 1  # 设置第0行0列元素
M.matrix[0][0] = 1  # 与M[0, 0] = 1等价

# 矩阵运算
cmp = (M == M)  # 比较

M = GF2Matrix([[0, 1]])
M = M | M  # 水平拼接（运算符重载）
# M = [[0, 1, 0, 1]]

M = GF2Matrix([[0, 1]])
M = M.h_stack(M)  # 水平拼接
# M = [[0, 1, 0, 1]]

M = GF2Matrix([[0, 1, 0, 1]])
M = M.h_slice(0, None, 2)  # 水平切片, start=0,stop=None,step=2
# M = [[0, 0]]

M = M.transpose()  # 转置
M = M + M  # 加法

M = GF2Matrix([[0, 1, 0, 0], [0, 0, 1, 0], [0, 0, 0, 1], [1, 0, 0, 0]])
M = M * M  # 乘法
M = M.inverse()  # 求逆
