// Copyright (c) Mito
import React, { useEffect, useState } from 'react';
import Input from '../../elements/Input';
import MultiToggleBox from '../../elements/MultiToggleBox';
import MultiToggleItem from '../../elements/MultiToggleItem';
import Select from '../../elements/Select';
import TextButton from '../../elements/TextButton';
import DropdownItem from '../../elements/DropdownItem';
// CSS
import '../../../../css/taskpanes/Import/ImportTaskpane.css';
/*
    Allows a user to import an XLSX file with the given name, and
    in turn allows them to configure how to import sheets in this
    file.
*/
function XLSXImport(props) {
    const [loading, setLoading] = useState(true);
    const [fileMetadata, setFileMetadata] = useState({ sheet_names: [], size: 0 });
    const [sheetToggles, setSheetToggles] = useState([]);
    const [hasHeaderRow, setHasHeaderRow] = useState('Yes');
    const [skiprows, setSkiprows] = useState('0');
    const [stepID, setStepID] = useState(undefined);
    const loadSheets = async () => {
        const joinedPath = await props.mitoAPI.getPathJoined(props.pathParts);
        if (joinedPath === undefined) {
            return;
        }
        const loadedFileMetadata = await props.mitoAPI.getExcelFileMetadata(joinedPath);
        setFileMetadata(loadedFileMetadata || { sheet_names: [], size: 0 });
        const newSheetToggles = ((loadedFileMetadata === null || loadedFileMetadata === void 0 ? void 0 : loadedFileMetadata.sheet_names) || []).map(() => true);
        setSheetToggles(newSheetToggles);
        setLoading(false);
    };
    useEffect(() => {
        void loadSheets();
    }, []);
    const importXLSXFile = async () => {
        const sheetsToImport = fileMetadata.sheet_names.filter((sheetName, idx) => {
            return sheetToggles[idx];
        });
        const joinedPath = await props.mitoAPI.getPathJoined(props.pathParts);
        if (joinedPath === undefined) {
            return;
        }
        const newStepID = await props.mitoAPI.editExcelImport(joinedPath, sheetsToImport, hasHeaderRow === 'Yes', parseInt(skiprows), stepID);
        setStepID(newStepID);
    };
    const numSelectedSheets = sheetToggles.reduce((prevValue, currentValue) => {
        if (currentValue) {
            return prevValue + 1;
        }
        return prevValue;
    }, 0);
    const importButtonText = stepID === undefined
        ? `Import ${numSelectedSheets} Selected Sheet${numSelectedSheets === 1 ? '' : 's'}`
        : `Reimport ${numSelectedSheets} Selected Sheet${numSelectedSheets === 1 ? '' : 's'}`;
    return (React.createElement(React.Fragment, null,
        React.createElement("div", null,
            React.createElement(MultiToggleBox, { loading: loading, searchable: true, height: 'medium', toggleAllIndexes: (indexesToToggle, newToggleValue) => {
                    setSheetToggles(oldSheetToggles => {
                        const newSheetToggles = [...oldSheetToggles];
                        indexesToToggle.forEach(index => {
                            newSheetToggles[index] = newToggleValue;
                        });
                        return newSheetToggles;
                    });
                    // Reset to a new step if we're importing new sheets
                    setStepID(undefined);
                } }, fileMetadata.sheet_names.map((sheetName, idx) => {
                return (React.createElement(MultiToggleItem, { key: idx, title: sheetName, toggled: sheetToggles[idx], onToggle: () => {
                        setSheetToggles(oldSheetToggles => {
                            const newSheetToggles = [...oldSheetToggles];
                            newSheetToggles[idx] = !newSheetToggles[idx];
                            return newSheetToggles;
                        });
                        // Reset to a new step if we're importing new sheets
                        setStepID(undefined);
                    }, index: idx }));
            })),
            React.createElement("p", { className: 'text-body-1 mt-20px' }, "Has Header Row"),
            React.createElement(Select, { value: hasHeaderRow, onChange: (newValue) => setHasHeaderRow(newValue) },
                React.createElement(DropdownItem, { title: 'Yes' }),
                React.createElement(DropdownItem, { title: 'No' })),
            React.createElement("p", { className: 'text-body-1 mt-20px' }, "Number of Rows to Skip"),
            React.createElement(Input, { value: skiprows, type: 'number', onChange: (e) => { setSkiprows(e.target.value); } }),
            fileMetadata.size >= 100000 && fileMetadata.size < 10000000 &&
                React.createElement("p", { className: "text-body-2 mt-20px" }, "Due to Python limitations, large Excel files take minutes to import."),
            fileMetadata.size >= 10000000 &&
                React.createElement("p", { className: "text-body-2 mt-20px" }, "Due to Python limitations, massive Excel files take many minutes to import. If possible, save the Excel file as a CSV before importing.")),
        React.createElement("div", { className: 'import-taskpane-import-button-container' },
            React.createElement(TextButton, { variant: 'dark', width: 'block', onClick: importXLSXFile, disabled: numSelectedSheets === 0 }, importButtonText))));
}
export default XLSXImport;
//# sourceMappingURL=XLSXImport.js.map