// Copyright (c) Mito
import React from 'react';
import { classNames } from '../../../utils/classNames';
import { ControlPanelTab } from './ControlPanelTaskpane';
/*
    The tabs at the bottom of the column control panel that allows users to switch
    from sort/filter to seeing summary statistics about the column
*/
function ControlPanelTaskpaneTabs(props) {
    const changeTab = (tab) => {
        props.setUIState(prevUIState => {
            return Object.assign(Object.assign({}, prevUIState), { selectedColumnControlPanelTab: tab });
        });
        // Send a log message saying that this tab has been clicked,
        // and keeping the tab at the highest level
        void props.mitoAPI.log('clicked_' + tab + '_tab');
    };
    return (React.createElement("div", { className: 'control-panel-taskpane-tab-container' },
        React.createElement("div", { className: classNames('control-panel-taskpane-tab', props.selectedTab === ControlPanelTab.FilterSort ? 'selected' : 'unselected'), onClick: () => changeTab(ControlPanelTab.FilterSort) },
            React.createElement("p", null, "Filter/Sort")),
        React.createElement("div", { className: classNames('control-panel-taskpane-tab', props.selectedTab === ControlPanelTab.UniqueValues ? 'selected' : 'unselected'), onClick: () => changeTab(ControlPanelTab.UniqueValues) },
            React.createElement("p", null, "Values")),
        React.createElement("div", { className: classNames('control-panel-taskpane-tab', props.selectedTab === ControlPanelTab.SummaryStats ? 'selected' : 'unselected'), onClick: () => changeTab(ControlPanelTab.SummaryStats) },
            React.createElement("p", null, "Summary Stats"))));
}
export default ControlPanelTaskpaneTabs;
//# sourceMappingURL=ControlPanelTaskpaneTabs.js.map