<p align="center">
<img width="33%" height="33%" src="https://mltraq.com/assets/img/logo-black.svg" alt="MLTRAQ Logo">
</p>

<p align="center">
<img src="https://www.mltraq.com/assets/img/badges/test.svg" alt="Test">
<img src="https://www.mltraq.com/assets/img/badges/coverage.svg" alt="Test">
<img src="https://www.mltraq.com/assets/img/badges/python.svg" alt="Test">
<img src="https://www.mltraq.com/assets/img/badges/pypi.svg" alt="Test">
<img src="https://www.mltraq.com/assets/img/badges/license.svg" alt="Test">
<img src="https://www.mltraq.com/assets/img/badges/code-style.svg" alt="Test">
</p>

---

Open source **experiment tracking API** with **ML performance analysis** to build better models faster, facilitating collaboration and transparency within the team and with stakeholders.

---

* **Documentation**: [https://www.mltraq.com](https://www.mltraq.com)
* **Source code**: [https://github.com/elehcimd/mltraq](https://github.com/elehcimd/mltraq)

---

## Key features

* **Fast and efficient**: start tracking experiments with a few lines of code.
* **Distributed**: work on experiments independently and upstream them for sharing.
* **Accessible**: Simple SQL tables queriable with SQL, Pandas and Python API.
* **Structured types**: track Python types, Numpy arrays, Pandas dataframes and series.
* **Parallel execution**: define experiments as steps with parameter grids and execute them.
* **Light checkpointing**: save time by reloading and continuing your experiments anywhere.
* **Steps library**: enjoy pre-built steps for tracking, testing, analysis and reporting.

## Requirements

* **Python 3.7+**
* **SQLAlchemy**, **Pandas**, and **Joblib** (installed as dependencies)

## Installation

```
pip install mltraq
```

## License

This project is licensed under the terms of the [BSD 3-Clause License](https://mltraq.com/license).

