/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.restapi.client.Asset;
import org.ergoplatform.restapi.client.Registers;

public class ErgoTransactionOutput {
    @SerializedName(value="boxId")
    private String boxId = null;
    @SerializedName(value="value")
    private Long value = null;
    @SerializedName(value="ergoTree")
    private String ergoTree = null;
    @SerializedName(value="creationHeight")
    private Integer creationHeight = null;
    @SerializedName(value="assets")
    private List<Asset> assets = null;
    @SerializedName(value="additionalRegisters")
    private Registers additionalRegisters = null;
    @SerializedName(value="transactionId")
    private String transactionId = null;
    @SerializedName(value="index")
    private Integer index = null;

    public ErgoTransactionOutput boxId(String string) {
        this.boxId = string;
        return this;
    }

    @Schema(description="")
    public String getBoxId() {
        return this.boxId;
    }

    public void setBoxId(String string) {
        this.boxId = string;
    }

    public ErgoTransactionOutput value(Long l) {
        this.value = l;
        return this;
    }

    @Schema(example="147", required=true, description="Amount of Ergo token")
    public Long getValue() {
        return this.value;
    }

    public void setValue(Long l) {
        this.value = l;
    }

    public ErgoTransactionOutput ergoTree(String string) {
        this.ergoTree = string;
        return this;
    }

    @Schema(required=true, description="")
    public String getErgoTree() {
        return this.ergoTree;
    }

    public void setErgoTree(String string) {
        this.ergoTree = string;
    }

    public ErgoTransactionOutput creationHeight(Integer n) {
        this.creationHeight = n;
        return this;
    }

    @Schema(example="9149", required=true, description="Height the output was created at")
    public Integer getCreationHeight() {
        return this.creationHeight;
    }

    public void setCreationHeight(Integer n) {
        this.creationHeight = n;
    }

    public ErgoTransactionOutput assets(List<Asset> list) {
        this.assets = list;
        return this;
    }

    public ErgoTransactionOutput addAssetsItem(Asset asset) {
        if (this.assets == null) {
            this.assets = new ArrayList<Asset>();
        }
        this.assets.add(asset);
        return this;
    }

    @Schema(description="Assets list in the transaction")
    public List<Asset> getAssets() {
        return this.assets;
    }

    public void setAssets(List<Asset> list) {
        this.assets = list;
    }

    public ErgoTransactionOutput additionalRegisters(Registers registers) {
        this.additionalRegisters = registers;
        return this;
    }

    @Schema(required=true, description="")
    public Registers getAdditionalRegisters() {
        return this.additionalRegisters;
    }

    public void setAdditionalRegisters(Registers registers) {
        this.additionalRegisters = registers;
    }

    public ErgoTransactionOutput transactionId(String string) {
        this.transactionId = string;
        return this;
    }

    @Schema(description="")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String string) {
        this.transactionId = string;
    }

    public ErgoTransactionOutput index(Integer n) {
        this.index = n;
        return this;
    }

    @Schema(description="Index in the transaction outputs")
    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer n) {
        this.index = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ErgoTransactionOutput ergoTransactionOutput = (ErgoTransactionOutput)object;
        return Objects.equals(this.boxId, ergoTransactionOutput.boxId) && Objects.equals(this.value, ergoTransactionOutput.value) && Objects.equals(this.ergoTree, ergoTransactionOutput.ergoTree) && Objects.equals(this.creationHeight, ergoTransactionOutput.creationHeight) && Objects.equals(this.assets, ergoTransactionOutput.assets) && Objects.equals(this.additionalRegisters, ergoTransactionOutput.additionalRegisters) && Objects.equals(this.transactionId, ergoTransactionOutput.transactionId) && Objects.equals(this.index, ergoTransactionOutput.index);
    }

    public int hashCode() {
        return Objects.hash(this.boxId, this.value, this.ergoTree, this.creationHeight, this.assets, this.additionalRegisters, this.transactionId, this.index);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class ErgoTransactionOutput {\n");
        stringBuilder.append("    boxId: ").append(this.toIndentedString(this.boxId)).append("\n");
        stringBuilder.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        stringBuilder.append("    ergoTree: ").append(this.toIndentedString(this.ergoTree)).append("\n");
        stringBuilder.append("    creationHeight: ").append(this.toIndentedString(this.creationHeight)).append("\n");
        stringBuilder.append("    assets: ").append(this.toIndentedString(this.assets)).append("\n");
        stringBuilder.append("    additionalRegisters: ").append(this.toIndentedString(this.additionalRegisters)).append("\n");
        stringBuilder.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        stringBuilder.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

