/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Hex-encoded big-endian 256-bits secret exponent \"w\" along with generators \"g\", \"h\", and group elements \"u\", \"v\", such as g^w = u, h^w = v")
public class DhtSecret {
    @SerializedName(value="secret")
    private String secret = null;
    @SerializedName(value="g")
    private String g = null;
    @SerializedName(value="h")
    private String h = null;
    @SerializedName(value="u")
    private String u = null;
    @SerializedName(value="v")
    private String v = null;

    public DhtSecret secret(String string) {
        this.secret = string;
        return this;
    }

    @Schema(example="433080ff80d0d52d7f8bfffff47f00807f44f680000949b800007f7f7ff1017f", required=true, description="Hex-encoded big-endian 256-bits secret exponent")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String string) {
        this.secret = string;
    }

    public DhtSecret g(String string) {
        this.g = string;
        return this;
    }

    @Schema(example="02a7955281885bf0f0ca4a48678848cad8dc5b328ce8bc1d4481d041c98e891ff3", required=true, description="Hex-encoded \"g\" generator for the Diffie-Hellman tuple (secp256k1 curve point)")
    public String getG() {
        return this.g;
    }

    public void setG(String string) {
        this.g = string;
    }

    public DhtSecret h(String string) {
        this.h = string;
        return this;
    }

    @Schema(example="02a7955281885bf0f0ca4a48678848cad8dc5b328ce8bc1d4481d041c98e891ff3", required=true, description="Hex-encoded \"h\" generator for the Diffie-Hellman tuple (secp256k1 curve point)")
    public String getH() {
        return this.h;
    }

    public void setH(String string) {
        this.h = string;
    }

    public DhtSecret u(String string) {
        this.u = string;
        return this;
    }

    @Schema(example="02a7955281885bf0f0ca4a48678848cad8dc5b328ce8bc1d4481d041c98e891ff3", required=true, description="Hex-encoded \"u\" group element of the Diffie-Hellman tuple (secp256k1 curve point)")
    public String getU() {
        return this.u;
    }

    public void setU(String string) {
        this.u = string;
    }

    public DhtSecret v(String string) {
        this.v = string;
        return this;
    }

    @Schema(example="02a7955281885bf0f0ca4a48678848cad8dc5b328ce8bc1d4481d041c98e891ff3", required=true, description="Hex-encoded \"v\" group element of the Diffie-Hellman tuple (secp256k1 curve point)")
    public String getV() {
        return this.v;
    }

    public void setV(String string) {
        this.v = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DhtSecret dhtSecret = (DhtSecret)object;
        return Objects.equals(this.secret, dhtSecret.secret) && Objects.equals(this.g, dhtSecret.g) && Objects.equals(this.h, dhtSecret.h) && Objects.equals(this.u, dhtSecret.u) && Objects.equals(this.v, dhtSecret.v);
    }

    public int hashCode() {
        return Objects.hash(this.secret, this.g, this.h, this.u, this.v);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class DhtSecret {\n");
        stringBuilder.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        stringBuilder.append("    g: ").append(this.toIndentedString(this.g)).append("\n");
        stringBuilder.append("    h: ").append(this.toIndentedString(this.h)).append("\n");
        stringBuilder.append("    u: ").append(this.toIndentedString(this.u)).append("\n");
        stringBuilder.append("    v: ").append(this.toIndentedString(this.v)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

