/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.explorer.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.ergoplatform.explorer.client.model.MinerInfo;

public class BlockInfo {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="epoch")
    private Integer epoch = null;
    @SerializedName(value="version")
    private Integer version = null;
    @SerializedName(value="timestamp")
    private Long timestamp = null;
    @SerializedName(value="transactionsCount")
    private Integer transactionsCount = null;
    @SerializedName(value="miner")
    private MinerInfo miner = null;
    @SerializedName(value="size")
    private Integer size = null;
    @SerializedName(value="difficulty")
    private Long difficulty = null;
    @SerializedName(value="minerReward")
    private Long minerReward = null;

    public BlockInfo id(String string) {
        this.id = string;
        return this;
    }

    @Schema(required=true, description="Block ID")
    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public BlockInfo height(Integer n) {
        this.height = n;
        return this;
    }

    @Schema(required=true, description="Block height")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer n) {
        this.height = n;
    }

    public BlockInfo epoch(Integer n) {
        this.epoch = n;
        return this;
    }

    @Schema(required=true, description="Block epoch (Epochs are enumerated from 0)")
    public Integer getEpoch() {
        return this.epoch;
    }

    public void setEpoch(Integer n) {
        this.epoch = n;
    }

    public BlockInfo version(Integer n) {
        this.version = n;
        return this;
    }

    @Schema(required=true, description="Block version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer n) {
        this.version = n;
    }

    public BlockInfo timestamp(Long l) {
        this.timestamp = l;
        return this;
    }

    @Schema(required=true, description="Timestamp the block was created (UNIX timestamp in millis)")
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long l) {
        this.timestamp = l;
    }

    public BlockInfo transactionsCount(Integer n) {
        this.transactionsCount = n;
        return this;
    }

    @Schema(required=true, description="Number of transactions included in the block")
    public Integer getTransactionsCount() {
        return this.transactionsCount;
    }

    public void setTransactionsCount(Integer n) {
        this.transactionsCount = n;
    }

    public BlockInfo miner(MinerInfo minerInfo) {
        this.miner = minerInfo;
        return this;
    }

    @Schema(required=true, description="")
    public MinerInfo getMiner() {
        return this.miner;
    }

    public void setMiner(MinerInfo minerInfo) {
        this.miner = minerInfo;
    }

    public BlockInfo size(Integer n) {
        this.size = n;
        return this;
    }

    @Schema(required=true, description="Overall size of the block in bytes")
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer n) {
        this.size = n;
    }

    public BlockInfo difficulty(Long l) {
        this.difficulty = l;
        return this;
    }

    @Schema(required=true, description="Block difficulty")
    public Long getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(Long l) {
        this.difficulty = l;
    }

    public BlockInfo minerReward(Long l) {
        this.minerReward = l;
        return this;
    }

    @Schema(required=true, description="The amount of nanoErgs miner received as a reward for block")
    public Long getMinerReward() {
        return this.minerReward;
    }

    public void setMinerReward(Long l) {
        this.minerReward = l;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BlockInfo blockInfo = (BlockInfo)object;
        return Objects.equals(this.id, blockInfo.id) && Objects.equals(this.height, blockInfo.height) && Objects.equals(this.epoch, blockInfo.epoch) && Objects.equals(this.version, blockInfo.version) && Objects.equals(this.timestamp, blockInfo.timestamp) && Objects.equals(this.transactionsCount, blockInfo.transactionsCount) && Objects.equals(this.miner, blockInfo.miner) && Objects.equals(this.size, blockInfo.size) && Objects.equals(this.difficulty, blockInfo.difficulty) && Objects.equals(this.minerReward, blockInfo.minerReward);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.height, this.epoch, this.version, this.timestamp, this.transactionsCount, this.miner, this.size, this.difficulty, this.minerReward);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class BlockInfo {\n");
        stringBuilder.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        stringBuilder.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        stringBuilder.append("    epoch: ").append(this.toIndentedString(this.epoch)).append("\n");
        stringBuilder.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        stringBuilder.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        stringBuilder.append("    transactionsCount: ").append(this.toIndentedString(this.transactionsCount)).append("\n");
        stringBuilder.append("    miner: ").append(this.toIndentedString(this.miner)).append("\n");
        stringBuilder.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        stringBuilder.append("    difficulty: ").append(this.toIndentedString(this.difficulty)).append("\n");
        stringBuilder.append("    minerReward: ").append(this.toIndentedString(this.minerReward)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

