/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import java.io.IOException;
import org.ergoplatform.appkit.ErgoClientException;
import retrofit2.Retrofit;

abstract class ApiFacade {
    ApiFacade() {
    }

    static ErgoClientException clientError(Retrofit retrofit, Throwable throwable) {
        return new ErgoClientException(String.format("Error executing API request to %s: %s", retrofit.baseUrl().toString(), throwable.getMessage()), throwable);
    }

    static <T> T execute(Retrofit retrofit, Supplier<T> supplier) throws ErgoClientException {
        try {
            return supplier.get();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw ApiFacade.clientError(retrofit, noSuchMethodException);
        }
        catch (IOException iOException) {
            throw ApiFacade.clientError(retrofit, iOException);
        }
    }

    static interface Supplier<T> {
        public T get() throws NoSuchMethodException, IOException;
    }
}

