/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.sql;

import com.databricks.labs.mosaic.functions.MosaicContext;
import com.databricks.labs.mosaic.functions.MosaicContext$;
import com.databricks.labs.mosaic.sql.MosaicAnalyzer$;
import com.databricks.labs.mosaic.sql.MosaicFrame;
import com.databricks.labs.mosaic.sql.MosaicSQLExceptions$;
import com.databricks.labs.mosaic.sql.SampleStrategy;
import com.databricks.labs.mosaic.sql.SampleStrategy$;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001\u0002\t\u0012\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\u0006Q\u0001!\t!\u000b\u0005\bY\u0001\u0011\r\u0011\"\u0001.\u0011\u0019\t\u0004\u0001)A\u0005]!)!\u0007\u0001C\u0001g!)!\u0007\u0001C\u0001s!)!\b\u0001C\u0001w!)!\b\u0001C\u0001\u000f\")!\u0007\u0001C\u0001\u001b\")q\n\u0001C\u0001!\"9A\u000eAI\u0001\n\u0003i\u0007b\u0002=\u0001#\u0003%\t!\u001f\u0005\bw\u0002\t\n\u0011\"\u0001z\u0011\u0015a\b\u0001\"\u0003~\u0011\u0019\u0011\u0004\u0001\"\u0001\u0002\u0004\tqQj\\:bS\u000e\fe.\u00197zu\u0016\u0014(B\u0001\n\u0014\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003)U\ta!\\8tC&\u001c'B\u0001\f\u0018\u0003\u0011a\u0017MY:\u000b\u0005aI\u0012A\u00033bi\u0006\u0014'/[2lg*\t!$A\u0002d_6\u001c\u0001a\u0005\u0002\u0001;A\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\f1#\u00198bYfTXM]'pg\u0006L7M\u0012:b[\u0016\u0004\"!\n\u0014\u000e\u0003EI!aJ\t\u0003\u00175{7/Y5d\rJ\fW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005)Z\u0003CA\u0013\u0001\u0011\u0015\u0019#\u00011\u0001%\u0003U!WMZ1vYR\u001c\u0016-\u001c9mK\u001a\u0013\u0018m\u0019;j_:,\u0012A\f\t\u0003==J!\u0001M\u0010\u0003\r\u0011{WO\u00197f\u0003Y!WMZ1vYR\u001c\u0016-\u001c9mK\u001a\u0013\u0018m\u0019;j_:\u0004\u0013\u0001F4fi>\u0003H/[7bYJ+7o\u001c7vi&|g\u000e\u0006\u00025oA\u0011a$N\u0005\u0003m}\u00111!\u00138u\u0011\u0015AT\u00011\u0001/\u00039\u0019\u0018-\u001c9mK\u001a\u0013\u0018m\u0019;j_:,\u0012\u0001N\u0001\u0018O\u0016$x\n\u001d;j[\u0006d'+Z:pYV$\u0018n\u001c8TiJ,\u0012\u0001\u0010\t\u0003{\u0011s!A\u0010\"\u0011\u0005}zR\"\u0001!\u000b\u0005\u0005[\u0012A\u0002\u001fs_>$h(\u0003\u0002D?\u00051\u0001K]3eK\u001aL!!\u0012$\u0003\rM#(/\u001b8h\u0015\t\u0019u\u0004\u0006\u0002=\u0011\")\u0011\n\u0003a\u0001\u0015\u0006q1/Y7qY\u0016\u001cFO]1uK\u001eL\bCA\u0013L\u0013\ta\u0015C\u0001\bTC6\u0004H.Z*ue\u0006$XmZ=\u0015\u0005Qr\u0005\"B%\n\u0001\u0004Q\u0015\u0001F4fiJ+7o\u001c7vi&|g.T3ue&\u001c7\u000f\u0006\u0003RO\"T\u0007C\u0001*e\u001d\t\u0019\u0016M\u0004\u0002U?:\u0011Q\u000b\u0018\b\u0003-fs!aP,\n\u0003a\u000b1a\u001c:h\u0013\tQ6,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00021&\u0011QLX\u0001\u0006gB\f'o\u001b\u0006\u00035nK!A\u00051\u000b\u0005us\u0016B\u00012d\u0003\u001d\u0001\u0018mY6bO\u0016T!A\u00051\n\u0005\u00154'!\u0003#bi\u00064%/Y7f\u0015\t\u00117\rC\u0004J\u0015A\u0005\t\u0019\u0001&\t\u000f%T\u0001\u0013!a\u0001i\u0005QAn\\<fe2KW.\u001b;\t\u000f-T\u0001\u0013!a\u0001i\u0005QQ\u000f\u001d9fe2KW.\u001b;\u0002=\u001d,GOU3t_2,H/[8o\u001b\u0016$(/[2tI\u0011,g-Y;mi\u0012\nT#\u00018+\u0005){7&\u00019\u0011\u0005E4X\"\u0001:\u000b\u0005M$\u0018!C;oG\",7m[3e\u0015\t)x$\u0001\u0006b]:|G/\u0019;j_:L!a\u001e:\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0010hKR\u0014Vm]8mkRLwN\\'fiJL7m\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\t!P\u000b\u00025_\u0006qr-\u001a;SKN|G.\u001e;j_:lU\r\u001e:jGN$C-\u001a4bk2$HeM\u0001\u0011O\u0016$X*Z1o\u0013:$W\r_!sK\u0006$2A\f@\u0000\u0011\u0015Ie\u00021\u0001K\u0011\u0019\t\tA\u0004a\u0001i\u0005Q!/Z:pYV$\u0018n\u001c8\u0015\u0007Q\n)\u0001\u0003\u0004\u0002\b=\u0001\r\u0001N\u0001\u000bg\u0006l\u0007\u000f\\3S_^\u001c\b")
public class MosaicAnalyzer {
    private final MosaicFrame analyzerMosaicFrame;
    private final double defaultSampleFraction;

    public double defaultSampleFraction() {
        return this.defaultSampleFraction;
    }

    public int getOptimalResolution(double sampleFraction) {
        return this.getOptimalResolution(new SampleStrategy((Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)sampleFraction)), SampleStrategy$.MODULE$.apply$default$2()));
    }

    public int getOptimalResolution() {
        return this.getOptimalResolution(new SampleStrategy(SampleStrategy$.MODULE$.apply$default$1(), SampleStrategy$.MODULE$.apply$default$2()));
    }

    public String getOptimalResolutionStr() {
        return this.getOptimalResolutionStr(new SampleStrategy(SampleStrategy$.MODULE$.apply$default$1(), SampleStrategy$.MODULE$.apply$default$2()));
    }

    public String getOptimalResolutionStr(SampleStrategy sampleStrategy) {
        int resolution = this.getOptimalResolution(sampleStrategy);
        MosaicContext mc = MosaicContext$.MODULE$.context();
        return mc.getIndexSystem().getResolutionStr(resolution);
    }

    public int getOptimalResolution(SampleStrategy sampleStrategy) {
        SparkSession ss = SparkSession$.MODULE$.builder().getOrCreate();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MosaicAnalyzer.class.getClassLoader());
        public final class Com_databricks_labs_mosaic_sql_MosaicAnalyzer$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Com_databricks_labs_mosaic_sql_MosaicAnalyzer$$typecreator5$1(MosaicAnalyzer $outer) {
            }
        }
        Tuple2[] metrics = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getResolutionMetrics(sampleStrategy, 1, 100).select("resolution", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"percentile_50_geometry_area"})).as(ss.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_databricks_labs_mosaic_sql_MosaicAnalyzer$$typecreator5$1(null)))).collect())).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1._2$mcD$sp()), (Ordering)Ordering.Double$.MODULE$);
        int midInd = (metrics.length - 1) / 2;
        return metrics[midInd]._1$mcI$sp();
    }

    public Dataset<Row> getResolutionMetrics(SampleStrategy sampleStrategy, int lowerLimit, int upperLimit) {
        MosaicContext mosaicContext = MosaicContext$.MODULE$.context();
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        Row percentiles = (Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.analyzerMosaicFrame.transform((Function1 & Serializable & scala.Serializable)df -> sampleStrategy.transformer((Dataset<Row>)df)).withColumn("area", mosaicContext.functions().st_area(this.analyzerMosaicFrame.getGeometryColumn())).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.mean("area").alias("mean"), MosaicAnalyzer.areaPercentile$1(0.25).alias("p25"), MosaicAnalyzer.areaPercentile$1(0.5).alias("p50"), MosaicAnalyzer.areaPercentile$1(0.75).alias("p75")})).collect())).head();
        Set meanIndexAreas = (Set)mosaicContext.getIndexSystem().resolutions().map((Function1 & Serializable & scala.Serializable)i -> MosaicAnalyzer.$anonfun$getResolutionMetrics$2(this, sampleStrategy, BoxesRunTime.unboxToInt((Object)i)), Set$.MODULE$.canBuildFrom());
        if (percentiles.anyNull()) {
            throw MosaicSQLExceptions$.MODULE$.NotEnoughGeometriesException();
        }
        List indexAreaRows = ((TraversableOnce)meanIndexAreas.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int resolution = tuple2._1$mcI$sp();
            double indexArea = tuple2._2$mcD$sp();
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)resolution), BoxesRunTime.boxToDouble((double)indexArea), BoxesRunTime.boxToDouble((double)(percentiles.getDouble(0) / indexArea)), BoxesRunTime.boxToDouble((double)(percentiles.getDouble(1) / indexArea)), BoxesRunTime.boxToDouble((double)(percentiles.getDouble(2) / indexArea)), BoxesRunTime.boxToDouble((double)(percentiles.getDouble(3) / indexArea))}));
            return row;
        }, Set$.MODULE$.canBuildFrom())).toList();
        StructType indexAreaSchema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("resolution", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("mean_index_area", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("mean_geometry_area", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("percentile_25_geometry_area", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("percentile_50_geometry_area", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("percentile_75_geometry_area", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))))));
        return spark.createDataFrame(spark.sparkContext().parallelize((Seq)indexAreaRows, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class)), indexAreaSchema).where(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(354).append("\n                 |(").append(lowerLimit).append(" < mean_geometry_area and mean_geometry_area < ").append(upperLimit).append(") or\n                 |(").append(lowerLimit).append(" < percentile_25_geometry_area and percentile_25_geometry_area < ").append(upperLimit).append(") or\n                 |(").append(lowerLimit).append(" < percentile_50_geometry_area and percentile_50_geometry_area < ").append(upperLimit).append(") or\n                 |(").append(lowerLimit).append(" < percentile_75_geometry_area and percentile_75_geometry_area < ").append(upperLimit).append(")\n                 |").toString())).stripMargin());
    }

    public SampleStrategy getResolutionMetrics$default$1() {
        return new SampleStrategy(SampleStrategy$.MODULE$.apply$default$1(), SampleStrategy$.MODULE$.apply$default$2());
    }

    public int getResolutionMetrics$default$2() {
        return 5;
    }

    public int getResolutionMetrics$default$3() {
        return 500;
    }

    private double getMeanIndexArea(SampleStrategy sampleStrategy, int resolution) {
        double result;
        MosaicContext mosaicContext = MosaicContext$.MODULE$.context();
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        Dataset meanIndexAreaDf = this.analyzerMosaicFrame.transform((Function1 & Serializable & scala.Serializable)df -> sampleStrategy.transformer((Dataset<Row>)df)).withColumn("centroid", mosaicContext.functions().st_centroid2D(this.analyzerMosaicFrame.getGeometryColumn())).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.mean(mosaicContext.functions().st_area(mosaicContext.functions().grid_boundaryaswkb(mosaicContext.functions().grid_longlatascellid(functions$.MODULE$.col("centroid").getItem((Object)"x"), functions$.MODULE$.col("centroid").getItem((Object)"y"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)resolution))))))}));
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])meanIndexAreaDf.as(spark.implicits().newDoubleEncoder()).collect())).head()));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                throw MosaicSQLExceptions$.MODULE$.NotEnoughGeometriesException();
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        double d = result = BoxesRunTime.unboxToDouble((Object)success.value());
        return d;
    }

    public int getOptimalResolution(int sampleRows) {
        Some x$1 = new Some((Object)BoxesRunTime.boxToInteger((int)sampleRows));
        Option<Object> x$2 = SampleStrategy$.MODULE$.apply$default$1();
        return this.getOptimalResolution(new SampleStrategy(x$2, (Option<Object>)x$1));
    }

    private static final Column areaPercentile$1(double p) {
        return functions$.MODULE$.percentile_approx(functions$.MODULE$.col("area"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)p)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10000)));
    }

    public static final /* synthetic */ Tuple2 $anonfun$getResolutionMetrics$2(MosaicAnalyzer $this, SampleStrategy sampleStrategy$1, int i) {
        return new Tuple2.mcID.sp(i, $this.getMeanIndexArea(sampleStrategy$1, i));
    }

    public MosaicAnalyzer(MosaicFrame analyzerMosaicFrame) {
        this.analyzerMosaicFrame = analyzerMosaicFrame;
        this.defaultSampleFraction = 0.01;
    }
}

