/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.expressions.index;

import com.databricks.labs.mosaic.expressions.index.GeometryKLoopExplode;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple5;
import scala.collection.immutable.StringOps;

public final class GeometryKLoopExplode$
implements Serializable {
    public static GeometryKLoopExplode$ MODULE$;

    static {
        new GeometryKLoopExplode$();
    }

    public ExpressionInfo registryExpressionInfo(Option<String> db) {
        return new ExpressionInfo(GeometryKLoopExplode.class.getCanonicalName(), (String)db.orNull(Predef$.MODULE$.$conforms()), "grid_cellkloopexplode", new StringOps(Predef$.MODULE$.augmentString("\n            |    _FUNC_(cell_id, resolution)) - Generates the geometry based k loop (hollow ring) cell IDs set for the input\n            |    geometry and the input k value.\n            ")).stripMargin(), "", new StringOps(Predef$.MODULE$.augmentString("\n            |    Examples:\n            |      > SELECT _FUNC_(a, b);\n            |        622236721274716159\n            |        622236721274716160\n            |        622236721274716161\n            |        ...\n            |\n            |  ")).stripMargin(), "", "generator_funcs", "1.0", "", "built-in");
    }

    public GeometryKLoopExplode apply(Expression geom, Expression resolution, Expression k, String indexSystemName, String geometryAPIName) {
        return new GeometryKLoopExplode(geom, resolution, k, indexSystemName, geometryAPIName);
    }

    public Option<Tuple5<Expression, Expression, Expression, String, String>> unapply(GeometryKLoopExplode x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.geom(), (Object)x$0.resolution(), (Object)x$0.k(), (Object)x$0.indexSystemName(), (Object)x$0.geometryAPIName()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GeometryKLoopExplode$() {
        MODULE$ = this;
    }
}

