/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core;

import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.api.GeometryAPI;
import com.databricks.labs.mosaic.core.geometry.linestring.MosaicLineString;
import com.databricks.labs.mosaic.core.geometry.multilinestring.MosaicMultiLineString;
import com.databricks.labs.mosaic.core.geometry.multipoint.MosaicMultiPoint;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPoint;
import com.databricks.labs.mosaic.core.index.IndexSystem;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.core.types.model.MosaicChip;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Either;

public final class Mosaic$ {
    public static Mosaic$ MODULE$;

    static {
        new Mosaic$();
    }

    public Seq<MosaicChip> getChips(MosaicGeometry geometry, int resolution, boolean keepCoreGeom, IndexSystem indexSystem, GeometryAPI geometryAPI) {
        Seq<MosaicChip> seq;
        Enumeration.Value value = GeometryTypeEnum$.MODULE$.fromString(geometry.getGeometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.POINT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            seq = this.pointChip(geometry, resolution, keepCoreGeom, indexSystem);
        } else {
            Enumeration.Value value4 = GeometryTypeEnum$.MODULE$.MULTIPOINT();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                seq = this.multiPointChips(geometry, resolution, keepCoreGeom, indexSystem);
            } else {
                Enumeration.Value value6 = GeometryTypeEnum$.MODULE$.LINESTRING();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    seq = this.lineFill(geometry, resolution, indexSystem, geometryAPI);
                } else {
                    Enumeration.Value value8 = GeometryTypeEnum$.MODULE$.MULTILINESTRING();
                    Enumeration.Value value9 = value;
                    seq = !(value8 != null ? !value8.equals(value9) : value9 != null) ? this.lineFill(geometry, resolution, indexSystem, geometryAPI) : this.mosaicFill(geometry, resolution, keepCoreGeom, indexSystem, geometryAPI);
                }
            }
        }
        return seq;
    }

    public Seq<MosaicChip> multiPointChips(MosaicGeometry geometry, int resolution, boolean keepCoreGeom, IndexSystem indexSystem) {
        Seq<MosaicPoint> points = ((MosaicMultiPoint)geometry).asSeq();
        return (Seq)points.flatMap((Function1 & Serializable & scala.Serializable)point -> MODULE$.pointChip((MosaicGeometry)point, resolution, keepCoreGeom, indexSystem), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<MosaicChip> pointChip(MosaicGeometry geometry, int resolution, boolean keepCoreGeom, IndexSystem indexSystem) {
        MosaicPoint point = (MosaicPoint)geometry;
        MosaicPoint chipGeom = keepCoreGeom ? point : null;
        long cellId = indexSystem.pointToIndex(point.getX(), point.getY(), resolution);
        MosaicChip chip = new MosaicChip(false, (Either<Object, String>)package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToLong((long)cellId)), chipGeom);
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MosaicChip[]{chip.formatCellId(indexSystem)}));
    }

    public Seq<MosaicChip> mosaicFill(MosaicGeometry geometry, int resolution, boolean keepCoreGeom, IndexSystem indexSystem, GeometryAPI geometryAPI) {
        double radius = indexSystem.getBufferRadius(geometry, resolution, geometryAPI);
        MosaicGeometry carvedGeometry = geometry.buffer(-radius);
        MosaicGeometry borderGeometry = carvedGeometry.isEmpty() ? geometry.buffer(radius * 1.01).simplify(0.01 * radius) : geometry.boundary().buffer(radius * 1.01).simplify(0.01 * radius);
        Seq<Object> coreIndices = indexSystem.polyfill(carvedGeometry, resolution, (Option<GeometryAPI>)new Some((Object)geometryAPI));
        Seq borderIndices = (Seq)indexSystem.polyfill(borderGeometry, resolution, (Option<GeometryAPI>)new Some((Object)geometryAPI)).diff(coreIndices);
        Seq<MosaicChip> coreChips = indexSystem.getCoreChips(coreIndices, keepCoreGeom, geometryAPI);
        Seq<MosaicChip> borderChips = indexSystem.getBorderChips(geometry, (Seq<Object>)borderIndices, keepCoreGeom, geometryAPI);
        return (Seq)coreChips.$plus$plus(borderChips, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<MosaicChip> lineFill(MosaicGeometry geometry, int resolution, IndexSystem indexSystem, GeometryAPI geometryAPI) {
        Seq seq;
        Enumeration.Value value = GeometryTypeEnum$.MODULE$.fromString(geometry.getGeometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.LINESTRING();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            seq = this.lineDecompose((MosaicLineString)geometry, resolution, indexSystem, geometryAPI);
        } else {
            Enumeration.Value value4 = GeometryTypeEnum$.MODULE$.MULTILINESTRING();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                MosaicMultiLineString multiLine = (MosaicMultiLineString)geometry;
                seq = (Seq)multiLine.flatten().flatMap((Function1 & Serializable & scala.Serializable)line -> MODULE$.lineDecompose((MosaicLineString)line, resolution, indexSystem, geometryAPI), Seq$.MODULE$.canBuildFrom());
            } else {
                throw new Error(new StringBuilder(49).append(value).append(" not supported for line fill/decompose operation.").toString());
            }
        }
        return seq;
    }

    public Set<Object> geometryKRing(MosaicGeometry geometry, int resolution, int k, IndexSystem indexSystem, GeometryAPI geometryAPI) {
        Tuple2<Set<Object>, Set<Object>> tuple2 = this.getCellSets(geometry, resolution, indexSystem, geometryAPI);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Set coreCells = (Set)tuple2._1();
        Set borderCells = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)coreCells, (Object)borderCells);
        Tuple2 tuple23 = tuple22;
        Set coreCells2 = (Set)tuple23._1();
        Set borderCells2 = (Set)tuple23._2();
        Set borderKRing = (Set)borderCells2.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> indexSystem.kRing(BoxesRunTime.unboxToLong((Object)x$2), k), Set$.MODULE$.canBuildFrom());
        Set kRing = (Set)coreCells2.$plus$plus((GenTraversableOnce)borderKRing);
        return kRing;
    }

    public Set<Object> geometryKLoop(MosaicGeometry geometry, int resolution, int k, IndexSystem indexSystem, GeometryAPI geometryAPI) {
        int n = k - 1;
        Tuple2<Set<Object>, Set<Object>> tuple2 = this.getCellSets(geometry, resolution, indexSystem, geometryAPI);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Set coreCells = (Set)tuple2._1();
        Set borderCells = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)coreCells, (Object)borderCells);
        Tuple2 tuple23 = tuple22;
        Set coreCells2 = (Set)tuple23._1();
        Set borderCells2 = (Set)tuple23._2();
        Set borderNRing = (Set)borderCells2.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> indexSystem.kRing(BoxesRunTime.unboxToLong((Object)x$4), n), Set$.MODULE$.canBuildFrom());
        Set nRing = (Set)coreCells2.$plus$plus((GenTraversableOnce)borderNRing);
        Set borderKLoop = (Set)borderCells2.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> indexSystem.kLoop(BoxesRunTime.unboxToLong((Object)x$5), k), Set$.MODULE$.canBuildFrom());
        Set kLoop = (Set)borderKLoop.$minus$minus((GenTraversableOnce)nRing);
        return kLoop;
    }

    private Seq<MosaicChip> lineDecompose(MosaicLineString line, int resolution, IndexSystem indexSystem, GeometryAPI geometryAPI) {
        MosaicPoint start = (MosaicPoint)((MosaicLineString)line.getShells().head()).asSeq().head();
        long startIndex = indexSystem.pointToIndex(start.getX(), start.getY(), resolution);
        Seq result = this.traverseLine$1(line, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{startIndex})), Predef$.MODULE$.Set().empty(), (Seq)Seq$.MODULE$.empty(), indexSystem, geometryAPI);
        return result;
    }

    private Tuple2<Set<Object>, Set<Object>> getCellSets(MosaicGeometry geometry, int resolution, IndexSystem indexSystem, GeometryAPI geometryAPI) {
        Seq<MosaicChip> chips = this.getChips(geometry, resolution, false, indexSystem, geometryAPI);
        Tuple2 tuple2 = chips.partition((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isCore()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq coreChips = (Seq)tuple2._1();
        Seq borderChips = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)coreChips, (Object)borderChips);
        Tuple2 tuple23 = tuple22;
        Seq coreChips2 = (Seq)tuple23._1();
        Seq borderChips2 = (Seq)tuple23._2();
        Set coreCells = ((TraversableOnce)coreChips2.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.cellIdAsLong(indexSystem)), Seq$.MODULE$.canBuildFrom())).toSet();
        Set borderCells = ((TraversableOnce)borderChips2.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.cellIdAsLong(indexSystem)), Seq$.MODULE$.canBuildFrom())).toSet();
        return new Tuple2((Object)coreCells, (Object)borderCells);
    }

    public static final /* synthetic */ Tuple2 $anonfun$lineDecompose$1(IndexSystem indexSystem$5, GeometryAPI geometryAPI$2, MosaicLineString line$1, Set newTraversed$1, Tuple2 accumulator, long current) {
        Tuple2 tuple2;
        MosaicGeometry indexGeom = indexSystem$5.indexToGeometry(current, geometryAPI$2);
        MosaicGeometry lineSegment = line$1.intersection(indexGeom);
        if (!lineSegment.isEmpty()) {
            MosaicChip chip = new MosaicChip(false, (Either<Object, String>)package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToLong((long)current)), lineSegment);
            Seq<Object> kRing = indexSystem$5.kRing(current, 1);
            Seq toQueue = (Seq)kRing.filterNot((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)elem -> newTraversed$1.contains((Object)BoxesRunTime.boxToLong((long)elem)));
            tuple2 = new Tuple2((Object)toQueue, ((TraversableLike)accumulator._2()).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MosaicChip[]{chip})), Seq$.MODULE$.canBuildFrom()));
        } else if (newTraversed$1.size() == 1) {
            Seq<Object> kRing = indexSystem$5.kRing(current, 1);
            Seq toQueue = (Seq)kRing.filterNot((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)elem -> newTraversed$1.contains((Object)BoxesRunTime.boxToLong((long)elem)));
            tuple2 = new Tuple2((Object)toQueue, accumulator._2());
        } else {
            tuple2 = accumulator;
        }
        return tuple2;
    }

    private final Seq traverseLine$1(MosaicLineString line, Seq queue, Set traversed, Seq chips, IndexSystem indexSystem$5, GeometryAPI geometryAPI$2) {
        Seq newChips;
        while (true) {
            Set newTraversed = (Set)traversed.$plus$plus((GenTraversableOnce)queue);
            Tuple2 tuple2 = (Tuple2)queue.foldLeft((Object)new Tuple2((Object)Seq$.MODULE$.empty(), (Object)chips), (Function2 & Serializable & scala.Serializable)(accumulator, current) -> Mosaic$.$anonfun$lineDecompose$1(indexSystem$5, geometryAPI$2, line, newTraversed, accumulator, BoxesRunTime.unboxToLong((Object)current)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq newQueue = (Seq)tuple2._1();
            Seq newChips2 = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)newQueue, (Object)newChips2);
            Tuple2 tuple23 = tuple22;
            Seq newQueue2 = (Seq)tuple23._1();
            newChips = (Seq)tuple23._2();
            if (newQueue2.isEmpty()) break;
            chips = newChips;
            traversed = newTraversed;
            queue = newQueue2;
        }
        return newChips;
    }

    private Mosaic$() {
        MODULE$ = this;
    }
}

